package ${package.Controller};

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.util.Assert;
import io.swagger.annotations.ApiOperation;
import com.byh.${package.ModuleName}.api.util.ResponseData;
import java.util.List;
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>
import ${package.Entity}.${entity};
import ${package.Service}.${table.serviceName};

/**
 * ${table.comment!}
 *
 * @author ${author}
 * @since ${date}
 */
<#if restControllerStyle>
@RestController
<#else>
@Controller
</#if>
@RequestMapping("/<#if controllerMappingHyphenStyle>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
public class ${table.controllerName}  {
    @Autowired
    private ${table.serviceName} ${table.entityPath}Service;


    /**
     * 新增或者更新
     */
    @PostMapping("/insert")
    @ApiOperation(value = "新增或者更新")
    public ResponseData save(@RequestBody ${entity} param) {
        try {
            boolean ${table.entityPath} = ${table.entityPath}Service.saveOrUpdate(param);
            Assert.isTrue(${table.entityPath},"保存失败!");
            return ResponseData.success();
        }catch (Exception ex) {
            return ResponseData.error(ex.getMessage());
        }
    }

    /**
     * 删除
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除")
    public ResponseData delete(@PathVariable Integer id) {
        try {
            boolean ${table.entityPath} = ${table.entityPath}Service.removeById(id);
            Assert.isTrue(${table.entityPath},"删除失败!");
            return ResponseData.success();
        }catch (Exception ex) {
            return ResponseData.error(ex.getMessage());
        }
    }

    /**
     * 批量删除
     */
    @PostMapping("/deleteList")
    @ApiOperation(value = "批量删除")
    public ResponseData deleteBatch(@RequestBody List<Integer> ids) {
        try {
            boolean ${table.entityPath} = ${table.entityPath}Service.removeByIds(ids);
            Assert.isTrue(${table.entityPath},"批量删除失败!");
            return ResponseData.success();

        }catch (Exception ex) {
            return ResponseData.error(ex.getMessage());
        }
    }

    /**
     * 查询所有数据
     */
    @GetMapping
    @ApiOperation(value = "查询所有数据")
    public ResponseData<List<${entity}>> findAll() {
        List<${entity}> list = ${table.entityPath}Service.list();
        return ResponseData.success(list);
    }

    /**
     * 查询单条数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "查询单条数据")
    public ResponseData<${entity}> findOne(@PathVariable Integer id) {
        ${entity} ${table.entityPath} = ${table.entityPath}Service.getById(id);
        return ResponseData.success(${table.entityPath});
    }

    /**
     * 分页查询
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询")
    public ResponseData<Page<${entity}>> findPage(@RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        QueryWrapper<${entity}> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("id");
        return ResponseData.success(${table.entityPath}Service.page(new Page<>(pageNum, pageSize), queryWrapper));
    }
}

