/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage;

import com.alibaba.fastjson.JSONObject;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.ConfirmOrderEnum;
import com.byh.pojo.dto.ApplyOrderDto;
import com.byh.pojo.dto.ConfirmOrderDto;
import com.byh.pojo.dto.FilterOrderDto;
import com.byh.pojo.dto.OrderSearchDto;
import com.byh.pojo.dto.SfApplyOrderDto;
import com.byh.pojo.dto.SfGoodsDto;
import com.byh.pojo.dto.SfOrderConfirmDto;
import com.byh.pojo.dto.SfOrderFilterDto;
import com.byh.pojo.dto.SfOrderFilterOptionDto;
import com.byh.pojo.dto.SfOrderSearchDto;
import com.byh.pojo.entity.BusinessOrderInfoEntity;
import com.byh.pojo.entity.SfOrderEntity;
import com.byh.pojo.entity.SfOrderOperatorLogEntity;
import com.byh.pojo.vo.ApplyOrderVO;
import com.byh.pojo.vo.BaseResposeVO;
import com.byh.pojo.vo.ConfirmOrderVO;
import com.byh.pojo.vo.FilterOrderVO;
import com.byh.pojo.vo.SearchOrderVO;
import com.byh.service.BusinessOrderInfoService;
import com.byh.service.SfOrderOperatorLogService;
import com.byh.service.SfOrderService;
import com.hxgy.commons.core.response.BaseResponse;
import com.sf.csim.express.service.CallExpressServiceTools;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SfOrderManage {
    private static final Logger log = LoggerFactory.getLogger(SfOrderManage.class);
    @Autowired
    private SfOrderService sfOrderService;
    @Autowired
    private BusinessOrderInfoService businessOrderInfoService;
    @Autowired
    private SfOrderOperatorLogService sfOrderOperatorLogService;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<ApplyOrderVO> applySfOrder(ApplyOrderDto applyOrderDto) {
        SfOrderEntity sfOrderEntity = this.sfOrderService.getByBusinessIdAndStatus(BaseStatusEnum.STATUS_VALID.getValue(), applyOrderDto.getOrderId());
        if (sfOrderEntity != null) {
            return BaseResponse.error((String)"\u6b64\u4e1a\u52a1\u8ba2\u5355\u5df2\u7ecf\u5b58\u5728\u987a\u4e30\u7684\u8ba2\u5355\u4e86\uff01\uff01");
        }
        String xmlReq = "<Request service=\"method\" lang=\"zh-CN\"> <Head>BYKJ</Head> <Body>".replaceAll("method", "OrderService");
        StringBuffer stringBuffer = new StringBuffer(xmlReq);
        XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xStream.processAnnotations(SfApplyOrderDto.class);
        xStream.autodetectAnnotations(true);
        SfApplyOrderDto order = new SfApplyOrderDto();
        order.setOrderId(applyOrderDto.getOrderId());
        order.setJCompany(applyOrderDto.getJCompany());
        order.setJContact(applyOrderDto.getJContact());
        order.setJTel(applyOrderDto.getJTel());
        order.setJMobile(applyOrderDto.getJMobile());
        order.setJProvince(applyOrderDto.getJProvince());
        order.setJCity(applyOrderDto.getJCity());
        order.setJCounty(applyOrderDto.getJCounty());
        order.setJAddress(applyOrderDto.getJAddress());
        order.setDContact(applyOrderDto.getDContact());
        order.setDTel(applyOrderDto.getDTel());
        order.setDMobile(applyOrderDto.getDMobile());
        order.setDProvince(applyOrderDto.getDProvince());
        order.setDCity(applyOrderDto.getDCity());
        order.setDCounty(applyOrderDto.getDCounty());
        order.setDAddress(applyOrderDto.getDAddress());
        order.setRemark(applyOrderDto.getRemark());
        order.setIsUnifiedWaybillNo("1");
        SfGoodsDto sfGoodsDto = new SfGoodsDto();
        sfGoodsDto.setName("\u836f\u7269");
        order.setSfGoodsDto(sfGoodsDto);
        String orderDataStr = xStream.toXML((Object)order);
        stringBuffer.append(orderDataStr).append("</Body> </Request>");
        log.info("\u987a\u4e30\u4e0b\u5355\u7684\u62a5\u6587\u8bf7\u6c42\u662f{}", (Object)stringBuffer.toString());
        String respXml = CallExpressServiceTools.callSfExpressServiceByCSIM((String)"https://bsp-oisp.sf-express.com/bsp-oisp/sfexpressService", (String)stringBuffer.toString(), (String)"BYKJ", (String)"QSTQKCCPvq8MC4CYUhJXkiS4X2SUBBiZ");
        log.info("\u987a\u4e30\u4e0b\u5355\u8fd4\u56de\u7684\u62a5\u6587\u662f{}", (Object)respXml);
        org.json.JSONObject jsonObject = XML.toJSONObject((String)respXml).getJSONObject("Response");
        BaseResposeVO baseResposeVo = (BaseResposeVO)JSONObject.parseObject((String)jsonObject.toString(), BaseResposeVO.class);
        if ("OK".equalsIgnoreCase(baseResposeVo.getHead()) && baseResposeVo.getBody() != null) {
            ApplyOrderVO orderVO = (ApplyOrderVO)JSONObject.parseObject((String)baseResposeVo.getBody().getJSONObject("OrderResponse").toString(), ApplyOrderVO.class);
            BusinessOrderInfoEntity businessOrderInfoEntity = new BusinessOrderInfoEntity();
            BeanUtils.copyProperties((Object)order, (Object)businessOrderInfoEntity);
            this.businessOrderInfoService.insert(businessOrderInfoEntity);
            SfOrderEntity sfOrder = new SfOrderEntity();
            sfOrder.setBusinessId(order.getOrderId());
            sfOrder.setDestCode(orderVO.getDestcode());
            sfOrder.setMailNo(orderVO.getMailno());
            sfOrder.setOriginCode(orderVO.getOrigincode());
            sfOrder.setFilterResult((Object)orderVO.getFilterResult());
            sfOrder.setStatus((Object)BaseStatusEnum.STATUS_VALID.getValue());
            sfOrder.setResponseResult(baseResposeVo.toString());
            this.sfOrderService.insert(sfOrder);
            return BaseResponse.success((Object)orderVO);
        }
        if ("ERR".equalsIgnoreCase(baseResposeVo.getHead())) {
            OrderSearchDto orderSearchDto = new OrderSearchDto();
            orderSearchDto.setOrderId(applyOrderDto.getOrderId());
            BaseResponse searchOrderVOBaseResponse = this.searchOrder(orderSearchDto);
            if ("1".equalsIgnoreCase(searchOrderVOBaseResponse.getCode()) && searchOrderVOBaseResponse.getData() != null) {
                ApplyOrderVO applyOrderVO = new ApplyOrderVO();
                applyOrderVO.setMailno(((SearchOrderVO)searchOrderVOBaseResponse.getData()).getMailno());
                return BaseResponse.success((Object)applyOrderVO);
            }
            return BaseResponse.error((String)"\u4e0b\u5355\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u4e0b\u5355\u5931\u8d25");
    }

    public BaseResponse<SearchOrderVO> searchOrder(OrderSearchDto orderSearchDto) {
        String xmlReq = "<Request service=\"method\" lang=\"zh-CN\"> <Head>BYKJ</Head> <Body>".replaceAll("method", "OrderSearchService");
        StringBuffer stringBuffer = new StringBuffer(xmlReq);
        XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xStream.processAnnotations(SfOrderSearchDto.class);
        xStream.autodetectAnnotations(true);
        SfOrderSearchDto sfOrderSearchDto = new SfOrderSearchDto();
        sfOrderSearchDto.setOrderId(orderSearchDto.getOrderId());
        sfOrderSearchDto.setSearchType(orderSearchDto.getSearchType());
        String xmlData = xStream.toXML((Object)sfOrderSearchDto);
        stringBuffer.append(xmlData).append("</Body> </Request>");
        log.info("\u67e5\u8be2\u987a\u4e30\u8ba2\u5355\u7684\u62a5\u6587\u662f{}", (Object)stringBuffer.toString());
        String respXml = CallExpressServiceTools.callSfExpressServiceByCSIM((String)"https://bsp-oisp.sf-express.com/bsp-oisp/sfexpressService", (String)stringBuffer.toString(), (String)"BYKJ", (String)"QSTQKCCPvq8MC4CYUhJXkiS4X2SUBBiZ");
        log.info("\u987a\u4e30\u8fd4\u56de\u7684\u67e5\u8be2\u62a5\u6587\u662f{}", (Object)respXml);
        org.json.JSONObject jsonObject = XML.toJSONObject((String)respXml).getJSONObject("Response");
        BaseResposeVO baseResposeVo = (BaseResposeVO)JSONObject.parseObject((String)jsonObject.toString(), BaseResposeVO.class);
        if ("OK".equalsIgnoreCase(baseResposeVo.getHead()) && baseResposeVo.getBody() != null) {
            SearchOrderVO searchOrderVO = (SearchOrderVO)JSONObject.parseObject((String)baseResposeVo.getBody().get((Object)"OrderResponse").toString(), SearchOrderVO.class);
            return BaseResponse.success((Object)searchOrderVO);
        }
        return BaseResponse.error((String)"\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<ConfirmOrderVO> confirmOrder(ConfirmOrderDto confirmOrderDto) {
        SfOrderEntity sfOrderEntity = this.sfOrderService.getByBusinessIdAndStatus(BaseStatusEnum.STATUS_VALID.getValue(), confirmOrderDto.getOrderid());
        if (sfOrderEntity == null) {
            return BaseResponse.error((String)"\u987a\u4e30\u8ba2\u5355\u4e2d\u65e0\u6b64\u4e1a\u52a1\u8ba2\u5355\u6216\u8be5\u8ba2\u5355\u5df2\u88ab\u53d6\u6d88!!");
        }
        SfOrderOperatorLogEntity logEntity = this.sfOrderOperatorLogService.getByOrderIdAndTypeAndStatus(ConfirmOrderEnum.CONFIRM.getValue(), Long.valueOf(Long.parseLong(confirmOrderDto.getOrderid())), BaseStatusEnum.STATUS_VALID.getValue());
        if (confirmOrderDto.getDealtype().intValue() == ConfirmOrderEnum.CANCEL.getValue().intValue() && logEntity != null) {
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u5df2\u53d6\u6d88\uff0c\u5207\u52ff\u91cd\u590d\u53d6\u6d88\uff01\uff01");
        }
        String xmlReq = "<Request service=\"method\" lang=\"zh-CN\"> <Head>BYKJ</Head> <Body>".replaceAll("method", "OrderConfirmService");
        StringBuffer stringBuffer = new StringBuffer(xmlReq);
        XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xStream.processAnnotations(SfOrderConfirmDto.class);
        xStream.autodetectAnnotations(true);
        SfOrderConfirmDto sfOrderConfirmDto = new SfOrderConfirmDto();
        sfOrderConfirmDto.setOrderid(confirmOrderDto.getOrderid());
        sfOrderConfirmDto.setAgentNo(confirmOrderDto.getAgentNo());
        sfOrderConfirmDto.setConsignEmpCode(confirmOrderDto.getConsignEmpCode());
        sfOrderConfirmDto.setDealtype(confirmOrderDto.getDealtype());
        sfOrderConfirmDto.setInProcessWaybillNo(confirmOrderDto.getInProcessWaybillNo());
        sfOrderConfirmDto.setMailno(confirmOrderDto.getMailno());
        sfOrderConfirmDto.setCustomsBatchs(confirmOrderDto.getCustomsBatchs());
        String xmlData = xStream.toXML((Object)sfOrderConfirmDto);
        stringBuffer.append(xmlData).append("</Body> </Request>");
        log.info("\u786e\u8ba4\u6216\u662f\u53d6\u6d88\u987a\u4e30\u8ba2\u5355\u65f6\u53d1\u9001\u7684\u62a5\u6587\u662f{}", (Object)stringBuffer.toString());
        String respXml = CallExpressServiceTools.callSfExpressServiceByCSIM((String)"https://bsp-oisp.sf-express.com/bsp-oisp/sfexpressService", (String)stringBuffer.toString(), (String)"BYKJ", (String)"QSTQKCCPvq8MC4CYUhJXkiS4X2SUBBiZ");
        log.info("\u786e\u8ba4\u6216\u662f\u53d6\u6d88\u987a\u4e30\u8ba2\u5355\u65f6\u8fd4\u56de\u7684\u7684\u62a5\u6587\u662f{}", (Object)respXml);
        org.json.JSONObject jsonObject = XML.toJSONObject((String)respXml).getJSONObject("Response");
        BaseResposeVO baseResposeVo = (BaseResposeVO)JSONObject.parseObject((String)jsonObject.toString(), BaseResposeVO.class);
        if ("OK".equalsIgnoreCase(baseResposeVo.getHead()) && baseResposeVo.getBody() != null) {
            sfOrderEntity.setStatus((Object)BaseStatusEnum.INVALID_VALID.getValue());
            this.sfOrderService.update(sfOrderEntity);
            SfOrderOperatorLogEntity sfOrderOperatorLogEntity = new SfOrderOperatorLogEntity();
            sfOrderOperatorLogEntity.setSfOrderId(sfOrderEntity.getId());
            sfOrderOperatorLogEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
            sfOrderOperatorLogEntity.setType(confirmOrderDto.getDealtype());
            this.sfOrderOperatorLogService.insert(sfOrderOperatorLogEntity);
            ConfirmOrderVO confirmOrderVO = (ConfirmOrderVO)JSONObject.parseObject((String)baseResposeVo.getBody().getJSONObject("OrderConfirmResponse").toString(), ConfirmOrderVO.class);
            return BaseResponse.success((Object)confirmOrderVO);
        }
        return BaseResponse.error((String)"\u786e\u8ba4\u6216\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
    }

    public BaseResponse<FilterOrderVO> filterOrder(FilterOrderDto filterOrderDto) {
        String xmlReq = "<Request service=\"method\" lang=\"zh-CN\"> <Head>BYKJ</Head> <Body>".replaceAll("method", "OrderFilterService");
        StringBuffer stringBuffer = new StringBuffer(xmlReq);
        XStream xStream = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")));
        xStream.processAnnotations(SfOrderFilterDto.class);
        xStream.autodetectAnnotations(true);
        SfOrderFilterDto sfOrderFilterDto = new SfOrderFilterDto();
        sfOrderFilterDto.setOrderid(filterOrderDto.getOrderid());
        sfOrderFilterDto.setDAddress(filterOrderDto.getDAddress());
        sfOrderFilterDto.setFilterType(filterOrderDto.getFilterType());
        SfOrderFilterOptionDto sfOrderFilterOptionDto = new SfOrderFilterOptionDto();
        sfOrderFilterOptionDto.setJTel(filterOrderDto.getJTel());
        sfOrderFilterOptionDto.setCountry(filterOrderDto.getCountry());
        sfOrderFilterOptionDto.setProvince(filterOrderDto.getProvince());
        sfOrderFilterOptionDto.setCity(filterOrderDto.getCity());
        sfOrderFilterOptionDto.setCounty(filterOrderDto.getCounty());
        sfOrderFilterOptionDto.setDCountry(filterOrderDto.getDCountry());
        sfOrderFilterOptionDto.setDProvince(filterOrderDto.getDProvince());
        sfOrderFilterOptionDto.setDCity(filterOrderDto.getDCity());
        sfOrderFilterOptionDto.setDCounty(filterOrderDto.getDCounty());
        sfOrderFilterOptionDto.setJAddress(filterOrderDto.getJAddress());
        sfOrderFilterOptionDto.setDTel(filterOrderDto.getDTel());
        sfOrderFilterOptionDto.setJCustid(filterOrderDto.getJCustid());
        sfOrderFilterDto.setSfOrderFilterOptionDto(sfOrderFilterOptionDto);
        String xmlData = xStream.toXML((Object)sfOrderFilterDto);
        stringBuffer.append(xmlData).append("</Body> </Request>");
        log.info("\u7b5b\u9009\u987a\u4e30\u8ba2\u5355\u8c03\u7528\u6240\u4f20\u7684\u62a5\u6587\u662f{}", (Object)stringBuffer.toString());
        String respXml = CallExpressServiceTools.callSfExpressServiceByCSIM((String)"https://bsp-oisp.sf-express.com/bsp-oisp/sfexpressService", (String)stringBuffer.toString(), (String)"BYKJ", (String)"QSTQKCCPvq8MC4CYUhJXkiS4X2SUBBiZ");
        log.info("\u7b5b\u9009\u987a\u4e30\u8ba2\u5355\u8fd4\u56de\u7684\u62a5\u6587\u662f{}", (Object)respXml);
        org.json.JSONObject jsonObject = XML.toJSONObject((String)respXml).getJSONObject("Response");
        BaseResposeVO baseResposeVo = (BaseResposeVO)JSONObject.parseObject((String)jsonObject.toString(), BaseResposeVO.class);
        if ("OK".equalsIgnoreCase(baseResposeVo.getHead()) && baseResposeVo.getBody() != null) {
            FilterOrderVO filterOrderVO = (FilterOrderVO)JSONObject.parseObject((String)baseResposeVo.getBody().getJSONObject("OrderFilterResponse").toString(), FilterOrderVO.class);
            return BaseResponse.success((Object)filterOrderVO);
        }
        return BaseResponse.error((String)"\u7b5b\u9009\u8ba2\u5355\u51fa\u9519");
    }
}

