/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.exception.BusinessException;
import com.byh.pojo.entity.MtLocalOrder;
import com.byh.pojo.vo.req.CancelMtLocalOrderReqVO;
import com.byh.pojo.vo.req.CreateMtLocalOrderReqVO;
import com.byh.pojo.vo.req.GetMtOrderInfoReqVO;
import com.byh.pojo.vo.resp.CancelMtLocalOrderRespVO;
import com.byh.pojo.vo.resp.CreateMtLocalOrderRespVO;
import com.byh.service.MtLocalOrderService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7f8e\u56e2\u540c\u57ce\u8ba2\u5355\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/access2/mt/local/order"})
public class MtLocalOrderController {
    private static final Logger log = LoggerFactory.getLogger(MtLocalOrderController.class);
    @Autowired
    private MtLocalOrderService mtLocalOrderService;

    @ApiOperation(value="\u7f8e\u56e2\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"/create"})
    public BaseResponse create(@RequestBody @Validated CreateMtLocalOrderReqVO createMtLocalOrderReqVO) {
        CreateMtLocalOrderRespVO createMtLocalOrderRespVO = this.mtLocalOrderService.createOrder(createMtLocalOrderReqVO);
        return BaseResponse.success((Object)createMtLocalOrderRespVO);
    }

    @ApiOperation(value="\u7f8e\u56e2\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"/cancel"})
    public BaseResponse cancel(@RequestBody @Validated CancelMtLocalOrderReqVO cancelMtLocalOrderReqVO) {
        CancelMtLocalOrderRespVO cancelMtLocalOrderRespVO = this.mtLocalOrderService.cancelOrder(cancelMtLocalOrderReqVO);
        return BaseResponse.success((Object)cancelMtLocalOrderRespVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u7f8e\u56e2\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/getMtOrderInfo"})
    public BaseResponse getMtOrderInfo(@RequestBody @Validated GetMtOrderInfoReqVO getMtOrderInfoReqVO) {
        Long zwbyOrderId = getMtOrderInfoReqVO.getZwbyOrderId();
        String orderId = getMtOrderInfoReqVO.getOrderId();
        if (zwbyOrderId == null && (orderId == null || "".equals(orderId.trim()))) {
            throw new BusinessException("zwbyOrderId\u548corderId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        MtLocalOrder mtLocalOrder = this.mtLocalOrderService.getMtOrderInfo(getMtOrderInfoReqVO);
        return BaseResponse.success((Object)mtLocalOrder);
    }
}

