/*
 * Decompiled with CFR 0.152.
 */
package com.byh.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.byh.config.RequestWrapper;
import com.byh.exception.AuthException;
import com.byh.pojo.entity.Merchant;
import com.byh.service.MerchantService;
import com.byh.util.BYSignUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private static final String TEST_ENVIRONMENT = "test";
    private static final String PRO_ENVIRONMENT = "pro";
    private static final String BATCH_ADD_ORDER_URI = "/access/sfmedical/batchAddOrder";
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private MerchantService merchantService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("environment = " + this.environment);
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        log.info("body = " + body);
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        Set entries = jsonObject.entrySet();
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String val = entry.getValue().toString();
            map.put(key, val);
        }
        String appId = (String)map.get("appId");
        if (appId == null || "".equals(appId.trim())) {
            throw new AuthException("appId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String merchantId = (String)map.get("merchantId");
        if (merchantId == null || "".equals(merchantId.trim())) {
            throw new AuthException("merchantId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)Long.valueOf(merchantId));
        if (merchant == null) {
            throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        String requestURI = request.getRequestURI();
        if (BATCH_ADD_ORDER_URI.equals(requestURI)) {
            return true;
        }
        if (TEST_ENVIRONMENT.equals(this.environment)) {
            String testAppId = merchant.getTestAppId();
            if (!appId.equals(testAppId)) throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
            String testAppSecret = merchant.getTestAppSecret();
            BYSignUtil.checkSign(map, (String)testAppSecret);
            return true;
        } else {
            if (!PRO_ENVIRONMENT.equals(this.environment)) throw new AuthException("\u73af\u5883\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01");
            String formalAppId = merchant.getFormalAppId();
            if (!appId.equals(formalAppId)) throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
            String formalAppSecret = merchant.getFormalAppSecret();
            BYSignUtil.checkSign(map, (String)formalAppSecret);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

