/*
 * Decompiled with CFR 0.152.
 */
package com.byh.mq;

import com.alibaba.fastjson.JSON;
import com.byh.dao.MtCallbackUrlMapper;
import com.byh.exception.BusinessException;
import com.byh.msg.MtMsgInfo;
import com.byh.msg.ResponseMsg;
import com.byh.pojo.entity.Merchant;
import com.byh.pojo.entity.MtCallbackUrlEntity;
import com.byh.service.MerchantService;
import com.byh.util.HttpUtils;
import com.byh.util.NewSignUtil;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class MtOrderStatusMsgConsumer {
    private static final Logger log = LoggerFactory.getLogger(MtOrderStatusMsgConsumer.class);
    private static final String TEST_ENVIRONMENT = "test";
    private static final String SUCCESS_CODE = "success";
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private MtCallbackUrlMapper mtCallbackUrlMapper;
    @Autowired
    private MerchantService merchantService;

    @RabbitHandler
    @RabbitListener(queues={"mt_order_msg_queue"})
    public void process(@RequestBody MtMsgInfo mtMsgInfo) throws UnsupportedEncodingException {
        MtCallbackUrlEntity mtCallbackUrlEntity;
        log.info("\u56de\u8c03\u4e1a\u52a1\u670d\u52a1MtMsgInfo\u5165\u53c2\u5b9e\u4f53\uff1a{}", (Object)JsonUtil.convertObject((Object)mtMsgInfo));
        Long merchantId = mtMsgInfo.getMerchantId();
        if (null != mtMsgInfo && null != merchantId && null != (mtCallbackUrlEntity = this.mtCallbackUrlMapper.selectByMerchantId(merchantId))) {
            String notifyUrl = mtCallbackUrlEntity.getNotifyUrl();
            Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
            String postJsonStr = JSON.toJSONString((Object)mtMsgInfo);
            String sign = null;
            if (TEST_ENVIRONMENT.equals(this.environment)) {
                String testAppId = merchant.getTestAppId();
                String testAppSecret = merchant.getTestAppSecret();
                sign = NewSignUtil.sign((String)postJsonStr, (String)testAppId, (String)testAppSecret);
            } else {
                String formalAppId = merchant.getFormalAppId();
                String formalAppSecret = merchant.getFormalAppSecret();
                sign = NewSignUtil.sign((String)postJsonStr, (String)formalAppId, (String)formalAppSecret);
            }
            try {
                log.info("\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u8ba2\u5355url\uff1a{},\u5165\u53c2\u5b9e\u4f53\uff1a{}", (Object)notifyUrl, (Object)postJsonStr);
                String postJsonResp = HttpUtils.postJson((String)(notifyUrl + "?sign=" + sign), (String)postJsonStr);
                log.info("\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u8ba2\u5355url\uff1a{},\u8fd4\u53c2\u5b9e\u4f53\uff1a{}", (Object)notifyUrl, (Object)postJsonResp);
                Gson gson = new Gson();
                ResponseMsg responseMsg = (ResponseMsg)gson.fromJson(postJsonResp, ResponseMsg.class);
                if (responseMsg.getCode() != 0 || !SUCCESS_CODE.equals(responseMsg.getMsg())) {
                    throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
            }
        }
    }
}

