/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.DicChannelMapper;
import com.byh.dao.MerchantChannelRelationMapper;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.DicChannel;
import com.byh.pojo.entity.MerchantChannelRelation;
import com.byh.pojo.vo.req.DicChannelPageReqVO;
import com.byh.pojo.vo.req.MerchantOpenedChannelRespVO;
import com.byh.pojo.vo.req.SaveDicChannelReqVO;
import com.byh.pojo.vo.req.UpdateDicChannelReqVO;
import com.byh.pojo.vo.req.UpdateMerchantOpenedChannelReqVO;
import com.byh.service.DicChannelService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DicChannelServiceImpl
implements DicChannelService {
    @Autowired
    private DicChannelMapper dicChannelMapper;
    @Autowired
    private MerchantChannelRelationMapper merchantChannelRelationMapper;

    public int insert(DicChannel entity) {
        return this.dicChannelMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.dicChannelMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(DicChannel entity) {
        this.dicChannelMapper.updateByPrimaryKeySelective(entity);
    }

    public DicChannel selectByPrimaryKey(Long id) {
        return this.dicChannelMapper.selectByPrimaryKey(id);
    }

    public PageResult<DicChannel> getPage(DicChannelPageReqVO dicChannelPageReqVO) {
        Integer pageNum = dicChannelPageReqVO.getPageNum();
        Integer pageSize = dicChannelPageReqVO.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dicChannelList = this.dicChannelMapper.findByPageReqVO(dicChannelPageReqVO);
        PageInfo pageInfo = new PageInfo(dicChannelList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(dicChannelList);
        return pageResult;
    }

    public void save(SaveDicChannelReqVO saveDicChannelReqVO) {
        DicChannel dicChannel = new DicChannel();
        BeanUtils.copyProperties((Object)saveDicChannelReqVO, (Object)dicChannel);
        dicChannel.setStatus(Integer.valueOf(1));
        dicChannel.setViewId(UUIDUtils.getUUID());
        this.insert(dicChannel);
    }

    public void update(UpdateDicChannelReqVO updateDicChannelReqVO) {
        DicChannel dicChannel = this.selectByPrimaryKey(updateDicChannelReqVO.getId());
        if (dicChannel == null) {
            throw new BusinessException("\u7528\u6237\u5df2\u5220\u9664\uff01");
        }
        BeanUtils.copyProperties((Object)updateDicChannelReqVO, (Object)dicChannel);
        this.updateByPrimaryKeySelective(dicChannel);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateMerchantOpenedChannel(UpdateMerchantOpenedChannelReqVO updateMerchantOpenedChannelReqVO) {
        Long merchantId = updateMerchantOpenedChannelReqVO.getMerchantId();
        this.merchantChannelRelationMapper.deleteByMerchantId(merchantId);
        Long[] dicChannelIds = updateMerchantOpenedChannelReqVO.getDicChannelIds();
        if (dicChannelIds != null && dicChannelIds.length > 0) {
            for (Long dicChannelId : dicChannelIds) {
                MerchantChannelRelation merchantChannelRelation = new MerchantChannelRelation();
                merchantChannelRelation.setMerchantId(merchantId);
                merchantChannelRelation.setChannelId(dicChannelId);
                this.merchantChannelRelationMapper.insert(merchantChannelRelation);
            }
        }
    }

    public List<MerchantOpenedChannelRespVO> findMerchantOpenedChannel(Long merchantId) {
        List merchantOpenedChannelRespVOList = this.dicChannelMapper.findOpenedChannelList(merchantId);
        List dicChannelList = this.dicChannelMapper.findAll();
        if (merchantOpenedChannelRespVOList == null && merchantOpenedChannelRespVOList.size() <= 0) {
            if (dicChannelList != null && dicChannelList.size() > 0) {
                ArrayList<MerchantOpenedChannelRespVO> merchantOpenedChannelRespVOS = new ArrayList<MerchantOpenedChannelRespVO>();
                for (DicChannel dicChannel : dicChannelList) {
                    MerchantOpenedChannelRespVO merchantOpenedChannelRespVO = new MerchantOpenedChannelRespVO();
                    merchantOpenedChannelRespVO.setDicChannelId(dicChannel.getId());
                    merchantOpenedChannelRespVO.setChannelName(dicChannel.getChannelName());
                    merchantOpenedChannelRespVO.setChannelDesc(dicChannel.getChannelDesc());
                    merchantOpenedChannelRespVO.setIsLocal(dicChannel.getIsLocal());
                    merchantOpenedChannelRespVO.setOpenedFlag(Integer.valueOf(-1));
                    merchantOpenedChannelRespVOS.add(merchantOpenedChannelRespVO);
                }
                return merchantOpenedChannelRespVOS;
            }
        } else if (dicChannelList != null && dicChannelList.size() > 0) {
            ArrayList<MerchantOpenedChannelRespVO> merchantOpenedChannelRespVOS = new ArrayList<MerchantOpenedChannelRespVO>();
            for (DicChannel dicChannel : dicChannelList) {
                int flag = -1;
                Long channelId = dicChannel.getId();
                for (MerchantOpenedChannelRespVO merchantOpenedChannelRespVO : merchantOpenedChannelRespVOList) {
                    Long dicChannelId = merchantOpenedChannelRespVO.getDicChannelId();
                    if (!dicChannelId.equals(channelId)) continue;
                    flag = 1;
                }
                MerchantOpenedChannelRespVO merchantOpenedChannelRespVO = new MerchantOpenedChannelRespVO();
                merchantOpenedChannelRespVO.setDicChannelId(channelId);
                merchantOpenedChannelRespVO.setChannelName(dicChannel.getChannelName());
                merchantOpenedChannelRespVO.setChannelDesc(dicChannel.getChannelDesc());
                merchantOpenedChannelRespVO.setIsLocal(dicChannel.getIsLocal());
                if (flag == 1) {
                    merchantOpenedChannelRespVO.setOpenedFlag(Integer.valueOf(1));
                } else {
                    merchantOpenedChannelRespVO.setOpenedFlag(Integer.valueOf(-1));
                }
                merchantOpenedChannelRespVOS.add(merchantOpenedChannelRespVO);
            }
            return merchantOpenedChannelRespVOS;
        }
        return null;
    }
}

