/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.MtLocalOrderMapper;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.MtLocalOrder;
import com.byh.pojo.vo.req.CancelMtLocalOrderReqVO;
import com.byh.pojo.vo.req.CreateMtLocalOrderReqVO;
import com.byh.pojo.vo.req.GetMtOrderInfoReqVO;
import com.byh.pojo.vo.resp.CancelMtLocalOrderRespVO;
import com.byh.pojo.vo.resp.CreateMtLocalOrderRespVO;
import com.byh.service.MtLocalOrderService;
import com.byh.util.mt.MTRequestHelper;
import com.byh.util.mt.vo.CancelOrderVO;
import com.byh.util.mt.vo.CreateOrderByShopVO;
import com.byh.util.mt.vo.req.CancelOrderReqVO;
import com.byh.util.mt.vo.req.CreateOrderByShopReqVO;
import com.byh.util.mt.vo.resp.CancelOrderRespVO;
import com.byh.util.mt.vo.resp.CreateOrderByShopRespVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MtLocalOrderServiceImpl
implements MtLocalOrderService {
    @Autowired
    private MtLocalOrderMapper mtLocalOrderMapper;

    public int insert(MtLocalOrder entity) {
        return this.mtLocalOrderMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.mtLocalOrderMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(MtLocalOrder entity) {
        this.mtLocalOrderMapper.updateByPrimaryKeySelective(entity);
    }

    public MtLocalOrder selectByPrimaryKey(Long id) {
        return this.mtLocalOrderMapper.selectByPrimaryKey(id);
    }

    @Transactional(rollbackFor={Exception.class, BusinessException.class})
    public CreateMtLocalOrderRespVO createOrder(CreateMtLocalOrderReqVO createMtLocalOrderReqVO) {
        CreateOrderByShopReqVO createOrderByShopReqVO = new CreateOrderByShopReqVO();
        createOrderByShopReqVO.setDelivery_id(createMtLocalOrderReqVO.getDeliveryId().toString());
        createOrderByShopReqVO.setOrder_id(createMtLocalOrderReqVO.getOrderId());
        createOrderByShopReqVO.setShop_id(createMtLocalOrderReqVO.getShopId());
        createOrderByShopReqVO.setDelivery_service_code(createMtLocalOrderReqVO.getDeliveryServiceCode().toString());
        createOrderByShopReqVO.setReceiver_name(createMtLocalOrderReqVO.getReceiverName());
        createOrderByShopReqVO.setReceiver_address(createMtLocalOrderReqVO.getReceiverAddress());
        createOrderByShopReqVO.setReceiver_phone(createMtLocalOrderReqVO.getReceiverPhone());
        createOrderByShopReqVO.setReceiver_lng(createMtLocalOrderReqVO.getReceiverLng().toString());
        createOrderByShopReqVO.setReceiver_lat(createMtLocalOrderReqVO.getReceiverLat().toString());
        createOrderByShopReqVO.setCoordinate_type(createMtLocalOrderReqVO.getCoordinateType().toString());
        createOrderByShopReqVO.setGoods_value(createMtLocalOrderReqVO.getGoodsValue().toString());
        createOrderByShopReqVO.setGoods_height(createMtLocalOrderReqVO.getGoodsHeight().toString());
        createOrderByShopReqVO.setGoods_width(createMtLocalOrderReqVO.getGoodsWidth().toString());
        createOrderByShopReqVO.setGoods_length(createMtLocalOrderReqVO.getGoodsLength().toString());
        createOrderByShopReqVO.setGoods_weight(createMtLocalOrderReqVO.getGoodsWeight().toString());
        createOrderByShopReqVO.setGoods_detail(createMtLocalOrderReqVO.getGoodsDetail());
        createOrderByShopReqVO.setGoods_pickup_info(createMtLocalOrderReqVO.getGoodsPickupInfo());
        createOrderByShopReqVO.setGoods_delivery_info(createMtLocalOrderReqVO.getGoodsDeliveryInfo());
        createOrderByShopReqVO.setExpected_pickup_time(createMtLocalOrderReqVO.getExpectedPickupTime().toString());
        createOrderByShopReqVO.setExpected_delivery_time(createMtLocalOrderReqVO.getExpectedDeliveryTime().toString());
        createOrderByShopReqVO.setOrder_type(createMtLocalOrderReqVO.getOrderType().toString());
        createOrderByShopReqVO.setPoi_seq(createMtLocalOrderReqVO.getPoiSeq());
        createOrderByShopReqVO.setNote(createMtLocalOrderReqVO.getNote());
        createOrderByShopReqVO.setCash_on_delivery(createMtLocalOrderReqVO.getCashOnDelivery().toString());
        createOrderByShopReqVO.setCash_on_pickup(createMtLocalOrderReqVO.getCashOnPickup().toString());
        createOrderByShopReqVO.setInvoice_title(createMtLocalOrderReqVO.getInvoiceTitle());
        CreateOrderByShopRespVO createOrderByShopRespVO = MTRequestHelper.createOrderByShop((CreateOrderByShopReqVO)createOrderByShopReqVO);
        if (createOrderByShopRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0b\u5355\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(createOrderByShopRespVO.getCode())) {
            throw new BusinessException("\u8c03\u7528\u9519\u8bef\uff1a" + createOrderByShopRespVO.getMsg());
        }
        CreateOrderByShopVO createOrderByShopVO = createOrderByShopRespVO.getData();
        Long deliveryId = createOrderByShopVO.getDelivery_id();
        String orderId = createOrderByShopVO.getOrder_id();
        String mtPeisongId = createOrderByShopVO.getMt_peisong_id();
        MtLocalOrder mtLocalOrder = new MtLocalOrder();
        BeanUtils.copyProperties((Object)createMtLocalOrderReqVO, (Object)mtLocalOrder);
        mtLocalOrder.setStatus(Integer.valueOf(1));
        mtLocalOrder.setMtPeisongId(mtPeisongId);
        mtLocalOrder.setDeliveryId(deliveryId);
        mtLocalOrder.setOrderId(orderId);
        this.insert(mtLocalOrder);
        CreateMtLocalOrderRespVO createMtLocalOrderRespVO = new CreateMtLocalOrderRespVO();
        createMtLocalOrderRespVO.setZwbyOrderId(mtLocalOrder.getId());
        createMtLocalOrderRespVO.setDeliveryId(deliveryId);
        createMtLocalOrderRespVO.setOrderId(orderId);
        return createMtLocalOrderRespVO;
    }

    public MtLocalOrder getByOrderId(String orderId) {
        return this.mtLocalOrderMapper.getByOrderId(orderId);
    }

    public MtLocalOrder getMtOrderInfo(GetMtOrderInfoReqVO getMtOrderInfoReqVO) {
        return this.mtLocalOrderMapper.getMtOrderInfo(getMtOrderInfoReqVO);
    }

    public CancelMtLocalOrderRespVO cancelOrder(CancelMtLocalOrderReqVO cancelMtLocalOrderReqVO) {
        Long id = cancelMtLocalOrderReqVO.getId();
        MtLocalOrder mtLocalOrder = this.selectByPrimaryKey(id);
        if (mtLocalOrder != null) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        String mtPeisongId = mtLocalOrder.getMtPeisongId();
        Long deliveryId = mtLocalOrder.getDeliveryId();
        CancelOrderReqVO cancelOrderReqVO = new CancelOrderReqVO();
        cancelOrderReqVO.setDelivery_id(String.valueOf(deliveryId));
        cancelOrderReqVO.setMt_peisong_id(mtPeisongId);
        String cancelReasonId = cancelMtLocalOrderReqVO.getCancel_reason_id();
        cancelOrderReqVO.setCancel_reason_id(cancelReasonId);
        String cancelReason = cancelMtLocalOrderReqVO.getCancel_reason();
        cancelOrderReqVO.setCancel_reason(cancelReason);
        Long timestamp = System.currentTimeMillis() / 1000L;
        cancelOrderReqVO.setTimestamp(String.valueOf(timestamp));
        CancelOrderRespVO cancelOrderRespVO = MTRequestHelper.cancelOrder((CancelOrderReqVO)cancelOrderReqVO);
        if (cancelOrderRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(cancelOrderRespVO.getCode())) {
            throw new BusinessException("\u8c03\u7528\u9519\u8bef\uff1a" + cancelOrderRespVO.getMsg());
        }
        CancelOrderVO cancelOrderVO = cancelOrderRespVO.getData();
        CancelMtLocalOrderRespVO cancelMtLocalOrderRespVO = new CancelMtLocalOrderRespVO();
        cancelMtLocalOrderRespVO.setMt_peisong_id(cancelOrderVO.getMt_peisong_id());
        cancelMtLocalOrderRespVO.setOrder_id(cancelOrderVO.getOrder_id());
        cancelMtLocalOrderRespVO.setDelivery_id(cancelOrderVO.getDelivery_id());
        cancelMtLocalOrderRespVO.setByOrderId(id);
        return cancelMtLocalOrderRespVO;
    }
}

