/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.MtLocalStoreMapper;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.MtLocalStore;
import com.byh.pojo.vo.req.UpdateMtLocalStoreReqVO;
import com.byh.service.MtLocalStoreService;
import com.byh.util.UUIDUtil;
import com.byh.util.mt.MTRequestHelper;
import com.byh.util.mt.vo.req.CreateShopReqVO;
import com.byh.util.mt.vo.resp.CreateShopRespVO;
import java.math.BigDecimal;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MtLocalStoreServiceImpl
implements MtLocalStoreService {
    @Autowired
    private MtLocalStoreMapper mtLocalStoreMapper;

    public int insert(MtLocalStore entity) {
        return this.mtLocalStoreMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.mtLocalStoreMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(MtLocalStore entity) {
        this.mtLocalStoreMapper.updateByPrimaryKeySelective(entity);
    }

    public MtLocalStore selectByPrimaryKey(Long id) {
        return this.mtLocalStoreMapper.selectByPrimaryKey(id);
    }

    public MtLocalStore getBySenderCommonId(Long senderCommonId) {
        return this.mtLocalStoreMapper.getBySenderCommonId(senderCommonId);
    }

    public MtLocalStore getByShopId(String shopId) {
        return this.mtLocalStoreMapper.getByShopId(shopId);
    }

    public void updateMtLocalStore(UpdateMtLocalStoreReqVO updateMtLocalStoreReqVO) {
        Long id = updateMtLocalStoreReqVO.getId();
        MtLocalStore mtLocalStore = this.selectByPrimaryKey(id);
        Integer shopStatus = mtLocalStore.getShopStatus();
        if (shopStatus.equals(20)) {
            throw new BusinessException("\u5e97\u94fa\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (shopStatus.equals(30)) {
            throw new BusinessException("\u5e97\u94fa\u521b\u5efa\u6210\u529f\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (shopStatus.equals(40)) {
            throw new BusinessException("\u5e97\u94fa\u53ef\u4e0a\u7ebf\u53ef\u53d1\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        BeanUtils.copyProperties((Object)updateMtLocalStoreReqVO, (Object)mtLocalStore);
        mtLocalStore.setShopId(UUIDUtil.getUUID());
        this.updateByPrimaryKeySelective(mtLocalStore);
        CreateShopReqVO createShopReqVO = new CreateShopReqVO();
        createShopReqVO.setBusiness_hours(mtLocalStore.getBusinessHours());
        createShopReqVO.setContact_name(mtLocalStore.getContactName());
        createShopReqVO.setContact_phone(mtLocalStore.getContactPhone());
        String shopLat = new BigDecimal(mtLocalStore.getShopLat()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lat(shopLat);
        createShopReqVO.setSecond_category(mtLocalStore.getSecondCategory().toString());
        createShopReqVO.setDelivery_service_codes(mtLocalStore.getDeliveryServiceCodes());
        createShopReqVO.setShop_name(mtLocalStore.getShopName());
        String shopLng = new BigDecimal(mtLocalStore.getShopLng()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lng(shopLng);
        createShopReqVO.setShop_address(mtLocalStore.getShopAddress());
        createShopReqVO.setContact_email(mtLocalStore.getContactEmail());
        createShopReqVO.setShop_id(mtLocalStore.getShopId());
        createShopReqVO.setShop_address_detail(mtLocalStore.getShopAddressDetail());
        createShopReqVO.setCategory(mtLocalStore.getCategory().toString());
        createShopReqVO.setCoordinate_type(mtLocalStore.getCoordinateType().toString());
        CreateShopRespVO createShopRespVO = MTRequestHelper.createShop((CreateShopReqVO)createShopReqVO);
        if (createShopRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8ba2\u5355\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(createShopRespVO.getCode())) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6838\u8c03\u7528\u9519\u8bef\uff1a" + createShopRespVO.getMsg());
        }
        mtLocalStore.setShopStatus(createShopRespVO.getData().getStatus());
        this.updateByPrimaryKeySelective(mtLocalStore);
    }
}

