/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.SenderCommonMapper;
import com.byh.enums.JdReviewStatusEnum;
import com.byh.enums.SfLocalReviewStatusEnum;
import com.byh.enums.SfMedicalReviewStatusEnum;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.MtLocalStore;
import com.byh.pojo.entity.SenderAddressChannel;
import com.byh.pojo.entity.SenderCommon;
import com.byh.pojo.entity.SfLocalStore;
import com.byh.pojo.vo.req.FindAllMerchantAddressPageReqVO;
import com.byh.pojo.vo.req.GetMerchantAddressDetailReqVO;
import com.byh.pojo.vo.req.JdReviewPassedReqVO;
import com.byh.pojo.vo.req.JdReviewRejectedReqVO;
import com.byh.pojo.vo.req.SaveMtLocalStoreReqVO;
import com.byh.pojo.vo.req.SaveSenderAddressReqVO;
import com.byh.pojo.vo.req.SaveSenderCommonReqVO;
import com.byh.pojo.vo.req.SfLocalStoreReqVO;
import com.byh.pojo.vo.req.SfMedicalReviewPassedReqVO;
import com.byh.pojo.vo.req.SfMedicalReviewRejectedReqVO;
import com.byh.pojo.vo.req.UpdateMtLocalStoreReqVO;
import com.byh.pojo.vo.req.UpdateSenderAddressReqVO;
import com.byh.pojo.vo.req.UpdateSenderCommonReqVO;
import com.byh.pojo.vo.req.UpdateSfLocalStoreReqVO;
import com.byh.service.MtLocalStoreService;
import com.byh.service.SenderAddressChannelService;
import com.byh.service.SenderCommonService;
import com.byh.service.SfLocalStoreService;
import com.byh.util.UUIDUtil;
import com.byh.util.mt.MTRequestHelper;
import com.byh.util.mt.vo.req.CreateShopReqVO;
import com.byh.util.mt.vo.resp.CreateShopRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SenderCommonServiceImpl
implements SenderCommonService {
    @Autowired
    private SenderCommonMapper senderCommonMapper;
    @Autowired
    private MtLocalStoreService mtLocalStoreService;
    @Autowired
    private SenderAddressChannelService senderAddressChannelService;
    @Autowired
    private SfLocalStoreService sfLocalStoreService;

    public int insert(SenderCommon entity) {
        return this.senderCommonMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.senderCommonMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(SenderCommon entity) {
        this.senderCommonMapper.updateByPrimaryKeySelective(entity);
    }

    public SenderCommon selectByPrimaryKey(Long id) {
        return this.senderCommonMapper.selectByPrimaryKey(id);
    }

    @Transactional
    public void saveSenderAddress(SaveSenderAddressReqVO saveSenderAddressReqVO) {
        SaveSenderCommonReqVO senderCommonReqVO = saveSenderAddressReqVO.getSaveSenderCommonReqVO();
        SenderCommon senderCommon = new SenderCommon();
        BeanUtils.copyProperties((Object)senderCommonReqVO, (Object)senderCommon);
        senderCommon.setStatus(Integer.valueOf(1));
        senderCommon.setViewId(UUIDUtil.getUUID());
        this.insert(senderCommon);
        SenderAddressChannel sfSenderAddressChannel = new SenderAddressChannel();
        sfSenderAddressChannel.setViewId(UUIDUtil.getUUID());
        sfSenderAddressChannel.setStatus(Integer.valueOf(1));
        sfSenderAddressChannel.setChannelName("\u987a\u4e30\u533b\u7597\u914d\u9001");
        sfSenderAddressChannel.setSenderCommonId(senderCommon.getId());
        sfSenderAddressChannel.setEnabled(Integer.valueOf(1));
        this.senderAddressChannelService.insert((Object)sfSenderAddressChannel);
        SenderAddressChannel jdSenderAddressChannel = new SenderAddressChannel();
        jdSenderAddressChannel.setViewId(UUIDUtil.getUUID());
        jdSenderAddressChannel.setStatus(Integer.valueOf(1));
        jdSenderAddressChannel.setChannelName("\u4eac\u4e1c\u7269\u6d41");
        jdSenderAddressChannel.setSenderCommonId(senderCommon.getId());
        jdSenderAddressChannel.setEnabled(Integer.valueOf(1));
        this.senderAddressChannelService.insert((Object)jdSenderAddressChannel);
        SaveMtLocalStoreReqVO mtLocalStoreReqVO = saveSenderAddressReqVO.getSaveMtLocalStoreReqVO();
        MtLocalStore mtLocalStore = new MtLocalStore();
        BeanUtils.copyProperties((Object)mtLocalStoreReqVO, (Object)mtLocalStore);
        mtLocalStore.setStatus(Integer.valueOf(1));
        mtLocalStore.setShopId(UUIDUtil.getUUID());
        mtLocalStore.setViewId(UUIDUtil.getUUID());
        mtLocalStore.setSenderCommonId(senderCommon.getId());
        mtLocalStore.setShopLng(senderCommonReqVO.getSenderLng());
        mtLocalStore.setShopLat(senderCommonReqVO.getSenderLat());
        mtLocalStore.setCoordinateType(senderCommonReqVO.getCoordinateType());
        mtLocalStore.setContactName(senderCommonReqVO.getSenderName());
        mtLocalStore.setContactPhone(senderCommonReqVO.getSenderMobile());
        mtLocalStore.setContactEmail(senderCommonReqVO.getSenderEmail());
        mtLocalStore.setShopAddress(senderCommonReqVO.getSenderDetailedAddress());
        this.mtLocalStoreService.insert((Object)mtLocalStore);
        SfLocalStoreReqVO sfLocalStoreReqVO = saveSenderAddressReqVO.getSfLocalStoreReqVO();
        SfLocalStore sfLocalStore = new SfLocalStore();
        BeanUtils.copyProperties((Object)sfLocalStoreReqVO, (Object)sfLocalStore);
        sfLocalStore.setViewId(UUIDUtil.getUUID());
        sfLocalStore.setStatus(Integer.valueOf(1));
        sfLocalStore.setShopStatus(Integer.valueOf(10));
        sfLocalStore.setWhetherDockSystem(Integer.valueOf(1));
        sfLocalStore.setSenderCommonId(senderCommon.getId());
        this.sfLocalStoreService.insert((Object)sfLocalStore);
        CreateShopReqVO createShopReqVO = new CreateShopReqVO();
        createShopReqVO.setBusiness_hours(mtLocalStore.getBusinessHours());
        createShopReqVO.setContact_name(mtLocalStore.getContactName());
        createShopReqVO.setContact_phone(mtLocalStore.getContactPhone());
        String shopLat = new BigDecimal(mtLocalStore.getShopLat()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lat(shopLat);
        createShopReqVO.setSecond_category(mtLocalStore.getSecondCategory().toString());
        createShopReqVO.setDelivery_service_codes(mtLocalStore.getDeliveryServiceCodes());
        createShopReqVO.setShop_name(mtLocalStore.getShopName());
        String shopLng = new BigDecimal(mtLocalStore.getShopLng()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lng(shopLng);
        createShopReqVO.setShop_address(mtLocalStore.getShopAddress());
        createShopReqVO.setContact_email(mtLocalStore.getContactEmail());
        createShopReqVO.setShop_id(mtLocalStore.getShopId());
        createShopReqVO.setShop_address_detail(mtLocalStore.getShopAddressDetail());
        createShopReqVO.setCategory(mtLocalStore.getCategory().toString());
        createShopReqVO.setCoordinate_type(mtLocalStore.getCoordinateType().toString());
        CreateShopRespVO createShopRespVO = MTRequestHelper.createShop((CreateShopReqVO)createShopReqVO);
        if (createShopRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8ba2\u5355\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(createShopRespVO.getCode())) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6838\u8c03\u7528\u9519\u8bef\uff1a" + createShopRespVO.getMsg());
        }
        mtLocalStore.setShopStatus(createShopRespVO.getData().getStatus());
        this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
    }

    public List<Map<String, Object>> findMerchantAddressList(Long merchantId) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List senderCommonList = this.findByMerchantId(merchantId);
        if (senderCommonList != null && senderCommonList.size() > 0) {
            for (SenderCommon senderCommon : senderCommonList) {
                Long senderCommonId = senderCommon.getId();
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("senderCommon", senderCommon);
                MtLocalStore mtLocalStore = this.mtLocalStoreService.getBySenderCommonId(senderCommonId);
                map.put("mtLocalStore", mtLocalStore);
                SfLocalStore sfLocalStore = this.sfLocalStoreService.getBySenderCommonId(senderCommonId);
                map.put("sfLocalStore", sfLocalStore);
                List senderAddressChannelList = this.senderAddressChannelService.findBySenderCommonId(senderCommonId);
                map.put("senderAddressChannelList", senderAddressChannelList);
                mapList.add(map);
            }
        }
        return mapList;
    }

    public List<SenderCommon> findByMerchantId(Long merchantId) {
        return this.senderCommonMapper.findByMerchantId(merchantId);
    }

    @Transactional
    public void updateSenderAddress(UpdateSenderAddressReqVO updateSenderAddressReqVO) {
        UpdateSenderCommonReqVO updateSenderCommonReqVO = updateSenderAddressReqVO.getUpdateSenderCommonReqVO();
        UpdateMtLocalStoreReqVO updateMtLocalStoreReqVO = updateSenderAddressReqVO.getUpdateMtLocalStoreReqVO();
        Long id = updateMtLocalStoreReqVO.getId();
        MtLocalStore mtLocalStore = (MtLocalStore)this.mtLocalStoreService.selectByPrimaryKey((Serializable)id);
        Integer shopStatus = mtLocalStore.getShopStatus();
        if (shopStatus.equals(20)) {
            throw new BusinessException("\u5e97\u94fa\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (shopStatus.equals(30)) {
            throw new BusinessException("\u5e97\u94fa\u521b\u5efa\u6210\u529f\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (shopStatus.equals(40)) {
            throw new BusinessException("\u5e97\u94fa\u53ef\u4e0a\u7ebf\u53ef\u53d1\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        Long senderCommonId = updateSenderCommonReqVO.getId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        Integer sfMedicalStatus = senderCommon.getSfMedicalStatus();
        if (SfMedicalReviewStatusEnum.PASSED.getValue().equals(sfMedicalStatus)) {
            throw new BusinessException("\u987a\u4e30\u533b\u7597\u914d\u9001\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        Integer jdStatus = senderCommon.getJdStatus();
        if (JdReviewStatusEnum.PASSED.getValue().equals(jdStatus)) {
            throw new BusinessException("\u4eac\u4e1c\u914d\u9001\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        BeanUtils.copyProperties((Object)updateSenderCommonReqVO, (Object)senderCommon);
        senderCommon.setStatus(Integer.valueOf(1));
        senderCommon.setViewId(UUIDUtil.getUUID());
        this.updateByPrimaryKeySelective(senderCommon);
        BeanUtils.copyProperties((Object)updateMtLocalStoreReqVO, (Object)mtLocalStore);
        mtLocalStore.setShopId(UUIDUtil.getUUID());
        mtLocalStore.setSenderCommonId(senderCommon.getId());
        mtLocalStore.setShopLng(updateSenderCommonReqVO.getSenderLng());
        mtLocalStore.setShopLat(updateSenderCommonReqVO.getSenderLat());
        mtLocalStore.setCoordinateType(updateSenderCommonReqVO.getCoordinateType());
        mtLocalStore.setContactName(updateSenderCommonReqVO.getSenderName());
        mtLocalStore.setContactPhone(updateSenderCommonReqVO.getSenderMobile());
        mtLocalStore.setContactEmail(updateSenderCommonReqVO.getSenderEmail());
        mtLocalStore.setShopAddress(updateSenderCommonReqVO.getSenderDetailedAddress());
        this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
        CreateShopReqVO createShopReqVO = new CreateShopReqVO();
        createShopReqVO.setBusiness_hours(mtLocalStore.getBusinessHours());
        createShopReqVO.setContact_name(mtLocalStore.getContactName());
        createShopReqVO.setContact_phone(mtLocalStore.getContactPhone());
        String shopLat = new BigDecimal(mtLocalStore.getShopLat()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lat(shopLat);
        createShopReqVO.setSecond_category(mtLocalStore.getSecondCategory().toString());
        createShopReqVO.setDelivery_service_codes(mtLocalStore.getDeliveryServiceCodes());
        createShopReqVO.setShop_name(mtLocalStore.getShopName());
        String shopLng = new BigDecimal(mtLocalStore.getShopLng()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lng(shopLng);
        createShopReqVO.setShop_address(mtLocalStore.getShopAddress());
        createShopReqVO.setContact_email(mtLocalStore.getContactEmail());
        createShopReqVO.setShop_id(mtLocalStore.getShopId());
        createShopReqVO.setShop_address_detail(mtLocalStore.getShopAddressDetail());
        createShopReqVO.setCategory(mtLocalStore.getCategory().toString());
        createShopReqVO.setCoordinate_type(mtLocalStore.getCoordinateType().toString());
        CreateShopRespVO createShopRespVO = MTRequestHelper.createShop((CreateShopReqVO)createShopReqVO);
        if (createShopRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8ba2\u5355\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(createShopRespVO.getCode())) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6838\u8c03\u7528\u9519\u8bef\uff1a" + createShopRespVO.getMsg());
        }
        mtLocalStore.setShopStatus(createShopRespVO.getData().getStatus());
        this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
        UpdateSfLocalStoreReqVO updateSfLocalStoreReqVO = updateSenderAddressReqVO.getUpdateSfLocalStoreReqVO();
        Long sfLocalStoreId = updateSfLocalStoreReqVO.getId();
        SfLocalStore sfLocalStore = (SfLocalStore)this.sfLocalStoreService.selectByPrimaryKey((Serializable)sfLocalStoreId);
        if (SfLocalReviewStatusEnum.PASSED.getValue().equals(sfLocalStore.getShopStatus())) {
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u5e97\u94fa\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u5f53\u524d\u4fee\u6539\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        BeanUtils.copyProperties((Object)updateSfLocalStoreReqVO, (Object)sfLocalStore);
        sfLocalStore.setViewId(UUIDUtil.getUUID());
        sfLocalStore.setStatus(Integer.valueOf(1));
        sfLocalStore.setShopStatus(SfLocalReviewStatusEnum.PENDING.getValue());
        sfLocalStore.setWhetherDockSystem(Integer.valueOf(1));
        this.sfLocalStoreService.updateByPrimaryKeySelective((Object)sfLocalStore);
    }

    public Map<String, Object> getMerchantAddressDetail(GetMerchantAddressDetailReqVO getMerchantAddressDetailReqVO) {
        Long senderCommonId = getMerchantAddressDetailReqVO.getSenderCommonId();
        Long mtLocalStoreId = getMerchantAddressDetailReqVO.getMtLocalStoreId();
        Long sfLocalStoreId = getMerchantAddressDetailReqVO.getSfLocalStoreId();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        map.put("senderCommon", senderCommon);
        MtLocalStore mtLocalStore = (MtLocalStore)this.mtLocalStoreService.selectByPrimaryKey((Serializable)mtLocalStoreId);
        map.put("mtLocalStore", mtLocalStore);
        List senderAddressChannelList = this.senderAddressChannelService.findBySenderCommonId(senderCommonId);
        map.put("senderAddressChannelList", senderAddressChannelList);
        SfLocalStore sfLocalStore = (SfLocalStore)this.sfLocalStoreService.selectByPrimaryKey((Serializable)sfLocalStoreId);
        map.put("sfLocalStore", sfLocalStore);
        return map;
    }

    public void sfMedicalReviewPassed(SfMedicalReviewPassedReqVO sfMedicalReviewPassedReqVO) {
        Long senderCommonId = sfMedicalReviewPassedReqVO.getSenderCommonId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        senderCommon.setSfMedicalStatus(SfMedicalReviewStatusEnum.PASSED.getValue());
        senderCommon.setSfMedicalHospitalCode(sfMedicalReviewPassedReqVO.getSfMedicalHospitalCode());
        senderCommon.setSfMedicalSecretKey(sfMedicalReviewPassedReqVO.getSfMedicalSecretKey());
        senderCommon.setSfMedicalRejectReason(null);
        this.updateByPrimaryKeySelective(senderCommon);
    }

    public void sfMedicalReviewRejected(SfMedicalReviewRejectedReqVO sfMedicalReviewRejectedReqVO) {
        Long senderCommonId = sfMedicalReviewRejectedReqVO.getSenderCommonId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        senderCommon.setSfMedicalStatus(SfMedicalReviewStatusEnum.REJECTED.getValue());
        senderCommon.setSfMedicalRejectReason(sfMedicalReviewRejectedReqVO.getRejectReason());
        this.updateByPrimaryKeySelective(senderCommon);
    }

    public void jdReviewPassed(JdReviewPassedReqVO jdReviewPassedReqVO) {
        Long senderCommonId = jdReviewPassedReqVO.getSenderCommonId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        senderCommon.setJdStatus(JdReviewStatusEnum.PASSED.getValue());
        this.updateByPrimaryKeySelective(senderCommon);
    }

    public void jdReviewRejected(JdReviewRejectedReqVO jdReviewRejectedReqVO) {
        Long senderCommonId = jdReviewRejectedReqVO.getSenderCommonId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        senderCommon.setJdStatus(JdReviewStatusEnum.REJECTED.getValue());
        senderCommon.setJdRejectReason(jdReviewRejectedReqVO.getRejectReason());
        this.updateByPrimaryKeySelective(senderCommon);
    }

    public PageResult<Map<String, Object>> findAllMerchantAddressPage(FindAllMerchantAddressPageReqVO findAllMerchantAddressPageReqVO) {
        ArrayList mapList = new ArrayList();
        PageHelper.startPage((int)findAllMerchantAddressPageReqVO.getPageNum(), (int)findAllMerchantAddressPageReqVO.getPageSize());
        List senderCommonList = this.findAll();
        PageInfo pageInfo = new PageInfo(senderCommonList);
        if (senderCommonList != null && senderCommonList.size() > 0) {
            for (SenderCommon senderCommon : senderCommonList) {
                Long senderCommonId = senderCommon.getId();
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("senderCommon", senderCommon);
                MtLocalStore mtLocalStore = this.mtLocalStoreService.getBySenderCommonId(senderCommonId);
                map.put("mtLocalStore", mtLocalStore);
                SfLocalStore sfLocalStore = this.sfLocalStoreService.getBySenderCommonId(senderCommonId);
                map.put("sfLocalStore", sfLocalStore);
                List senderAddressChannelList = this.senderAddressChannelService.findBySenderCommonId(senderCommonId);
                map.put("senderAddressChannelList", senderAddressChannelList);
                mapList.add(map);
            }
        }
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(mapList);
        return pageResult;
    }

    public List<SenderCommon> findAll() {
        return this.senderCommonMapper.findAll();
    }

    public void updateSenderCommon(UpdateSenderCommonReqVO updateSenderCommonReqVO) {
        Long senderCommonId = updateSenderCommonReqVO.getId();
        SenderCommon senderCommon = this.selectByPrimaryKey(senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        Integer sfMedicalStatus = senderCommon.getSfMedicalStatus();
        if (SfMedicalReviewStatusEnum.PASSED.getValue().equals(sfMedicalStatus)) {
            throw new BusinessException("\u987a\u4e30\u533b\u7597\u914d\u9001\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        Integer jdStatus = senderCommon.getJdStatus();
        if (JdReviewStatusEnum.PASSED.getValue().equals(jdStatus)) {
            throw new BusinessException("\u4eac\u4e1c\u914d\u9001\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        MtLocalStore mtLocalStore = this.mtLocalStoreService.getBySenderCommonId(senderCommonId);
        Integer mtShopStatus = mtLocalStore.getShopStatus();
        if (mtShopStatus.equals(20)) {
            throw new BusinessException("\u7f8e\u56e2\u5e97\u94fa\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (mtShopStatus.equals(30)) {
            throw new BusinessException("\u7f8e\u56e2\u5e97\u94fa\u521b\u5efa\u6210\u529f\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        if (mtShopStatus.equals(40)) {
            throw new BusinessException("\u7f8e\u56e2\u5e97\u94fa\u53ef\u4e0a\u7ebf\u53ef\u53d1\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
        }
        mtLocalStore.setShopId(UUIDUtil.getUUID());
        mtLocalStore.setSenderCommonId(senderCommon.getId());
        mtLocalStore.setShopLng(updateSenderCommonReqVO.getSenderLng());
        mtLocalStore.setShopLat(updateSenderCommonReqVO.getSenderLat());
        mtLocalStore.setCoordinateType(updateSenderCommonReqVO.getCoordinateType());
        mtLocalStore.setContactName(updateSenderCommonReqVO.getSenderName());
        mtLocalStore.setContactPhone(updateSenderCommonReqVO.getSenderMobile());
        mtLocalStore.setContactEmail(updateSenderCommonReqVO.getSenderEmail());
        mtLocalStore.setShopAddress(updateSenderCommonReqVO.getSenderDetailedAddress());
        this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
        CreateShopReqVO createShopReqVO = new CreateShopReqVO();
        createShopReqVO.setBusiness_hours(mtLocalStore.getBusinessHours());
        createShopReqVO.setContact_name(mtLocalStore.getContactName());
        createShopReqVO.setContact_phone(mtLocalStore.getContactPhone());
        String shopLat = new BigDecimal(mtLocalStore.getShopLat()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lat(shopLat);
        createShopReqVO.setSecond_category(mtLocalStore.getSecondCategory().toString());
        createShopReqVO.setDelivery_service_codes(mtLocalStore.getDeliveryServiceCodes());
        createShopReqVO.setShop_name(mtLocalStore.getShopName());
        String shopLng = new BigDecimal(mtLocalStore.getShopLng()).multiply(new BigDecimal(10).pow(6)).setScale(0, 1).toPlainString();
        createShopReqVO.setShop_lng(shopLng);
        createShopReqVO.setShop_address(mtLocalStore.getShopAddress());
        createShopReqVO.setContact_email(mtLocalStore.getContactEmail());
        createShopReqVO.setShop_id(mtLocalStore.getShopId());
        createShopReqVO.setShop_address_detail(mtLocalStore.getShopAddressDetail());
        createShopReqVO.setCategory(mtLocalStore.getCategory().toString());
        createShopReqVO.setCoordinate_type(mtLocalStore.getCoordinateType().toString());
        CreateShopRespVO createShopRespVO = MTRequestHelper.createShop((CreateShopReqVO)createShopReqVO);
        if (createShopRespVO == null) {
            throw new BusinessException("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f8e\u56e2\u95e8\u5e97\u4fe1\u606f\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\uff01");
        }
        if (!"OP_SUCCESS".equals(createShopRespVO.getCode())) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6838\u8c03\u7528\u9519\u8bef\uff1a" + createShopRespVO.getMsg());
        }
        mtLocalStore.setShopStatus(createShopRespVO.getData().getStatus());
        this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
    }
}

