/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.SfLocalStoreMapper;
import com.byh.enums.SfLocalReviewStatusEnum;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.SfLocalStore;
import com.byh.pojo.vo.req.SfLocalReviewPassedReqVO;
import com.byh.pojo.vo.req.SfLocalReviewRejectedReqVO;
import com.byh.pojo.vo.req.UpdateSfLocalStoreReqVO;
import com.byh.service.SfLocalStoreService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SfLocalStoreServiceImpl
implements SfLocalStoreService {
    @Autowired
    private SfLocalStoreMapper sfLocalStoreMapper;

    public int insert(SfLocalStore entity) {
        return this.sfLocalStoreMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.sfLocalStoreMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(SfLocalStore entity) {
        this.sfLocalStoreMapper.updateByPrimaryKeySelective(entity);
    }

    public SfLocalStore selectByPrimaryKey(Long id) {
        return this.sfLocalStoreMapper.selectByPrimaryKey(id);
    }

    public SfLocalStore getBySenderCommonId(Long senderCommonId) {
        return this.sfLocalStoreMapper.getBySenderCommonId(senderCommonId);
    }

    @Transactional(rollbackFor={Exception.class, BusinessException.class})
    public void updateSfLocalStore(UpdateSfLocalStoreReqVO updateSfLocalStoreReqVO) {
        Long sfLocalStoreId = updateSfLocalStoreReqVO.getId();
        SfLocalStore sfLocalStore = this.selectByPrimaryKey(sfLocalStoreId);
        Integer shopStatus = sfLocalStore.getShopStatus();
        if (SfLocalReviewStatusEnum.PASSED.getValue().equals(shopStatus)) {
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u5e97\u94fa\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u5f53\u524d\u4fee\u6539\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        BeanUtils.copyProperties((Object)updateSfLocalStoreReqVO, (Object)sfLocalStore);
        sfLocalStore.setShopStatus(SfLocalReviewStatusEnum.PENDING.getValue());
        sfLocalStore.setWhetherDockSystem(Integer.valueOf(1));
        this.updateByPrimaryKeySelective(sfLocalStore);
    }

    public void sfLocalReviewPassed(SfLocalReviewPassedReqVO sfLocalReviewPassedReqVO) {
        Long id = sfLocalReviewPassedReqVO.getId();
        SfLocalStore sfLocalStore = this.selectByPrimaryKey(id);
        if (sfLocalStore == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        sfLocalStore.setShopStatus(SfLocalReviewStatusEnum.PASSED.getValue());
        sfLocalStore.setAppId(sfLocalReviewPassedReqVO.getAppId());
        sfLocalStore.setAppSecret(sfLocalReviewPassedReqVO.getAppSecret());
        this.updateByPrimaryKeySelective(sfLocalStore);
    }

    public void sfLocalReviewRejected(SfLocalReviewRejectedReqVO sfLocalReviewRejectedReqVO) {
        Long id = sfLocalReviewRejectedReqVO.getId();
        SfLocalStore sfLocalStore = this.selectByPrimaryKey(id);
        if (sfLocalStore == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u5ba1\u6838\u5931\u8d25\uff01");
        }
        sfLocalStore.setRejectMessage(sfLocalReviewRejectedReqVO.getRejectMessage());
        sfLocalStore.setShopStatus(SfLocalReviewStatusEnum.REJECTED.getValue());
        this.updateByPrimaryKeySelective(sfLocalStore);
    }
}

