/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.exception.BusinessException;
import com.byh.pojo.dto.OpenApiAddressVO;
import com.byh.pojo.dto.OrderThirdRequestVO;
import com.byh.pojo.dto.OrderThirdVO;
import com.byh.pojo.entity.SfMedicalCallbackUrl;
import com.byh.pojo.entity.SfMedicalOrder;
import com.byh.pojo.vo.sfmedical.WaybillRouteVo;
import com.byh.pojo.vo.sfmedical.req.SfBatchAddOrderReqVO;
import com.byh.pojo.vo.sfmedical.req.SfCancelThirdOrderReqVO;
import com.byh.pojo.vo.sfmedical.req.SfFreightQueryReqVO;
import com.byh.pojo.vo.sfmedical.req.SfListOrderRouteReqVO;
import com.byh.pojo.vo.sfmedical.req.SfSieveOrderReqVO;
import com.byh.service.SfMedicalCallbackUrlService;
import com.byh.service.SfMedicalOrderService;
import com.byh.service.SfMedicalService2;
import com.byh.util.UUIDUtil;
import com.byh.util.sfmedical.SFMedicalRequestHelper;
import com.byh.util.sfmedical.vo.req.BatchAddOrderReqVO;
import com.byh.util.sfmedical.vo.req.CancelThirdOrderReqVO;
import com.byh.util.sfmedical.vo.req.FreightQueryReqVO;
import com.byh.util.sfmedical.vo.req.ListOrderRouteReqVO;
import com.byh.util.sfmedical.vo.req.SieveOrderReqVO;
import com.byh.util.sfmedical.vo.resp.BatchAddOrderRespVO;
import com.byh.util.sfmedical.vo.resp.CancelThirdOrderRespVO;
import com.byh.util.sfmedical.vo.resp.FreightQueryRespVO;
import com.byh.util.sfmedical.vo.resp.ListOrderRouteRespVO;
import com.byh.util.sfmedical.vo.resp.SieveOrderRespVO;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfMedicalService2Impl
implements SfMedicalService2 {
    private static final Logger log = LoggerFactory.getLogger(SfMedicalService2Impl.class);
    private static final String SUCCESS_CODE = "SUCCESS";
    @Autowired
    private SfMedicalOrderService sfMedicalOrderService;
    @Autowired
    private SfMedicalCallbackUrlService sfMedicalCallbackUrlService;

    public SieveOrderRespVO sieveOrder(SfSieveOrderReqVO sfSieveOrderReqVO) {
        SieveOrderReqVO sieveOrderReqVO = new SieveOrderReqVO();
        sieveOrderReqVO.setHospitalCode(sfSieveOrderReqVO.getHospitalCode());
        sieveOrderReqVO.setSecretKey(sfSieveOrderReqVO.getSecretKey());
        sieveOrderReqVO.setSrcAddress(sfSieveOrderReqVO.getSrcAddress());
        sieveOrderReqVO.setDestAddress(sfSieveOrderReqVO.getDestAddress());
        SieveOrderRespVO sieveOrderRespVO = SFMedicalRequestHelper.sieveOrder((SieveOrderReqVO)sieveOrderReqVO);
        return sieveOrderRespVO;
    }

    public FreightQueryRespVO freightQuery(SfFreightQueryReqVO sfFreightQueryReqVO) {
        FreightQueryReqVO freightQueryReqVO = new FreightQueryReqVO();
        OpenApiAddressVO openApiAddressVO = new OpenApiAddressVO();
        BeanUtils.copyProperties((Object)sfFreightQueryReqVO, (Object)openApiAddressVO);
        openApiAddressVO.setTimestamp(Long.valueOf(4070916000000L));
        freightQueryReqVO.setOpenApiAddressVO(openApiAddressVO);
        freightQueryReqVO.setHospitalCode(sfFreightQueryReqVO.getHospitalCode());
        freightQueryReqVO.setSecretKey(sfFreightQueryReqVO.getSecretKey());
        FreightQueryRespVO freightQueryRespVO = SFMedicalRequestHelper.freightQuery((FreightQueryReqVO)freightQueryReqVO);
        return freightQueryRespVO;
    }

    public BatchAddOrderRespVO batchAddOrder(SfBatchAddOrderReqVO sfBatchAddOrderReqVO) {
        BatchAddOrderReqVO batchAddOrderReqVO = new BatchAddOrderReqVO();
        OrderThirdRequestVO orderThirdRequestVO = new OrderThirdRequestVO();
        BeanUtils.copyProperties((Object)sfBatchAddOrderReqVO, (Object)orderThirdRequestVO);
        orderThirdRequestVO.setTimestamp(Long.valueOf(4070916000000L));
        batchAddOrderReqVO.setOrderThirdRequestVO(orderThirdRequestVO);
        batchAddOrderReqVO.setHospitalCode(sfBatchAddOrderReqVO.getHospitalCode());
        batchAddOrderReqVO.setSecretKey(sfBatchAddOrderReqVO.getSecretKey());
        log.info("batchAddOrder \u53c2\u6570\u6253\u5370\uff1a" + JSON.toJSONString((Object)batchAddOrderReqVO));
        BatchAddOrderRespVO batchAddOrderRespVO = SFMedicalRequestHelper.batchAddOrder((BatchAddOrderReqVO)batchAddOrderReqVO);
        if (batchAddOrderRespVO != null && SUCCESS_CODE.equals(batchAddOrderRespVO.getCode())) {
            try {
                BatchAddOrderRespVO.ResultBean result = batchAddOrderRespVO.getResult();
                List failResultBeanList = result.getFailResult();
                List successResultBeanList = result.getSuccessResult();
                List orderThirdVOList = sfBatchAddOrderReqVO.getOrderThirds();
                if (orderThirdVOList != null && orderThirdVOList.size() > 0) {
                    for (OrderThirdVO orderThirdVO : orderThirdVOList) {
                        String bspOrderNo = orderThirdVO.getBspOrderNo();
                        SfMedicalOrder sfMedicalOrder = new SfMedicalOrder();
                        BeanUtils.copyProperties((Object)orderThirdVO, (Object)sfMedicalOrder);
                        sfMedicalOrder.setViewId(UUIDUtil.getUUID());
                        sfMedicalOrder.setStatus(Integer.valueOf(1));
                        sfMedicalOrder.setMerchantId(sfBatchAddOrderReqVO.getMerchantId());
                        if (failResultBeanList != null && failResultBeanList.size() > 0) {
                            for (BatchAddOrderRespVO.ResultBean.FailResultBean failResultBean : failResultBeanList) {
                                if (!bspOrderNo.equals(failResultBean.getBspOrderNo())) continue;
                                sfMedicalOrder.setFailMsg(failResultBean.getMessage());
                                this.sfMedicalOrderService.insert((Object)sfMedicalOrder);
                            }
                        }
                        if (successResultBeanList == null || successResultBeanList.size() <= 0) continue;
                        for (BatchAddOrderRespVO.ResultBean.SuccessResultBean successResultBean : successResultBeanList) {
                            if (!bspOrderNo.equals(successResultBean.getBspOrderNo())) continue;
                            sfMedicalOrder.setMailNo(successResultBean.getMailNo());
                            this.sfMedicalOrderService.insert((Object)sfMedicalOrder);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return batchAddOrderRespVO;
    }

    public ListOrderRouteRespVO listOrderRoute(SfListOrderRouteReqVO sfListOrderRouteReqVO) {
        ListOrderRouteReqVO listOrderRouteReqVO = new ListOrderRouteReqVO();
        listOrderRouteReqVO.setOrderNo(sfListOrderRouteReqVO.getOrderNo());
        listOrderRouteReqVO.setHospitalCode(sfListOrderRouteReqVO.getHospitalCode());
        listOrderRouteReqVO.setSecretKey(sfListOrderRouteReqVO.getSecretKey());
        ListOrderRouteRespVO listOrderRouteRespVO = SFMedicalRequestHelper.listOrderRoute((ListOrderRouteReqVO)listOrderRouteReqVO);
        return listOrderRouteRespVO;
    }

    public CancelThirdOrderRespVO cancelThirdOrder(SfCancelThirdOrderReqVO sfCancelThirdOrderReqVO) {
        CancelThirdOrderReqVO cancelThirdOrderReqVO = new CancelThirdOrderReqVO();
        cancelThirdOrderReqVO.setOrderNo(sfCancelThirdOrderReqVO.getOrderNo());
        cancelThirdOrderReqVO.setHospitalCode(sfCancelThirdOrderReqVO.getHospitalCode());
        cancelThirdOrderReqVO.setSecretKey(sfCancelThirdOrderReqVO.getSecretKey());
        CancelThirdOrderRespVO cancelThirdOrderRespVO = SFMedicalRequestHelper.cancelThirdOrder((CancelThirdOrderReqVO)cancelThirdOrderReqVO);
        return cancelThirdOrderRespVO;
    }

    public String callback(WaybillRouteVo waybillRouteVo) {
        String orderId = waybillRouteVo.getOrderId();
        SfMedicalOrder sfMedicalOrder = this.sfMedicalOrderService.getByBspOrderNo(orderId);
        if (sfMedicalOrder == null) {
            return SUCCESS_CODE;
        }
        Long merchantId = sfMedicalOrder.getMerchantId();
        SfMedicalCallbackUrl sfMedicalCallbackUrl = this.sfMedicalCallbackUrlService.getByMerchantId(merchantId);
        if (sfMedicalCallbackUrl == null || "".equals(sfMedicalCallbackUrl.getNotifyUrl())) {
            return SUCCESS_CODE;
        }
        String notifyUrl = sfMedicalCallbackUrl.getNotifyUrl();
        if (notifyUrl == null || "".equals(notifyUrl)) {
            return SUCCESS_CODE;
        }
        String responseJson = null;
        try {
            responseJson = HttpKit.jsonPost((String)notifyUrl, (String)JSON.toJSONString((Object)waybillRouteVo));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u5904\u7406\u987a\u4e30\u533b\u7597\u914d\u9001\u8def\u7531\u56de\u8c03\u5931\u8d25\uff01");
        }
        if (SUCCESS_CODE.equalsIgnoreCase(responseJson)) {
            return SUCCESS_CODE;
        }
        log.error(responseJson);
        return SUCCESS_CODE;
    }
}

