/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.dao.BusinessOrderRecordMapper;
import com.byh.dao.RoutePushConfigMapper;
import com.byh.dao.SfOrderDao;
import com.byh.enums.SFMedicalMethodEnum;
import com.byh.pojo.dto.OpenApiAddressVO;
import com.byh.pojo.dto.OrderThirdRequestVO;
import com.byh.pojo.entity.BusinessOrderRecordEntity;
import com.byh.pojo.entity.RoutePushConfigEntity;
import com.byh.pojo.entity.SfOrderEntity;
import com.byh.pojo.vo.sfmedical.CancelThirdOrderReqVo;
import com.byh.pojo.vo.sfmedical.OrderThirdResVo;
import com.byh.pojo.vo.sfmedical.QueryRouteReqVo;
import com.byh.pojo.vo.sfmedical.QueryRouteResVo;
import com.byh.pojo.vo.sfmedical.QueryRouteSFResVo;
import com.byh.pojo.vo.sfmedical.SFMedicalRequest;
import com.byh.pojo.vo.sfmedical.SFMedicalResponse;
import com.byh.pojo.vo.sfmedical.SieveOrderReqVo;
import com.byh.pojo.vo.sfmedical.WaybillRouteVo;
import com.byh.service.SfMedicalService;
import com.byh.util.sfmedical.HttpClientUtils;
import com.byh.util.sfmedical.SHAUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SfMedicalServiceImpl
implements SfMedicalService {
    private static final Logger log = LoggerFactory.getLogger(SfMedicalServiceImpl.class);
    @Autowired
    private RoutePushConfigMapper routePushConfigMapper;
    @Autowired
    private SfOrderDao sfOrderDao;
    @Value(value="${sfMedicalSecretKey}")
    private String sfMedicalSecretKey;
    @Value(value="${sfMedicalHospitalCode}")
    private String sfMedicalHospitalCode;
    @Value(value="${sfMedicalURL}")
    private String sfMedicalURL;
    @Autowired
    private BusinessOrderRecordMapper businessOrderRecordMapper;

    public BaseResponse cancelThirdOrder(SFMedicalRequest<CancelThirdOrderReqVo> cancelThirdOrderRequest) {
        cancelThirdOrderRequest.setVersion("1.0");
        cancelThirdOrderRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        String sign = SHAUtils.SHA512((String)(((CancelThirdOrderReqVo)cancelThirdOrderRequest.getBody()).getOrderNo() + this.sfMedicalSecretKey));
        String url = this.sfMedicalURL + SFMedicalMethodEnum.getDisplay((String)"cancelThirdOrder");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hospitalCode", this.sfMedicalHospitalCode);
        map.put("sign", sign);
        map.put("orderNo", ((CancelThirdOrderReqVo)cancelThirdOrderRequest.getBody()).getOrderNo());
        map.put("timestamp", cancelThirdOrderRequest.getTimestamp().toString());
        map.put("version", cancelThirdOrderRequest.getVersion());
        log.info("url->{}, param->{}", (Object)url, (Object)((Object)map).toString());
        String result = HttpClientUtils.doGet((String)url, map);
        log.info("result->{}", (Object)result);
        if (result == null) {
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u5f02\u5e38");
        }
        SFMedicalResponse logisticsResponse = (SFMedicalResponse)JSON.parseObject((String)result, SFMedicalResponse.class);
        if (!logisticsResponse.getSuccess().booleanValue()) {
            return BaseResponse.error((String)logisticsResponse.getMessage());
        }
        return BaseResponse.success((Object)logisticsResponse.getResult());
    }

    public BaseResponse<String> sieveOrder(SFMedicalRequest<SieveOrderReqVo> sieveOrderRequest) {
        sieveOrderRequest.setVersion("1.0");
        sieveOrderRequest.setTimestamp(Long.valueOf(4070916000000L));
        SieveOrderReqVo sieveOrderReqVo = (SieveOrderReqVo)sieveOrderRequest.getBody();
        String sign = SHAUtils.SHA512((String)(sieveOrderReqVo.getSrcAddress() + sieveOrderReqVo.getDestAddress() + this.sfMedicalSecretKey));
        String url = this.sfMedicalURL + SFMedicalMethodEnum.getDisplay((String)"sieveOrder");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hospitalCode", this.sfMedicalHospitalCode);
        map.put("sign", sign);
        map.put("srcAddress", sieveOrderReqVo.getSrcAddress());
        map.put("destAddress", sieveOrderReqVo.getDestAddress());
        map.put("timestamp", sieveOrderRequest.getTimestamp().toString());
        map.put("version", sieveOrderRequest.getVersion());
        log.info("url->{}, param->{}", (Object)url, (Object)((Object)map).toString());
        String result = HttpClientUtils.doGet((String)url, map);
        log.info("result->{}", (Object)result);
        if (result == null) {
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u5f02\u5e38");
        }
        SFMedicalResponse logisticsResponse = (SFMedicalResponse)JSON.parseObject((String)result, SFMedicalResponse.class);
        if (!logisticsResponse.getSuccess().booleanValue()) {
            return BaseResponse.error((String)logisticsResponse.getMessage());
        }
        return BaseResponse.success((Object)logisticsResponse.getResult());
    }

    public String routeCall(WaybillRouteVo waybillRouteVo) {
        String orderId = waybillRouteVo.getOrderId();
        String mchId = this.businessOrderRecordMapper.selectMchIdByBusinessId(orderId);
        log.info("route call mch id->{}", (Object)mchId);
        RoutePushConfigEntity routePushConfigEntity = this.routePushConfigMapper.selectByMchId(mchId);
        log.info("\u8def\u7531\u56de\u8c03\u7684URL\u914d\u7f6e->{}", (Object)Objects.toString(routePushConfigEntity, null));
        if (routePushConfigEntity == null) {
            waybillRouteVo.setRoutePushFlag(Boolean.valueOf(true));
            return "SUCCESS";
        }
        if (waybillRouteVo.getOpCode().equals("44")) {
            try {
                String deliveryInfo = waybillRouteVo.getRemark().split(":")[1];
                String deliveryName = deliveryInfo.split(",")[0];
                String deliveryPhone = waybillRouteVo.getRemark().split(":")[2].substring(0, 11);
                waybillRouteVo.setDeliveryPhone(deliveryPhone);
                waybillRouteVo.setDeliveryName(deliveryName);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6d3e\u9001\u5458\u4fe1\u606f\u5f02\u5e38->{}", (Throwable)e);
            }
        }
        try {
            String responseJson = HttpKit.jsonPost((String)routePushConfigEntity.getPushUrl(), (String)JSON.toJSONString((Object)waybillRouteVo));
            BaseResponse response = (BaseResponse)JSON.parseObject((String)responseJson, BaseResponse.class);
            return ((String)response.getData()).toUpperCase();
        }
        catch (Exception e) {
            log.error("\u8def\u7531\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38->{}", (Throwable)e);
            return "SUCCESS";
        }
    }

    public BaseResponse<List<QueryRouteResVo>> queryRoute(SFMedicalRequest<QueryRouteReqVo> request) {
        request.setVersion("1.0");
        request.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        log.info("======>\u67e5\u8be2\u8def\u7531\u8ba2\u5355\u53f7:{}", (Object)((QueryRouteReqVo)request.getBody()).getOrderNo());
        String sign = SHAUtils.SHA512((String)(((QueryRouteReqVo)request.getBody()).getOrderNo() + this.sfMedicalSecretKey));
        String url = this.sfMedicalURL + SFMedicalMethodEnum.getDisplay((String)"listOrderRoute");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hospitalCode", this.sfMedicalHospitalCode);
        map.put("sign", sign);
        map.put("orderNo", ((QueryRouteReqVo)request.getBody()).getOrderNo());
        map.put("timestamp", request.getTimestamp().toString());
        map.put("version", request.getVersion());
        log.info("url->{}, param->{}", (Object)url, (Object)((Object)map).toString());
        String result = HttpClientUtils.doGet((String)url, map);
        log.info("result->{}", (Object)result);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u5f02\u5e38");
        }
        SFMedicalResponse logisticsResponse = (SFMedicalResponse)JSON.parseObject((String)result, SFMedicalResponse.class);
        if (!logisticsResponse.getSuccess().booleanValue()) {
            return BaseResponse.error((String)logisticsResponse.getMessage());
        }
        List queryRouteSFResVoList = JSON.parseArray((String)JSON.toJSONString((Object)logisticsResponse.getResult()), QueryRouteSFResVo.class);
        List queryRouteResVoList = queryRouteSFResVoList.stream().map(queryRouteSFResVo -> {
            QueryRouteResVo queryRouteResVo = new QueryRouteResVo();
            queryRouteResVo.setAcceptAddress(queryRouteSFResVo.getAccept_address());
            queryRouteResVo.setAcceptDate(queryRouteSFResVo.getAccept_date());
            queryRouteResVo.setAcceptTime(queryRouteSFResVo.getAccept_time());
            queryRouteResVo.setAcceptTotalTime(queryRouteSFResVo.getAccept_totaltime());
            queryRouteResVo.setMailNo(queryRouteSFResVo.getMailno());
            queryRouteResVo.setOpCode(queryRouteSFResVo.getOpcode());
            queryRouteResVo.setRemark(queryRouteSFResVo.getRemark());
            if (queryRouteSFResVo.getOpcode().equals("44")) {
                try {
                    String deliveryInfo = queryRouteSFResVo.getRemark().split(":")[1];
                    String deliveryName = deliveryInfo.split(",")[0];
                    String deliveryPhone = queryRouteSFResVo.getRemark().split(":")[2].substring(0, 11);
                    queryRouteResVo.setDeliveryPhone(deliveryPhone);
                    queryRouteResVo.setDeliveryName(deliveryName);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6d3e\u9001\u5458\u4fe1\u606f\u5f02\u5e38->{}", (Throwable)e);
                }
            }
            return queryRouteResVo;
        }).collect(Collectors.toList());
        return BaseResponse.success(queryRouteResVoList);
    }

    public BaseResponse addOrder(SFMedicalRequest<OrderThirdRequestVO> orderThirdRequest) {
        orderThirdRequest.setVersion("1.0");
        orderThirdRequest.setTimestamp(Long.valueOf(4070916000000L));
        OrderThirdRequestVO vo = (OrderThirdRequestVO)orderThirdRequest.getBody();
        vo.setTimestamp(Long.valueOf(4070916000000L));
        orderThirdRequest.setBody((Object)vo);
        String param = JSONObject.toJSONString((Object)orderThirdRequest.getBody());
        String sign = SHAUtils.SHA512((String)(param + this.sfMedicalSecretKey));
        StringBuffer urlBuff = new StringBuffer(this.sfMedicalURL + SFMedicalMethodEnum.getDisplay((String)"addOrder"));
        urlBuff.append("?sign=" + sign).append("&timestamp=" + orderThirdRequest.getTimestamp()).append("&hospitalCode=" + this.sfMedicalHospitalCode).append("&version=" + orderThirdRequest.getVersion());
        log.info("url->{}, param->{}", (Object)urlBuff.toString(), (Object)param.toString());
        String result = HttpClientUtils.doPost((String)urlBuff.toString(), (String)param, (ContentType)ContentType.APPLICATION_JSON);
        log.info("result->{}", (Object)result);
        if (result == null) {
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u5f02\u5e38");
        }
        SFMedicalResponse logisticsResponse = (SFMedicalResponse)JSON.parseObject((String)result, SFMedicalResponse.class);
        if (!logisticsResponse.getSuccess().booleanValue()) {
            return BaseResponse.error((String)logisticsResponse.getMessage());
        }
        new Thread(() -> {
            try {
                if (result.contains("successResult")) {
                    Object successResult = JSON.parseObject((String)logisticsResponse.getResult().toString()).get((Object)"successResult");
                    List orderThirdResVoList = JSON.parseArray((String)JSON.toJSONString((Object)successResult), OrderThirdResVo.class);
                    Map<String, OrderThirdResVo> orderThirdResVoMap = orderThirdResVoList.stream().collect(Collectors.toMap(OrderThirdResVo::getBspOrderNo, orderThirdResVo -> orderThirdResVo));
                    List orderThirdVOList = ((OrderThirdRequestVO)orderThirdRequest.getBody()).getOrderThirds();
                    orderThirdVOList.stream().forEach(orderThirdVO -> {
                        OrderThirdResVo orderThirdResVo = (OrderThirdResVo)orderThirdResVoMap.get(orderThirdVO.getBspOrderNo());
                        if (orderThirdResVo != null) {
                            BusinessOrderRecordEntity businessOrderRecordEntity = new BusinessOrderRecordEntity();
                            businessOrderRecordEntity.setBusinessId(orderThirdVO.getBspOrderNo());
                            businessOrderRecordEntity.setMchId(orderThirdRequest.getMchId());
                            businessOrderRecordEntity.setRequest(JSON.toJSONString((Object)orderThirdVO));
                            businessOrderRecordEntity.setResponse(JSON.toJSONString((Object)orderThirdResVo));
                            businessOrderRecordEntity.setMainNo(orderThirdResVo.getMailNo());
                            this.businessOrderRecordMapper.insertSelective(businessOrderRecordEntity);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u4e0b\u5355\u8bb0\u5f55\u5f02\u5e38->{}", (Throwable)e);
            }
        }).start();
        return BaseResponse.success((Object)logisticsResponse.getResult());
    }

    public BaseResponse freightQuery(SFMedicalRequest<OpenApiAddressVO> openApiAddressVO) {
        openApiAddressVO.setVersion("1.0");
        openApiAddressVO.setTimestamp(Long.valueOf(4070916000000L));
        OpenApiAddressVO vo = (OpenApiAddressVO)openApiAddressVO.getBody();
        vo.setTimestamp(Long.valueOf(4070916000000L));
        String param = JSONObject.toJSONString((Object)vo);
        String sign = SHAUtils.SHA512((String)(param + this.sfMedicalSecretKey));
        StringBuffer urlBuff = new StringBuffer(this.sfMedicalURL + SFMedicalMethodEnum.getDisplay((String)"freightQuery"));
        urlBuff.append("?sign=" + sign).append("&timestamp=" + openApiAddressVO.getTimestamp()).append("&hospitalCode=" + this.sfMedicalHospitalCode).append("&version=" + openApiAddressVO.getVersion());
        log.info("url->{}, param->{}", (Object)urlBuff.toString(), (Object)param);
        String result = HttpClientUtils.doPost((String)urlBuff.toString(), (String)param, (ContentType)ContentType.APPLICATION_JSON);
        log.info("result->{}", (Object)result);
        if (result == null) {
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u5f02\u5e38");
        }
        SFMedicalResponse logisticsResponse = (SFMedicalResponse)JSON.parseObject((String)result, SFMedicalResponse.class);
        if (!logisticsResponse.getSuccess().booleanValue()) {
            return BaseResponse.error((String)logisticsResponse.getMessage());
        }
        return BaseResponse.success((Object)logisticsResponse.getResult());
    }

    public BaseResponse checkHealth() {
        SfOrderEntity sfOrderEntity = this.sfOrderDao.getAll();
        return BaseResponse.success((Object)sfOrderEntity);
    }
}

