/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.mt;

import com.alibaba.fastjson.JSON;
import com.byh.util.HttpUtils;
import com.byh.util.mt.Config;
import com.byh.util.mt.util.RequestUtils;
import com.byh.util.mt.util.SignUtil;
import com.byh.util.mt.vo.req.CancelOrderReqVO;
import com.byh.util.mt.vo.req.CreateOrderByShopReqVO;
import com.byh.util.mt.vo.req.CreateShopReqVO;
import com.byh.util.mt.vo.req.QueryOrderStatusReqVO;
import com.byh.util.mt.vo.resp.CancelOrderRespVO;
import com.byh.util.mt.vo.resp.CreateOrderByShopRespVO;
import com.byh.util.mt.vo.resp.CreateShopRespVO;
import com.byh.util.mt.vo.resp.ShopQueryRespVO;
import com.google.gson.Gson;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(MTRequestHelper.class);

    public static CancelOrderRespVO cancelOrder(CancelOrderReqVO cancelOrderReqVO) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        paramsMap.put("timestamp", cancelOrderReqVO.getTimestamp());
        paramsMap.put("charset", Config.CHARSET);
        paramsMap.put("version", Config.VERSION);
        paramsMap.put("developerId", Config.DEVELOPER_ID);
        HashMap<String, String> bizMap = new HashMap<String, String>(16);
        bizMap.put("delivery_id", cancelOrderReqVO.getDelivery_id());
        bizMap.put("mt_peisong_id", cancelOrderReqVO.getMt_peisong_id());
        bizMap.put("cancel_reason_id", cancelOrderReqVO.getCancel_reason_id());
        bizMap.put("cancel_reason", cancelOrderReqVO.getCancel_reason());
        paramsMap.put("biz", JSON.toJSONString(bizMap));
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, paramsMap);
        if (sign == null || "".equals(sign)) {
            throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        paramsMap.put("sign", sign);
        String reqStr = RequestUtils.generateRequestStr(paramsMap);
        log.info("reqStr = " + reqStr);
        String post = null;
        try {
            log.info("url = " + Config.ORDER_CANCEL);
            post = HttpUtils.postForm((String)Config.ORDER_CANCEL, (String)reqStr);
            log.info("post = " + post);
            if (post == null || "".equals(post)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        Gson gson = new Gson();
        CancelOrderRespVO cancelOrderRespVO = (CancelOrderRespVO)gson.fromJson(post, CancelOrderRespVO.class);
        return cancelOrderRespVO;
    }

    public static ShopQueryRespVO queryOrderStatus(QueryOrderStatusReqVO queryOrderStatusReqVO) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        paramsMap.put("timestamp", timestamp);
        paramsMap.put("charset", Config.CHARSET);
        paramsMap.put("version", Config.VERSION);
        paramsMap.put("developerId", Config.DEVELOPER_ID);
        HashMap<String, String> bizMap = new HashMap<String, String>(16);
        bizMap.put("delivery_id", queryOrderStatusReqVO.getDelivery_id());
        bizMap.put("mt_peisong_id", queryOrderStatusReqVO.getMt_peisong_id());
        paramsMap.put("biz", JSON.toJSONString(bizMap));
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, paramsMap);
        if (sign == null || "".equals(sign)) {
            throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        paramsMap.put("sign", sign);
        String reqStr = RequestUtils.generateRequestStr(paramsMap);
        log.info("reqStr = " + reqStr);
        String post = null;
        try {
            log.info("url = " + Config.ORDER_QUERY_STATUS);
            post = HttpUtils.postForm((String)Config.ORDER_QUERY_STATUS, (String)reqStr);
            log.info("post = " + post);
            if (post == null || "".equals(post)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        Gson gson = new Gson();
        ShopQueryRespVO shopQueryRespVO = (ShopQueryRespVO)gson.fromJson(post, ShopQueryRespVO.class);
        return shopQueryRespVO;
    }

    public static CreateOrderByShopRespVO createOrderByShop(CreateOrderByShopReqVO createOrderByShopReqVO) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        paramsMap.put("timestamp", timestamp);
        paramsMap.put("charset", Config.CHARSET);
        paramsMap.put("version", Config.VERSION);
        paramsMap.put("developerId", Config.DEVELOPER_ID);
        HashMap<String, String> bizMap = new HashMap<String, String>(16);
        bizMap.put("delivery_id", createOrderByShopReqVO.getDelivery_id());
        bizMap.put("order_id", createOrderByShopReqVO.getOrder_id());
        bizMap.put("shop_id", createOrderByShopReqVO.getShop_id());
        bizMap.put("delivery_service_code", createOrderByShopReqVO.getDelivery_service_code());
        bizMap.put("receiver_name", createOrderByShopReqVO.getReceiver_name());
        bizMap.put("receiver_address", createOrderByShopReqVO.getReceiver_address());
        bizMap.put("receiver_phone", createOrderByShopReqVO.getReceiver_phone());
        bizMap.put("receiver_lng", createOrderByShopReqVO.getReceiver_lng());
        bizMap.put("receiver_lat", createOrderByShopReqVO.getReceiver_lat());
        bizMap.put("coordinate_type", createOrderByShopReqVO.getCoordinate_type());
        bizMap.put("goods_value", createOrderByShopReqVO.getGoods_value());
        bizMap.put("goods_height", createOrderByShopReqVO.getGoods_height());
        bizMap.put("goods_width", createOrderByShopReqVO.getGoods_width());
        bizMap.put("goods_length", createOrderByShopReqVO.getGoods_length());
        bizMap.put("goods_weight", createOrderByShopReqVO.getGoods_weight());
        bizMap.put("goods_detail", createOrderByShopReqVO.getGoods_detail());
        bizMap.put("goods_pickup_info", createOrderByShopReqVO.getGoods_pickup_info());
        bizMap.put("goods_delivery_info", createOrderByShopReqVO.getGoods_delivery_info());
        bizMap.put("expected_pickup_time", createOrderByShopReqVO.getExpected_pickup_time());
        bizMap.put("expected_delivery_time", createOrderByShopReqVO.getExpected_delivery_time());
        bizMap.put("order_type", createOrderByShopReqVO.getOrder_type());
        bizMap.put("poi_seq", createOrderByShopReqVO.getPoi_seq());
        bizMap.put("note", createOrderByShopReqVO.getNote());
        bizMap.put("cash_on_delivery", createOrderByShopReqVO.getCash_on_delivery());
        bizMap.put("cash_on_pickup", createOrderByShopReqVO.getCash_on_pickup());
        bizMap.put("invoice_title", createOrderByShopReqVO.getInvoice_title());
        paramsMap.put("biz", JSON.toJSONString(bizMap));
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, paramsMap);
        if (sign == null || "".equals(sign)) {
            throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        paramsMap.put("sign", sign);
        String reqStr = RequestUtils.generateRequestStr(paramsMap);
        log.info("reqStr = " + reqStr);
        String post = null;
        try {
            log.info("url = " + Config.ORDER_CREATE_BY_SHOP);
            post = HttpUtils.postForm((String)Config.ORDER_CREATE_BY_SHOP, (String)reqStr);
            log.info("post = " + post);
            if (post == null || "".equals(post)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        Gson gson = new Gson();
        CreateOrderByShopRespVO createOrderByShopRespVO = (CreateOrderByShopRespVO)gson.fromJson(post, CreateOrderByShopRespVO.class);
        return createOrderByShopRespVO;
    }

    public static CreateShopRespVO createShop(CreateShopReqVO createShopReqVO) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        paramsMap.put("timestamp", timestamp);
        paramsMap.put("charset", Config.CHARSET);
        paramsMap.put("version", Config.VERSION);
        paramsMap.put("developerId", Config.DEVELOPER_ID);
        HashMap<String, String> bizMap = new HashMap<String, String>(16);
        bizMap.put("business_hours", createShopReqVO.getBusiness_hours());
        bizMap.put("contact_name", createShopReqVO.getContact_name());
        bizMap.put("contact_phone", createShopReqVO.getContact_phone());
        bizMap.put("shop_lat", createShopReqVO.getShop_lat());
        bizMap.put("second_category", createShopReqVO.getSecond_category());
        bizMap.put("delivery_service_codes", createShopReqVO.getDelivery_service_codes());
        bizMap.put("shop_name", createShopReqVO.getShop_name());
        bizMap.put("shop_lng", createShopReqVO.getShop_lng());
        bizMap.put("shop_address", createShopReqVO.getShop_address());
        bizMap.put("contact_email", createShopReqVO.getContact_email());
        bizMap.put("shop_id", createShopReqVO.getShop_id());
        bizMap.put("shop_address_detail", createShopReqVO.getShop_address_detail());
        bizMap.put("category", createShopReqVO.getCategory());
        bizMap.put("coordinate_type", createShopReqVO.getCoordinate_type());
        paramsMap.put("biz", JSON.toJSONString(bizMap));
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, paramsMap);
        if (sign == null || "".equals(sign)) {
            throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        paramsMap.put("sign", sign);
        String reqStr = RequestUtils.generateRequestStr(paramsMap);
        log.info("reqStr = " + reqStr);
        String post = null;
        try {
            log.info("url = " + Config.SHOP_CREATE);
            post = HttpUtils.postForm((String)Config.SHOP_CREATE, (String)reqStr);
            log.info("post = " + post);
            if (post == null || "".equals(post)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        Gson gson = new Gson();
        CreateShopRespVO createShopRespVO = (CreateShopRespVO)gson.fromJson(post, CreateShopRespVO.class);
        return createShopRespVO;
    }

    public static ShopQueryRespVO queryShop(String shopId) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        paramsMap.put("timestamp", timestamp);
        paramsMap.put("charset", Config.CHARSET);
        paramsMap.put("version", Config.VERSION);
        paramsMap.put("developerId", Config.DEVELOPER_ID);
        HashMap<String, String> bizMap = new HashMap<String, String>(16);
        bizMap.put("shop_id", shopId);
        paramsMap.put("biz", JSON.toJSONString(bizMap));
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, paramsMap);
        if (sign == null || "".equals(sign)) {
            throw new RuntimeException("\u83b7\u53d6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        paramsMap.put("sign", sign);
        String reqStr = RequestUtils.generateRequestStr(paramsMap);
        log.info("reqStr = " + reqStr);
        String post = null;
        try {
            log.info("url = " + Config.SHOP_QUERY);
            post = HttpUtils.postForm((String)Config.SHOP_QUERY, (String)reqStr);
            log.info("post = " + post);
            if (post == null || "".equals(post)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        Gson gson = new Gson();
        ShopQueryRespVO shopQueryRespVO = (ShopQueryRespVO)gson.fromJson(post, ShopQueryRespVO.class);
        return shopQueryRespVO;
    }
}

