/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.mt.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);

    private SignUtil() {
    }

    public static String getSign(String signKey, Map<String, String> params) {
        try {
            String sortedStr = SignUtil.getSortedParamStr(params);
            String paraStr = signKey + sortedStr;
            return SignUtil.createSign((String)paraStr);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("getSign UnsupportedEncodingException ", (Throwable)e);
            return "";
        }
    }

    private static String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder strB = new StringBuilder();
        for (String key : sortedParams) {
            String value;
            if ("sign".equalsIgnoreCase(key) || !StringUtils.isNotEmpty((CharSequence)(value = params.get(key)))) continue;
            strB.append(key).append(value);
        }
        return strB.toString();
    }

    private static String createSign(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            log.warn("create sign was failed", (Throwable)e);
            return null;
        }
    }
}

