/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.sflocal;

import com.alibaba.fastjson.JSON;
import com.byh.exception.BusinessException;
import com.byh.util.sflocal.SFApiProxy;
import com.byh.util.sflocal.SfLocalConfig;
import com.byh.util.sflocal.vo.req.CancelOrderReqVO;
import com.byh.util.sflocal.vo.req.CreateOrderReqVO;
import com.byh.util.sflocal.vo.req.GetCallbackInfoReqVO;
import com.byh.util.sflocal.vo.req.ListOrderFeedReqVO;
import com.byh.util.sflocal.vo.req.PreCreateOrderReqVO;
import com.byh.util.sflocal.vo.resp.CancelOrderRespVO;
import com.byh.util.sflocal.vo.resp.CreateOrderRespVO;
import com.byh.util.sflocal.vo.resp.GetCallbackInfoRespVO;
import com.byh.util.sflocal.vo.resp.ListOrderFeedRespVO;
import com.byh.util.sflocal.vo.resp.PreCreateOrderRespVO;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(SFRequestHelper.class);
    private static final SFApiProxy sfApiProxy = new SFApiProxy();

    public static PreCreateOrderRespVO preCreateOrder(PreCreateOrderReqVO preCreateOrderReqVO, String appId, String appSecret) {
        String jsonReqStr = JSON.toJSONString((Object)preCreateOrderReqVO);
        String callResp = null;
        try {
            callResp = sfApiProxy.callApi(SfLocalConfig.INTERFACE_PREFIX + "/open/api/external/precreateorder", jsonReqStr, appId, appSecret);
            if (callResp == null || "".equals(callResp)) {
                throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u9884\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u7b7e\u540d\u7f16\u7801\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u9884\u521b\u5efa\u8ba2\u5355\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage());
        }
        Gson gson = new Gson();
        PreCreateOrderRespVO preCreateOrderRespVO = (PreCreateOrderRespVO)gson.fromJson(callResp, PreCreateOrderRespVO.class);
        return preCreateOrderRespVO;
    }

    public static CreateOrderRespVO createOrder(CreateOrderReqVO createOrderReqVO, String appId, String appSecret) {
        String jsonReqStr = JSON.toJSONString((Object)createOrderReqVO);
        String callResp = null;
        try {
            callResp = sfApiProxy.callApi(SfLocalConfig.INTERFACE_PREFIX + "/open/api/external/createorder", jsonReqStr, appId, appSecret);
            if (callResp == null || "".equals(callResp)) {
                throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u7b7e\u540d\u7f16\u7801\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u521b\u5efa\u8ba2\u5355\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage());
        }
        Gson gson = new Gson();
        CreateOrderRespVO createOrderRespVO = (CreateOrderRespVO)gson.fromJson(callResp, CreateOrderRespVO.class);
        return createOrderRespVO;
    }

    public static CancelOrderRespVO cancelOrder(CancelOrderReqVO cancelOrderReqVO, String appId, String appSecret) {
        String jsonReqStr = JSON.toJSONString((Object)cancelOrderReqVO);
        String callResp = null;
        try {
            callResp = sfApiProxy.callApi(SfLocalConfig.INTERFACE_PREFIX + "/open/api/external/cancelorder", jsonReqStr, appId, appSecret);
            if (callResp == null || "".equals(callResp)) {
                throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u53d6\u6d88\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u53d6\u6d88\u8ba2\u5355\u7b7e\u540d\u7f16\u7801\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u53d6\u6d88\u8ba2\u5355\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage());
        }
        Gson gson = new Gson();
        CancelOrderRespVO cancelOrderRespVO = (CancelOrderRespVO)gson.fromJson(callResp, CancelOrderRespVO.class);
        return cancelOrderRespVO;
    }

    public static ListOrderFeedRespVO listOrderFeed(ListOrderFeedReqVO listOrderFeedReqVO, String appId, String appSecret) {
        String jsonReqStr = JSON.toJSONString((Object)listOrderFeedReqVO);
        String callResp = null;
        try {
            callResp = sfApiProxy.callApi(SfLocalConfig.INTERFACE_PREFIX + "/open/api/external/listorderfeed", jsonReqStr, appId, appSecret);
            if (callResp == null || "".equals(callResp)) {
                throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u8ba2\u5355\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u8ba2\u5355\u67e5\u8be2\u7b7e\u540d\u7f16\u7801\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u8ba2\u5355\u67e5\u8be2\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage());
        }
        Gson gson = new Gson();
        ListOrderFeedRespVO listOrderFeedRespVO = (ListOrderFeedRespVO)gson.fromJson(callResp, ListOrderFeedRespVO.class);
        return listOrderFeedRespVO;
    }

    public static GetCallbackInfoRespVO getCallbackInfo(GetCallbackInfoReqVO getCallbackInfoReqVO, String appId, String appSecret) {
        String jsonReqStr = JSON.toJSONString((Object)getCallbackInfoReqVO);
        String callResp = null;
        try {
            callResp = sfApiProxy.callApi(SfLocalConfig.INTERFACE_PREFIX + "/open/api/external/getcallbackinfo", jsonReqStr, appId, appSecret);
            if (callResp == null || "".equals(callResp)) {
                throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u56de\u8c03\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u56de\u8c03\u8be6\u60c5\u67e5\u8be2\u7b7e\u540d\u7f16\u7801\u5f02\u5e38\uff01" + e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u540c\u57ce\u6025\u9001\u56de\u8c03\u8be6\u60c5\u67e5\u8be2\u8c03\u7528\u5931\u8d25\uff01" + e.getMessage());
        }
        Gson gson = new Gson();
        GetCallbackInfoRespVO getCallbackInfoRespVO = (GetCallbackInfoRespVO)gson.fromJson(callResp, GetCallbackInfoRespVO.class);
        return getCallbackInfoRespVO;
    }

    public static void main(String[] args) {
    }
}

