/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.mq;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusDescribeEnum;
import com.byh.nursingcarenewserver.pojo.enums.OrderStatusEnum;
import com.byh.nursingcarenewserver.pojo.vo.RefundVo;
import com.byh.nursingcarenewserver.service.PayService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class DoctorNotServiceListener {
    private static final Logger log = LoggerFactory.getLogger(DoctorNotServiceListener.class);
    public static final String CHAR = "&&&&";
    @Resource
    private AppointmentMapper appointmentMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private PayService payService;
    @Resource
    private ComponentConstant componentConstant;

    @RabbitHandler
    @RabbitListener(queues={"doctor.not.service.queue"})
    @Transactional(rollbackFor={Exception.class})
    public void process(String info) {
        log.info("\u533b\u751f\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1,\u8fdb\u5165\u6d88\u606f\u5904\u7406\uff0c\u53c2\u6570\u4e3a:{}", (Object)info);
        if (StringUtils.isEmpty((CharSequence)info)) {
            return;
        }
        String viewId = "";
        String doctorId = "";
        try {
            String[] infos = info.split(CHAR);
            viewId = infos[0];
            doctorId = infos[1];
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            return;
        }
        Appointment appointment = (Appointment)this.appointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId));
        if (ObjectUtils.isEmpty((Object)appointment)) {
            log.info("\u9884\u7ea6\u5355\u627e\u4e0d\u5230\u4e86\u3002\u76f4\u63a5\u9000\u51fa" + viewId);
            return;
        }
        log.info("\u627e\u5230\u9884\u7ea6\u5355\u7684\u4fe1\u606f:" + JSON.toJSONString((Object)appointment));
        Long serviceOrderId = appointment.getServiceOrderId();
        Orders order = (Orders)this.orderMapper.selectById((Serializable)serviceOrderId);
        if (ObjectUtils.isEmpty((Object)order)) {
            log.info("\u8ba2\u5355\u627e\u4e0d\u5230\uff0c\u9000\u51fa,{}", (Object)order.getViewId());
            return;
        }
        if (!order.getStatus().equals(OrderStatusEnum.ORDER_STATUS_SYZ.getValue())) {
            log.info("\u8ba2\u5355\u72b6\u6001\u4e0d\u662f'\u4f7f\u7528\u4e2d'\uff0c\u9000\u51fa");
            return;
        }
        this.handleOrderRefund(appointment, order);
        log.info("\u62a4\u58eb\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1\uff0c\u961f\u5217\u6d88\u8d39\u5b8c\u6bd5!!");
    }

    private void handleOrderRefund(Appointment appointment, Orders order) {
        if (order.getServerTotalNum().equals(1)) {
            RefundVo refundVo = new RefundVo();
            refundVo.setAppCode(this.componentConstant.getAppCode());
            refundVo.setOrderViewId(order.getViewId());
            refundVo.setPrice(order.getPrice());
            Boolean refund = this.payService.refund(refundVo);
            if (refund.booleanValue()) {
                appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
                appointment.setStatusDescribe("\u62a4\u58eb\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1\u81ea\u52a8\u53d6\u6d88");
                order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + 1));
                order.setStatus(OrderStatusEnum.ORDER_STATUS_YTK.getValue());
                order.setStatusDescribe(OrderStatusDescribeEnum.STATUS_DOCTOR_YTK.getDisplay());
                order.setRefundPrice(order.getPrice());
                order.setServerTotalNum(Integer.valueOf(0));
                log.info("\u62a4\u58eb\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1\u5df2\u9000\u6b3e");
            }
        } else {
            appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_YQX.getValue());
            appointment.setStatusDescribe("\u62a4\u58eb\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1\uff0c\u5e76\u4e14\u670d\u52a1\u6b21\u6570\u5927\u4e8e1\u672c\u6b21\u670d\u52a1\u5df2\u4e3a\u60a8\u8fd4\u8fd8\u6b21\u6570");
            order.setServerResidueNum(Integer.valueOf(order.getServerResidueNum() + 1));
            log.info("\u62a4\u58eb\u63a5\u5355\u8d85\u65f6\u672a\u670d\u52a1\u5df2\u9000\u6b21\u6570");
        }
        this.appointmentMapper.updateById((Object)appointment);
        this.orderMapper.updateById((Object)order);
    }
}

