/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.nursingcarenewserver.common.execption.BusinessException;
import com.byh.nursingcarenewserver.mapper.CartItemMapper;
import com.byh.nursingcarenewserver.mapper.ProductSubitemMapper;
import com.byh.nursingcarenewserver.pojo.dto.QueryCartDto;
import com.byh.nursingcarenewserver.pojo.dto.QueryCartItemDto;
import com.byh.nursingcarenewserver.pojo.entity.Cart;
import com.byh.nursingcarenewserver.pojo.entity.CartItem;
import com.byh.nursingcarenewserver.pojo.entity.HospitalConfig;
import com.byh.nursingcarenewserver.pojo.entity.ProductSubitem;
import com.byh.nursingcarenewserver.pojo.vo.QueryCartItemVo;
import com.byh.nursingcarenewserver.pojo.vo.SaveCartItemVo;
import com.byh.nursingcarenewserver.service.CartItemService;
import com.byh.nursingcarenewserver.service.CartService;
import com.byh.nursingcarenewserver.service.HospitalConfigService;
import com.byh.nursingcarenewserver.utils.DistanceUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CartItemServiceImpl
extends ServiceImpl<CartItemMapper, CartItem>
implements CartItemService {
    private static final Logger log = LoggerFactory.getLogger(CartItemServiceImpl.class);
    @Autowired
    private CartService cartService;
    @Autowired
    private CartItemMapper cartItemMapper;
    @Autowired
    private ProductSubitemMapper productSubitemMapper;
    @Resource
    private HospitalConfigService hospitalConfigService;

    public QueryCartDto selectCartItemByUser(QueryCartItemVo queryCartItemVo) {
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)queryCartItemVo.getOrganId()));
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isEmpty((Object)hospitalConfig)) {
            throw new BusinessException("\u533b\u9662\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        QueryCartDto queryCartDto = new QueryCartDto();
        Cart cart = this.cartService.saveCart(queryCartItemVo.getUserId());
        List cartItemList = this.cartItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"cart_id", (Object)cart.getId()));
        if (CollectionUtils.isEmpty((Collection)cartItemList)) {
            return queryCartDto;
        }
        double distance = 0.0;
        if (queryCartItemVo.getLat() != null && queryCartItemVo.getLng() != null) {
            distance = DistanceUtil.distance((double)queryCartItemVo.getLat(), (double)queryCartItemVo.getLng(), (double)Double.parseDouble(hospitalConfig.getHosLat()), (double)Double.parseDouble(hospitalConfig.getHosLng()));
        }
        Object[] objects = this.getDisTypeAndPrice(distance, queryCartItemVo.getOrganId());
        queryCartDto.setIsDistribution(Integer.valueOf(Integer.parseInt(String.valueOf(objects[0]))));
        BigDecimal tripPrice = new BigDecimal(String.valueOf(objects[1]));
        ArrayList<QueryCartItemDto> queryCartItemDtoList = new ArrayList<QueryCartItemDto>();
        for (CartItem cartItem : cartItemList) {
            QueryCartItemDto queryCartItemDto = new QueryCartItemDto();
            ProductSubitem productSubitem = (ProductSubitem)this.productSubitemMapper.selectById((Serializable)cartItem.getProductSubitemId());
            BeanUtils.copyProperties((Object)cartItem, (Object)queryCartItemDto);
            BeanUtils.copyProperties((Object)productSubitem, (Object)queryCartItemDto);
            queryCartItemDto.setCartItemId(cartItem.getId());
            queryCartItemDto.setTotalPrice(productSubitem.getPrice().multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDto.setTripPrice(tripPrice.multiply(new BigDecimal(cartItem.getQuantity())));
            queryCartItemDtoList.add(queryCartItemDto);
        }
        queryCartDto.setQueryCartItemDtoList(queryCartItemDtoList);
        return queryCartDto;
    }

    public Object[] getDisTypeAndPrice(double distance, Integer organId) {
        log.info("\u8fdb\u5165\u8ba1\u7b97\u8fd0\u8d39\u65b9\u6cd5,\u4f20\u5165\u53c2\u6570distance={},organId={}", (Object)distance, (Object)organId);
        HospitalConfig hospitalConfig = (HospitalConfig)this.hospitalConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(HospitalConfig::getOrganId, (Object)organId));
        if (ObjectUtils.isEmpty((Object)hospitalConfig)) {
            throw new RuntimeException("\u533b\u9662\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        Object[] objects = new Object[2];
        BigDecimal tripPriceFinal = new BigDecimal(0);
        BigDecimal basicTripPrice = new BigDecimal(hospitalConfig.getBasTrip());
        double overKm = Double.parseDouble(hospitalConfig.getOverKm()) * 1000.0;
        double freeKm = Double.parseDouble(hospitalConfig.getFreeKm()) * 1000.0;
        double billKm = Double.parseDouble(hospitalConfig.getBillKm()) * 1000.0;
        BigDecimal addFee = new BigDecimal(hospitalConfig.getAddFee());
        BigDecimal doubleKm = new BigDecimal(hospitalConfig.getDoubleKm());
        log.info("overKm={},freeKm={},billKm={},addFee={},doubleKm={}", new Object[]{overKm, freeKm, billKm, addFee, doubleKm});
        if (distance != 0.0) {
            if (distance > overKm) {
                objects[0] = 3;
            } else if (distance <= freeKm) {
                objects[0] = 1;
            } else if (distance <= billKm) {
                objects[0] = 2;
                tripPriceFinal = basicTripPrice;
            } else {
                objects[0] = 2;
                BigDecimal subtract = BigDecimal.valueOf(distance).subtract(BigDecimal.valueOf(billKm)).divide(new BigDecimal("1000"), 5, RoundingMode.HALF_UP);
                BigDecimal tripPrice = basicTripPrice.add(subtract.multiply(addFee));
                tripPriceFinal = tripPrice.setScale(2, RoundingMode.HALF_UP);
                log.info("\u8bbe\u7f6e\u7cbe\u5ea6\u540e\u7684\u6700\u7ec8\u8def\u8d39\u4e3a{}", (Object)tripPriceFinal);
            }
        }
        objects[1] = tripPriceFinal.multiply(doubleKm).setScale(2, RoundingMode.HALF_UP);
        log.info("\u8ddd\u79bb\u4e3adistance={},\u8ba1\u7b97\u7684\u8def\u8d39\u4e3a{}", (Object)distance, objects[1]);
        return objects;
    }

    @Transactional(rollbackFor={Exception.class})
    public String saveCartItem(SaveCartItemVo saveCartItemVo) {
        Cart cart = this.cartService.saveCart(saveCartItemVo.getUserId());
        CartItem cartItem = new CartItem();
        cartItem.setCartId(cart.getId().toString());
        cartItem.setQuantity(saveCartItemVo.getQuantity());
        cartItem.setProductSubitemId(saveCartItemVo.getProductSubitemId());
        cartItem.setProductId(saveCartItemVo.getProductId());
        int insert = this.cartItemMapper.insert((Object)cartItem);
        return "\u5546\u54c1\u6dfb\u52a0\u6210\u529f";
    }

    public String deleteCartItem(List<Long> cartItemIdList) {
        this.cartItemMapper.deleteBatchIds(cartItemIdList);
        return "\u5546\u54c1\u5220\u9664\u6210\u529f";
    }

    public void updateCartItemCount(Long cartItemId, int count) {
        CartItem cartItem = new CartItem();
        cartItem.setQuantity(Integer.valueOf(count));
        this.cartItemMapper.update((Object)cartItem, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)cartItemId));
    }
}

