/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.mapper.AppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderAppointmentMapper;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.mapper.ServiceMerchantConfigMapper;
import com.byh.nursingcarenewserver.mapper.ServicePayBillMapper;
import com.byh.nursingcarenewserver.pojo.entity.Appointment;
import com.byh.nursingcarenewserver.pojo.entity.OrderAppointment;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.entity.ServiceMerchantConfig;
import com.byh.nursingcarenewserver.pojo.entity.ServicePayBill;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusDescribeUserEnum;
import com.byh.nursingcarenewserver.pojo.enums.AppointmentStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.PayStatusEnum;
import com.byh.nursingcarenewserver.pojo.enums.ReturnCodeEnum;
import com.byh.nursingcarenewserver.pojo.vo.AggregationPayWxVo;
import com.byh.nursingcarenewserver.pojo.vo.CancelReasonVo;
import com.byh.nursingcarenewserver.pojo.vo.DiscountVo;
import com.byh.nursingcarenewserver.pojo.vo.PayCallbackVo;
import com.byh.nursingcarenewserver.pojo.vo.PayParamVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundCallbackVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundHttpVo;
import com.byh.nursingcarenewserver.pojo.vo.RefundVo;
import com.byh.nursingcarenewserver.service.PayService;
import com.byh.nursingcarenewserver.service.impl.CancelReasonServiceImpl;
import com.byh.nursingcarenewserver.utils.HttpUtils;
import com.byh.nursingcarenewserver.utils.SignUtil;
import com.byh.nursingcarenewserver.utils.UniqueKeyGenerator;
import com.byh.nursingcarenewserver.utils.pinyinUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger log = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderAppointmentMapper orderAppointmentMapper;
    @Autowired
    private AppointmentMapper appointmentMapper;
    @Resource
    private ComponentConstant componentConstant;
    @Resource
    private CancelReasonServiceImpl cancelReasonService;

    @Transactional
    public BaseResponse<JSONObject> pricePay(PayParamVo payParamVo) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"app_code", (Object)payParamVo.getAppCode())).eq((Object)"status", (Object)"1");
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("serviceMerchantConfig:{}", (Object)serviceMerchantConfig);
        StringBuffer serviceCode = new StringBuffer();
        serviceCode.append(payParamVo.getAppCode()).append("_").append("HLZH");
        AggregationPayWxVo aggregationPayWxVo = new AggregationPayWxVo();
        aggregationPayWxVo.setPayChannel(payParamVo.getPayChannel());
        aggregationPayWxVo.setPayType(payParamVo.getPayType());
        aggregationPayWxVo.setMchCode(serviceMerchantConfig.getMerchantSeq());
        aggregationPayWxVo.setServiceCode(serviceCode.toString());
        aggregationPayWxVo.setUserSign(payParamVo.getOpenId());
        aggregationPayWxVo.setOutTradeNo(payParamVo.getOrderViewId());
        aggregationPayWxVo.setTotalAmount(payParamVo.getPrice());
        aggregationPayWxVo.setActuallyAmount(payParamVo.getPrice());
        aggregationPayWxVo.setProductInfo("\u62a4\u7406\u7167\u62a4");
        aggregationPayWxVo.setDiscountVo(new DiscountVo());
        aggregationPayWxVo.setAuthCode("");
        aggregationPayWxVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        aggregationPayWxVo.setPayNotifyUrl(this.componentConstant.getPAY_CALLBACK());
        aggregationPayWxVo.setApplyCode(serviceMerchantConfig.getMerchantSeq());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)aggregationPayWxVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])str);
        aggregationPayWxVo.setSign(sign);
        log.info("\u652f\u4ed8\u521b\u5efaaggregationPayWxVo\uff1a{}", (Object)aggregationPayWxVo);
        String url = this.componentConstant.getPAY_HTTP_WX_XCX();
        log.info("\u652f\u4ed8\u521b\u5efa\u8bf7\u6c42\u8def\u5f84url\uff1a{}", (Object)url);
        String respStr = "";
        log.info("\u652f\u4ed8\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)aggregationPayWxVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aggregationPayWxVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
            return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
        }
        return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean payCallback(PayCallbackVo payCallbackVo) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u53c2\u6570payNotifyReqVO\uff1a{}\uff1b", (Object)JSON.toJSONString((Object)payCallbackVo));
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"apply_id", (Object)payCallbackVo.getApplyId())).eq((Object)"status", (Object)"1");
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014serviceMerchantConfig\uff1a{}\uff1b", (Object)serviceMerchantConfig);
        String serviceCode = serviceMerchantConfig.getAppCode() + "_HLZH";
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014payNotifyAggregationVo\uff1a{}\uff1b", (Object)payCallbackVo);
        Map map = SignUtil.getKeyAndValue((Object)payCallbackVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9a8c\u7b7e\u7ed3\u679cbool\uff1a{}\uff1b", (Object)bool);
        if (bool.booleanValue()) {
            Orders orders = this.orderMapper.queryByViewId(payCallbackVo.getOutTradeNo());
            OrderAppointment orderAppointment = (OrderAppointment)this.orderAppointmentMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"order_id", (Object)orders.getId()));
            Appointment appointment = new Appointment();
            appointment.setViewId(UniqueKeyGenerator.generateViewId().toString());
            appointment.setServiceOrderId(orders.getId());
            appointment.setStatus(AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue());
            appointment.setStatusDescribe(AppointmentStatusDescribeUserEnum.getAppointmentStatusDescribeUserEnum((Integer)AppointmentStatusEnum.APPOINTMENT_STATUS_DSH.getValue()).getDisplay());
            appointment.setAppointmentTime(orderAppointment.getAppointmentTime());
            appointment.setRemark(orderAppointment.getRemark());
            this.appointmentMapper.insert((Object)appointment);
            CancelReasonVo cancelReasonVo = new CancelReasonVo();
            cancelReasonVo.setAppointmentId(appointment.getViewId());
            cancelReasonVo.setOrderId(orders.getViewId());
            this.cancelReasonService.addReason(cancelReasonVo);
            ServicePayBill servicePayBillEntity = new ServicePayBill();
            servicePayBillEntity.setStatus(Integer.valueOf(3));
            servicePayBillEntity.setAppCode(serviceMerchantConfig.getAppCode());
            servicePayBillEntity.setOrganName("");
            servicePayBillEntity.setWorkServiceCode("HLZH");
            servicePayBillEntity.setApplyCode(serviceMerchantConfig.getMerchantSeq());
            servicePayBillEntity.setPayChannel(payCallbackVo.getPayChannel());
            servicePayBillEntity.setTradeTime(payCallbackVo.getPayTime());
            servicePayBillEntity.setTradeNo(payCallbackVo.getTradeNo());
            servicePayBillEntity.setOutTradeNo(payCallbackVo.getOutTradeNo());
            servicePayBillEntity.setTradeStatus("SUCCESS");
            servicePayBillEntity.setOrderAmount(payCallbackVo.getTotalAmount());
            servicePayBillEntity.setDealAmount(payCallbackVo.getTotalAmount());
            servicePayBillEntity.setServiceCode(serviceCode);
            servicePayBillEntity.setDealTradeNo(payCallbackVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58servicePayBillEntity\uff1a{}\uff1b", (Object)servicePayBillEntity);
            int insert = this.servicePayBillMapper.insert((Object)servicePayBillEntity);
            if (insert != 1) {
                return false;
            }
        } else {
            this.orderMapper.delete((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)payCallbackVo.getOutTradeNo()));
            return false;
        }
        return true;
    }

    public Boolean refund(RefundVo refundVo) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"out_trade_no", (Object)refundVo.getOrderViewId());
        List servicePayBillList = this.servicePayBillMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)servicePayBillList)) {
            log.error("\u627e\u4e0d\u5230\u8be5\u8ba2\u5355\u7684\u8d26\u5355\u4fe1\u606f\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)refundVo.getOrderViewId());
            return false;
        }
        ServicePayBill servicePayBill = (ServicePayBill)servicePayBillList.get(0);
        QueryWrapper configQueryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"app_code", (Object)refundVo.getAppCode())).eq((Object)"status", (Object)"1");
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)configQueryWrapper);
        RefundHttpVo refundHttpVo = new RefundHttpVo();
        refundHttpVo.setPayChannel(servicePayBill.getPayChannel());
        refundHttpVo.setMchCode(servicePayBill.getApplyCode());
        refundHttpVo.setOutTradeNo(servicePayBill.getOutTradeNo());
        refundHttpVo.setDealTradeNo(servicePayBill.getDealTradeNo());
        refundHttpVo.setTotalAmount(servicePayBill.getOrderAmount());
        refundHttpVo.setRefundAmount(refundVo.getPrice());
        refundHttpVo.setNonceStr(pinyinUtil.getRandomString((int)32));
        refundHttpVo.setRefundNotifyUrl(this.componentConstant.getPAY_REFUND_CALLBACK());
        refundHttpVo.setApplyCode(servicePayBill.getApplyCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)refundHttpVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])str);
        refundHttpVo.setSign(sign);
        String url = this.componentConstant.getPAY_REFUND_HTTP();
        String respStr = "";
        log.info("\u9000\u6b3e\u8bf7\u6c42url\u662f:{} http\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)refundHttpVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)refundHttpVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8bf7\u6c42http\u8bf7\u6c42\u8fd4\u56de:{}", (Object)respStr);
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
            return true;
        }
        return false;
    }

    @Transactional
    public Boolean refundCallback(RefundCallbackVo refundCallbackVo) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u53c2\u6570refundCallbackVo\uff1a{}\uff1b", (Object)refundCallbackVo);
        if (!PayStatusEnum.SUCCESS.getValue().equals(refundCallbackVo.getReturnCode())) {
            log.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)refundCallbackVo.getOutTradeNo());
            return false;
        }
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"apply_id", (Object)refundCallbackVo.getApplyId())).eq((Object)"status", (Object)"1");
        ServiceMerchantConfig serviceMerchantConfig = (ServiceMerchantConfig)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03serviceMerchantConfig\uff1a{}\uff1b", (Object)serviceMerchantConfig);
        QueryWrapper billQueryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"out_trade_no", (Object)refundCallbackVo.getOutTradeNo());
        List servicePayBillList = this.servicePayBillMapper.selectList((Wrapper)billQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)servicePayBillList)) {
            log.error("\u627e\u4e0d\u5230\u8d26\u5355\u4fe1\u606f\uff1a{}\uff1b", (Object)refundCallbackVo.getOutTradeNo());
            return false;
        }
        ServicePayBill servicePayBill = (ServicePayBill)servicePayBillList.get(0);
        String serviceCode = serviceMerchantConfig.getAppCode() + "_HLZH";
        Map map = SignUtil.getKeyAndValue((Object)refundCallbackVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey());
        if (bool.booleanValue()) {
            ServicePayBill refundPayBillEntity = new ServicePayBill();
            refundPayBillEntity.setStatus(Integer.valueOf(6));
            refundPayBillEntity.setRemark("");
            refundPayBillEntity.setAppCode(serviceMerchantConfig.getAppCode());
            refundPayBillEntity.setOrganName("");
            refundPayBillEntity.setWorkServiceCode("HLZH");
            refundPayBillEntity.setApplyCode(serviceMerchantConfig.getMerchantSeq());
            refundPayBillEntity.setPayChannel(refundCallbackVo.getPayChannel());
            refundPayBillEntity.setTradeTime(servicePayBill.getTradeTime());
            refundPayBillEntity.setTradeNo(servicePayBill.getTradeNo());
            refundPayBillEntity.setOutTradeNo(refundCallbackVo.getOutTradeNo());
            refundPayBillEntity.setTradeStatus("SUCCESS");
            refundPayBillEntity.setOrderAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setDealAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setRefundNo(refundCallbackVo.getRefundNo());
            refundPayBillEntity.setOutRefundNo(refundCallbackVo.getOutRefundNo());
            refundPayBillEntity.setRefundTime(refundCallbackVo.getRefundTime());
            refundPayBillEntity.setRefundAmount(refundCallbackVo.getRefundMoney());
            refundPayBillEntity.setServiceCode(serviceCode);
            refundPayBillEntity.setDealTradeNo(refundCallbackVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58refundPayBillEntity\uff1a{}\uff1b", (Object)refundPayBillEntity);
            int insert = this.servicePayBillMapper.insert((Object)refundPayBillEntity);
            if (insert != 1) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

