/*
 * Decompiled with CFR 0.152.
 */
package com.byh.nursingcarenewserver.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.nursingcarenewserver.constant.ComponentConstant;
import com.byh.nursingcarenewserver.mapper.OrderMapper;
import com.byh.nursingcarenewserver.pojo.entity.Orders;
import com.byh.nursingcarenewserver.pojo.req.GetTokenReqVO;
import com.byh.nursingcarenewserver.pojo.req.PushSubscribeMessageReqVO;
import com.byh.nursingcarenewserver.service.ProgramPushService;
import com.byh.nursingcarenewserver.utils.ProgramUtil;
import com.byh.nursingcarenewserver.utils.PushParamUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProgramPushServiceImpl
implements ProgramPushService {
    private static final Logger log = LoggerFactory.getLogger(ProgramPushServiceImpl.class);
    @Resource
    private ComponentConstant componentConstant;
    @Resource
    private PushParamUtil pushParamUtil;
    @Autowired
    private OrderMapper orderMapper;
    @Resource
    private ProgramUtil programUtil;
    private static final String VALUE_STR = "value";

    public void refundPush(String appCode, String viewId, BigDecimal refundPrice) {
        Orders orders = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"view_id", (Object)viewId));
        String openId = this.pushParamUtil.getWxOpenId(orders.getUserId(), appCode);
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9000\u6b3eopenId:{}", (Object)openId);
        String clientCode = this.pushParamUtil.getPushConfig(this.componentConstant.getAppCode(), "weChatApplets", "patient", "weChatApplets").getClientCode();
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9000\u6b3eclientCode:{}", (Object)clientCode);
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put(VALUE_STR, orders.getPatientName());
        data.put("name8", patientNameMap);
        HashMap<String, String> refundPriceMap = new HashMap<String, String>(5);
        String priceStr = refundPrice.setScale(2, 0).toString();
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9000\u6b3e\u4ef7\u683c:{}", (Object)priceStr);
        refundPriceMap.put(VALUE_STR, priceStr);
        data.put("amount4", refundPriceMap);
        HashMap<String, String> thingMap = new HashMap<String, String>(10);
        thingMap.put(VALUE_STR, "\u62a4\u7406\u670d\u52a1\u5df2\u9000\u6b3e\uff0c\u53ef\u70b9\u51fb\u6211\u7684-\u62a4\u7406\u7167\u62a4\u67e5\u770b");
        data.put("thing1", thingMap);
        GetTokenReqVO getTokenReqVO = new GetTokenReqVO();
        getTokenReqVO.setClientCode(clientCode);
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setTemplateCode(this.componentConstant.getPROGRAM_PUSH_TEMPLATECODE());
        pushSubscribeMessageReqVO.setPage(this.componentConstant.getPROGRAM_PUSH_JUMPURL() + viewId);
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setGetTokenReqVO(getTokenReqVO);
        pushSubscribeMessageReqVO.setClientCode(clientCode);
        this.programUtil.pushSubscribeMessage(pushSubscribeMessageReqVO);
    }

    public void distributeOrderPush(String appCode, Long viewId, String time) {
        Orders orders = (Orders)this.orderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)viewId));
        String openId = this.pushParamUtil.getWxOpenId(orders.getUserId(), appCode);
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u60a3\u8005openId:{}", (Object)openId);
        String clientCode = this.pushParamUtil.getPushConfig(this.componentConstant.getAppCode(), "weChatApplets", "patient", "weChatApplets").getClientCode();
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u62a4\u58eb\u63a5\u5355clientCode:{}", (Object)clientCode);
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put(VALUE_STR, orders.getPatientName());
        data.put("thing4", patientNameMap);
        HashMap<String, String> refundPriceMap = new HashMap<String, String>(5);
        refundPriceMap.put(VALUE_STR, time);
        data.put("time3", refundPriceMap);
        HashMap<String, String> thingMap = new HashMap<String, String>(10);
        thingMap.put(VALUE_STR, "\u60a8\u7684\u62a4\u7406\u8ba2\u5355\u5df2\u7531\u62a4\u58eb\u63a5\u5355");
        data.put("thing5", thingMap);
        GetTokenReqVO getTokenReqVO = new GetTokenReqVO();
        getTokenReqVO.setClientCode(clientCode);
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setTemplateCode(this.componentConstant.getDISTRIBUTE_ORDER_PUSH_TEMPLATE_CODE());
        pushSubscribeMessageReqVO.setPage(this.componentConstant.getPROGRAM_PUSH_JUMPURL() + orders.getViewId());
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setGetTokenReqVO(getTokenReqVO);
        pushSubscribeMessageReqVO.setClientCode(clientCode);
        this.programUtil.pushSubscribeMessage(pushSubscribeMessageReqVO);
    }
}

