/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.excel.TestExcel;
import com.byh.outpatient.api.model.OutCustomerServiceSettingsEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksVo;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.TaskByDispense;
import com.byh.outpatient.api.vo.TaskByDrugVo;
import com.byh.outpatient.api.vo.TaskByPatientVo;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutFollowUpTasksService;
import com.byh.outpatient.web.service.PatientService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class OutFollowUpTasksController {
    @Autowired
    private OutFollowUpTasksService outFollowUpTasksService;
    @Autowired
    private OutFollowUpTasksMapper tasksMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientService patientService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/import"})
    public void export(@RequestPart(value="file") MultipartFile file, HttpServletResponse response) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> param = new HashMap<String, String>();
        for (Sheet rows : workbook) {
            Integer count = 0;
            for (Row row : rows) {
                if (count < 1) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                String patientName = row.getCell(3).getStringCellValue();
                String cardNo = row.getCell(4).getStringCellValue();
                if (param.containsKey(cardNo)) continue;
                param.put(cardNo, patientName);
            }
        }
        ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
        for (Map.Entry entry : param.entrySet()) {
            Integer i;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.length() != 18 || (i = this.patientMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PatientEntity::getTenantId, (Object)1)).eq(PatientEntity::getCardNo, (Object)key))) != 1) continue;
            PatientEntity patient = new PatientEntity();
            patient.setCardNo(key);
            patient.setName(value);
            patient.setTenantId(Integer.valueOf(1));
            patient.setCardType("1");
            int age = OutFollowUpTasksController.calculateAge((String)key);
            patient.setAge(Integer.valueOf(age));
            String birthDate = OutFollowUpTasksController.getBirthDate((String)key);
            patient.setBirthday(birthDate);
            Integer gender = OutFollowUpTasksController.getGender((String)key);
            patient.setSex(gender + "");
            patient.setRemark("23\u5e74\u65e0\u6863\u6848\u60a3\u8005");
            this.patientMapper.update((Object)patient, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(PatientEntity::getTenantId, (Object)1)).eq(PatientEntity::getCardNo, (Object)key));
            patientList.add(patient);
        }
        this.patientService.insertImport(patientList);
    }

    public static Integer getGender(String idCard) {
        if (idCard == null || idCard.length() != 18) {
            throw new IllegalArgumentException("Invalid ID card number. It should be 18 characters long.");
        }
        char genderChar = idCard.charAt(16);
        int genderDigit = Character.getNumericValue(genderChar);
        if (genderDigit % 2 == 0) {
            return 2;
        }
        return 1;
    }

    public static int calculateAge(String idCard) {
        String birthDateStr = OutFollowUpTasksController.getBirthDate((String)idCard);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date birthDate = null;
        try {
            birthDate = format.parse(birthDateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date currentDate = OutFollowUpTasksController.getCurrentDate();
        int age = currentDate.getYear() - birthDate.getYear();
        if (currentDate.before(birthDate)) {
            --age;
        }
        return age;
    }

    public static String getBirthDate(String idCard) {
        System.out.println(idCard);
        String birthDate = idCard.substring(6, 14);
        return birthDate;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    @PostMapping(value={"/export2"})
    public void export2(@RequestPart(value="file") MultipartFile file, HttpServletResponse response) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        ArrayList list = new ArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> sheetList = new ArrayList<String>();
        sheetList.add("\u8179\u900f");
        sheetList.add("\u80bf\u7624");
        HashMap paramMap = new HashMap();
        HashSet<String> nameList = new HashSet<String>();
        int c = 0;
        for (Sheet rows : workbook) {
            if (c == 0) {
                ++c;
                continue;
            }
            Integer count = 0;
            ArrayList sheetData = new ArrayList();
            for (Row row : rows) {
                List<String> strings;
                if (count < 1) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                Date drugTime = row.getCell(0).getDateCellValue();
                String patientName = "";
                try {
                    patientName = row.getCell(1).getStringCellValue();
                }
                catch (Exception e) {
                    continue;
                }
                System.out.println(patientName);
                if (drugTime == null) continue;
                String drugTimeStr = format.format(drugTime);
                patientName = patientName.substring(0, patientName.indexOf("\uff08") == -1 ? patientName.length() : patientName.indexOf("\uff08"));
                nameList.add(patientName);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("drugTime", format.format(drugTime));
                param.put("patientNames", patientName);
                if (paramMap.containsKey(drugTimeStr)) {
                    strings = (List)paramMap.get(drugTimeStr);
                    strings.add(patientName);
                    continue;
                }
                strings = new ArrayList();
                strings.add(patientName);
                paramMap.put(drugTimeStr, strings);
            }
        }
        ArrayList dataList = new ArrayList();
        HashMap checkMap = new HashMap();
        for (String key : paramMap.keySet()) {
            List strings = (List)paramMap.get(key);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("drugTime", key);
            param.put("patientNames", strings);
            List testExcels = this.tasksMapper.export2(param);
            dataList.addAll(testExcels);
            if (testExcels.size() >= strings.size()) continue;
            List collect = testExcels.stream().map(item -> {
                String name = item.getName();
                return name;
            }).collect(Collectors.toList());
            for (String string : strings) {
                List<String> strings1;
                if (collect.contains(string)) continue;
                if (checkMap.containsKey(key)) {
                    strings1 = (List)checkMap.get(key);
                    strings1.add(string);
                    continue;
                }
                strings1 = new ArrayList();
                strings1.add(string);
                checkMap.put(key, strings1);
            }
        }
        list.add(dataList);
        EasyExcelUtil.exportExcelMerge2((HttpServletResponse)response, (String)"\u8179\u900f", (String)"\u8179\u900f", (List)((List)list.get(0)), TestExcel.class);
    }

    @PostMapping(value={"/out/follow/up/tasks/queryMyPatient"})
    public ResponseData<PageInfo<OutCustomerServiceSettingsEntity>> queryMyPatient(@RequestBody @Valid OutFollowUpTasksEntity entity) throws ParseException {
        Integer userId = this.commonRequest.getUserId();
        PageHelper.startPage((int)entity.getCurrent(), (int)entity.getSize());
        List detailList = this.tasksMapper.queryMyPatientDetail(userId);
        PageInfo pageInfo1 = new PageInfo(detailList);
        List patientIds = detailList.stream().map(map -> {
            Integer id = map.getPatientId();
            return id;
        }).collect(Collectors.toList());
        List taskByPatientVos = this.tasksMapper.queryDispenseDateByPatientId(patientIds);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        Date nowDay = format.parse(timeStr);
        for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
            Object patientId = null;
            Integer beforeEnd = taskByPatientVo.getBeforeEnd();
            Integer afterEnd = taskByPatientVo.getAfterEnd();
            Integer afterEndOver = taskByPatientVo.getAfterEndOver();
            long taskTime = 0L;
            for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                List dispenseList = drugVo.getDispenseList();
                String dispenseDate = null;
                String followUpDate = null;
                Integer medicationDays = null;
                String opdId = null;
                String outpatientNo = null;
                String remark = null;
                for (int i = 0; i < dispenseList.size(); ++i) {
                    long followUpDateL;
                    TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                    opdId = taskByDispense.getOpdId();
                    outpatientNo = taskByDispense.getOutpatientNo();
                    String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                    String voFollowUpDate = taskByDispense.getFollowUpDate();
                    if (dispenseDate == null) {
                        dispenseDate = voDispenseDateTime;
                        followUpDate = voFollowUpDate.substring(0, 10);
                        continue;
                    }
                    long dspenseDateL = format.parse(dispenseDate).getTime();
                    if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                    medicationDays = ((TaskByDispense)dispenseList.get(i - 1)).getMedicationDays() + taskByDispense.getMedicationDays();
                    dispenseDate = voDispenseDateTime;
                    calendar.setTime(format.parse(voDispenseDateTime));
                    calendar.add(5, medicationDays);
                    followUpDate = format.format(calendar.getTime());
                    remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                }
                if (!StringUtils.isNotBlank(followUpDate)) continue;
                calendar.setTime(format.parse(followUpDate));
                Date followUpDateTime = calendar.getTime();
                calendar.add(5, -afterEndOver.intValue());
                long l = calendar.getTime().getTime() - nowDay.getTime();
                if (l > 0L) continue;
                calendar.setTime(followUpDateTime);
                calendar.add(5, beforeEnd);
                if (calendar.getTime().getTime() - nowDay.getTime() <= 0L) {
                    calendar.setTime(followUpDateTime);
                    calendar.add(5, -afterEnd.intValue());
                }
                Date date = new Date(taskTime);
                if (taskTime == 0L) {
                    taskTime = calendar.getTime().getTime();
                    continue;
                }
                if (taskTime >= calendar.getTime().getTime() || date.getTime() - nowDay.getTime() <= 0L) continue;
                taskTime = calendar.getTime().getTime();
            }
            Date date = new Date(taskTime);
            String taskDate = "";
            taskDate = date.getTime() - nowDay.getTime() > 0L ? format.format(date) : "\u5df2\u8fc7\u56de\u8bbf\u65f6\u95f4";
            for (int i = 0; i < detailList.size(); ++i) {
                OutCustomerServiceSettingsEntity map2 = (OutCustomerServiceSettingsEntity)detailList.get(i);
                Integer id = map2.getPatientId();
                Integer voPatientId = taskByPatientVo.getPatientId();
                if (voPatientId - id != 0) continue;
                map2.setTaskDate(taskDate);
            }
        }
        detailList.forEach(item -> {
            String taskDate = item.getTaskDate();
            if (StringUtil.isBlank((String)taskDate)) {
                item.setTaskDate("\u672a\u8d2d\u836f");
            }
        });
        PageInfo pageInfo = new PageInfo(detailList);
        return ResponseData.success((Object)pageInfo);
    }

    @RequestMapping(value={"/out/follow/up/tasks/test"})
    public ResponseData outFollowUpTasksSave() throws ParseException {
        Integer tenant = this.commonRequest.getTenant();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = format.format(new Date());
        Calendar calendar = Calendar.getInstance();
        Date nowDay = format.parse(timeStr);
        List taskByPatientVos = this.tasksMapper.queryDispenseDateByTask();
        ArrayList<OutFollowUpTasksEntity> list = new ArrayList<OutFollowUpTasksEntity>();
        block0: for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
            Integer userId = null;
            Integer patientId = null;
            Integer beforeEnd = taskByPatientVo.getBeforeEnd();
            Integer afterEnd = taskByPatientVo.getAfterEnd();
            Integer afterEndOver = taskByPatientVo.getAfterEndOver();
            for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                List dispenseList = drugVo.getDispenseList();
                String dispenseDate = null;
                String followUpDate = null;
                Integer medicationDays = null;
                String opdId = null;
                String outpatientNo = null;
                String remark = null;
                for (int i = 0; i < dispenseList.size(); ++i) {
                    long followUpDateL;
                    TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                    opdId = taskByDispense.getOpdId();
                    outpatientNo = taskByDispense.getOutpatientNo();
                    String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                    String voFollowUpDate = taskByDispense.getFollowUpDate();
                    if (dispenseDate == null) {
                        dispenseDate = voDispenseDateTime;
                        followUpDate = voFollowUpDate.substring(0, 10);
                        continue;
                    }
                    long dspenseDateL = format.parse(dispenseDate).getTime();
                    if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                    medicationDays = ((TaskByDispense)dispenseList.get(i - 1)).getMedicationDays() + taskByDispense.getMedicationDays();
                    dispenseDate = voDispenseDateTime;
                    calendar.setTime(format.parse(voDispenseDateTime));
                    calendar.add(5, medicationDays);
                    followUpDate = format.format(calendar.getTime());
                    remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                }
                if (!StringUtils.isNotBlank(followUpDate)) continue;
                calendar.setTime(format.parse(followUpDate));
                Date followUpDateTime = calendar.getTime();
                calendar.add(5, -afterEndOver.intValue());
                long l = calendar.getTime().getTime() - nowDay.getTime();
                if (l > 0L) continue;
                Integer type = null;
                calendar.setTime(nowDay);
                calendar.add(5, beforeEnd);
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 1;
                }
                calendar.setTime(nowDay);
                calendar.add(5, -afterEnd.intValue());
                if (calendar.getTime().getTime() - followUpDateTime.getTime() == 0L) {
                    type = 2;
                }
                if (type == null) continue;
                userId = taskByPatientVo.getUserId();
                patientId = taskByPatientVo.getPatientId();
                OutFollowUpTasksEntity entity = new OutFollowUpTasksEntity();
                entity.setFollowType(type);
                entity.setCreateTime(timeStr);
                entity.setStatus(Integer.valueOf(1));
                entity.setUserId(userId);
                entity.setPatientId(patientId);
                entity.setTenantId(tenant);
                entity.setDrugName(drugVo.getDrugName());
                entity.setOpdId(opdId);
                entity.setOutpatientNo(outpatientNo);
                entity.setFollowUpDate(followUpDate);
                if (StringUtils.isNotBlank((CharSequence)remark)) {
                    entity.setRemark(remark);
                }
                list.add(entity);
                continue block0;
            }
        }
        if (list.size() > 0) {
            this.tasksMapper.createTask(list);
        }
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/out/follow/up/tasks/select"})
    public ResponseData<PageInfo<OutFollowUpTasksEntity>> outFollowUpTasksSelect(@RequestBody @Valid OutFollowUpTasksEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        entity.setReqUserId(userId);
        entity.setTenantId(tenant);
        PageInfo list = this.outFollowUpTasksService.outFollowUpTasksSelect(entity);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/out/follow/up/tasks/queryTaskDetail"})
    public ResponseData<List<OutFollowUpTasksVo>> queryTaskDetail(@RequestBody @Valid OutFollowUpTasksEntity entity) throws ParseException {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        List list = this.outFollowUpTasksService.queryTaskDetail(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/follow/up/tasks/update"})
    public ResponseData outFollowUpTasksUpdate(@RequestBody @Valid OutFollowUpTasksEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.outFollowUpTasksService.outFollowUpTasksUpdate(entity);
        return ResponseData.success().update();
    }
}

