/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.DataInput;
import com.byh.outpatient.api.dto.Group;
import com.byh.outpatient.api.dto.Indicator;
import com.byh.outpatient.api.dto.RequestDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryPatientMedicalDto;
import com.byh.outpatient.api.model.ArchivalFileEntity;
import com.byh.outpatient.api.model.ArchivalFileTypeEntity;
import com.byh.outpatient.api.model.ArchivalRecordsEntity;
import com.byh.outpatient.api.model.ExpertStudioDto;
import com.byh.outpatient.api.model.OutEtubePatientDossierEntity;
import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.OutEtubeStudioDoctorEntity;
import com.byh.outpatient.api.model.OutEtubeStudioPatientEntity;
import com.byh.outpatient.api.model.OutExpertStudioRecordEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HttpUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringPinyinUtil;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.SysParamVo;
import com.byh.outpatient.api.vo.medicalRecord.QueryDiagnosisTreatmentRecordsVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.ArchivalFileMapper;
import com.byh.outpatient.data.repository.ArchivalFileTypeMapper;
import com.byh.outpatient.data.repository.ArchivalRecordsMapper;
import com.byh.outpatient.data.repository.OutEtubePatientDossierMapper;
import com.byh.outpatient.data.repository.OutEtubePatientInfoMapper;
import com.byh.outpatient.data.repository.OutEtubeStudioDoctorMapper;
import com.byh.outpatient.data.repository.OutEtubeStudioInfoMapper;
import com.byh.outpatient.data.repository.OutEtubeStudioPatientMapper;
import com.byh.outpatient.data.repository.OutExpertStudioRecordMapper;
import com.byh.outpatient.data.repository.OutIcdItemMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.data.repository.SysParamMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.config.MinioConfig;
import com.byh.outpatient.web.mvc.utils.MinioClientUtils;
import com.byh.outpatient.web.mvc.utils.OSSClientUtil;
import com.byh.outpatient.web.service.ExpertStudioService;
import com.byh.outpatient.web.service.MinioFileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class ExpertStudioServiceImpl
implements ExpertStudioService {
    private static Logger log = LoggerFactory.getLogger(ExpertStudioServiceImpl.class);
    private final String orderSite = "https://server.etube365.com/csp/pass/proxy/api";
    private final String orderSiteTest = "https://pass.etube365.com/tcsp/pass/proxy/api";
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutExpertStudioRecordMapper outExpertStudioRecordMapper;
    @Resource
    private OutEtubePatientInfoMapper outEtubePatientInfoMapper;
    @Resource
    private OutEtubeStudioDoctorMapper outEtubeStudioDoctorMapper;
    @Autowired
    private OutEtubeStudioPatientMapper outEtubeStudioPatientMapper;
    @Autowired
    private OutEtubePatientDossierMapper outEtubePatientDossierMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OutPrescriptionDrugMapper prescriptionDrugMapper;
    @Autowired
    private OutPrescriptionMapper prescriptionMapper;
    @Autowired
    private OutMedicalRecordMapper outMedicalRecordMapper;
    @Autowired
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Autowired
    private OutIcdItemMapper outIcdItemMapper;
    @Resource
    private OutEtubeStudioInfoMapper outEtubeStudioInfoMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Resource
    private MinioClientUtils minioClientUtils;
    @Resource
    private MinioConfig minioConfig;
    @Autowired
    private MinioFileService minioFileService;
    @Autowired
    private ArchivalRecordsMapper archivalRecordsMapper;
    @Autowired
    private ArchivalFileTypeMapper archivalFileTypeMapper;
    @Autowired
    private ArchivalFileMapper archivalFileMapper;
    @Autowired
    private SysParamMapper sysParamMapper;
    private SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ResponseData batchPush(Integer tenantId) {
        String code;
        List studioPatients = this.outEtubeStudioPatientMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        List studioPatientIds = studioPatients.stream().map(item -> item.getPatientId()).collect(Collectors.toList());
        List patientList = this.patientMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PatientEntity::getTenantId, (Object)tenantId)).notIn(studioPatientIds.size() > 0, PatientEntity::getId, studioPatientIds));
        Map<String, List<PatientEntity>> cardNoMap = patientList.stream().collect(Collectors.groupingBy(PatientEntity::getCardNo));
        Set<String> cardNoList = cardNoMap.keySet();
        RequestDto dto = new RequestDto();
        dto.setTenantId(Integer.valueOf(1));
        ResponseData responseData1 = this.queryStudioInfoList(dto);
        JSONArray data = JSONArray.parseArray((String)responseData1.getData().toString());
        block2: for (Object datum : data) {
            for (int i = 1; i > 0; ++i) {
                dto.setCurrent(Integer.valueOf(i));
                dto.setSize(Integer.valueOf(i * 100));
                String url = "https://server.etube365.com/csp/pass/proxy/api/patient/queryStudioPatientInfoPage";
                log.info("==============>\u5de5\u4f5c\u5ba4\u60a3\u8005\u5217\u8868\u5206\u9875----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
                String respStr = null;
                try {
                    respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                    log.info("=======>\u5de5\u4f5c\u5ba4\u60a3\u8005\u5217\u8868\u5206\u9875\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JSONObject respJson = JSON.parseObject((String)respStr);
                String msg = respJson.get((Object)"msg").toString();
                code = respJson.get((Object)"code").toString();
                boolean nextTag = false;
                if ("200".equals(code) && respJson.get((Object)"data") != null) {
                    String pageData = respJson.get((Object)"data").toString();
                    JSONObject paging = (JSONObject)respJson.get((Object)"paging");
                    nextTag = (Boolean)paging.get((Object)"nextTag");
                    JSONArray arr = JSONArray.parseArray((String)pageData);
                    for (Object o : arr) {
                        JSONObject jsonObj = (JSONObject)o;
                        String cardId = jsonObj.get((Object)"card_id").toString();
                        if (StringUtil.isBlank((String)cardId)) continue;
                        cardNoList.remove(cardId);
                    }
                }
                if (!nextTag) continue block2;
            }
        }
        OutExpertStudioRecordEntity outExpertStudioRecordEntity = new OutExpertStudioRecordEntity();
        outExpertStudioRecordEntity.setTenantId(tenantId);
        outExpertStudioRecordEntity.setDoctorId(Integer.valueOf(1));
        outExpertStudioRecordEntity.setStudioCode("ZJ-493");
        ArrayList<String> errorKey = new ArrayList<String>();
        for (String cardNo : cardNoList) {
            List<PatientEntity> list = cardNoMap.get(cardNo);
            if (!list.isEmpty()) continue;
            PatientEntity p = list.get(0);
            ResponseData responseData = this.pushStudioPatient(outExpertStudioRecordEntity);
            code = responseData.getCode();
            if ("200".equals(code)) continue;
            errorKey.add(cardNo);
        }
        cardNoList.removeAll(errorKey);
        String[] tagType = new String[]{"PATIENT_ONLINE_TAG", "OPERATION_TAG"};
        dto.setTenantId(tenantId);
        for (String cardNo : cardNoList) {
            List<PatientEntity> list = cardNoMap.get(cardNo);
            if (list.isEmpty()) continue;
            PatientEntity p = list.get(0);
            dto.setPatientId(p.getId());
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(1);
            status.add(99);
            List outPrescriptions = this.prescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutPrescription::getTenantId, (Object)tenantId)).eq(OutPrescription::getPatientId, (Object)p.getId())).in(OutPrescription::getPrescriptionStatus, status));
            for (OutPrescription outPrescription : outPrescriptions) {
                String prescriptionNo = outPrescription.getPrescriptionNo();
                if (StringUtil.isBlank((String)prescriptionNo)) continue;
                dto.setPrescriptionNo(prescriptionNo);
                for (String s : tagType) {
                    dto.setSourceType(s);
                    this.pushTag(dto);
                }
            }
        }
        return ResponseData.success();
    }

    public ResponseData test(RequestDto dto) {
        dto.setTenantId(Integer.valueOf(1));
        ResponseData responseData = this.queryStudioInfoList(dto);
        JSONArray data = JSONArray.parseArray((String)responseData.getData().toString());
        block0: for (Object datum : data) {
            JSONObject jsonObject = (JSONObject)datum;
            String studioCode = jsonObject.get((Object)"studioCode").toString();
            dto.setStudioCode(studioCode);
            if (studioCode.equals("ZJ-493")) continue;
            for (int i = 1; i > 0; ++i) {
                dto.setCurrent(Integer.valueOf(i));
                dto.setSize(Integer.valueOf(i * 100));
                ResponseData queryPatientRsp = this.queryStudioPatientInfoPage(dto);
                boolean nextTag = (Boolean)queryPatientRsp.getData();
                if (!nextTag) continue block0;
            }
        }
        return ResponseData.success();
    }

    public ResponseData pushTagInfo(RequestDto dto) {
        Integer flag = dto.getFlag();
        List contents = null;
        String remark = null;
        if (flag == 1) {
            contents = this.prescriptionDrugMapper.queryOutpatientDrugTag();
            remark = "\u7528\u836f\u6807\u7b7e";
        } else {
            List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutMedicalRecordDiagnosis::getTenantId, (Object)1)).isNotNull(OutMedicalRecordDiagnosis::getDiagnosis)).groupBy(OutMedicalRecordDiagnosis::getIcdCode));
            contents = outMedicalRecordDiagnoses.stream().map(itme -> {
                String diagnosis = itme.getDiagnosis();
                return diagnosis;
            }).collect(Collectors.toList());
            remark = "\u8bca\u65ad\u6807\u7b7e";
        }
        for (String content : contents) {
            dto.setTagName(content);
            dto.setRemark(remark);
            this.insertTagInfo(dto);
        }
        return ResponseData.success();
    }

    public ResponseData insertTagInfo(RequestDto dto) {
        dto.setHospitalCode("YY-111");
        dto.setStudioCode("ZJ-493");
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/insertTagInfo";
        log.info("==============>\u6807\u7b7e\u5e93-\u65b0\u589e\u6807\u7b7e\u57fa\u7840\u4fe1\u606f----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u6807\u7b7e\u5e93-\u65b0\u589e\u6807\u7b7e\u57fa\u7840\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        return ResponseData.success();
    }

    public ResponseData queryStudioPatientInfoPage(RequestDto dto) {
        String url = "https://server.etube365.com/csp/pass/proxy/api/patient/queryStudioPatientInfoPage";
        log.info("==============>\u5de5\u4f5c\u5ba4\u60a3\u8005\u5217\u8868\u5206\u9875----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u5de5\u4f5c\u5ba4\u60a3\u8005\u5217\u8868\u5206\u9875\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        String data = "";
        boolean nextTag = false;
        if ("200".equals(code) && respJson.get((Object)"data") != null) {
            data = respJson.get((Object)"data").toString();
            JSONObject paging = (JSONObject)respJson.get((Object)"paging");
            nextTag = (Boolean)paging.get((Object)"nextTag");
            JSONArray arr = JSONArray.parseArray((String)data);
            ArrayList<Object> insertList = new ArrayList<Object>();
            ArrayList<PatientEntity> updateList = new ArrayList<PatientEntity>();
            for (Object e : arr) {
                JSONObject jsonObj = (JSONObject)e;
                String mobilePhone = jsonObj.get((Object)"mobilePhone").toString();
                String userName = jsonObj.get((Object)"userName").toString();
                String cardId = jsonObj.get((Object)"card_id").toString();
                if (StringUtil.isBlank((String)cardId) || StringUtil.isBlank((String)mobilePhone) || StringUtil.isBlank((String)userName)) continue;
                PatientEntity patient = new PatientEntity();
                patient.setTenantId(dto.getTenantId());
                patient.setPhone(mobilePhone);
                patient.setName(userName);
                patient.setCardNo(cardId);
                List patientList = this.patientMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PatientEntity::getTenantId, (Object)patient.getTenantId())).eq(PatientEntity::getPhone, (Object)patient.getPhone())).eq(PatientEntity::getCardNo, (Object)patient.getCardNo())).eq(PatientEntity::getName, (Object)patient.getName()));
                if (patientList.size() == 0) {
                    String birthday;
                    String sex;
                    String idCard = jsonObj.get((Object)"idCard") == null ? "" : jsonObj.get((Object)"idCard").toString();
                    String string = sex = jsonObj.get((Object)"sex") == null ? "" : jsonObj.get((Object)"sex").toString();
                    if (sex.equals("0")) {
                        sex = "2";
                    }
                    String age = jsonObj.get((Object)"age") == null ? "" : jsonObj.get((Object)"age").toString();
                    String string2 = birthday = jsonObj.get((Object)"birthday") == null ? "" : jsonObj.get((Object)"birthday").toString();
                    if (StringUtil.isNotBlank((String)idCard)) {
                        patient.setCardNo(idCard);
                    }
                    if (StringUtil.isNotBlank((String)sex)) {
                        patient.setSex(sex);
                    }
                    if (StringUtil.isNotBlank((String)age)) {
                        patient.setAge(Integer.valueOf(Integer.parseInt(age)));
                    }
                    if (StringUtil.isNotBlank((String)birthday)) {
                        patient.setBirthday(birthday);
                    }
                    patient.setTenantId(Integer.valueOf(1));
                    patient.setRemark("\u533b\u597d\u5eb7\u540c\u6b65\u60a3\u8005");
                    patient.setEtubePushType(Integer.valueOf(1));
                    patient.setMedicalRecordNo(this.generateMedicalRecordNo(patient.getTenantId(), this.patientMapper.queryMaxMedicalNo(patient.getTenantId())));
                    patient.setNamePinyin(StringPinyinUtil.toFirstChar((String)patient.getName()));
                    int insert = this.patientMapper.insert((Object)patient);
                    insertList.add(patient);
                    continue;
                }
                PatientEntity patientEntity = (PatientEntity)patientList.get(0);
                updateList.add(patientEntity);
            }
            insertList.addAll(updateList);
            for (PatientEntity patientEntity : insertList) {
                patientEntity.setEtubePushType(Integer.valueOf(1));
                this.patientMapper.update((Object)patientEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(PatientEntity::getId, (Object)patientEntity.getId())).eq(PatientEntity::getTenantId, (Object)dto.getTenantId()));
                List list = this.outEtubePatientInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)patientEntity.getId())).eq(OutEtubePatientInfoEntity::getTenantId, (Object)dto.getTenantId()));
                OutEtubePatientInfoEntity etubePatient = new OutEtubePatientInfoEntity();
                etubePatient.setPatientId(patientEntity.getId());
                etubePatient.setTenantId(dto.getTenantId());
                etubePatient.setMobilePhone(patientEntity.getPhone());
                etubePatient.setUserName(patientEntity.getName());
                etubePatient.setAge(patientEntity.getAge());
                String sex = patientEntity.getSex();
                if (StringUtil.isNotBlank((String)sex) && "2".equals(sex)) {
                    sex = "0";
                }
                etubePatient.setSex(Integer.valueOf(Integer.parseInt(sex)));
                if (list.size() == 0) {
                    this.outEtubePatientInfoMapper.insert((Object)etubePatient);
                } else {
                    this.outEtubePatientInfoMapper.update((Object)etubePatient, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientInfoEntity::getTenantId, (Object)dto.getTenantId())).eq(OutEtubePatientInfoEntity::getPatientId, (Object)dto.getPatientId()));
                }
                OutEtubeStudioPatientEntity outEtubeStudioPatientEntity = new OutEtubeStudioPatientEntity();
                outEtubeStudioPatientEntity.setStudioCode(dto.getStudioCode());
                outEtubeStudioPatientEntity.setPatientId(patientEntity.getId());
                List studioPatientList = this.outEtubeStudioPatientMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)patientEntity.getId()));
                if (studioPatientList.size() == 0) {
                    this.outEtubeStudioPatientMapper.insert((Object)outEtubeStudioPatientEntity);
                    continue;
                }
                this.outEtubeStudioPatientMapper.update((Object)outEtubeStudioPatientEntity, (Wrapper)Wrappers.lambdaUpdate().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)patientEntity.getId()));
            }
        }
        return ResponseData.success((Object)nextTag);
    }

    private String generateMedicalRecordNo(Integer tenantId, String no) {
        Integer endNo = Objects.isNull(no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
        String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
        Integer suffix = tenantId + 1000000 + endNo;
        return currentDate + suffix;
    }

    public ResponseData pushTagNetwork(RequestDto dto) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String bizCode = null;
        Integer bizCodeFlag = dto.getBizCodeFlag();
        if (bizCodeFlag == 1) {
            bizCode = "PATIENT_ONLINE_TAG";
        } else if (bizCodeFlag == 2) {
            bizCode = "OPERATION_TAG";
        }
        if (StringUtil.isBlank((String)bizCode)) {
            return ResponseData.error((String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setHospitalCode("YY-111");
        dto.setStudioCode("ZJ-493");
        dto.setDataParent("sys");
        dto.setBizCode(bizCode);
        for (int i = 1; i > 0; ++i) {
            dto.setCurrent(Integer.valueOf(i));
            dto.setSize(Integer.valueOf(i * 100));
            ResponseData queryTagInfoRsp = this.getTagInfoPage(dto);
            JSONObject jsonObject = JSONObject.parseObject((String)queryTagInfoRsp.getData().toString());
            JSONArray dataList = JSONArray.parseArray((String)jsonObject.get((Object)"data").toString());
            for (int i1 = 0; i1 < dataList.size(); ++i1) {
                JSONObject data = JSONObject.parseObject((String)dataList.get(i1).toString());
                String createTime = data.get((Object)"createTime").toString();
                Date parse = format.parse(createTime);
                Date time = format.parse("2024-09-27");
                if (bizCode.equals("PATIENT_ONLINE_TAG") ? parse.getTime() >= time.getTime() : bizCode.equals("OPERATION_TAG") && parse.getTime() < time.getTime()) continue;
                String tagCode = data.get((Object)"tagCode").toString();
                dto.setTagCode(tagCode);
                this.insertTagNetwork(dto);
            }
            JSONObject paging = JSONObject.parseObject((String)jsonObject.get((Object)"paging").toString());
            boolean nextTag = (Boolean)paging.get((Object)"nextTag");
            if (!nextTag) break;
        }
        return null;
    }

    public ResponseData insertTagNetwork(RequestDto dto) {
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/insertTagNetwork";
        log.info("==============>\u6807\u7b7e\u7f51-\u65b0\u589e\u6807\u7b7e\u5173\u7cfb\u7f51----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u6807\u7b7e\u7f51-\u65b0\u589e\u6807\u7b7e\u5173\u7cfb\u7f51{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        return ResponseData.success((Object)respJson);
    }

    public ResponseData getTagInfoPage(RequestDto dto) {
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/getTagInfoPage";
        log.info("==============>\u6807\u7b7e\u5e93-\u67e5\u8be2\u5de5\u4f5c\u5ba4\u6807\u7b7e\u5217\u8868----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u6807\u7b7e\u5e93-\u67e5\u8be2\u5de5\u4f5c\u5ba4\u6807\u7b7e\u5217\u8868{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        return ResponseData.success((Object)respJson);
    }

    public ResponseData queryStudioInfoList(RequestDto dto) {
        dto.setHospitalCode("YY-111");
        String url = "https://server.etube365.com/csp/pass/proxy/api/studio/queryStudioInfoList";
        log.info("==============>\u673a\u6784\u7684\u5de5\u4f5c\u5ba4\u5217\u8868----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u673a\u6784\u7684\u5de5\u4f5c\u5ba4\u5217\u8868\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        return ResponseData.success((Object)data);
    }

    public ResponseData checkRecord() throws IOException {
        HashSet<String> patientNames = new HashSet<String>();
        File file = new File("F:\\\u533b\u4fdd\u79d1\\\u80bf\u7624\u60a3\u8005\u6863\u6848");
        if (file.isDirectory()) {
            for (File listFile : file.listFiles()) {
                if (!listFile.exists()) continue;
                for (File listedFile : listFile.listFiles()) {
                    if (!listedFile.exists()) continue;
                    String name = listedFile.getName();
                    patientNames.add(name);
                }
            }
        }
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        if (!patientNames.isEmpty()) {
            for (String name : patientNames) {
                Integer i = this.patientMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PatientEntity::getTenantId, (Object)1)).eq(PatientEntity::getName, (Object)name));
                if (i == 0) {
                    sb1.append("," + name);
                }
                if (i <= 1) continue;
                sb2.append("," + name);
            }
        }
        SysParamVo vo = new SysParamVo();
        vo.setName("patient");
        vo.setTenantId(Integer.valueOf(1));
        vo.setValue("\u6ca1\u6709\u7684\uff1a" + sb1.toString() + "\r\n----------\u91cd\u590d\u7684\uff1a" + sb2.toString());
        this.sysParamMapper.insert((Object)vo);
        return ResponseData.success(patientNames);
    }

    public ResponseData pushRecord() throws IOException {
        HashMap<Object, Object> patientRecords = new HashMap<Object, Object>();
        ArrayList<String> patients = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        boolean flag = true;
        String topFileName = "E:\\\u8179\u900f\u60a3\u8005\u6863\u6848";
        File file = new File(topFileName);
        HashMap patientFileName = new HashMap();
        String[] surnames = new String[]{"\u4e07\u4fdf", "\u53f8\u9a6c", "\u4e0a\u5b98", "\u6b27\u9633", "\u590f\u4faf", "\u8bf8\u845b", "\u95fb\u4eba", "\u4e1c\u65b9", "\u8d6b\u8fde", "\u7687\u752b", "\u5c09\u8fdf", "\u516c\u7f8a", "\u6fb9\u53f0", "\u516c\u51b6", "\u5b97\u653f", "\u6fee\u9633", "\u6df3\u4e8e", "\u5355\u4e8e", "\u592a\u53d4", "\u7533\u5c60", "\u516c\u5b59", "\u4ef2\u5b59", "\u8f69\u8f95", "\u4ee4\u72d0", "\u949f\u79bb", "\u5b87\u6587", "\u957f\u5b59", "\u6155\u5bb9", "\u53f8\u5f92", "\u53f8\u7a7a", "\u738b\u5b59", "\u53d4\u5b59", "\u516c\u660e", "\u8c37\u6881", "\u7aef\u6728", "\u58e4\u9a77", "\u7f8a\u820c", "\u5b50\u6851", "\u4e3b\u7236", "\u9ad8\u5802", "\u6bb5\u5e72", "\u516c\u826f", "\u53f8\u5bc7", "\u547c\u5ef6", "\u4e94\u9e7f", "\u76f8\u91cc", "\u4e5d\u65b9", "\u65b0\u57a3", "\u7528\u91cc", "\u5c60\u5cb8", "\u72ec\u5b64", "\u5c11\u6b63", "\u5b89\u90b1", "\u9ad8\u9633", "\u4e93\u5b98", "\u6bcb\u90b1", "\u5fae\u751f", "\u53d4\u6881", "\u8fbe\u9c81", "\u8fbe\u595a", "\u5bb0\u7236", "\u5deb\u9a6c", "\u5de6\u90b1", "\u4e50\u6b63", "\u989b\u5b59", "\u80e1\u6bcd", "\u6f06\u96d5", "\u7b2c\u4e94", "\u5317\u5bab", "\u767e\u91cc", "\u53f8\u57ce", "\u5b50\u670d", "\u5b8c\u989c", "\u58eb\u5b59", "\u6c88\u72b9", "\u63d0\u5f25", "\u53f3\u5e08", "\u5b50\u5bb6", "\u4ec6\u56fa", "\u5e08\u5ef6", "\u4ef2\u957f", "\u6a17\u91cc", "\u96cd\u95e8", "\u5357\u90ed", "\u54b8\u90b1", "\u884c\u4eba", "\u5c4b\u5e90", "\u76c6\u6210", "\u4e1c\u95e8", "\u897f\u95e8", "\u5317\u95e8", "\u62d3\u8dcb", "\u5939\u8c37", "\u6881\u90b1", "\u9c9c\u4e8e", "\u8d3a\u5170", "\u5c48\u7a81", "\u606f\u592b", "\u54e5\u8212", "\u5b89\u671f", "\u53e4\u51b6", "\u5357\u5bab", "\u4e2d\u884c", "\u95fe\u90b1", "\u5b50\u8f66", "\u8a00\u798f", "\u4e1c\u5173", "\u4e1c\u90ed", "\u4e1c\u4e61", "\u4e1c\u5bab", "\u4e1c\u9633", "\u4e1c\u91ce", "\u4e1c\u9601", "\u516c\u8f93", "\u516c\u897f", "\u516c\u4eea", "\u516c\u5c71", "\u516c\u58eb", "\u516c\u4f2f", "\u516c\u7956", "\u516c\u4ef2", "\u516c\u65cf", "\u516c\u5bbe", "\u516c\u7eea", "\u516c\u6cb3", "\u516c\u738b", "\u516c\u53d4", "\u516c\u5b5f", "\u516c\u660e", "\u516c\u6662", "\u516c\u5b50", "\u516c\u4e58", "\u516c\u6237", "\u516c\u9f50", "\u516c\u90fd", "\u516c\u6298", "\u516c\u65c5", "\u516c\u65d7", "\u516c\u4e4b", "\u516c\u5deb", "\u516c\u6587", "\u516c\u5efa", "\u9022\u95e8", "\u5f13\u91cc", "\u9f99\u90b1", "\u5bb9\u57ce", "\u753e\u90b1", "\u53f8\u9e3f", "\u5e08\u5b9c", "\u7da6\u6bcd", "\u7da6\u8fde", "\u4f0a\u5a04", "\u800f\u95e8", "\u543e\u4ed5", "\u865e\u90b1", "\u6bcb\u5c06", "\u58f6\u90b1", "\u80e1\u975e", "\u8c46\u5362", "\u84b2\u5362", "\u59d1\u5e03", "\u897f\u4e61", "\u897f\u65b9", "\u595a\u5bb9", "\u7533\u5f92", "\u7533\u516c", "\u771f\u90ed", "\u5b59\u9633", "\u90af\u90f8", "\u5b89\u90b1", "\u5b89\u56fd", "\u5ef6\u9675", "\u5eea\u90b1", "\u66f9\u90b1", "\u9676\u90b1", "\u7455\u90b1", "\u5546\u90b1", "\u5c06\u5de8", "\u5c06\u95fe", "\u9633\u6210", "\u68e0\u6eaa", "\u7ae0\u4ec7", "\u7f8a\u89d2", "\u4eac\u76f8", "\u6210\u516c", "\u9752\u53f2", "\u9752\u4e4c", "\u6d6e\u90b1", "\u6d6e\u5c60", "\u52fe\u9f99", "\u7531\u543e", "\u6797\u95fe", "\u5357\u516c", "\u5b50\u5dde", "\u4e8e\u4f2f", "\u6c34\u90b1", "\u5c14\u6731", "\u5de6\u4eba", "\u53e4\u91ce", "\u5bb0\u6c0f", "\u5c39\u6587", "\u8001\u6210", "\u8001\u5546", "\u8001\u83b1", "\u4ef2\u957f", "\u5f85\u5176", "\u5e93\u72c4", "\u52a1\u6210", "\u6b65\u53d4", "\u5085\u4f59", "\u7b2c\u4e8c", "\u95ed\u73ca", "\u5951\u82fe", "\u592a\u53f2", "\u4fe1\u90fd", "\u6d69\u661f", "\u8d3a\u82e5", "\u8d3a\u5a04", "\u8d3a\u62d4", "\u6d1e\u6c90", "\u5320\u4e3d", "\u4e0a\u65b9", "\u5317\u4eba", "\u5317\u5510", "\u659b\u5f8b", "\u659b\u65af", "\u8c37\u90a3", "\u79c3\u53d1", "\u8d64\u5c06", "\u5ba4\u4e2d", "\u4e59\u5f17", "\u5c48\u4faf", "\u4e5e\u4f0f", "\u959f\u95e8", "\u5217\u5fa1", "\u6d1b\u4e0b", "\u7d22\u7f57", "\u970d\u91cc", "\u77f3\u4f5c", "\u77f3\u6237", "\u4f2f\u6210", "\u67cf\u4faf", "\u9ed1\u9f7f", "\u58a8\u80ce", "\u6267\u5931", "\u7fc1\u627f", "\u7ff0\u516c", "\u5b63\u878d", "\u4ef2\u718a", "\u5df4\u516c", "\u6f5c\u9f99", "\u5173\u9f99", "\u5217\u5b97", "\u95fe\u8475", "\u4f8d\u5176", "\u67f7\u5176", "\u9e20\u5937", "\u76ee\u5937", "\u56f4\u9f9f", "\u53f2\u9f9f", "\u6298\u9f9f", "\u4fdf\u5206", "\u8354\u975e", "\u53f3\u5f52", "\u4fee\u9c7c", "\u6cae\u6e20", "\u8f9c\u7528", "\u4fe1\u90fd", "\u5bc6\u5982", "\u590d\u84b2", "\u738b\u592b", "\u7978\u4f59", "\u6c93\u5362", "\u5802\u6eaa", "\u4f59\u63a8", "\u9648\u54c0", "\u826f\u81e3", "\u5143\u94a7", "\u4e09\u4f09", "\u4f2f\u660f", "\u5f92\u5355", "\u5b50\u4e8e", "\u5b50\u5e9a", "\u8d8a\u6912", "\u6597\u5f3a", "\u9c81\u9633", "\u5bfb\u6881", "\u5f3a\u6881", "\u4e30\u5c06", "\u8d64\u5f20", "\u82d1\u7f8a", "\u79e3\u9675", "\u83df\u88d8", "\u4e1c\u697c", "\u9091\u7531", "\u9488\u5deb", "\u6c88\u7038", "\u8d75", "\u94b1", "\u5b59", "\u674e", "\u5468", "\u5434", "\u90d1", "\u738b", "\u51af", "\u9648", "\u891a", "\u536b", "\u848b", "\u6c88", "\u97e9", "\u6768", "\u6731", "\u79e6", "\u5c24", "\u8bb8", "\u4f55", "\u5415", "\u65bd", "\u5f20", "\u5b54", "\u66f9", "\u4e25", "\u534e", "\u91d1", "\u9b4f", "\u9676", "\u59dc", "\u621a", "\u8c22", "\u90b9", "\u55bb", "\u67cf", "\u6c34", "\u7aa6", "\u7ae0", "\u4e91", "\u82cf", "\u6f58", "\u845b", "\u595a", "\u8303", "\u5f6d", "\u90ce", "\u9c81", "\u97e6", "\u660c", "\u9a6c", "\u82d7", "\u51e4", "\u82b1", "\u65b9", "\u4fde", "\u4efb", "\u8881", "\u67f3", "\u9146", "\u9c8d", "\u53f2", "\u5510", "\u8d39", "\u5ec9", "\u5c91", "\u859b", "\u96f7", "\u8d3a", "\u502a", "\u6c64", "\u6ed5", "\u6bb7", "\u7f57", "\u6bd5", "\u90dd", "\u90ac", "\u5b89", "\u5e38", "\u4e50", "\u4e8e", "\u65f6", "\u5085", "\u76ae", "\u535e", "\u9f50", "\u5eb7", "\u4f0d", "\u4f59", "\u5143", "\u535c", "\u987e", "\u5b5f", "\u5e73", "\u9ec4", "\u548c", "\u7a46", "\u8427", "\u5c39", "\u59da", "\u90b5", "\u6e5b", "\u6c6a", "\u7941", "\u6bdb", "\u79b9", "\u72c4", "\u7c73", "\u8d1d", "\u660e", "\u81e7", "\u8ba1", "\u4f0f", "\u6210", "\u6234", "\u8c08", "\u5b8b", "\u8305", "\u5e9e", "\u718a", "\u7eaa", "\u8212", "\u5c48", "\u9879", "\u795d", "\u8463", "\u6881", "\u675c", "\u962e", "\u84dd", "\u95f5", "\u5e2d", "\u5b63", "\u9ebb", "\u5f3a", "\u8d3e", "\u8def", "\u5a04", "\u5371", "\u6c5f", "\u7ae5", "\u989c", "\u90ed", "\u6885", "\u76db", "\u6797", "\u5201", "\u949f", "\u5f90", "\u90b1", "\u9a86", "\u9ad8", "\u590f", "\u8521", "\u7530", "\u6a0a", "\u80e1", "\u51cc", "\u970d", "\u865e", "\u4e07", "\u652f", "\u67ef", "\u661d", "\u7ba1", "\u5362", "\u83ab", "\u7ecf", "\u623f", "\u88d8", "\u7f2a", "\u5e72", "\u89e3", "\u5e94", "\u5b97", "\u4e01", "\u5ba3", "\u8d32", "\u9093", "\u90c1", "\u5355", "\u676d", "\u6d2a", "\u5305", "\u8bf8", "\u5de6", "\u77f3", "\u5d14", "\u5409", "\u94ae", "\u9f9a", "\u7a0b", "\u5d47", "\u90a2", "\u6ed1", "\u88f4", "\u9646", "\u8363", "\u7fc1", "\u8340", "\u7f8a", "\u65bc", "\u60e0", "\u7504", "\u66f2", "\u5bb6", "\u5c01", "\u82ae", "\u7fbf", "\u50a8", "\u9773", "\u6c72", "\u90b4", "\u7cdc", "\u677e", "\u4e95", "\u6bb5", "\u5bcc", "\u5deb", "\u4e4c", "\u7126", "\u5df4", "\u5f13", "\u7267", "\u9697", "\u5c71", "\u8c37", "\u8f66", "\u4faf", "\u5b93", "\u84ec", "\u5168", "\u90d7", "\u73ed", "\u4ef0", "\u79cb", "\u4ef2", "\u4f0a", "\u5bab", "\u5b81", "\u4ec7", "\u683e", "\u66b4", "\u7518", "\u94ad", "\u5389", "\u620e", "\u7956", "\u6b66", "\u7b26", "\u5218", "\u666f", "\u8a79", "\u675f", "\u9f99", "\u53f6", "\u5e78", "\u53f8", "\u97f6", "\u90dc", "\u9ece", "\u84df", "\u8584", "\u5370", "\u5bbf", "\u767d", "\u6000", "\u84b2", "\u53f0", "\u4ece", "\u9102", "\u7d22", "\u54b8", "\u7c4d", "\u8d56", "\u5353", "\u853a", "\u5c60", "\u8499", "\u6c60", "\u4e54", "\u9634", "\u90c1", "\u80e5", "\u80fd", "\u82cd", "\u53cc", "\u95fb", "\u8398", "\u515a", "\u7fdf", "\u8c2d", "\u8d21", "\u52b3", "\u9004", "\u59ec", "\u7533", "\u6276", "\u5835", "\u5189", "\u5bb0", "\u90e6", "\u96cd", "\u5374", "\u74a9", "\u6851", "\u6842", "\u6fee", "\u725b", "\u5bff", "\u901a", "\u8fb9", "\u6248", "\u71d5", "\u5180", "\u90cf", "\u6d66", "\u5c1a", "\u519c", "\u6e29", "\u522b", "\u5e84", "\u664f", "\u67f4", "\u77bf", "\u960e", "\u5145", "\u6155", "\u8fde", "\u8339", "\u4e60", "\u5ba6", "\u827e", "\u9c7c", "\u5bb9", "\u5411", "\u53e4", "\u6613", "\u614e", "\u6208", "\u5ed6", "\u5e9a", "\u7ec8", "\u66a8", "\u5c45", "\u8861", "\u6b65", "\u90fd", "\u803f", "\u6ee1", "\u5f18", "\u5321", "\u56fd", "\u6587", "\u5bc7", "\u5e7f", "\u7984", "\u9619", "\u4e1c", "\u6bb4", "\u6bb3", "\u6c83", "\u5229", "\u851a", "\u8d8a", "\u5914", "\u9686", "\u5e08", "\u5de9", "\u538d", "\u8042", "\u6641", "\u52fe", "\u6556", "\u878d", "\u51b7", "\u8a3e", "\u8f9b", "\u961a", "\u90a3", "\u7b80", "\u9976", "\u7a7a", "\u66fe", "\u6bcb", "\u6c99", "\u4e5c", "\u517b", "\u97a0", "\u987b", "\u4e30", "\u5de2", "\u5173", "\u84af", "\u76f8", "\u67e5", "\u540e", "\u8346", "\u7ea2", "\u6e38", "\u7afa", "\u6743", "\u902f", "\u76d6", "\u76ca", "\u6853", "\u516c"};
        if (topFileName.contains("\u8179\u900f")) {
            if (file.isDirectory()) {
                block11: for (File listedFile : file.listFiles()) {
                    if (!listedFile.exists() || !listedFile.exists()) continue;
                    File[] name = listedFile.getName();
                    String string = name.replaceAll("\u767e\u7279", "").replaceAll("\u5a01\u9ad8", "").replaceAll("\u8d39\u68ee", "");
                    for (String surname : surnames) {
                        String checkName;
                        String patientName;
                        block45: {
                            int i = string.indexOf(surname);
                            if (i == -1) continue;
                            patientName = "";
                            try {
                                try {
                                    if (surname.length() == 1) {
                                        patientName = string.substring(i, i + 3);
                                    } else if (surname.length() == 2) {
                                        patientName = string.substring(i, i + 4);
                                    }
                                }
                                catch (Exception e) {
                                    if (surname.length() == 1) {
                                        patientName = string.substring(i, i + 2);
                                        break block45;
                                    }
                                    if (surname.length() != 2) break block45;
                                    patientName = string.substring(i, i + 3);
                                }
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if ((checkName = patientName.replaceAll(" ", "").replaceAll("-", "").replaceAll("1", "").replaceAll("2", "").replaceAll("3", "").replaceAll("4", "").replaceAll("5", "").replaceAll("6", "").replaceAll("7", "").replaceAll("8", "").replaceAll("9", "").replaceAll("0", "").replaceAll("\\.", "").replaceAll("\uff08", "").replaceAll("\uff09", "").replaceAll("\\(", "").replaceAll("\\)", "")).length() == 1) continue;
                        Map<Object, ArrayList<String>> stringListMap = new HashMap();
                        if (patientFileName.containsKey(checkName)) {
                            stringListMap = (Map)patientFileName.get(checkName);
                        }
                        ArrayList<String> records = new ArrayList<String>();
                        if (!listedFile.isDirectory()) continue;
                        for (File record : listedFile.listFiles()) {
                            String[] split;
                            String s;
                            if (!record.exists() || !(s = (split = record.getName().split("\\."))[split.length - 1]).equals("pdf") && !s.equals("png") && !s.equals("jpg")) continue;
                            String absolutePath = record.getAbsolutePath();
                            records.add(absolutePath);
                        }
                        stringListMap.put(name, records);
                        patientFileName.put(checkName, stringListMap);
                        patientRecords.put(name, records);
                        System.out.println((String)name);
                        continue block11;
                    }
                }
            }
        } else if (topFileName.contains("\u80bf\u7624") && file.isDirectory()) {
            for (File listFile : file.listFiles()) {
                if (!listFile.exists()) continue;
                for (File listedFile : listFile.listFiles()) {
                    if (!listedFile.exists()) continue;
                    String name = listedFile.getName();
                    if (patientRecords.containsKey(name)) {
                        patients.add(name);
                    }
                    Iterator<String> records = new ArrayList();
                    if (!listedFile.isDirectory()) continue;
                    for (File record : listedFile.listFiles()) {
                        String[] split;
                        String s;
                        if (!record.exists() || !(s = (split = record.getName().split("\\."))[split.length - 1]).equals("pdf") && !s.equals("png") && !s.equals("jpg")) continue;
                        String absolutePath = record.getAbsolutePath();
                        records.add(absolutePath);
                    }
                    patientRecords.put(name, records);
                    System.out.println(name);
                }
            }
        }
        Set<Object> keys = new HashSet();
        if (patientFileName.size() > 0) {
            keys = patientFileName.keySet();
        } else {
            keys = patientRecords.keySet();
            keys.removeAll(patients);
        }
        List patientList = this.patientMapper.patientNameDuplicateRemoval(keys);
        Map<String, List<PatientEntity>> collect = patientList.stream().collect(Collectors.groupingBy(PatientEntity::getName));
        int count = 1;
        for (String string : collect.keySet()) {
            if (flag) {
                if (!string.equals("\u9648\u56fd\u658c")) continue;
                flag = false;
                continue;
            }
            ArrayList<MultipartFile> arrayList = new ArrayList<MultipartFile>();
            if (patientFileName.size() > 1) {
                Object checkKey = "";
                int checkSize = 0;
                for (String s : ((Map)patientFileName.get(string)).keySet()) {
                    List strings = (List)((Map)patientFileName.get(string)).get(s);
                    if (strings.size() <= checkSize) continue;
                    checkKey = s;
                    checkSize = strings.size();
                }
                if (checkSize > 0) {
                    for (String s : (List)((Map)patientFileName.get(string)).get(checkKey)) {
                        MultipartFile mulFileByPath = this.getMulFileByPath(s);
                        arrayList.add(mulFileByPath);
                    }
                }
            } else {
                for (String s : (List)patientRecords.get(string)) {
                    MultipartFile mulFileByPath = this.getMulFileByPath(s);
                    arrayList.add(mulFileByPath);
                }
            }
            if (arrayList.size() == 0) continue;
            System.out.println("\u4e0a\u4f20\u60a3\u8005\uff1a" + string);
            System.out.println("\u5e8f\u53f7\uff1a" + count);
            ++count;
            MultipartFile[] filesArray = arrayList.toArray(new MultipartFile[arrayList.size()]);
            Map map = OSSClientUtil.fileUploads((MultipartFile[])filesArray, (String)"cdn2019");
            if (map.isEmpty()) continue;
            List<PatientEntity> patientEntityList = collect.get(string);
            if (patientEntityList == null || patientEntityList.isEmpty()) {
                patients.add(string);
                continue;
            }
            PatientEntity patient = patientEntityList.get(0);
            List archivalRecordsEntities = this.archivalRecordsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalRecordsEntity::getVisitingHospital, (Object)"\u8179\u900f\u7cfb\u7edf\u81ea\u52a8\u5bfc\u5165")).eq(ArchivalRecordsEntity::getTenantId, (Object)1)).eq(ArchivalRecordsEntity::getPatientId, (Object)patient.getId()));
            ArchivalRecordsEntity archivalRecords = new ArchivalRecordsEntity();
            if (archivalRecordsEntities.isEmpty()) {
                archivalRecords.setTenantId(Integer.valueOf(1));
                archivalRecords.setPatientId(patient.getId());
                archivalRecords.setDiagnosis(patient.getChronicDisease());
                archivalRecords.setVisitingHospital("\u8179\u900f\u7cfb\u7edf\u81ea\u52a8\u5bfc\u5165");
                archivalRecords.setVisitingTime(format.format(new Date()));
                this.archivalRecordsMapper.insert((Object)archivalRecords);
            } else {
                archivalRecords = (ArchivalRecordsEntity)archivalRecordsEntities.get(0);
            }
            Integer typeId = 0;
            List queryType = this.archivalFileTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ArchivalFileTypeEntity::getTenantId, (Object)1)).eq(ArchivalFileTypeEntity::getArchivalRecordsId, (Object)archivalRecords.getId())).eq(ArchivalFileTypeEntity::getTypeName, (Object)"\u5176\u4ed6"));
            ArchivalFileTypeEntity typeEntity = new ArchivalFileTypeEntity();
            if (queryType.isEmpty()) {
                typeEntity.setArchivalRecordsId(Integer.valueOf(Integer.parseInt(archivalRecords.getId().toString())));
                typeEntity.setCreateTime(format.format(new Date()));
                typeEntity.setSort(Integer.valueOf(0));
                typeEntity.setTenantId(Integer.valueOf(1));
                for (int i = 0; i < 5; ++i) {
                    String typeName = "";
                    switch (i) {
                        case 0: {
                            typeName = "\u75c5\u4f8b";
                            break;
                        }
                        case 1: {
                            typeName = "\u51fa\u9662\u5c0f\u7ed3";
                            break;
                        }
                        case 2: {
                            typeName = "\u5904\u65b9";
                            break;
                        }
                        case 3: {
                            typeName = "\u68c0\u67e5\u68c0\u9a8c";
                            break;
                        }
                        case 4: {
                            typeName = "\u5176\u4ed6";
                        }
                    }
                    typeEntity.setTypeName(typeName);
                    this.archivalFileTypeMapper.insert((Object)typeEntity);
                    if (!typeName.equals("\u5176\u4ed6")) continue;
                    typeId = Integer.parseInt(typeEntity.getId().toString());
                }
            } else {
                typeEntity = (ArchivalFileTypeEntity)queryType.get(0);
                typeId = Integer.parseInt(typeEntity.getId().toString());
            }
            String[] urlArr = map.get("fileUrl").toString().split(",");
            String[] nameArr = map.get("name").toString().split(",");
            for (int i = 0; i < urlArr.length; ++i) {
                String fileUrl = urlArr[i];
                ArchivalFileEntity fileEntity = new ArchivalFileEntity();
                fileEntity.setFileTypeId(typeId);
                fileEntity.setSort("0");
                fileEntity.setIsDel("0");
                fileEntity.setName(nameArr[i]);
                fileEntity.setUrl(fileUrl);
                fileEntity.setTenantId(Integer.valueOf(1));
                fileEntity.setCreateTime(format.format(new Date()));
                this.archivalFileMapper.insert((Object)fileEntity);
            }
        }
        keys.removeAll(collect.keySet());
        StringBuffer sb = new StringBuffer();
        for (String string : keys) {
            sb.append(string + ",");
        }
        SysParamVo sysParamVo = new SysParamVo();
        sysParamVo.setName("patient");
        sysParamVo.setTenantId(Integer.valueOf(1));
        sysParamVo.setValue(sb.toString());
        this.sysParamMapper.insert((Object)sysParamVo);
        return ResponseData.success(keys);
    }

    private MultipartFile getMulFileByPath(String filePath) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "textField";
        int num = filePath.lastIndexOf(".");
        String extFile = filePath.substring(num);
        File newfile = new File(filePath);
        String name = newfile.getName();
        String s = name.split("\\.")[0];
        FileItem item = factory.createItem(textFieldName, "image/png", true, s + extFile);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(newfile);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CommonsMultipartFile mfile = new CommonsMultipartFile(item);
        return mfile;
    }

    public ResponseData pushStudioPatient(OutExpertStudioRecordEntity entity) {
        OutEtubeStudioDoctorEntity studioInfo = this.outExpertStudioRecordMapper.queryStudioDoctor(entity);
        if (studioInfo == null) {
            studioInfo = new OutEtubeStudioDoctorEntity();
        }
        if (StringUtil.isNotBlank((String)entity.getStudioCode())) {
            studioInfo.setStudioCode(entity.getStudioCode());
        } else {
            studioInfo.setStudioCode("ZJ-493");
        }
        studioInfo.setHospitalCode("YY-111");
        OutEtubePatientInfoEntity patientInfo = this.outExpertStudioRecordMapper.queryPatientInfo(entity);
        String userName = patientInfo.getUserName();
        String mobilePhone = patientInfo.getMobilePhone();
        ExceptionUtils.createException((Logger)log, (StringUtil.isBlank((String)userName) || StringUtil.isBlank((String)mobilePhone) ? 1 : 0) != 0, (String)"\u8bf7\u5b8c\u5584\u60a3\u8005\u59d3\u540d\uff0c\u624b\u673a\u53f7");
        List isEmpty = this.outEtubeStudioPatientMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getStudioCode, (Object)studioInfo.getStudioCode())).eq(OutEtubeStudioPatientEntity::getPatientId, (Object)patientInfo.getPatientId()));
        ExceptionUtils.createException((Logger)log, (isEmpty.size() > 0 ? 1 : 0) != 0, (String)"500", (String)"\u8be5\u60a3\u8005\u5df2\u7ecf\u52a0\u5165\u8be5\u5de5\u4f5c\u5ba4\uff0c\u65e0\u9700\u63a8\u9001");
        String timeStr = this.fmt.format(new Date());
        ExpertStudioDto dto = new ExpertStudioDto();
        dto.setStudioInfo(studioInfo);
        dto.setPatientInfo(patientInfo);
        String url = "https://server.etube365.com/csp/pass/proxy/api/patient/insertStudioPatientOnline";
        log.info("==============>\u60a3\u8005\u52a0\u5165\u4e13\u5bb6\u5de5\u4f5c\u5ba4----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
        Object respStr = null;
        entity.setCreateTime(timeStr);
        entity.setUrl(url);
        entity.setParam(JSON.toJSONString((Object)dto));
        PatientEntity patientEntity = new PatientEntity();
        patientEntity.setEtubePushType(Integer.valueOf(1));
        this.patientMapper.update((Object)patientEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(PatientEntity::getId, (Object)entity.getPatientId())).eq(PatientEntity::getTenantId, (Object)entity.getTenantId()));
        patientInfo.setPatientId(entity.getPatientId());
        patientInfo.setTenantId(entity.getTenantId());
        patientInfo.setPatientCode(entity.getData());
        patientInfo.setReqRecord(entity.getId() + "");
        patientInfo.setCreateTime(timeStr);
        int insert1 = this.outEtubePatientInfoMapper.insert((Object)patientInfo);
        studioInfo.setTenantId(entity.getTenantId());
        studioInfo.setInviteCode(studioInfo.getDoctorCode());
        studioInfo.setUserId(entity.getDoctorId());
        studioInfo.setReqRecord(entity.getId() + "");
        OutEtubePatientDossierEntity dossier = new OutEtubePatientDossierEntity();
        dossier.setPatientId(entity.getPatientId());
        List outEtubePatientDossierEntities = this.outEtubePatientDossierMapper.queryRequiredByPatientId(dossier);
        if (outEtubePatientDossierEntities.size() > 0) {
            OutEtubePatientDossierEntity item = (OutEtubePatientDossierEntity)outEtubePatientDossierEntities.get(0);
            item.setInviteCode(studioInfo.getDoctorCode());
            item.setStudioCode(studioInfo.getStudioCode());
            item.setPatientCode(patientInfo.getPatientCode());
            this.updatePatientDossier2(item);
        }
        return ResponseData.success();
    }

    public ResponseData pushStudioPatients(OutExpertStudioRecordEntity entity) {
        OutEtubeStudioDoctorEntity studioInfo = this.outExpertStudioRecordMapper.queryStudioDoctor(entity);
        List patientInfoList = this.outExpertStudioRecordMapper.queryPatientInfos(entity);
        List patientIds = entity.getPatientIds();
        List isEmpty = this.outEtubeStudioPatientMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getStudioCode, (Object)studioInfo.getStudioCode())).in(OutEtubeStudioPatientEntity::getPatientId, (Collection)patientIds));
        isEmpty.forEach(item -> {
            Integer patientId = item.getPatientId();
            if (patientIds.contains(patientId)) {
                patientIds.remove(patientIds.indexOf(patientId));
            }
        });
        ExceptionUtils.createException((Logger)log, (patientIds.size() == 0 ? 1 : 0) != 0, (String)"500", (String)"\u6240\u6709\u60a3\u8005\u90fd\u5df2\u63a8\u9001\u4e86\u8be5\u5de5\u4f5c\u5ba4");
        String timeStr = this.fmt.format(new Date());
        patientInfoList.forEach(patientInfo -> {
            Integer patientId = patientInfo.getPatientId();
            if (patientIds.contains(patientId)) {
                ExpertStudioDto dto = new ExpertStudioDto();
                dto.setStudioInfo(studioInfo);
                dto.setPatientInfo(patientInfo);
                String url = "https://server.etube365.com/csp/pass/proxy/api/patient/insertStudioPatientOnline";
                log.info("==============>\u60a3\u8005\u52a0\u5165\u4e13\u5bb6\u5de5\u4f5c\u5ba4----------->url={},\u53c2\u6570={}", (Object)url, (Object)dto);
                String respStr = null;
                try {
                    respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                    log.info("=======>\u60a3\u8005\u52a0\u5165\u4e13\u5bb6\u5de5\u4f5c\u5ba4\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JSONObject respJson = JSON.parseObject((String)respStr);
                String msg = respJson.get((Object)"msg").toString();
                String code = respJson.get((Object)"code").toString();
                String data = "";
                if ("200".equals(code)) {
                    data = respJson.get((Object)"data").toString();
                }
                entity.setCreateTime(timeStr);
                entity.setUrl(url);
                entity.setParam(JSON.toJSONString((Object)dto));
                entity.setMsg(msg);
                entity.setCode(code);
                entity.setData(data);
                int insert = this.outExpertStudioRecordMapper.insert((Object)entity);
                if (code.equals("200")) {
                    PatientEntity patientEntity = new PatientEntity();
                    patientEntity.setEtubePushType(Integer.valueOf(1));
                    this.patientMapper.update((Object)patientEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(PatientEntity::getId, (Object)entity.getPatientId())).eq(PatientEntity::getTenantId, (Object)entity.getTenantId()));
                    patientInfo.setPatientId(entity.getPatientId());
                    patientInfo.setTenantId(entity.getTenantId());
                    patientInfo.setPatientCode(entity.getData());
                    patientInfo.setReqRecord(entity.getId() + "");
                    patientInfo.setCreateTime(timeStr);
                    int insert1 = this.outEtubePatientInfoMapper.insert(patientInfo);
                    studioInfo.setTenantId(entity.getTenantId());
                    studioInfo.setInviteCode(studioInfo.getDoctorCode());
                    studioInfo.setUserId(entity.getDoctorId());
                    studioInfo.setReqRecord(entity.getId() + "");
                    OutEtubeStudioPatientEntity outEtubeStudioPatientEntity = new OutEtubeStudioPatientEntity();
                    outEtubeStudioPatientEntity.setStudioCode(studioInfo.getStudioCode());
                    outEtubeStudioPatientEntity.setPatientId(patientInfo.getPatientId());
                    this.outEtubeStudioPatientMapper.insert((Object)outEtubeStudioPatientEntity);
                    OutEtubePatientDossierEntity dossier = new OutEtubePatientDossierEntity();
                    dossier.setPatientId(entity.getPatientId());
                    List outEtubePatientDossierEntities = this.outEtubePatientDossierMapper.queryRequiredByPatientId(dossier);
                    if (outEtubePatientDossierEntities.size() > 0) {
                        OutEtubePatientDossierEntity item = (OutEtubePatientDossierEntity)outEtubePatientDossierEntities.get(0);
                        item.setInviteCode(studioInfo.getDoctorCode());
                        item.setStudioCode(studioInfo.getStudioCode());
                        item.setPatientCode(patientInfo.getPatientCode());
                        this.updatePatientDossier(item);
                    }
                }
            }
        });
        return ResponseData.success();
    }

    public ResponseData queryPatient(OutEtubePatientInfoEntity entity) {
        HashMap<String, String> param = new HashMap<String, String>();
        String patientCode = entity.getPatientCode();
        param.put("patientCode", patientCode);
        String url = "https://server.etube365.com/csp/pass/proxy/api/patient/queryPatientBasicInfo";
        String respStr = null;
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u60a3\u8005\u57fa\u672c\u4fe1\u606f\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String msg = respJson.get((Object)"msg").toString();
        String code = respJson.get((Object)"code").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        OutExpertStudioRecordEntity outExpertStudioRecordEntity = new OutExpertStudioRecordEntity();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        outExpertStudioRecordEntity.setCreateTime(format.format(new Date()));
        outExpertStudioRecordEntity.setUrl(url);
        outExpertStudioRecordEntity.setParam(JSON.toJSONString(param));
        outExpertStudioRecordEntity.setMsg(msg);
        outExpertStudioRecordEntity.setCode(code);
        outExpertStudioRecordEntity.setData(data);
        outExpertStudioRecordEntity.setTenantId(entity.getTenantId());
        int insert = this.outExpertStudioRecordMapper.insert((Object)outExpertStudioRecordEntity);
        if ("200".equals(code)) {
            JSONObject jsonObject = JSON.parseObject((String)data);
            String mobilePhone = jsonObject.get((Object)"mobilePhone").toString();
            String userName = jsonObject.get((Object)"userName").toString();
            String avatarUrl = jsonObject.get((Object)"avatarUrl").toString();
            String idCard = jsonObject.get((Object)"idCard").toString();
            String sex = jsonObject.get((Object)"sex").toString();
            String age = jsonObject.get((Object)"age").toString();
            String birthday = jsonObject.get((Object)"birthday").toString();
            entity.setMobilePhone(mobilePhone);
            entity.setUserName(userName);
            entity.setAvatarUrl(avatarUrl);
            entity.setIdCard(idCard);
            entity.setSex(Integer.valueOf(Integer.parseInt(sex)));
            entity.setAge(Integer.valueOf(Integer.parseInt(age)));
            entity.setBirthday(birthday);
            List list = this.outEtubePatientInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientCode, (Object)entity.getPatientCode()));
            entity.setReqRecord(entity.getReqRecord() + "->" + outExpertStudioRecordEntity.getId());
            if (list.size() > 0) {
                entity.setReqRecord(((OutEtubePatientInfoEntity)list.get(0)).getReqRecord());
                int n = this.outEtubePatientInfoMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientInfoEntity::getPatientCode, (Object)entity.getPatientCode()));
            } else {
                int n = this.outEtubePatientInfoMapper.insert((Object)entity);
            }
            return ResponseData.success((Object)entity);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData updatePatient(OutEtubePatientInfoEntity entity) {
        OutEtubeStudioPatientEntity outEtubeStudioPatientEntity;
        Integer patientId;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String patientCode = entity.getPatientCode();
        if (StringUtil.isBlank((String)patientCode) && (patientId = entity.getPatientId()) != null) {
            OutEtubePatientInfoEntity patient = (OutEtubePatientInfoEntity)this.outEtubePatientInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)patientId));
            patientCode = patient.getPatientCode();
        }
        ExceptionUtils.createException((Logger)log, ((outEtubeStudioPatientEntity = (OutEtubeStudioPatientEntity)this.outEtubeStudioPatientMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)entity.getPatientId()))) == null ? 1 : 0) != 0, (String)"\u60a3\u8005\u672a\u52a0\u5165\u5de5\u4f5c\u5ba4");
        param.put("studioCode", outEtubeStudioPatientEntity.getStudioCode());
        param.put("patientCode", patientCode);
        String idCard = entity.getIdCard();
        String mobilePhone = entity.getMobilePhone();
        String userName = entity.getUserName();
        Integer sex = entity.getSex();
        Integer age = entity.getAge();
        String birthday = entity.getBirthday();
        param.put("idCard", idCard);
        param.put("mobilePhone", mobilePhone);
        param.put("userName", userName);
        param.put("sex", sex);
        param.put("age", age);
        param.put("birthday", birthday);
        String url = "https://server.etube365.com/csp/pass/proxy/api/patient/updatePatientBasicInfo";
        String respStr = null;
        try {
            log.info("===========>\u5f00\u59cb\u66f4\u65b0\u60a3\u8005\u57fa\u672c\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString(param));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u66f4\u65b0\u60a3\u8005\u57fa\u672c\u4fe1\u606f\u8fd4\u56de\u53c2\u6570{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        OutExpertStudioRecordEntity outExpertStudioRecordEntity = new OutExpertStudioRecordEntity();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        outExpertStudioRecordEntity.setCreateTime(format.format(new Date()));
        outExpertStudioRecordEntity.setUrl(url);
        outExpertStudioRecordEntity.setParam(JSON.toJSONString(param));
        outExpertStudioRecordEntity.setMsg(msg);
        outExpertStudioRecordEntity.setCode(code);
        outExpertStudioRecordEntity.setData(data);
        outExpertStudioRecordEntity.setTenantId(entity.getTenantId());
        int insert = this.outExpertStudioRecordMapper.insert((Object)outExpertStudioRecordEntity);
        if ("200".equals(code)) {
            List list = this.outEtubePatientInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientCode, (Object)patientCode));
            entity.setReqRecord(entity.getReqRecord() + "->" + outExpertStudioRecordEntity.getId());
            if (list.size() > 0) {
                entity.setReqRecord(((OutEtubePatientInfoEntity)list.get(0)).getReqRecord());
                int n = this.outEtubePatientInfoMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientInfoEntity::getPatientCode, (Object)patientCode));
            } else {
                entity.setPatientCode("HZ-" + entity.getPatientId());
                int n = this.outEtubePatientInfoMapper.insert((Object)entity);
            }
            return ResponseData.success((Object)entity);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData queryPatientDossier(OutEtubePatientDossierEntity entity) {
        String studioCode = entity.getStudioCode();
        String patientCode = entity.getPatientCode();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("studioCode", studioCode);
        param.put("patientCode", patientCode);
        String url = "https://server.etube365.com/csp/pass/proxy/api/studio/queryPatientDossierInfo";
        String respStr = null;
        try {
            log.info("===========>\u67e5\u8be2\u60a3\u8005\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4\u6863\u6848\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString(param));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u67e5\u8be2\u60a3\u8005\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4\u6863\u6848\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        OutExpertStudioRecordEntity outExpertStudioRecordEntity = new OutExpertStudioRecordEntity();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        outExpertStudioRecordEntity.setCreateTime(format.format(new Date()));
        outExpertStudioRecordEntity.setUrl(url);
        outExpertStudioRecordEntity.setParam(JSON.toJSONString(param));
        outExpertStudioRecordEntity.setMsg(msg);
        outExpertStudioRecordEntity.setCode(code);
        outExpertStudioRecordEntity.setData(data);
        outExpertStudioRecordEntity.setTenantId(entity.getTenantId());
        int insert = this.outExpertStudioRecordMapper.insert((Object)outExpertStudioRecordEntity);
        if ("200".equals(code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            String createTime = jsonObject.get((Object)"createTime").toString();
            String hospitalCode = jsonObject.get((Object)"hospitalCode").toString();
            String inviteCode = jsonObject.get((Object)"inviteCode").toString();
            String patientRemark = jsonObject.get((Object)"patientRemark").toString();
            String dossierInfo = jsonObject.get((Object)"dossierInfo").toString();
            JSONObject dossier = JSONObject.parseObject((String)dossierInfo);
            String weight = dossier.get((Object)"weight").toString();
            String patientInsure = dossier.get((Object)"patient_insure").toString();
            String familyAddress = dossier.get((Object)"family_address").toString();
            String companyAddress = dossier.get((Object)"company_address").toString();
            String medicalRecordNo = dossier.get((Object)"medical_record_no").toString();
            String height = dossier.get((Object)"height").toString();
            entity.setWeight(weight);
            entity.setPatientInsure(patientInsure);
            entity.setFamilyAddress(familyAddress);
            entity.setCompanyAddress(companyAddress);
            entity.setMedicalRecordNo(medicalRecordNo);
            entity.setHeight(height);
            entity.setInviteCode(inviteCode);
            entity.setPatientRemark(patientRemark);
            entity.setCreateTime(createTime);
            entity.setReqRecord(outExpertStudioRecordEntity.getId() + "");
            List list = this.outEtubePatientDossierMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode())).eq(OutEtubePatientDossierEntity::getInviteCode, (Object)entity.getInviteCode())).eq(OutEtubePatientDossierEntity::getTenantId, (Object)entity.getTenantId()));
            if (list.size() > 0) {
                entity.setReqRecord(((OutEtubePatientDossierEntity)list.get(0)).getReqRecord() + outExpertStudioRecordEntity.getId());
                this.outEtubePatientDossierMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode()));
            } else {
                this.outEtubePatientDossierMapper.insert((Object)entity);
            }
            return ResponseData.success((Object)jsonObject).msg(msg);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData updatePatientDossier2(OutEtubePatientDossierEntity entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("studioCode", entity.getStudioCode());
        param.put("inviteCode", entity.getInviteCode());
        param.put("patientCode", entity.getPatientCode());
        param.put("patientRemark", entity.getPatientRemark());
        HashMap<String, String> dossierParam = new HashMap<String, String>();
        dossierParam.put("weight", entity.getWeight());
        dossierParam.put("patient_insure", entity.getPatientInsure());
        dossierParam.put("family_address", entity.getFamilyAddress());
        dossierParam.put("company_address", entity.getCompanyAddress());
        dossierParam.put("medical_record_no", entity.getMedicalRecordNo());
        dossierParam.put("height", entity.getHeight());
        param.put("dossierInfo", dossierParam);
        List list = this.outEtubePatientDossierMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(entity.getStudioCode() != null, OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode())).eq(entity.getInviteCode() != null, OutEtubePatientDossierEntity::getInviteCode, (Object)entity.getInviteCode())).eq(entity.getTenantId() != null, OutEtubePatientDossierEntity::getTenantId, (Object)entity.getTenantId()));
        if (list.size() > 0) {
            this.outEtubePatientDossierMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode()));
        } else {
            entity.setCreateTime(this.fmt.format(new Date()));
            this.outEtubePatientDossierMapper.insert((Object)entity);
        }
        return ResponseData.success();
    }

    public ResponseData updatePatientDossier(OutEtubePatientDossierEntity entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("studioCode", entity.getStudioCode());
        param.put("inviteCode", entity.getInviteCode());
        param.put("patientCode", entity.getPatientCode());
        param.put("patientRemark", entity.getPatientRemark());
        HashMap<String, String> dossierParam = new HashMap<String, String>();
        dossierParam.put("weight", entity.getWeight());
        dossierParam.put("patient_insure", entity.getPatientInsure());
        dossierParam.put("family_address", entity.getFamilyAddress());
        dossierParam.put("company_address", entity.getCompanyAddress());
        dossierParam.put("medical_record_no", entity.getMedicalRecordNo());
        dossierParam.put("height", entity.getHeight());
        param.put("dossierInfo", dossierParam);
        String url = "https://server.etube365.com/csp/pass/proxy/api/studio/updatePatientDossierInfo";
        String respStr = null;
        try {
            log.info("===========>\u66f4\u65b0\u60a3\u8005\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4\u6863\u6848\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString(param));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString(param), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u66f4\u65b0\u60a3\u8005\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4\u6863\u6848\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
        }
        OutExpertStudioRecordEntity outExpertStudioRecordEntity = new OutExpertStudioRecordEntity();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        outExpertStudioRecordEntity.setCreateTime(format.format(new Date()));
        outExpertStudioRecordEntity.setUrl(url);
        outExpertStudioRecordEntity.setParam(JSON.toJSONString(param));
        outExpertStudioRecordEntity.setMsg(msg);
        outExpertStudioRecordEntity.setCode(code);
        outExpertStudioRecordEntity.setData(data);
        outExpertStudioRecordEntity.setTenantId(entity.getTenantId());
        int insert = this.outExpertStudioRecordMapper.insert((Object)outExpertStudioRecordEntity);
        if ("200".equals(code)) {
            List list = this.outEtubePatientDossierMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(entity.getStudioCode() != null, OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode())).eq(entity.getInviteCode() != null, OutEtubePatientDossierEntity::getInviteCode, (Object)entity.getInviteCode())).eq(entity.getTenantId() != null, OutEtubePatientDossierEntity::getTenantId, (Object)entity.getTenantId()));
            if (list.size() > 0) {
                entity.setReqRecord(((OutEtubePatientDossierEntity)list.get(0)).getReqRecord() + "->" + outExpertStudioRecordEntity.getId());
                this.outEtubePatientDossierMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutEtubePatientDossierEntity::getPatientCode, (Object)entity.getPatientCode())).eq(OutEtubePatientDossierEntity::getStudioCode, (Object)entity.getStudioCode()));
            } else {
                entity.setCreateTime(this.fmt.format(new Date()));
                this.outEtubePatientDossierMapper.insert((Object)entity);
            }
            return ResponseData.success((Object)data).msg(msg);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public RequestDto getByPatientId(Integer patientId) {
        String studioCode = "";
        String patientCode = "";
        String doctorCode = "";
        if (patientId != null) {
            List outEtubeStudioDoctorEntities;
            List outEtubePatientInfoEntities;
            List outEtubeStudioPatientEntities = this.outEtubeStudioPatientMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)patientId));
            if (outEtubeStudioPatientEntities.size() > 0) {
                OutEtubeStudioPatientEntity entity = (OutEtubeStudioPatientEntity)outEtubeStudioPatientEntities.get(0);
                studioCode = entity.getStudioCode();
            }
            if ((outEtubePatientInfoEntities = this.outEtubePatientInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)patientId))).size() > 0) {
                OutEtubePatientInfoEntity entity = (OutEtubePatientInfoEntity)outEtubePatientInfoEntities.get(0);
                patientCode = entity.getPatientCode();
            }
            if ((outEtubeStudioDoctorEntities = this.outEtubeStudioDoctorMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioDoctorEntity::getStudioCode, (Object)studioCode))).size() > 0) {
                OutEtubeStudioDoctorEntity entity = (OutEtubeStudioDoctorEntity)outEtubeStudioDoctorEntities.get(0);
                doctorCode = entity.getDoctorCode();
            }
        }
        RequestDto dto = new RequestDto();
        dto.setStudioCode(studioCode);
        dto.setPatientCode(patientCode);
        dto.setDoctorCode(doctorCode);
        return dto;
    }

    public ResponseData pushTag(RequestDto dto) {
        List outEtubePatientInfoEntities;
        Integer patientId = dto.getPatientId();
        ExceptionUtils.createException((Logger)log, (patientId == null ? 1 : 0) != 0, (String)"patientId\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceType = dto.getSourceType();
        if (StringUtil.isBlank((String)sourceType)) {
            return ResponseData.error((String)"\u7528\u836f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String studioCode = "";
        String patientCode = "";
        List outEtubeStudioPatientEntities = this.outEtubeStudioPatientMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubeStudioPatientEntity::getPatientId, (Object)patientId));
        if (outEtubeStudioPatientEntities.size() > 0) {
            OutEtubeStudioPatientEntity entity = (OutEtubeStudioPatientEntity)outEtubeStudioPatientEntities.get(0);
            studioCode = entity.getStudioCode();
        }
        if ((outEtubePatientInfoEntities = this.outEtubePatientInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutEtubePatientInfoEntity::getPatientId, (Object)patientId))).size() > 0) {
            OutEtubePatientInfoEntity entity = (OutEtubePatientInfoEntity)outEtubePatientInfoEntities.get(0);
            patientCode = entity.getPatientCode();
        }
        if (StringUtil.isBlank((String)studioCode) || StringUtil.isBlank((String)patientCode)) {
            return ResponseData.error((String)"\u8be5\u60a3\u8005\u672a\u52a0\u5165\u5de5\u4f5c\u5ba4");
        }
        dto.setStudioCode(studioCode);
        dto.setPatientCode(patientCode);
        HashSet<String> networkCodeSet = new HashSet<String>();
        HashMap networkMap = new HashMap();
        if (sourceType.equals("PATIENT_ONLINE_TAG")) {
            String prescriptionNo = dto.getPrescriptionNo();
            ExceptionUtils.createException((Logger)log, (boolean)StringUtil.isBlank((String)prescriptionNo), (String)"\u5904\u65b9\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            List outPrescriptions = this.prescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutPrescription::getTenantId, (Object)dto.getTenantId())).eq(OutPrescription::getPatientId, (Object)dto.getPatientId())).eq(OutPrescription::getPrescriptionStatus, (Object)1));
            List outPrescriptionList = outPrescriptions.stream().map(item -> {
                String prescriptionNoItem = item.getPrescriptionNo();
                return prescriptionNoItem;
            }).collect(Collectors.toList());
            List prescriptionDrugList = this.prescriptionDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutPrescriptionDrug::getTenantId, (Object)dto.getTenantId())).eq(OutPrescriptionDrug::getStatus, (Object)1)).in(OutPrescriptionDrug::getPrescriptionNo, outPrescriptionList)).groupBy(OutPrescriptionDrug::getDrugNo));
            List drugNames = prescriptionDrugList.stream().map(item -> {
                String drugName = StringUtil.isBlank((String)item.getDrugName()) ? "\u65e0\u836f\u54c1\u540d\u79f0" : item.getDrugName();
                String specification = StringUtil.isBlank((String)item.getSpecification()) ? "\u65e0\u89c4\u683c" : item.getSpecification();
                String singleDose = item.getSingleDose() == null ? "\u65e0\u5355\u6b21\u5242\u91cf" : item.getSingleDose().toString();
                String doseUnit = StringUtil.isBlank((String)item.getDoseUnit()) ? "\u65e0\u5242\u91cf\u5355\u4f4d" : item.getDoseUnit();
                String drugUsage = StringUtil.isBlank((String)item.getDrugUsage()) ? "\u65e0\u7528\u6cd5" : item.getDrugUsage();
                String context = drugName + " (" + specification + ") \u6bcf\u6b21" + singleDose + doseUnit + " " + drugUsage;
                return context;
            }).collect(Collectors.toList());
            dto.setSourceType(sourceType);
            dto.setStudioCode(studioCode);
            ResponseData responseData = this.queryTagTree(dto);
            String code = responseData.getCode();
            if ("200".equals(code)) {
                String tagData = (String)responseData.getData();
                JSONArray objects = JSONArray.parseArray((String)tagData);
                block0: for (int i = 0; i < objects.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)objects.get(i);
                    JSONArray tagList = (JSONArray)jsonObject.get((Object)"tagList");
                    if (tagList != null) {
                        block1: for (int j = 0; j < tagList.size(); ++j) {
                            JSONObject tag = (JSONObject)tagList.get(j);
                            String tagName = (String)tag.get((Object)"tagName");
                            for (int k = 0; k < drugNames.size(); ++k) {
                                String drugName = (String)drugNames.get(k);
                                if (!tagName.equals(drugName)) continue;
                                String networkCode = (String)tag.get((Object)"networkCode");
                                networkCodeSet.add(networkCode);
                                drugNames.remove(k);
                                continue block1;
                            }
                        }
                        continue;
                    }
                    String tagName = (String)jsonObject.get((Object)"tagName");
                    for (int k = 0; k < drugNames.size(); ++k) {
                        String drugName = (String)drugNames.get(k);
                        if (!tagName.equals(drugName)) continue;
                        String networkCode = (String)jsonObject.get((Object)"networkCode");
                        networkCodeSet.add(networkCode);
                        drugNames.remove(k);
                        continue block0;
                    }
                }
            }
        } else if (sourceType.equals("OPERATION_TAG")) {
            QueryPatientMedicalDto queryPatientMedicalDto = new QueryPatientMedicalDto();
            queryPatientMedicalDto.setTenantId(dto.getTenantId());
            queryPatientMedicalDto.setPatientId(dto.getPatientId());
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            statusList.add(20);
            statusList.add(30);
            statusList.add(99);
            queryPatientMedicalDto.setStatus(statusList);
            List vos = this.outMedicalRecordMapper.queryDiagnosisTreatmentRecords(queryPatientMedicalDto);
            ArrayList diagnosisNames = new ArrayList();
            for (QueryDiagnosisTreatmentRecordsVo vo : vos) {
                List diagnosisList = vo.getDiagnosisList();
                if (diagnosisList.size() <= 0) continue;
                List names = diagnosisList.stream().map(item -> {
                    String diagnosis = item.getDiagnosis();
                    return diagnosis;
                }).collect(Collectors.toList());
                diagnosisNames.addAll(names);
            }
            if (diagnosisNames == null || diagnosisNames.size() == 0) {
                return ResponseData.error((String)"\u60a3\u8005\u65e0\u8bca\u65ad");
            }
            dto.setSourceType(sourceType);
            dto.setStudioCode(studioCode);
            ResponseData responseData = this.queryTagTree(dto);
            String code = responseData.getCode();
            if ("200".equals(code)) {
                String tagData = (String)responseData.getData();
                JSONArray objects = JSONArray.parseArray((String)tagData);
                block5: for (int i = 0; i < objects.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)objects.get(i);
                    JSONArray tagList = (JSONArray)jsonObject.get((Object)"tagList");
                    if (tagList != null) {
                        block6: for (int j = 0; j < tagList.size(); ++j) {
                            JSONObject tag = (JSONObject)tagList.get(j);
                            String tagName = (String)tag.get((Object)"tagName");
                            for (int k = 0; k < diagnosisNames.size(); ++k) {
                                String diagnosisName = (String)diagnosisNames.get(k);
                                if (!diagnosisName.equals(tagName)) continue;
                                String networkCode = (String)tag.get((Object)"networkCode");
                                networkCodeSet.add(networkCode);
                                diagnosisNames.remove(k);
                                continue block6;
                            }
                        }
                        continue;
                    }
                    String tagName = (String)jsonObject.get((Object)"tagName");
                    for (int k = 0; k < diagnosisNames.size(); ++k) {
                        String diagnosisName = (String)diagnosisNames.get(k);
                        if (!diagnosisName.equals(tagName)) continue;
                        String networkCode = (String)jsonObject.get((Object)"networkCode");
                        networkCodeSet.add(networkCode);
                        diagnosisNames.remove(k);
                        continue block5;
                    }
                }
            }
        }
        dto.setNetworkMap(networkMap);
        if (networkCodeSet.size() > 0) {
            dto.setNetworkCodeSet(networkCodeSet);
            ResponseData responseData = this.insertPatientTagInfo(dto);
            String code = responseData.getCode();
            if ("200".equals(code)) {
                return ResponseData.success();
            }
            return ResponseData.error((String)"\u63a8\u9001\u5931\u8d25");
        }
        return ResponseData.error((String)"\u6ca1\u6709\u5339\u914d\u7684\u6807\u7b7e");
    }

    private void putNetWork(Map<String, Set<String>> networkMap, JSONObject jsonObject) {
        Set<String> networkParentList = networkMap.keySet();
        String networkCode = (String)jsonObject.get((Object)"networkCode");
        String networkParent = (String)jsonObject.get((Object)"networkParent");
        if (!networkParentList.contains(networkParent)) {
            HashSet<String> networkCodeSet = new HashSet<String>();
            networkCodeSet.add(networkCode);
            networkMap.put(networkParent, networkCodeSet);
        } else {
            Set<String> networkCodeSet = networkMap.get(networkParent);
            networkMap.put(networkParent, networkCodeSet);
        }
    }

    public ResponseData queryIndicatorGroup(RequestDto dto) {
        String studioCode = dto.getStudioCode();
        if (StringUtil.isBlank((String)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://server.etube365.com/csp/pass/proxy/api/indicator/queryIndicatorGroup";
        String respStr = null;
        try {
            log.info("===========>\u67e5\u8be2\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u8f85\u52a9\u68c0\u67e5-\u6307\u6807\u5206\u7ec4\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u67e5\u8be2\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u8f85\u52a9\u68c0\u67e5-\u6307\u6807\u5206\u7ec4\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
            return ResponseData.success((Object)data);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData queryTagTree(RequestDto dto) {
        String sourceType = dto.getSourceType();
        String studioCode = dto.getStudioCode();
        if (StringUtil.isBlank((String)sourceType) || StringUtil.isBlank((String)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/queryTagTreeInfo";
        String respStr = null;
        try {
            log.info("===========>\u67e5\u8be2\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u67e5\u8be2\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            if (respJson.get((Object)"data") != null) {
                data = respJson.get((Object)"data").toString();
            }
            return ResponseData.success((Object)data);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData insertPatientTagInfo(RequestDto dto) {
        String studioCode = dto.getStudioCode();
        String patientCode = dto.getPatientCode();
        String sourceType = dto.getSourceType();
        Set networkCodeSet = dto.getNetworkCodeSet();
        dto.setHospitalCode("YY-111");
        if (StringUtil.isBlank((String)studioCode) || StringUtil.isBlank((String)patientCode) || StringUtil.isBlank((String)sourceType) || networkCodeSet.size() == 0) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/insertPatientTagInfo";
        String respStr = null;
        try {
            log.info("===========>\u65b0\u589e\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u65b0\u589e\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData deletePatientTagInfo(RequestDto dto) {
        String studioCode = dto.getStudioCode();
        String patientCode = dto.getPatientCode();
        String operationCode = dto.getOperationCode();
        if (StringUtil.isBlank((String)operationCode)) {
            operationCode = "YS-0";
        }
        ArrayList idSet = dto.getIdSet();
        if (StringUtil.isBlank((String)studioCode) || StringUtil.isBlank((String)patientCode) || StringUtil.isBlank((String)operationCode) || idSet.size() == 0) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://server.etube365.com/csp/pass/proxy/api/tag/deletePatientTagInfo";
        String respStr = null;
        try {
            log.info("===========>\u5220\u9664\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u5220\u9664\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            return ResponseData.success((Object)jsonObject);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData queryIndicatorInfo(RequestDto dto) {
        String studioCode = dto.getStudioCode();
        if (StringUtil.isBlank((String)studioCode)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = "https://server.etube365.com/csp/pass/proxy/api/indicator/queryIndicatorInfo";
        String respStr = null;
        try {
            log.info("===========>\u5220\u9664\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u5220\u9664\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u6807\u7b7e\u4fe1\u606f{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
            return ResponseData.success((Object)data);
        }
        return ResponseData.error((String)code, (String)msg);
    }

    public ResponseData insertPatientIndicatorUpload(RequestDto dto) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = format.format(new Date());
        String studioCode = dto.getStudioCode();
        String patientCode = dto.getPatientCode();
        String createBy = dto.getCreateBy();
        if (StringUtil.isBlank((String)createBy)) {
            createBy = "YS-0";
            dto.setCreateBy(createBy);
        }
        List groupList = dto.getGroupList();
        Boolean isEmpty = true;
        if (StringUtil.isBlank((String)studioCode) || StringUtil.isBlank((String)patientCode) || StringUtil.isBlank((String)createBy) || groupList.size() == 0) {
            isEmpty = false;
        } else {
            block2: for (Group group : groupList) {
                group.setUploadTime(timeStr);
                String groupCode = group.getGroupCode();
                String uploadTime = group.getUploadTime();
                List indicatorList = group.getIndicatorList();
                if (StringUtil.isBlank((String)groupCode) || StringUtil.isBlank((String)uploadTime) || indicatorList.size() == 0) {
                    isEmpty = false;
                    break;
                }
                for (Indicator indicator : indicatorList) {
                    String indicatorType = indicator.getIndicatorType();
                    String indicatorCode = indicator.getIndicatorCode();
                    List dataInput = indicator.getDataInput();
                    if (StringUtil.isBlank((String)indicatorType) || StringUtil.isBlank((String)indicatorCode) || dataInput.size() == 0) {
                        isEmpty = false;
                        break block2;
                    }
                    for (DataInput input : dataInput) {
                        String name = input.getName();
                        String value = input.getValue();
                        String valueCode = input.getValueCode();
                        if (!StringUtil.isBlank((String)name) && !StringUtil.isBlank((String)value)) continue;
                        isEmpty = false;
                        break block2;
                    }
                }
            }
        }
        ExceptionUtils.createException((Logger)log, (isEmpty == false ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u5b8c\u6574");
        String url = "https://server.etube365.com/csp/pass/proxy/api/indicator/insertPatientIndicatorUpload";
        String respStr = null;
        try {
            log.info("===========>\u65b0\u589e\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u8f85\u52a9\u68c0\u67e5-\u6307\u6807\u4e0a\u4f20\u8bb0\u5f55------------>url={},\u53c2\u6570={}", (Object)url, (Object)JSON.toJSONString((Object)dto));
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)dto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=============>\u65b0\u589e\u60a3\u8005-\u6240\u5728\u4e13\u5bb6\u5de5\u4f5c\u5ba4-\u8f85\u52a9\u68c0\u67e5-\u6307\u6807\u4e0a\u4f20\u8bb0\u5f55{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject respJson = JSON.parseObject((String)respStr);
        String code = respJson.get((Object)"code").toString();
        String msg = respJson.get((Object)"msg").toString();
        String data = "";
        if ("200".equals(code)) {
            data = respJson.get((Object)"data").toString();
            return ResponseData.success();
        }
        return ResponseData.error((String)code, (String)msg);
    }
}

