/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.prescription.OutPrescriptionDto;
import com.byh.outpatient.api.dto.prescription.SavePrescriptionDrugsDto;
import com.byh.outpatient.api.dto.prescription.SavePrescriptionDto;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PrescriptionTypeEnum;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.sysService.SysDrugPharmacyOutEntity;
import com.byh.outpatient.api.sysModel.request.SysDrugPharmacyOutPrescriptionSaveDto;
import com.byh.outpatient.api.sysModel.request.SysDrugPharmacyOutSaveDto;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.OutPrescriptionDrugService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutPrescriptionDrugServiceImpl
implements OutPrescriptionDrugService {
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    private static Logger log = LoggerFactory.getLogger(OutPrescriptionDrugServiceImpl.class);

    public List<OutPrescriptionDrug> updatePrescriptionDrugs(SavePrescriptionDto parameter) {
        Integer size;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryWrapper.eq((Object)"prescription_no", (Object)parameter.getPrescriptionNo());
        List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)outPrescriptionDrugs)) {
            List ids = outPrescriptionDrugs.stream().map(OutPrescriptionDrug::getId).collect(Collectors.toList());
            size = this.outPrescriptionDrugMapper.updateByIdsToDelete(ids, parameter.getPrescriptionNo(), parameter.getOperatorId());
            log.info("\u5220\u9664\u836f\u54c1\u6570\u91cf\uff1a{},\u5904\u65b9\u53f7:{}", (Object)size, (Object)parameter.getPrescriptionNo());
        }
        List outPrescriptionDrugList = parameter.getDrugList().stream().map(SavePrescriptionDrugsDto2 -> {
            OutPrescriptionDrug dto = new OutPrescriptionDrug();
            BeanUtils.copyProperties((Object)SavePrescriptionDrugsDto2, (Object)dto);
            dto.setMedicalInsuranceAuditFlag(StrUtil.isEmpty((CharSequence)SavePrescriptionDrugsDto2.getMedicalInsuranceAuditFlag()) ? "1" : SavePrescriptionDrugsDto2.getMedicalInsuranceAuditFlag());
            dto.setCreateId(parameter.getOperatorId());
            dto.setPrescriptionNo(parameter.getPrescriptionNo());
            dto.setTenantId(parameter.getTenantId());
            dto.setStatus(OutpatientDataStatusEnum.NORMAL.getValue());
            if (PrescriptionTypeEnum.TRADITIONAL_CHINESEMEDICINEDRINK.getValue().equals(parameter.getPrescriptionType())) {
                dto.setSingleDose(SavePrescriptionDrugsDto2.getQuantity());
                dto.setQuantity(SavePrescriptionDrugsDto2.getQuantity().multiply(new BigDecimal(parameter.getDosage())));
            }
            return dto;
        }).collect(Collectors.toList());
        size = this.outPrescriptionDrugMapper.batchInsert(outPrescriptionDrugList);
        log.info("\u65b0\u589e\u836f\u54c1\u6570\u91cf\uff1a{},\u5904\u65b9\u53f7:{}", (Object)size, (Object)parameter.getPrescriptionNo());
        return outPrescriptionDrugs;
    }

    public String deductionOfDrugInventoryQuantity(SavePrescriptionDto parameter) {
        ArrayList<SysDrugPharmacyOutPrescriptionSaveDto> list = new ArrayList<SysDrugPharmacyOutPrescriptionSaveDto>();
        for (SavePrescriptionDrugsDto drugsDto : parameter.getDrugList()) {
            SysDrugPharmacyOutPrescriptionSaveDto saveDto = new SysDrugPharmacyOutPrescriptionSaveDto();
            saveDto.setDrugsId(drugsDto.getDrugNo());
            saveDto.setDrugsName(drugsDto.getDrugName());
            saveDto.setSpecifications(drugsDto.getSpecification());
            saveDto.setQuantity(Integer.valueOf(drugsDto.getQuantity().intValue()));
            if (PrescriptionTypeEnum.TRADITIONAL_CHINESEMEDICINEDRINK.getValue().equals(parameter.getPrescriptionType())) {
                saveDto.setQuantity(Integer.valueOf(drugsDto.getQuantity().multiply(new BigDecimal(parameter.getDosage())).intValue()));
            }
            saveDto.setUnit(drugsDto.getQuantityUnit());
            saveDto.setRetailPrice(drugsDto.getDrugPriceAmount());
            saveDto.setEffectiveTime(drugsDto.getEffectiveTime());
            saveDto.setManufacturer(drugsDto.getManufacturer());
            saveDto.setPurchasePrice(drugsDto.getPurchasePrice());
            saveDto.setInventoryQuantity(drugsDto.getInventoryQuantity());
            saveDto.setMedicalInsuranceCode(drugsDto.getMedicalInsuranceCode());
            saveDto.setTenantId(parameter.getTenantId());
            saveDto.setLevel(drugsDto.getLevel());
            saveDto.setOutboundWarehouse(drugsDto.getPharmacyId());
            list.add(saveDto);
        }
        SysDrugPharmacyOutSaveDto dto = new SysDrugPharmacyOutSaveDto();
        dto.setDepartmentId(String.valueOf(parameter.getPrescribingDepartmentId()));
        dto.setDepartmentName(parameter.getPrescribingDepartmentName());
        dto.setOutboundMethod("10");
        dto.setOutboundTime(new Date());
        dto.setOutboundUse(parameter.getOperatorName());
        dto.setOutboundWarehouse(((SysDrugPharmacyOutPrescriptionSaveDto)list.get(0)).getOutboundWarehouse());
        dto.setRemarks("\u5904\u65b9\u5f00\u5177");
        dto.setTenantId(parameter.getTenantId());
        dto.setUpdateId(parameter.getOperatorId());
        dto.setList(list);
        dto.setPrescriptionId(parameter.getPrescriptionNo());
        log.info("\u5e93\u5b58\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)dto));
        ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutSave(dto, String.valueOf(parameter.getTenantId()), parameter.getOperatorId());
        log.info("\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            throw new IllegalStateException(responseData.getMsg());
        }
        SysDrugPharmacyOutEntity sysDrugPharmacyOutEntity = (SysDrugPharmacyOutEntity)JSONObject.parseObject((String)JSONObject.toJSONString((Object)responseData.getData()), SysDrugPharmacyOutEntity.class);
        log.info("\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679cENTITY,", (Object)JSONObject.toJSONString((Object)sysDrugPharmacyOutEntity));
        return sysDrugPharmacyOutEntity.getId();
    }

    public void returnOfDrugInventoryQuantity(String prescriptionNo, String wareHouse, Integer tenantId) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        sysEasyEntity.setId(prescriptionNo);
        sysEasyEntity.setWarehouse(wareHouse);
        ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutDeleteByPrescriptionId(sysEasyEntity, String.valueOf(tenantId));
        log.info("\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            throw new IllegalStateException(responseData.getMsg());
        }
    }

    public ResponseData<String> sysDrugPharmacyOutUpdateStatus(String lnventoryNumber, String wareHouse, String auditStatus, Integer tenantId) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        sysEasyEntity.setId(lnventoryNumber);
        sysEasyEntity.setAuditStatus(auditStatus);
        sysEasyEntity.setOutboundWarehouse(wareHouse);
        ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutUpdateStatus(sysEasyEntity, String.valueOf(tenantId));
        log.info("\u5e93\u5b58\u4f5c\u5e9f\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            return responseData;
        }
        return ResponseData.success();
    }

    public void confirmOutbound(String lnventoryNumber, Integer tenantId, OutPrescriptionDto parameter) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        sysEasyEntity.setId(lnventoryNumber);
        sysEasyEntity.setDrugTracCodg(parameter.getDrugTracCodg());
        sysEasyEntity.setJsonList(parameter.getDrugList());
        log.info("\u5e93\u5b58\u64cd\u4f5c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)sysEasyEntity));
        ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutConfirm(sysEasyEntity, String.valueOf(tenantId), parameter.getOperatorId());
        log.info("\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            throw new IllegalStateException(responseData.getMsg());
        }
    }

    public void confirmOutack(String lnventoryNumber, Integer tenantId, OutPrescriptionDto parameter) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        sysEasyEntity.setId(lnventoryNumber);
        sysEasyEntity.setDrugTracCodg(parameter.getDrugTracCodg());
        sysEasyEntity.setJsonList(parameter.getDrugList());
        ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutBackDrug(sysEasyEntity, String.valueOf(tenantId), parameter.getOperatorId());
        log.info("\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)responseData));
        if (!responseData.isSuccess()) {
            throw new IllegalStateException(responseData.getMsg());
        }
    }

    public List<OutPrescriptionDrug> queryPrescriptionDrugsByPresNo(Integer tenantId, String prescriptionNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"prescription_no", (Object)prescriptionNo);
        List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryWrapper);
        return outPrescriptionDrugs;
    }

    public List<OutPrescriptionDrug> queryPrescriptionDrugsByPresNoList(Integer tenantId, List<String> prescriptionNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.in((Object)"prescription_no", prescriptionNoList);
        List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryWrapper);
        return outPrescriptionDrugs;
    }
}

