/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.sysModel.request.SysDrugEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.service.OutEtubePatientInfoService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutEtubePatientInfoController {
    @Autowired
    private OutEtubePatientInfoService outEtubePatientInfoService;

    @RequestMapping(value={"/out/etube/patient/info/save"})
    public ResponseData outEtubePatientInfoSave(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        this.outEtubePatientInfoService.outEtubePatientInfoSave(entity);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/out/etube/patient/info/select"})
    public ResponseData outEtubePatientInfoSelect(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        List list = this.outEtubePatientInfoService.outEtubePatientInfoSelect(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/etube/patient/info/update"})
    public ResponseData outEtubePatientInfoUpdate(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        this.outEtubePatientInfoService.outEtubePatientInfoUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/out/etube/patient/info/delete"})
    public ResponseData outEtubePatientInfoDelete(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        this.outEtubePatientInfoService.outEtubePatientInfoDelete(entity);
        return ResponseData.success().delete();
    }

    @RequestMapping(value={"/out/etube/patient/info/queryDrugRecordByPatient"})
    public ResponseData<PageInfo<SysDrugEntity>> queryDrugRecordByPatient(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PageInfo page = this.outEtubePatientInfoService.queryDrugRecordByPatient(entity);
        return ResponseData.success((Object)page);
    }

    @RequestMapping(value={"/out/etube/patient/info/queryDiagnosisByPatient"})
    public ResponseData<List<String>> queryDiagnosisByPatient(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List page = this.outEtubePatientInfoService.queryDiagnosisByPatient(entity);
        return ResponseData.success((Object)page);
    }

    @RequestMapping(value={"/out/etube/patient/info/queryTreatmentByPatient"})
    public ResponseData<List<String>> queryTreatmentByPatient(@RequestBody @Valid OutEtubePatientInfoEntity entity) {
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List page = this.outEtubePatientInfoService.queryTreatmentByPatient(entity);
        return ResponseData.success((Object)page);
    }
}

