/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller.netHospital;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.dto.QueryScheduleRecordDto;
import com.byh.outpatient.api.dto.admission.QuickTreatementDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.dto.pay.FeeBillCreationDto;
import com.byh.outpatient.api.dto.schedule.QueryRecordDto;
import com.byh.outpatient.api.enums.ApprovalIdentifyType;
import com.byh.outpatient.api.hsModel.BaseinfoEntity;
import com.byh.outpatient.api.hsModel.request.MedicalChronicRequest;
import com.byh.outpatient.api.hsModel.request.PatientInfoRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.hsModel.respones.HsPatientInfoResponse;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.datacenter.OutPatientRecordTempEntity;
import com.byh.outpatient.api.model.netHospital.GytPatientNarrativeEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordDetailEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.netHospital.GytPatientNarrativeSessionVo;
import com.byh.outpatient.api.vo.netHospital.GytPatientNarrativeVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsVo;
import com.byh.outpatient.api.vo.schedule.QueryRecordVo;
import com.byh.outpatient.api.vo.schedule.QueryScheduleRecordVo;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutPatientRecordTempMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.AdmissionService;
import com.byh.outpatient.web.service.GytgytPatientNarrativeService;
import com.byh.outpatient.web.service.OutDoctorRegFeeService;
import com.byh.outpatient.web.service.OutDoctorTypeService;
import com.byh.outpatient.web.service.OutMedicalRecordDiagnosisService;
import com.byh.outpatient.web.service.OutOrderPaymentService;
import com.byh.outpatient.web.service.OutOrderService;
import com.byh.outpatient.web.service.OutPayService;
import com.byh.outpatient.web.service.OutpatientTypeService;
import com.byh.outpatient.web.service.PatientService;
import com.byh.outpatient.web.service.ScheduleService;
import com.byh.outpatient.web.service.SelfHelpService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/netHospital"})
public class netHospitalController {
    private static Logger logger = LoggerFactory.getLogger(netHospitalController.class);
    @Autowired
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    private final OutOrderPaymentService outOrderPaymentService;
    private final ScheduleService scheduleService;
    private final OutpatientTypeService outpatientTypeService;
    private final AdmissionService admissionService;
    private final OutPayService outPayService;
    private final OutOrderService outOrderService;
    private final SelfHelpService selfHelpService;
    private final OutDoctorTypeService outDoctorTypeService;
    private final SysServiceFeign sysServiceFeign;
    private final OutOrderPaymentMapper outOrderPaymentMapper;
    private final GytgytPatientNarrativeService gytPatientNarrativeService;
    private final OutMedicalRecordDiagnosisService outMedicalRecordDiagnosisService;
    private final OutDoctorRegFeeService outDoctorRegFeeService;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private PatientService patientService;
    @Autowired
    private OutPatientRecordTempMapper outPatientRecordTempMapper;

    @PostMapping(value={"/scheduleRecordQuery"})
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f", httpMethod="GET", notes="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f")
    public ResponseData scheduleRecordQuery(@RequestBody QueryScheduleRecordDto queryScheduleRecordDto) {
        queryScheduleRecordDto.setCurrent(Integer.valueOf(1));
        ResponseData pageResultResponseData = this.scheduleService.queryRecord(queryScheduleRecordDto);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        if (!records.isEmpty()) {
            for (QueryScheduleRecordVo data : records) {
                if (data.getRegFee() != null) continue;
                QueryRecordDto ot = new QueryRecordDto();
                ot.setDeptId(data.getDeptId());
                ot.setSearchDate(queryScheduleRecordDto.getScheduleDate());
                ot.setTenantId(Integer.valueOf(1));
                List list = this.scheduleService.selectListByHy(ot);
                QueryRecordVo queryRecordVo = list.stream().filter(o -> o.getDoctorId().equals(data.getDoctorId())).findFirst().orElse(null);
                if (queryRecordVo == null) continue;
                data.setOutpatientType(queryRecordVo.getRepeatTypeCode());
                data.setOutpatientTypeName(queryRecordVo.getRepeatTypeName());
                data.setRegFee(queryRecordVo.getRepeatFee());
            }
        }
        return ResponseData.success((Object)records);
    }

    @GetMapping(value={"/queryRecordDetail"})
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f", httpMethod="GET", notes="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f")
    public ResponseData<List<ScheduleRecordDetailEntity>> queryRecordDetail(@RequestParam(value="scheduleCode", required=true) String scheduleCode, @RequestParam(value="reservationId", required=false) Integer reservationId) {
        return this.scheduleService.queryRecordDetail(scheduleCode, reservationId);
    }

    @PostMapping(value={"/registration"})
    @ApiOperation(value="\u6302\u53f7\u767b\u8bb0", httpMethod="POST", notes="\u6302\u53f7\u767b\u8bb0")
    public ResponseData registration(@RequestBody QuickTreatementDto quickTreatementDto) {
        String deviceNo = quickTreatementDto.getDeviceNo();
        logger.info("\u6302\u53f7\u63a5\u6536\u5230\u7684deviceNo===========\u300b{}", (Object)deviceNo);
        quickTreatementDto.setTenantId(Integer.valueOf(1));
        quickTreatementDto.setOperatorName("\u4e92\u533b");
        return this.admissionService.registration(quickTreatementDto);
    }

    @GetMapping(value={"/test"})
    @ApiOperation(value="\u6302\u53f7\u767b\u8bb0", httpMethod="POST", notes="\u6302\u53f7\u767b\u8bb0")
    public ResponseData test() {
        this.admissionService.test("42088100200105");
        return ResponseData.success();
    }

    @ApiOperation(value="\u53d6\u6d88\u767b\u8bb0")
    @PostMapping(value={"/cancelRegistration"})
    public ResponseData<Integer> cancelRegistration(@RequestBody AdmissionEntity admission) {
        admission.setTenantId(Integer.valueOf(1));
        return ResponseData.success((Object)this.admissionService.cancelRegistration(admission));
    }

    @PostMapping(value={"/queryItemInfo"})
    @ApiOperation(value="\u6839\u636epatientId\u67e5\u8be2\u5f85\u6536\u8d39/\u6536\u8d39\u9879\u76ee", httpMethod="POST", notes="\u6839\u636epatientId\u67e5\u8be2\u5f85\u6536\u8d39/\u6536\u8d39\u9879\u76ee")
    public ResponseData<List<QueryFeeDetailsVo>> queryItemInfo(@RequestBody QueryFeeDetailsDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderService.queryFeeDetailsByPId(parameter);
    }

    @PostMapping(value={"/queryChargeItem"})
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u5f85\u6536\u8d39\u9879\u76ee", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u6536\u8d39\u9879\u76ee")
    public ResponseData<QueryFeeDetailsVo> queryChargeItem(@RequestBody QueryFeeDetailsDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderService.queryFeeDetails(parameter);
    }

    @PostMapping(value={"/queryItemInfoByOutpatientNo"})
    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u8be6\u7ec6", httpMethod="POST", notes="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u8be6\u7ec6")
    public ResponseData<QueryFeeDetailsVo> queryItemInfoByOutpatientNo(@RequestBody QueryFeeDetailsDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderService.queryItemInfoByOutpatientNo(parameter);
    }

    @PostMapping(value={"/queryChargeItemDetails"})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6536\u8d39\u9879\u76ee\u660e\u7ec6")
    public ResponseData queryChargeItemDetails(@RequestBody QueryFeeDetailsListDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        return this.outOrderService.queryFeeDetailsByProjectID(parameter);
    }

    @PostMapping(value={"/orderCharge"})
    @ApiOperation(value="\u652f\u4ed8-\u652f\u4ed8\u8ba2\u5355\u521b\u5efa", httpMethod="POST", notes="\u652f\u4ed8-\u652f\u4ed8\u5355\u521b\u5efa")
    public ResponseData orderCharge(@RequestBody FeeBillCreationDto parameter) {
        parameter.setTenantId(Integer.valueOf(1));
        parameter.setOperatorName("\u8d63\u533b\u901a");
        return this.outPayService.orderCharge(parameter);
    }

    @PostMapping(value={"/patientAddNarrative"})
    @ApiOperation(value="\u65b0\u589e\u60a3\u8005\u4e3b\u8ff0", httpMethod="POST", notes="\u65b0\u589e\u60a3\u8005\u4e3b\u8ff0")
    public ResponseData patientAddNarrative(@RequestBody GytPatientNarrativeEntity entity) {
        this.gytPatientNarrativeService.patientAddNarrative(entity);
        return ResponseData.success();
    }

    @GetMapping(value={"/queryNarrative"})
    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0\u548c\u4e0a\u6b21\u8bca\u65ad", httpMethod="GET", notes="\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0\u548c\u4e0a\u6b21\u8bca\u65ad")
    public ResponseData queryNarrative(Integer patientId) {
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        GytPatientNarrativeVo gytPatientNarrative = this.gytPatientNarrativeService.queryNarrative(patientId);
        if (!Objects.isNull(gytPatientNarrative)) {
            MedicalChronicRequest medicalChronicRequest = new MedicalChronicRequest();
            if (StringUtil.isNotEmpty((String)gytPatientNarrative.getPsnNo())) {
                medicalChronicRequest.setPsn_no(gytPatientNarrative.getPsnNo());
            } else {
                ResponseData patientEntity = this.patientService.queryById(patientId);
                PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
                patientInfoRequest.setCertno(((PatientEntity)patientEntity.getData()).getCardNo());
                patientInfoRequest.setMdtrt_cert_no(((PatientEntity)patientEntity.getData()).getCardNo());
                patientInfoRequest.setMdtrt_cert_type("02");
                patientInfoRequest.setTenantId(Integer.valueOf(1));
                logger.info("\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0\u548c\u4e0a\u6b21\u8bca\u65ad,1101\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)patientInfoRequest));
                ResponseData hsPatientInfo = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
                logger.info("\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0\u548c\u4e0a\u6b21\u8bca\u65ad,1101\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)hsPatientInfo));
                if (Objects.isNull(hsPatientInfo) || !hsPatientInfo.isSuccess()) {
                    medicalChronicRequest.setPsn_no("");
                } else {
                    BaseinfoEntity baseinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsPatientInfo.getData()).getOutput()).getBaseinfo();
                    medicalChronicRequest.setPsn_no(baseinfo.getPsn_no());
                }
            }
            if (StringUtil.isNotEmpty((String)medicalChronicRequest.getPsn_no())) {
                medicalChronicRequest.setTenantId(Integer.valueOf(1));
                ResponseData responseData = this.hsServiceFeign.medicalChronic(medicalChronicRequest);
                if (!Objects.isNull(responseData) && responseData.isSuccess() && !Objects.isNull(((HsBaseResponse)responseData.getData()).getOutput())) {
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add(((HsBaseResponse)responseData.getData()).getOutput());
                    logger.info(jsonArray.toJSONString());
                    List list = (List)jsonArray.get(0);
                    LinkedHashMap linkedHashMap = (LinkedHashMap)list.get(0);
                    List list1 = (List)linkedHashMap.get("feedetail");
                    gytPatientNarrative.setMedicalChronicList(list1);
                }
            } else {
                gytPatientNarrative.setMedicalChronicList(null);
            }
        }
        return ResponseData.success((Object)gytPatientNarrative);
    }

    @GetMapping(value={"/queryNarrativeList"})
    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u5386\u53f2\u4e3b\u8ff0\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u60a3\u8005\u5386\u53f2\u4e3b\u8ff0\u5217\u8868")
    public ResponseData queryNarrativeList(Integer patientId) {
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List list = this.gytPatientNarrativeService.queryNarrativeList(patientId);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/queryNarrativeBySessionId"})
    @ApiOperation(value="\u901a\u8fc7\u4f1a\u8bddid\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0", httpMethod="GET", notes="\u901a\u8fc7\u4f1a\u8bddid\u67e5\u8be2\u60a3\u8005\u4e3b\u8ff0")
    public ResponseData queryNarrativeBySessionId(Integer sessionId) {
        if (sessionId == null) {
            return ResponseData.error((String)"\u4f1a\u8bddid\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        GytPatientNarrativeEntity gytPatientNarrativeEntity = this.gytPatientNarrativeService.queryNarrativeBySessionId(sessionId);
        QueryWrapper outDiagnosis = new QueryWrapper();
        outDiagnosis.eq((Object)"tenant_id", (Object)1);
        outDiagnosis.eq((Object)"outpatient_no", (Object)gytPatientNarrativeEntity.getOutpatientNo());
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
        GytPatientNarrativeSessionVo gytPatientNarrativeSessionVo = new GytPatientNarrativeSessionVo();
        BeanUtils.copyProperties((Object)gytPatientNarrativeEntity, (Object)gytPatientNarrativeSessionVo);
        gytPatientNarrativeSessionVo.setIsDiagnosis(Boolean.valueOf(!outMedicalRecordDiagnoses.isEmpty()));
        return ResponseData.success((Object)gytPatientNarrativeSessionVo);
    }

    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u8bca\u65ad")
    @GetMapping(value={"/selectDiagnosisByOutpatientNo"})
    public ResponseData selectDiagnosisByOutpatientNo(String outpatientNo) {
        if (outpatientNo == null) {
            return ResponseData.error((String)"\u95e8\u8bca\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        QueryWrapper outDiagnosis = new QueryWrapper();
        outDiagnosis.eq((Object)"tenant_id", (Object)1);
        outDiagnosis.eq((Object)"outpatient_no", (Object)outpatientNo);
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
        return ResponseData.success((Object)outMedicalRecordDiagnoses);
    }

    @PostMapping(value={"/addFlow"})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1\u7533\u8bf7\u6750\u6599", httpMethod="POST", notes="\u65b0\u589e\u836f\u54c1\u7533\u8bf7\u6750\u6599")
    public ResponseData addFlow(@RequestBody JSONObject jsonObject) {
        logger.info("\u65b0\u589e\u836f\u54c1\u7533\u8bf7\u6750\u6599,\u5165\u53c2:" + jsonObject.toJSONString());
        OutPatientRecordTempEntity copy = (OutPatientRecordTempEntity)JSON.parseObject((String)jsonObject.toJSONString(), OutPatientRecordTempEntity.class);
        Long id = jsonObject.getLong("id");
        logger.info("id" + id);
        copy.setId(id);
        OutPatientRecordTempEntity outPatientRecordTemp = (OutPatientRecordTempEntity)this.outPatientRecordTempMapper.selectById((Serializable)id);
        copy.setApprovalIdentify(ApprovalIdentifyType.NO_APPROVE.getCode());
        if (Objects.isNull(outPatientRecordTemp)) {
            copy.setCreateTime(new Date());
            copy.setUserId(jsonObject.getString("userId"));
            this.outPatientRecordTempMapper.insertOutPatientRecordTemp(copy);
        } else {
            copy.setUpdateTime(new Date());
            this.outPatientRecordTempMapper.updateById((Object)copy);
        }
        return ResponseData.success();
    }

    @PostMapping(value={"/deleteFlow"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u7533\u8bf7\u6750\u6599", httpMethod="POST", notes="\u5220\u9664\u836f\u54c1\u7533\u8bf7\u6750\u6599")
    public ResponseData deleteFlow(@RequestBody JSONObject jsonObject) {
        logger.info("\u5220\u9664\u836f\u54c1\u7533\u8bf7\u6750\u6599,\u5165\u53c2:" + jsonObject.toJSONString());
        Long id = jsonObject.getLong("id");
        OutPatientRecordTempEntity outPatientRecordTemp = (OutPatientRecordTempEntity)this.outPatientRecordTempMapper.selectById((Serializable)id);
        if (!Objects.isNull(outPatientRecordTemp) && outPatientRecordTemp.getApprovalIdentify().equals(ApprovalIdentifyType.NO_APPROVE.getCode())) {
            this.outPatientRecordTempMapper.deleteById((Serializable)id);
        }
        return ResponseData.success();
    }

    @PostMapping(value={"/wxPayRefundNotify"})
    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u56de\u8c03", httpMethod="POST", notes="\u5fae\u4fe1\u652f\u4ed8\u9000\u6b3e\u56de\u8c03")
    public ResponseData wxPayRefundNotify(@RequestBody JSONObject jsonObject) {
        return this.outPayService.wxPayRefundNotify(jsonObject);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u9996\u8bca\u60a3\u8005")
    @GetMapping(value={"/queryFirstVisit"})
    public ResponseData queryFirstVisit(String patientId) {
        List list = this.outOrderService.queryFirstVisitByPatientId(patientId);
        return ResponseData.success((Object)list);
    }

    @ApiOperation(value="\u9662\u5185\u5927\u5c4f\u6570\u636e")
    @GetMapping(value={"/queryLargeScreenInfo"})
    public ResponseData queryLargeScreenInfo() {
        return ResponseData.success((Object)this.outOrderService.queryLargeScreenInfo());
    }

    public netHospitalController(OutOrderPaymentService outOrderPaymentService, ScheduleService scheduleService, OutpatientTypeService outpatientTypeService, AdmissionService admissionService, OutPayService outPayService, OutOrderService outOrderService, SelfHelpService selfHelpService, OutDoctorTypeService outDoctorTypeService, SysServiceFeign sysServiceFeign, OutOrderPaymentMapper outOrderPaymentMapper, GytgytPatientNarrativeService gytPatientNarrativeService, OutMedicalRecordDiagnosisService outMedicalRecordDiagnosisService, OutDoctorRegFeeService outDoctorRegFeeService) {
        this.outOrderPaymentService = outOrderPaymentService;
        this.scheduleService = scheduleService;
        this.outpatientTypeService = outpatientTypeService;
        this.admissionService = admissionService;
        this.outPayService = outPayService;
        this.outOrderService = outOrderService;
        this.selfHelpService = selfHelpService;
        this.outDoctorTypeService = outDoctorTypeService;
        this.sysServiceFeign = sysServiceFeign;
        this.outOrderPaymentMapper = outOrderPaymentMapper;
        this.gytPatientNarrativeService = gytPatientNarrativeService;
        this.outMedicalRecordDiagnosisService = outMedicalRecordDiagnosisService;
        this.outDoctorRegFeeService = outDoctorRegFeeService;
    }
}

