/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.model.OutCustomerServiceSettingsEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksVo;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.SysParamVo;
import com.byh.outpatient.api.vo.TaskByDispense;
import com.byh.outpatient.api.vo.TaskByDrugVo;
import com.byh.outpatient.api.vo.TaskByPatientVo;
import com.byh.outpatient.api.vo.prescription.WesternMedicineDrugsVo;
import com.byh.outpatient.data.repository.OutCustomerServiceSettingsMapper;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.OutFollowUpTasksService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutFollowUpTasksServiceImpl
implements OutFollowUpTasksService {
    @Resource
    private OutFollowUpTasksMapper outFollowUpTasksMapper;
    @Autowired
    private OutCustomerServiceSettingsMapper customerServiceSettingsMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;

    public void outFollowUpTasksSave(OutFollowUpTasksEntity entity) {
        int a = this.outFollowUpTasksMapper.outFollowUpTasksSave(entity);
    }

    public PageInfo<OutFollowUpTasksEntity> outFollowUpTasksSelect(OutFollowUpTasksEntity entity) {
        ResponseData followGroupLeader = this.sysServiceFeign.sysParamSelectByName("follow_group_leader", entity.getTenantId());
        String value = ((SysParamVo)followGroupLeader.getData()).getValue();
        List<String> ids = Arrays.asList(value.split(","));
        if (ids.contains(entity.getReqUserId() + "")) {
            entity.setIsGroupLeader(Integer.valueOf(1));
        }
        PageHelper.startPage((int)entity.getCurrent(), (int)entity.getSize());
        List list = this.outFollowUpTasksMapper.outFollowUpTasksSelect(entity);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public List<OutFollowUpTasksVo> queryTaskDetail(OutFollowUpTasksEntity entity) throws ParseException {
        List outFollowUpTasksVos = this.outFollowUpTasksMapper.queryTaskDetail(entity);
        if (outFollowUpTasksVos.size() > 0) {
            OutFollowUpTasksVo outFollowUpTasksVo = (OutFollowUpTasksVo)outFollowUpTasksVos.get(0);
            List drugList = outFollowUpTasksVo.getDrugList();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String timeStr = format.format(new Date());
            Calendar calendar = Calendar.getInstance();
            Date nowDay = format.parse(timeStr);
            List taskByPatientVos = this.outFollowUpTasksMapper.queryDispenseDateByTaskDetail(entity);
            ArrayList list = new ArrayList();
            for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
                for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                    String voDrugNo = drugVo.getDrugNo();
                    for (WesternMedicineDrugsVo westernMedicineDrugsVo : drugList) {
                        String drugNo = westernMedicineDrugsVo.getDrugNo();
                        if (!voDrugNo.equals(drugNo)) continue;
                        List dispenseList = drugVo.getDispenseList();
                        String dispenseDate = null;
                        String followUpDate = null;
                        Integer medicationDays = null;
                        String remark = null;
                        for (int i = 0; i < dispenseList.size(); ++i) {
                            long followUpDateL;
                            TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                            String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                            String voFollowUpDate = taskByDispense.getFollowUpDate();
                            Integer voMedicationDays = taskByDispense.getMedicationDays();
                            if (dispenseDate == null) {
                                dispenseDate = voDispenseDateTime;
                                followUpDate = voFollowUpDate.substring(0, 10);
                                medicationDays = voMedicationDays;
                                continue;
                            }
                            long dspenseDateL = format.parse(dispenseDate).getTime();
                            if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                            medicationDays = ((TaskByDispense)dispenseList.get(i - 1)).getMedicationDays() + taskByDispense.getMedicationDays();
                            dispenseDate = voDispenseDateTime;
                            calendar.setTime(format.parse(voDispenseDateTime));
                            calendar.add(5, medicationDays);
                            followUpDate = format.format(calendar.getTime());
                            remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                        }
                        if (!StringUtils.isNotBlank(followUpDate)) continue;
                        westernMedicineDrugsVo.setEndTime(followUpDate);
                        westernMedicineDrugsVo.setRemark(remark);
                        westernMedicineDrugsVo.setTotalMedicationDays(medicationDays + "");
                    }
                }
            }
        }
        return outFollowUpTasksVos;
    }

    public void outFollowUpTasksUpdate(OutFollowUpTasksEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        entity.setFinishTime(format.format(new Date()));
        int a = this.outFollowUpTasksMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(OutFollowUpTasksEntity::getId, (Object)entity.getId()));
        Integer isEnd = entity.getIsEnd();
        if (isEnd == 1) {
            OutCustomerServiceSettingsEntity customer = new OutCustomerServiceSettingsEntity();
            customer.setEnable(Integer.valueOf(0));
            this.customerServiceSettingsMapper.update((Object)customer, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutCustomerServiceSettingsEntity::getPatientId, (Object)entity.getPatientId())).eq(OutCustomerServiceSettingsEntity::getTenantId, (Object)entity.getTenantId()));
        }
    }

    public void outFollowUpTasksDelete(OutFollowUpTasksEntity entity) {
        int a = this.outFollowUpTasksMapper.outFollowUpTasksDelete(entity);
    }
}

