/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.medicalRecord.QueryHistoricalDiagnosisVo;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.service.OutMedicalRecordDiagnosisService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutMedicalRecordDiagnosisServiceImpl
implements OutMedicalRecordDiagnosisService {
    @Autowired
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    private static Logger log = LoggerFactory.getLogger(OutMedicalRecordDiagnosisServiceImpl.class);

    public ResponseData updateMedicalRecordDiagnosis(Integer tenantId, Integer patientId, String outpatientNo, List<OutMedicalRecordDiagnosis> outMedicalRecordDiagnosisList) {
        if (tenantId == null || patientId == null || CollectionUtils.isEmpty(outMedicalRecordDiagnosisList)) {
            throw new RunDisplayException("\u66f4\u65b0\u75c5\u5386\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        log.info("\u66f4\u65b0\u75c5\u5386\u8bca\u65ad-\u95e8\u8bca\u53f7:{}-\u60a3\u8005ID:{}", (Object)outpatientNo, (Object)patientId);
        QueryWrapper delOutDiagnosis = new QueryWrapper();
        delOutDiagnosis.eq((Object)"tenant_id", (Object)tenantId);
        delOutDiagnosis.eq((Object)"patient_id", (Object)patientId);
        delOutDiagnosis.eq((Object)"outpatient_no", (Object)outpatientNo);
        this.outMedicalRecordDiagnosisMapper.delete((Wrapper)delOutDiagnosis);
        Integer size = this.outMedicalRecordDiagnosisMapper.batchInsert(outMedicalRecordDiagnosisList);
        System.out.printf("size" + size, new Object[0]);
        return ResponseData.success();
    }

    public List<OutMedicalRecordDiagnosis> queryMedicalRecordDiagnosis(Integer tenantId, Integer patientId, String outpatientNo) {
        if (tenantId == null || patientId == null) {
            throw new RunDisplayException("\u67e5\u8be2\u75c5\u5386\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outDiagnosis = new QueryWrapper();
        outDiagnosis.eq((Object)"tenant_id", (Object)tenantId);
        outDiagnosis.eq((Object)"patient_id", (Object)patientId);
        outDiagnosis.eq((Object)"outpatient_no", (Object)outpatientNo);
        return this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
    }

    public List<OutMedicalRecordDiagnosis> queryMedicalRecordDiagnosisByOutpatientNo(Integer tenantId, String outpatientNo) {
        if (tenantId == null) {
            throw new RunDisplayException("\u67e5\u8be2\u75c5\u5386\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper outDiagnosis = new QueryWrapper();
        outDiagnosis.eq((Object)"tenant_id", (Object)tenantId);
        outDiagnosis.eq((Object)"outpatient_no", (Object)outpatientNo);
        return this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
    }

    public List<QueryHistoricalDiagnosisVo> queryHistoricalDiagnosis(Integer tenantId, Integer patientId, Integer outMedicalDiagnosisType) {
        if (tenantId == null || patientId == null) {
            throw new RunDisplayException("\u67e5\u8be2\u75c5\u5386\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.outMedicalRecordDiagnosisMapper.queryHistoricalDiagnosis(tenantId, patientId, outMedicalDiagnosisType);
    }
}

