/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.outpatient.api.constants.BusinessConstant;
import com.byh.outpatient.api.dto.order.FeeManagemenDto;
import com.byh.outpatient.api.dto.order.PaymentOrderUpdateDTO;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsDto;
import com.byh.outpatient.api.dto.order.QueryFeeDetailsListDto;
import com.byh.outpatient.api.dto.order.QueryOrderDto;
import com.byh.outpatient.api.dto.order.SaveOrderDto;
import com.byh.outpatient.api.enums.DeliveryStatusEnum;
import com.byh.outpatient.api.enums.OperationTypeEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PaymentTypeEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.order.OutOrderPaymentRecord;
import com.byh.outpatient.api.model.order.WisOutOrder;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.treatment.OutTreatmentItems;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.netHospital.DiseaseVo;
import com.byh.outpatient.api.vo.netHospital.KeyValueStringVo;
import com.byh.outpatient.api.vo.netHospital.LargeScreenVo;
import com.byh.outpatient.api.vo.netHospital.NdzsrVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsListVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsVo;
import com.byh.outpatient.api.vo.order.QueryFeeManagementVo;
import com.byh.outpatient.api.vo.order.QueryFeeOrderPaidItemsVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentRecordMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutTreatmentDetailsMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.web.feign.SdkServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.RedisUtil;
import com.byh.outpatient.web.service.OutOrderService;
import com.byh.outpatient.web.service.impl.OutOrderServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OutOrderServiceImpl
implements OutOrderService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutTreatmentDetailsMapper outTreatmentDetailsMapper;
    @Autowired
    private OutTreatmentItemsMapper outTreatmentItemsMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    private static Logger log = LoggerFactory.getLogger(OutOrderServiceImpl.class);
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutOrderPaymentRecordMapper outOrderPaymentRecordMapper;
    @Autowired
    private SdkServiceFeign sdkServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;

    public void saveOrder(OrderTypeEnum orderTypeEnum, SaveOrderDto saveOrderDto) {
        log.info("\u8ba2\u5355\u4fdd\u5b58 -->>\u7c7b\u578b:{}\u4f20\u53c2:{}", (Object)orderTypeEnum.getDesc(), (Object)JSON.toJSONString((Object)saveOrderDto));
        OutOrder order = new OutOrder();
        order.setOrderAmount(saveOrderDto.getOrderAmount());
        order.setActualOtherPayment(saveOrderDto.getActualOtherPayment());
        order.setAmount(order.getOrderAmount().add(order.getActualOtherPayment()));
        order.setTotalAmount(order.getAmount());
        order.setCreateId(saveOrderDto.getOperatorId());
        order.setTenantId(saveOrderDto.getTenantId());
        order.setOutpatientNo(saveOrderDto.getOutpatientNo());
        order.setOrderType(orderTypeEnum.getValue());
        order.setOrderEntryName(orderTypeEnum.getName());
        order.setPrescriptionNo(saveOrderDto.getPrescriptionNo());
        order.setStatus(OutpatientDataStatusEnum.NORMAL.getValue());
        order.setPatientId(saveOrderDto.getPatientId());
        order.setPatientName(saveOrderDto.getPatientName());
        order.setMedicalRecordNo(saveOrderDto.getMedicalRecordNo());
        order.setPaymentStatus("5".equals(saveOrderDto.getPrescriptionType()) ? PaymentStatusEnum.PAYMENT_REQUIRED.getValue() : PaymentStatusEnum.PAYMENT_PENDING.getValue());
        order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue());
        order.setRegTime(saveOrderDto.getRegTime());
        order.setPhone(saveOrderDto.getPhone());
        order.setPatientCardNo(saveOrderDto.getPatientCardNo());
        order.setSource(saveOrderDto.getSource());
        order.setRemark(saveOrderDto.getRemark());
        order.setSettleTypeCode(saveOrderDto.getSettleTypeCode());
        order.setSettleTypeName(saveOrderDto.getSettleTypeName());
        if (orderTypeEnum == OrderTypeEnum.REGISTERED_ORDINARY_ORDERS) {
            order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_REQUIRED.getValue());
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        query.eq((Object)"prescription_no", (Object)saveOrderDto.getPrescriptionNo());
        OutOrder outOrders = (OutOrder)this.outOrderMapper.selectOne((Wrapper)query);
        if (outOrders == null) {
            log.info("\u8ba2\u5355\u521b\u5efa-->\u65b0\u589e\u8ba2\u5355[\u5f00\u59cb]");
            String orderNo = UUIDUtils.getOrderNo();
            log.info("\u8ba2\u5355\u521b\u5efa-->>\u751f\u6210\u7684\u8ba2\u5355\u7f16\u53f7:{}", (Object)orderNo);
            order.setOrderNo(orderNo);
            order.setNumberCharges(BusinessConstant.ONE);
            Integer size = this.outOrderMapper.insert((Object)order);
            if (size < 1) {
                throw new RunDisplayException("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
            }
            if (orderTypeEnum == OrderTypeEnum.REGISTERED_ORDINARY_ORDERS) {
                AdmissionEntity admission = new AdmissionEntity();
                admission.setId(saveOrderDto.getAdmissionId());
                admission.setOrderNo(order.getOrderNo());
                this.admissionMapper.updateById((Object)admission);
            }
        } else {
            log.info("\u8ba2\u5355\u4fee\u6539-->>\u4fee\u6539\u7684\u7f16\u53f7:{}", (Object)outOrders.getId());
            order.setId(outOrders.getId());
            Integer size = this.outOrderMapper.updateById((Object)order);
            if (size < 1) {
                throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
            }
        }
    }

    public List<OutOrder> getOrderListByPrescriptionNos(List<String> orderType, List<String> prescriptionNos) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"order_type", orderType);
        queryWrapper.in((Object)"prescription_no", prescriptionNos);
        queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        List outOrders = this.outOrderMapper.selectList((Wrapper)queryWrapper);
        return outOrders;
    }

    public ResponseData<PageResult<QueryFeeManagementVo>> feeManagement(FeeManagemenDto parameter) {
        if (!StringUtil.isEmpty((String)parameter.getStarTime()) && !StringUtil.isEmpty((String)parameter.getEndTime())) {
            parameter.setStarTime(parameter.getStarTime() + " 00:00:00");
            parameter.setEndTime(parameter.getEndTime() + " 23:59:59");
        }
        PageHelper.startPage((int)parameter.getCurrent(), (int)parameter.getSize());
        List queryFeeManagementVos = this.outOrderMapper.feeManagement(parameter);
        PageInfo pageInfo = new PageInfo(queryFeeManagementVos);
        PageResult pageResult = new PageResult(parameter.getCurrent().intValue(), parameter.getSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(queryFeeManagementVos);
        pageResult.setCurrent(parameter.getCurrent().intValue());
        pageResult.setSize(parameter.getSize().intValue());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<QueryFeeDetailsVo> queryFeeDetails(QueryFeeDetailsDto parameter) {
        parameter.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
        QueryFeeDetailsVo queryFeeDetailsVo = this.outOrderMapper.queryFeeDetails(parameter);
        if (queryFeeDetailsVo == null) {
            return ResponseData.success((Object)new QueryFeeDetailsVo());
        }
        queryFeeDetailsVo.setPatientCardNo(null);
        queryFeeDetailsVo.setIsPrintReg(String.valueOf(this.redisUtil.get(parameter.getOutpatientNo() + "_isPrintReg")));
        return ResponseData.success((Object)queryFeeDetailsVo);
    }

    public ResponseData<QueryFeeDetailsVo> queryFeeDetailsByPatientId(QueryFeeDetailsDto parameter) {
        parameter.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
        QueryFeeDetailsVo queryFeeDetailsVo = this.outOrderMapper.queryFeeDetailsByPatientId(parameter);
        return ResponseData.success((Object)queryFeeDetailsVo);
    }

    public ResponseData<List<QueryFeeDetailsVo>> queryFeeDetailsByPId(QueryFeeDetailsDto parameter) {
        List queryFeeDetailsVos = this.outOrderMapper.queryFeeDetailsByPId(parameter);
        return ResponseData.success((Object)queryFeeDetailsVos);
    }

    public ResponseData<List<QueryFeeOrderPaidItemsVo>> queryFeePaidDetails(QueryFeeDetailsDto parameter) {
        parameter.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        List queryFeeOrderPaidItemsVos = this.outOrderMapper.queryFeeDetailsByProjectID(parameter);
        return ResponseData.success((Object)queryFeeOrderPaidItemsVos);
    }

    public ResponseData<List<QueryFeeDetailsListVo>> queryFeeDetailsByProjectID(QueryFeeDetailsListDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"order_no", (Object)parameter.getOrderNo());
        OutOrder order = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
        if (order == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8ba2\u5355!");
        }
        List<QueryFeeDetailsListVo> queryFeeDetailsListVoList = new ArrayList();
        switch (1.$SwitchMap$com$byh$outpatient$api$enums$OrderTypeEnum[OrderTypeEnum.getEnum((String)order.getOrderType()).ordinal()]) {
            case 1: {
                QueryFeeDetailsListVo queryFeeDetails = new QueryFeeDetailsListVo();
                queryFeeDetails.setMedicalInsuranceCode("");
                queryFeeDetails.setMedicalInsuranceName("");
                queryFeeDetails.setInsuranceDrugCode("");
                queryFeeDetails.setLevel("");
                queryFeeDetails.setName(OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getName());
                queryFeeDetails.setQuantity(new BigDecimal("1"));
                queryFeeDetails.setTotalDrugAmount(order.getTotalAmount());
                queryFeeDetails.setDrugPriceAmount(order.getTotalAmount());
                queryFeeDetailsListVoList.add(queryFeeDetails);
                break;
            }
            case 2: {
                queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                break;
            }
            case 3: {
                queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                break;
            }
            case 4: {
                queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                break;
            }
            case 5: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 6: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 7: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 8: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 9: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 10: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 11: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            case 12: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                break;
            }
            default: {
                queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                log.error("\u67e5\u8be2\u4e1a\u52a1\u8be6\u60c5\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u5904\u7406\u903b\u8f91");
            }
        }
        return ResponseData.success(queryFeeDetailsListVoList);
    }

    private List<QueryFeeDetailsListVo> getFeeDetailsListVos(OutOrder order) {
        QueryWrapper detailsQueryWrapper = new QueryWrapper();
        detailsQueryWrapper.eq((Object)"out_treatment_id", (Object)order.getPrescriptionNo());
        List outTreatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)detailsQueryWrapper);
        List<QueryFeeDetailsListVo> collected = outTreatmentDetailsList.stream().map(OutTreatmentDetails2 -> {
            QueryFeeDetailsListVo queryFeeDetailsListVo = new QueryFeeDetailsListVo();
            queryFeeDetailsListVo.setMedicalInsuranceCode(OutTreatmentDetails2.getMedicalInsuranceCode());
            queryFeeDetailsListVo.setMedicalInsuranceName(OutTreatmentDetails2.getMedicalInsuranceName());
            queryFeeDetailsListVo.setInsuranceDrugCode(OutTreatmentDetails2.getInsuranceCode());
            queryFeeDetailsListVo.setLevel(OutTreatmentDetails2.getLevel());
            queryFeeDetailsListVo.setName(OutTreatmentDetails2.getTreatmentName());
            queryFeeDetailsListVo.setQuantity(new BigDecimal(OutTreatmentDetails2.getQuantity()));
            queryFeeDetailsListVo.setTotalDrugAmount(OutTreatmentDetails2.getTotalAmount());
            queryFeeDetailsListVo.setDrugPriceAmount(OutTreatmentDetails2.getUnitPriceAmount());
            queryFeeDetailsListVo.setPaymentStatus(order.getPaymentStatus());
            return queryFeeDetailsListVo;
        }).collect(Collectors.toList());
        return collected;
    }

    private List<QueryFeeDetailsListVo> getQueryFeeDetailsListVos(OutOrder order) {
        QueryWrapper queryDrugWrapper = new QueryWrapper();
        queryDrugWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        queryDrugWrapper.eq((Object)"prescription_no", (Object)order.getPrescriptionNo());
        List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryDrugWrapper);
        ArrayList<QueryFeeDetailsListVo> queryFeeDetailsListVoList = new ArrayList<QueryFeeDetailsListVo>();
        for (OutPrescriptionDrug outPrescriptionDrug : outPrescriptionDrugs) {
            QueryFeeDetailsListVo queryFeeDetailsListVo = new QueryFeeDetailsListVo();
            BeanUtils.copyProperties((Object)outPrescriptionDrug, (Object)queryFeeDetailsListVo);
            queryFeeDetailsListVo.setName(outPrescriptionDrug.getDrugName());
            queryFeeDetailsListVo.setQuantityPerSticker(null);
            queryFeeDetailsListVo.setNumberOfStickers(Integer.valueOf(outPrescriptionDrug.getQuantity().intValue()));
            queryFeeDetailsListVo.setPaymentStatus(order.getPaymentStatus());
            queryFeeDetailsListVo.setSpec(outPrescriptionDrug.getSpecification());
            queryFeeDetailsListVoList.add(queryFeeDetailsListVo);
        }
        return queryFeeDetailsListVoList;
    }

    public List<QueryFeeDetailsListVo> queryFeeDetailsByOrderNo(List<String> orderNoList) {
        ArrayList<QueryFeeDetailsListVo> resultList = new ArrayList<QueryFeeDetailsListVo>();
        for (int i = 0; i < orderNoList.size(); ++i) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"order_no", (Object)orderNoList.get(i));
            OutOrder order = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
            List<QueryFeeDetailsListVo> queryFeeDetailsListVoList = new ArrayList();
            switch (1.$SwitchMap$com$byh$outpatient$api$enums$OrderTypeEnum[OrderTypeEnum.getEnum((String)order.getOrderType()).ordinal()]) {
                case 1: {
                    QueryFeeDetailsListVo queryFeeDetails = new QueryFeeDetailsListVo();
                    queryFeeDetails.setMedicalInsuranceCode("");
                    queryFeeDetails.setMedicalInsuranceName("");
                    queryFeeDetails.setInsuranceDrugCode("");
                    queryFeeDetails.setLevel("");
                    queryFeeDetails.setName(OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getName());
                    queryFeeDetails.setQuantity(new BigDecimal("1"));
                    queryFeeDetails.setTotalDrugAmount(order.getTotalAmount());
                    queryFeeDetails.setDrugPriceAmount(order.getTotalAmount());
                    queryFeeDetails.setPaymentStatus(order.getPaymentStatus());
                    queryFeeDetailsListVoList.add(queryFeeDetails);
                    break;
                }
                case 2: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 3: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 4: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 6: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 5: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 7: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 8: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 9: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 10: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 12: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                case 13: {
                    queryFeeDetailsListVoList = this.getFeeDetailsListVos(order);
                    break;
                }
                default: {
                    log.error("\u67e5\u8be2\u4e1a\u52a1\u8be6\u60c5\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u5904\u7406\u903b\u8f91");
                }
            }
            resultList.addAll(queryFeeDetailsListVoList);
        }
        return resultList;
    }

    public List<QueryFeeDetailsListVo> queryFeeItemByOrderNo(List<String> orderNoList) {
        ArrayList<QueryFeeDetailsListVo> resultList = new ArrayList<QueryFeeDetailsListVo>();
        for (int i = 0; i < orderNoList.size(); ++i) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"order_no", (Object)orderNoList.get(i));
            OutOrder order = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
            List<QueryFeeDetailsListVo> queryFeeDetailsListVoList = new ArrayList();
            switch (1.$SwitchMap$com$byh$outpatient$api$enums$OrderTypeEnum[OrderTypeEnum.getEnum((String)order.getOrderType()).ordinal()]) {
                case 1: {
                    QueryFeeDetailsListVo queryFeeDetails = new QueryFeeDetailsListVo();
                    queryFeeDetails.setMedicalInsuranceCode("");
                    queryFeeDetails.setMedicalInsuranceName("");
                    queryFeeDetails.setInsuranceDrugCode("");
                    queryFeeDetails.setLevel("");
                    queryFeeDetails.setName(OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getName());
                    queryFeeDetails.setQuantity(new BigDecimal("1"));
                    queryFeeDetails.setTotalDrugAmount(order.getTotalAmount());
                    queryFeeDetails.setDrugPriceAmount(order.getTotalAmount());
                    queryFeeDetails.setPaymentStatus(order.getPaymentStatus());
                    queryFeeDetailsListVoList.add(queryFeeDetails);
                    break;
                }
                case 2: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 3: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 4: {
                    queryFeeDetailsListVoList = this.getQueryFeeDetailsListVos(order);
                    break;
                }
                case 6: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 5: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 7: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 8: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 9: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 10: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 12: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 13: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                case 14: {
                    queryFeeDetailsListVoList = this.getFeeItemListVos(order);
                    break;
                }
                default: {
                    log.error("\u67e5\u8be2\u4e1a\u52a1\u8be6\u60c5\uff1a\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u578b\u5904\u7406\u903b\u8f91");
                }
            }
            resultList.addAll(queryFeeDetailsListVoList);
        }
        return resultList;
    }

    private List<QueryFeeDetailsListVo> getFeeItemListVos(OutOrder order) {
        QueryWrapper detailsQueryWrapper = new QueryWrapper();
        detailsQueryWrapper.eq((Object)"id", (Object)order.getPrescriptionNo());
        OutTreatmentItems outTreatmentItems = (OutTreatmentItems)this.outTreatmentItemsMapper.selectOne((Wrapper)detailsQueryWrapper);
        ArrayList<QueryFeeDetailsListVo> collected = new ArrayList<QueryFeeDetailsListVo>();
        QueryFeeDetailsListVo queryFeeDetailsListVo = new QueryFeeDetailsListVo();
        queryFeeDetailsListVo.setInsuranceDrugCode(outTreatmentItems.getItemsCode());
        queryFeeDetailsListVo.setName(outTreatmentItems.getName());
        queryFeeDetailsListVo.setQuantity(new BigDecimal(outTreatmentItems.getQuantity()));
        queryFeeDetailsListVo.setTotalDrugAmount(outTreatmentItems.getTotalAmount());
        queryFeeDetailsListVo.setDrugPriceAmount(outTreatmentItems.getUnitPriceAmount());
        queryFeeDetailsListVo.setPaymentStatus(order.getPaymentStatus());
        collected.add(queryFeeDetailsListVo);
        return collected;
    }

    public ResponseData<List<OutOrder>> queryByPresNoAndOutNo(QueryOrderDto parameter) {
        String outpatientNo = parameter.getOutpatientNo();
        String prescriptionNo = parameter.getPrescriptionNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outpatient_no", (Object)outpatientNo);
        queryWrapper.eq(Objects.nonNull(prescriptionNo), (Object)"prescription_no", (Object)prescriptionNo);
        if (OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(parameter.getOrderType() + "")) {
            queryWrapper.eq((Object)"order_type", (Object)parameter.getOrderType());
        }
        List outOrders = this.outOrderMapper.selectList((Wrapper)queryWrapper);
        return ResponseData.success((Object)outOrders);
    }

    public ResponseData<List<OutOrder>> queryByMainIdAndOutNo(QueryOrderDto parameter) {
        String outpatientNo = parameter.getOutpatientNo();
        String mainId = parameter.getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"outpatient_no", (Object)outpatientNo);
        if (OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(parameter.getOrderType() + "")) {
            queryWrapper.eq((Object)"order_type", (Object)parameter.getOrderType());
            List outOrders = this.outOrderMapper.selectList((Wrapper)queryWrapper);
            return ResponseData.success((Object)outOrders);
        }
        QueryWrapper prescriptionQueryWrapper = new QueryWrapper();
        prescriptionQueryWrapper.eq((Object)"outpatient_no", (Object)outpatientNo);
        prescriptionQueryWrapper.eq((Object)"main_id", (Object)mainId);
        List prescriptionList = this.outPrescriptionMapper.selectList((Wrapper)prescriptionQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)prescriptionList)) {
            return ResponseData.error((String)("\u5904\u65b9\u67e5\u65b0\u4e3a\u7a7a,mainId:" + mainId));
        }
        List prescriptionNoList = prescriptionList.stream().map(x -> x.getPrescriptionNo()).collect(Collectors.toList());
        queryWrapper.in((Object)"prescription_no", prescriptionNoList);
        List outOrders = this.outOrderMapper.selectList((Wrapper)queryWrapper);
        return ResponseData.success((Object)outOrders);
    }

    public ResponseData<List<WisOutOrder>> queryByWaitPayByPatientId(Integer patientId, Integer tenant) {
        return ResponseData.success((Object)this.outOrderMapper.queryOrderByPatientId(patientId, tenant));
    }

    public ResponseData<QueryFeeDetailsVo> wisQueryFeeDetailsByOrderNo(QueryFeeDetailsDto parameter) {
        parameter.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
        QueryFeeDetailsVo queryFeeDetailsVo = this.outOrderMapper.queryFeeDetailsByOrderNo(parameter);
        if (queryFeeDetailsVo == null) {
            return ResponseData.success((Object)new QueryFeeDetailsVo());
        }
        return ResponseData.success((Object)queryFeeDetailsVo);
    }

    public ResponseData<QueryFeeDetailsVo> queryItemInfoByOutpatientNo(QueryFeeDetailsDto parameter) {
        QueryFeeDetailsVo queryFeeDetailsVo = this.outOrderMapper.queryItemInfoByOutpatientNo(parameter);
        if (queryFeeDetailsVo == null) {
            return ResponseData.success((Object)new QueryFeeDetailsVo());
        }
        return ResponseData.success((Object)queryFeeDetailsVo);
    }

    @Transactional
    public ResponseData paymentOrderUpdate(PaymentOrderUpdateDTO dto) {
        Integer size;
        QueryWrapper orderQuery = new QueryWrapper();
        orderQuery.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        orderQuery.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
        orderQuery.eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrders = this.outOrderMapper.selectList((Wrapper)orderQuery);
        if (outOrders != null && !outOrders.isEmpty()) {
            for (OutOrder outOrder : outOrders) {
                OutOrder order = new OutOrder();
                log.info("\u652f\u4ed8\u5b8c\u6210\u66f4\u65b0\u652f\u4ed8\u72b6\u6001 \u8ba2\u5355id:{}", (Object)outOrder.getId());
                order.setId(outOrder.getId());
                order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
                order.setDeliveryStatus(dto.getDeliveryStatus());
                size = this.outOrderMapper.updateById((Object)order);
                if (size < 1) {
                    throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
                }
                QueryWrapper recordQueryWrapper = new QueryWrapper();
                recordQueryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                recordQueryWrapper.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
                recordQueryWrapper.eq((Object)"payment_type", (Object)PaymentTypeEnum.ONLINE_PAYMENT.getValue());
                OutOrderPaymentRecord orderPaymentRecord = (OutOrderPaymentRecord)this.outOrderPaymentRecordMapper.selectOne((Wrapper)recordQueryWrapper);
                OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
                outOrderPaymentRecord.setTenantId(Integer.valueOf(1));
                outOrderPaymentRecord.setOrderNo(outOrder.getOrderNo());
                outOrderPaymentRecord.setPayOrderNo(dto.getOutTradeNo());
                outOrderPaymentRecord.setTransactionNumber(dto.getTransactionId());
                outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
                outOrderPaymentRecord.setStatus(Integer.valueOf(1));
                outOrderPaymentRecord.setAmount(outOrder.getAmount());
                outOrderPaymentRecord.setTotalAmount(outOrder.getTotalAmount());
                outOrderPaymentRecord.setActualPayment(outOrder.getActualPayment());
                outOrderPaymentRecord.setPaymentMethod(PaymentMethodEnum.PAY_WECHAT.getValue());
                outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
                outOrderPaymentRecord.setDeliveryStatus(outOrder.getDeliveryStatus());
                outOrderPaymentRecord.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
                outOrderPaymentRecord.setPaymentTime(dto.getPayTime());
                outOrderPaymentRecord.setTransactionNumber(dto.getTransactionId());
                outOrderPaymentRecord.setCheckerId(Integer.valueOf(9001));
                outOrderPaymentRecord.setCheckerName("XHY");
                outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
                if (orderPaymentRecord != null) {
                    outOrderPaymentRecord.setId(orderPaymentRecord.getId());
                    this.outOrderPaymentRecordMapper.updateById((Object)outOrderPaymentRecord);
                    continue;
                }
                this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
            }
        }
        QueryWrapper orderPaymentQuery = new QueryWrapper();
        orderPaymentQuery.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        orderPaymentQuery.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
        orderPaymentQuery.eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        OutOrderPayment outOrderPayment1 = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)orderPaymentQuery);
        if (outOrderPayment1 != null) {
            OutOrderPayment outOrderPayment = new OutOrderPayment();
            outOrderPayment.setId(outOrderPayment1.getId());
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_WECHAT.getValue());
            outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderPayment.setPayChannel("WX");
            outOrderPayment.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
            outOrderPayment.setSettlementMethod(SettlementMethodEnum.STATUS_SELF_FUNDED.getValue());
            outOrderPayment.setPaymentTransactionNo(dto.getTransactionId());
            outOrderPayment.setPaymentTime(dto.getPayTime());
            outOrderPayment.setCheckerId(Integer.valueOf(9001));
            outOrderPayment.setCheckerName("XHY");
            size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
            if (size < 1) {
                throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
            }
        }
        if ("2".equals(dto.getDeliverystationno()) || "4".equals(dto.getDeliverystationno())) {
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            orderQueryWrapper.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)orderQueryWrapper);
            if (outOrder != null) {
                SysEasyEntity sysEasyEntity = new SysEasyEntity();
                sysEasyEntity.setId(outOrder.getOutpatientNo());
                ArrayList<String> list = new ArrayList<String>();
                list.add(outOrder.getPrescriptionNo());
                sysEasyEntity.setIds(list.toArray(new String[list.size()]));
                if (dto.getDeliverystationno().equals("2")) {
                    sysEasyEntity.setBakValue(dto.getBakValue());
                    sysEasyEntity.setSourceName(dto.getSourceName());
                    this.sdkServiceFeign.printerReceiptByHy(sysEasyEntity);
                } else if (dto.getDeliverystationno().equals("4")) {
                    sysEasyEntity.setBakJsonStr(dto.getBakJsonStr());
                    this.sdkServiceFeign.printerReceiptDelivery(sysEasyEntity);
                }
            }
        }
        return ResponseData.success();
    }

    public ResponseData regOrderUpdate(PaymentOrderUpdateDTO dto) {
        QueryWrapper orderQuery = new QueryWrapper();
        orderQuery.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        orderQuery.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
        orderQuery.eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        orderQuery.eq((Object)"order_type", (Object)OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue());
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)orderQuery);
        OutOrder order = new OutOrder();
        log.info("\u652f\u4ed8\u5b8c\u6210\u66f4\u65b0\u652f\u4ed8\u72b6\u6001 \u8ba2\u5355id:{}", (Object)outOrder.getId());
        order.setId(outOrder.getId());
        order.setActualPayment(outOrder.getTotalAmount());
        order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        order.setDeliveryStatus(dto.getDeliveryStatus());
        Integer size = this.outOrderMapper.updateById((Object)order);
        if (size < 1) {
            throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
        }
        QueryWrapper orderPaymentQuery = new QueryWrapper();
        orderPaymentQuery.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        orderPaymentQuery.eq((Object)"pay_order_no", (Object)dto.getOutTradeNo());
        orderPaymentQuery.eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        OutOrderPayment outOrderPayment1 = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)orderPaymentQuery);
        if (outOrderPayment1 != null) {
            OutOrderPayment outOrderPayment = new OutOrderPayment();
            outOrderPayment.setId(outOrderPayment1.getId());
            outOrderPayment.setActualPayment(outOrderPayment1.getTotalAmount());
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_WECHAT.getValue());
            outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderPayment.setPayChannel("WX");
            outOrderPayment.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
            outOrderPayment.setSettlementMethod(SettlementMethodEnum.STATUS_SELF_FUNDED.getValue());
            outOrderPayment.setPaymentTransactionNo(dto.getTransactionId());
            outOrderPayment.setPaymentTime(dto.getPayTime());
            outOrderPayment.setCheckerId(Integer.valueOf(9001));
            outOrderPayment.setCheckerName("XHY");
            Integer size1 = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
            if (size1 < 1) {
                throw new RunDisplayException("\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
            }
        }
        return ResponseData.success();
    }

    public List<OutOrder> queryFirstVisitByPatientId(String patientId) {
        QueryWrapper outOrder = new QueryWrapper();
        outOrder.eq((Object)"tenant_id", (Object)1);
        outOrder.eq((Object)"patient_id", (Object)patientId);
        outOrder.eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrder.ne((Object)"order_type", (Object)OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue());
        return this.outOrderMapper.selectList((Wrapper)outOrder);
    }

    public LargeScreenVo queryLargeScreenInfo() {
        LargeScreenVo largeScreenVo = new LargeScreenVo();
        String zsr = this.outOrderPaymentMapper.querySr("1", null);
        String dyzsr = this.outOrderPaymentMapper.querySr("1", "1");
        String jzrc = this.outOrderPaymentMapper.queryJzrc("1");
        String dykfsl = this.outOrderPaymentMapper.queryKfsl("1", "1");
        List list = this.outOrderPaymentMapper.queryndzsrList("1");
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                NdzsrVo ndzsrVo = (NdzsrVo)list.get(i);
                if (i == 0) {
                    ndzsrVo.setOnYear("0");
                    continue;
                }
                NdzsrVo lastndzsrVo = (NdzsrVo)list.get(i - 1);
                BigDecimal b1 = new BigDecimal(ndzsrVo.getValue());
                BigDecimal b2 = new BigDecimal(lastndzsrVo.getValue());
                ndzsrVo.setOnYear(b1.subtract(b2).divide(b2, 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).toString());
            }
        }
        ArrayList<DiseaseVo> diseaseVoList = new ArrayList<DiseaseVo>();
        List jzrcList = this.outOrderPaymentMapper.queryJzrcList();
        if (Objects.nonNull(jzrcList)) {
            for (KeyValueStringVo keyValueVo : jzrcList) {
                DiseaseVo diseaseVo = new DiseaseVo();
                diseaseVo.setName(keyValueVo.getKey());
                diseaseVo.setNumber(keyValueVo.getValue());
                ArrayList<String> stringList = new ArrayList<String>();
                if (keyValueVo.getKey().equals("\u6162\u75c5")) {
                    stringList.add("\u9ad8\u8840\u538b");
                    stringList.add("\u7cd6\u5c3f\u75c5");
                    stringList.add("\u98ce\u6e7f");
                } else if (keyValueVo.getKey().equals("\u80bf\u7624")) {
                    stringList.add("\u4e73\u817a");
                    stringList.add("\u809d\u75c5");
                    stringList.add("\u8840\u6db2");
                } else if (keyValueVo.getKey().equals("\u80be\u5185")) {
                    stringList.add("\u5c3f\u6bd2\u75c7");
                    stringList.add("\u80be\u8870\u7aed");
                    stringList.add("\u6162\u6027\u80be\u810f\u75c5");
                }
                String str = "";
                if (!stringList.isEmpty()) {
                    str = String.join((CharSequence)",", stringList);
                }
                List list1 = this.outOrderPaymentMapper.queryInfo(str);
                if (keyValueVo.getKey().equals("\u7ebf\u4e0b\u95e8\u8bca")) {
                    stringList.add("\u897f\u533b");
                    stringList.add("\u4e2d\u533b/\u5eb7\u590d\u7406\u7597");
                }
                ArrayList<KeyValueStringVo> list2 = new ArrayList<KeyValueStringVo>();
                for (String s : stringList) {
                    KeyValueStringVo vo = new KeyValueStringVo();
                    vo.setKey(s);
                    if (!list1.isEmpty()) {
                        Long value = list1.stream().filter(vo1 -> vo1.getKey().contains(s)).count();
                        vo.setValue(String.valueOf(value));
                    } else {
                        vo.setValue("0");
                    }
                    list2.add(vo);
                }
                diseaseVo.setNameDistributionList(list2);
                ArrayList<KeyValueStringVo> ageList = new ArrayList<KeyValueStringVo>();
                for (int i = 0; i <= 2; ++i) {
                    KeyValueStringVo keyValueVo1 = new KeyValueStringVo();
                    int x = 35;
                    int y = 65;
                    switch (i) {
                        case 0: {
                            keyValueVo1.setKey(x + "\u5c81\u4ee5\u4e0b");
                            break;
                        }
                        case 1: {
                            keyValueVo1.setKey(x + "\u5c81-" + y + "\u5c81");
                            break;
                        }
                        case 2: {
                            keyValueVo1.setKey(y + "\u5c81\u4ee5\u4e0a");
                            break;
                        }
                    }
                    if (!list1.isEmpty()) {
                        String value1;
                        switch (i) {
                            case 0: {
                                value1 = new BigDecimal(list1.stream().filter(o -> Integer.parseInt(o.getValue()) < x).count()).divide(new BigDecimal(list1.size()), 2, 5).multiply(new BigDecimal("100")).toString();
                                break;
                            }
                            case 1: {
                                value1 = new BigDecimal(list1.stream().filter(o -> Integer.parseInt(o.getValue()) >= x && Integer.parseInt(o.getValue()) <= y).count()).divide(new BigDecimal(list1.size()), 2, 5).multiply(new BigDecimal("100")).toString();
                                break;
                            }
                            case 2: {
                                value1 = new BigDecimal(list1.stream().filter(o -> Integer.parseInt(o.getValue()) > y).count()).divide(new BigDecimal(list1.size()), 2, 5).multiply(new BigDecimal("100")).toString();
                                break;
                            }
                            default: {
                                value1 = new BigDecimal("0").toString();
                            }
                        }
                        keyValueVo1.setValue(value1);
                    } else {
                        keyValueVo1.setValue("0");
                    }
                    ageList.add(keyValueVo1);
                }
                diseaseVo.setAgeDistributionList(ageList);
                diseaseVoList.add(diseaseVo);
            }
        }
        largeScreenVo.setZsr(zsr);
        largeScreenVo.setDyzsr(dyzsr);
        largeScreenVo.setJzrc(jzrc);
        largeScreenVo.setDykfsl(dykfsl);
        largeScreenVo.setNdzsrList(list);
        largeScreenVo.setJzrsList(diseaseVoList);
        return largeScreenVo;
    }
}

