/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.byh.sdk.entity.FEEntity;
import com.byh.sdk.entity.drug.SysEasyEntity;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.entity.ve.OutPrescriptionDrug;
import com.byh.sdk.mapper.OutPrescriptionDrugMapper;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.service.FPrinterService;
import com.byh.sdk.util.BeanUtil;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.ExceptionUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FPrinterServiceImpl
implements FPrinterService {
    private static final Logger log = LoggerFactory.getLogger(FPrinterServiceImpl.class);
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;

    public void printerReceipt(SysEasyEntity entity) {
        String[] ids;
        String prescriptionId = this.outPrescriptionDrugMapper.selectTakeDrug(entity.getId());
        ExceptionUtils.createException((Logger)log, (null == prescriptionId || prescriptionId.isEmpty() ? 1 : 0) != 0, (String)"500", (String)"\u4ec5\u96503\u65e5\u5185\u5904\u65b9\u30013\u65e5\u5185\u4ed8\u8d39\u3001\u672a\u53d1\u836f\u7684\u624d\u53ef\u4ee5\u8865\u6253\uff0c\u8fc7\u65f6\u65e0\u6cd5\u7b7e\u5230");
        for (String id : ids = prescriptionId.split(",")) {
            OutPrescription outPrescription = this.outPrescriptionMapper.selectOneByPrescriptionId(id);
            if (!"202401290919222322".equals(outPrescription.getOutboundWarehouse())) continue;
            List outPrescriptionDrug = this.outPrescriptionDrugMapper.selectPrescriptionDrug(id);
            try {
                FEEntity feEntity = new FEEntity();
                feEntity.setStime(String.valueOf(new Date().getTime()));
                StringBuilder content = new StringBuilder();
                content.append("<CB># \u5357\u660c\u4f17\u5eb7\u533b\u9662</CB><BR>").append("<CB>===\u53d6\u836f(" + outPrescription.getPatientSource() + ")===</CB><BR>").append("<BOLD><B>" + outPrescription.getPatientName() + "(" + outPrescription.getSex() + ")(" + outPrescription.getAge() + "\u5c81)</B></BOLD><BR>").append("\u7b7e\u5230\u65f6\u95f4:" + DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "<BR>").append("\u5904\u65b9\u53f7:" + id + "<BR><BR>").append("<C>============ \u836f\u54c1 ============</C><BR>");
                for (OutPrescriptionDrug n : outPrescriptionDrug) {
                    content.append("<BOLD>" + n.getDrugName() + "</BOLD><BR>").append("\u3010\u5382\u5546\u3011" + n.getManufacturer() + "<BR>").append("\u3010\u7528\u6cd5\u3011" + n.getFrequency() + "\uff1b\u6bcf\u6b21" + n.getSingleDose() + n.getDoseUnit() + "\uff1b" + n.getDrugUsage() + "<BR>").append(n.getSpecification() + "  x" + n.getQuantity() + n.getQuantityUnit() + "<BR>").append("<C>-----------------------------</C><BR>");
                }
                content.append("<QR>" + entity.getId() + "</QR>").append("<C>-----------\u626b\u7801\u53eb\u53f7-----------</C><BR>");
                feEntity.setSig(feEntity.getSig() + feEntity.getStime());
                String s = this.shaUtil(feEntity.getSig());
                feEntity.setSig(s);
                feEntity.setContent(content.toString());
                System.out.println(123);
                String string = this.send("https://api.feieyun.cn/Api/Open/", feEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    private String shaUtil(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] bytes = data.getBytes();
        digest.update(bytes);
        byte[] hashedBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashedBytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String hashedData = hexString.toString();
        return hashedData;
    }

    public String send(String url, FEEntity feEntity) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Map objMap = BeanUtil.getObjMap((Object)feEntity);
        for (Map.Entry entry : objMap.entrySet()) {
            params.add((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String response = ((String)restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0])).replace("\\", "");
        return response;
    }
}

