/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.config.minio;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.byh.sdk.config.minio.MinioConfig;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    @Autowired
    private MinioConfig prop;
    @Resource
    private MinioClient minioClient;

    public Boolean bucketExists(String bucketName) {
        Boolean found;
        try {
            found = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return found;
    }

    public Boolean makeBucket(String bucketName) {
        try {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Boolean removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<Bucket> getAllBuckets() {
        try {
            List buckets = this.minioClient.listBuckets();
            return buckets;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject upload(MultipartFile file) {
        JSONObject jsonObject = new JSONObject();
        String originalFilename = file.getOriginalFilename();
        if (StrUtil.isBlank((CharSequence)originalFilename)) {
            throw new RuntimeException();
        }
        String fileName = UUID.randomUUID().toString() + originalFilename.substring(originalFilename.lastIndexOf("."));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String objectName = "profile/upload/" + sdf.format(new Date()) + "/" + fileName;
        try {
            if (!this.bucketExists(this.prop.getBucketName()).booleanValue()) {
                this.makeBucket(this.prop.getBucketName());
            }
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.prop.getBucketName())).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioClient.putObject(objectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String url = this.prop.getEndpoint() + "/" + this.prop.getBucketName() + "/" + objectName;
        jsonObject.put("originalFilename", (Object)originalFilename);
        jsonObject.put("fileName", (Object)objectName);
        jsonObject.put("newFileName", (Object)fileName);
        jsonObject.put("url", (Object)url);
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject upload(String fileUrl) {
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            JSONObject jsonObject = new JSONObject();
            String path = fileUrl.split("\\?")[0];
            String originalFilename = path.substring(path.lastIndexOf("/") + 1);
            if (StrUtil.isBlank((CharSequence)originalFilename)) {
                throw new RuntimeException();
            }
            String fileName = UUID.randomUUID().toString() + originalFilename.substring(originalFilename.lastIndexOf("."));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String objectName = "profile/upload/" + sdf.format(new Date()) + "/" + fileName;
            try {
                if (!this.bucketExists(this.prop.getBucketName()).booleanValue()) {
                    this.makeBucket(this.prop.getBucketName());
                }
                PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.prop.getBucketName())).object(objectName)).stream(inputStream, -1L, 0xA00000L).contentType("audio/x-wav").build();
                this.minioClient.putObject(objectArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
                JSONObject jSONObject = null;
                try {
                    assert (inputStream != null);
                    inputStream.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                return jSONObject;
            }
            String url1 = this.prop.getEndpoint() + "/" + this.prop.getBucketName() + "/" + objectName;
            jsonObject.put("originalFilename", (Object)originalFilename);
            jsonObject.put("fileName", (Object)objectName);
            jsonObject.put("newFileName", (Object)fileName);
            jsonObject.put("url", (Object)url1);
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (IOException e) {
            e.printStackTrace();
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            try {
                assert (inputStream != null);
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JSONObject uploads(MultipartFile[] files) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<String> newFileNames = new ArrayList<String>();
        ArrayList<String> originalFilenames = new ArrayList<String>();
        for (MultipartFile file : files) {
            String originalFilename = file.getOriginalFilename();
            if (StrUtil.isBlank((CharSequence)originalFilename)) {
                throw new RuntimeException();
            }
            String fileName = UUID.randomUUID().toString() + originalFilename.substring(originalFilename.lastIndexOf("."));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String objectName = "profile/upload/" + sdf.format(new Date()) + "/" + fileName;
            try {
                if (!this.bucketExists(this.prop.getBucketName()).booleanValue()) {
                    this.makeBucket(this.prop.getBucketName());
                }
                PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.prop.getBucketName())).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
                this.minioClient.putObject(objectArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            String url = this.prop.getEndpoint() + "/" + this.prop.getBucketName() + "/" + objectName;
            urls.add(url);
            fileNames.add(objectName);
            newFileNames.add(fileName);
            originalFilenames.add(originalFilename);
        }
        jsonObject.put("originalFilename", originalFilenames);
        jsonObject.put("fileName", fileNames);
        jsonObject.put("newFileName", newFileNames);
        jsonObject.put("url", urls);
        return jsonObject;
    }

    public String preview(String fileName) {
        new GetPresignedObjectUrlArgs();
        GetPresignedObjectUrlArgs build = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).method(Method.GET).build();
        try {
            String url = this.minioClient.getPresignedObjectUrl(build);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void download(String fileName, HttpServletResponse res) {
        GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).build();
        try (GetObjectResponse response = this.minioClient.getObject(objectArgs);){
            byte[] buf = new byte[1024];
            try (FastByteArrayOutputStream os = new FastByteArrayOutputStream();){
                int len;
                while ((len = response.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                os.flush();
                byte[] bytes = os.toByteArray();
                res.setCharacterEncoding("utf-8");
                res.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                try (ServletOutputStream stream = res.getOutputStream();){
                    stream.write(bytes);
                    stream.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Item> listObjects() {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.prop.getBucketName())).build());
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            for (Result result : results) {
                items.add((Item)result.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return items;
    }

    public boolean remove(String fileName) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).build());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

