/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.byh.sdk.entity.admission.QuickTreatementDto;
import com.byh.sdk.entity.doctor.SysDoctorDto;
import com.byh.sdk.entity.outpatientType.OutpatientTypeEntity;
import com.byh.sdk.entity.outpatientType.QueryOutpatientTypeDto;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.mapper.PatientMapper;
import com.byh.sdk.service.AdmissionService;
import com.byh.sdk.service.PatientService;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.exception.BusinessException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdmissionServiceImpl
implements AdmissionService {
    private Logger logger = LoggerFactory.getLogger(AdmissionServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private PatientMapper patientMapper;
    @Autowired
    private PatientService patientService;

    @Transactional(rollbackFor={BusinessException.class})
    public ResponseData registration(QuickTreatementDto dto) {
        ResponseData responseData = this.outpatientServiceFeign.registration(dto);
        return responseData;
    }

    public ResponseData<List<OutpatientTypeEntity>> selectOupatientTypeByName(QueryOutpatientTypeDto dto) {
        return this.outpatientServiceFeign.queryOutpatientTypeByName(dto);
    }

    public ResponseData selectDoctorPageList(SysDoctorDto dto) {
        return this.sysServiceFeign.withoutSelectPageList(dto);
    }
}

