/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.diagnostic.DiagnosticDetailReqDTO;
import com.byh.sdk.entity.diagnostic.DiagnosticReqDTO;
import com.byh.sdk.entity.diagnostic.OutIcdItem;
import com.byh.sdk.entity.diagnostic.OutpatientInfomationDto;
import com.byh.sdk.entity.diagnostic.QueryOutpatientInfomationVo;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.service.DiagnosticService;
import com.byh.sdk.util.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DiagnosticServiceImpl
implements DiagnosticService {
    private static final Logger log = LoggerFactory.getLogger(DiagnosticServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    public FrontResponse<String> updateOutpatientMedicalRecords(FrontRequest<DiagnosticReqDTO> param) {
        log.info("\u8bca\u65ad\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            DiagnosticReqDTO body = (DiagnosticReqDTO)param.getBody();
            body.setOperatorSource(SourceEnum.ONLINE.getValue());
            List icdCodes = body.getDiagnosis().stream().map(DiagnosticDetailReqDTO::getIcdCode).collect(Collectors.toList());
            ResponseData itemsResponseData = this.outpatientServiceFeign.queryIcdByCode(icdCodes, tenantId);
            if (itemsResponseData == null || !itemsResponseData.isSuccess()) {
                log.info("\u8bca\u65adicd\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)itemsResponseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)itemsResponseData.getMsg());
            }
            List items = JSON.parseArray((String)JSON.toJSONString((Object)itemsResponseData.getData()), OutIcdItem.class);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u672a\u67e5\u8be2\u5230\u8bca\u65ad\u4fe1\u606f");
            }
            Map itemMap = items.stream().collect(Collectors.toMap(OutIcdItem::getIcdCode, Function.identity()));
            ArrayList<DiagnosticDetailReqDTO> diagnosis = new ArrayList<DiagnosticDetailReqDTO>(items.size());
            for (DiagnosticDetailReqDTO item : body.getDiagnosis()) {
                OutIcdItem outIcdItem = (OutIcdItem)itemMap.get(item.getIcdCode());
                DiagnosticDetailReqDTO detailReqDTO = new DiagnosticDetailReqDTO();
                detailReqDTO.setDiagnosis(outIcdItem.getIcdName());
                detailReqDTO.setIcdCode(outIcdItem.getIcdCode());
                detailReqDTO.setRegionalMedicalInsuranceCode(item.getRegionalMedicalInsuranceCode());
                detailReqDTO.setRegionalMedicalInsuranceName(item.getRegionalMedicalInsuranceName());
                diagnosis.add(detailReqDTO);
            }
            body.setDiagnosis(diagnosis);
            if (CollectionUtils.isEmpty(diagnosis)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u672a\u67e5\u8be2\u5230\u8bca\u65ad\u4fe1\u606f!");
            }
            OutpatientInfomationDto outpatientInfomationDto = new OutpatientInfomationDto();
            outpatientInfomationDto.setOutpatientNo(body.getOutpatientNo());
            ResponseData informationResponseData = this.outpatientServiceFeign.queryOutpatientInformation(outpatientInfomationDto, tenantId, param.getOperatorId(), param.getOperatorName());
            if (informationResponseData == null || !informationResponseData.isSuccess()) {
                log.info("\u8bca\u65ad\u67e5\u8be2\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)outpatientInfomationDto), (Object)JSON.toJSONString((Object)informationResponseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8bca\u65ad\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            log.info("his\u8bca\u65ad\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)informationResponseData));
            QueryOutpatientInfomationVo queryOutpatientInfomationVo = (QueryOutpatientInfomationVo)JSON.parseObject((String)JSON.toJSONString((Object)informationResponseData.getData()), QueryOutpatientInfomationVo.class);
            log.info("his\u8bca\u65ad\u4fe1\u606f\u8f6c\u6362:{}", (Object)JSON.toJSONString((Object)queryOutpatientInfomationVo));
            if (Objects.isNull(queryOutpatientInfomationVo)) {
                log.info("\u8bca\u65ad\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)outpatientInfomationDto), (Object)JSON.toJSONString((Object)queryOutpatientInfomationVo));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8bca\u65ad\u67e5\u8be2\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            ResponseData responseData = this.outpatientServiceFeign.updateOutpatientMedicalRecords(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u8bca\u65ad\u4fdd\u5b58\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8bca\u65ad\u4fdd\u5b58\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8bca\u65ad\u64cd\u4f5c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u8bca\u65ad\u64cd\u4f5c\u5f02\u5e38");
        }
    }
}

