/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.byh.sdk.entity.im.IMGenerateDto;
import com.byh.sdk.entity.im.IMSessionHistoryPatientVo;
import com.byh.sdk.service.IMGenerateService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.ResponseData;
import com.tencentyun.TLSSigAPIv2;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IMGenerateServiceImpl
implements IMGenerateService {
    private Logger logger = LoggerFactory.getLogger(IMGenerateServiceImpl.class);
    @Value(value="${IMConfig.sdkAppId}")
    private long sdkAppId;
    @Value(value="${IMConfig.secretKey}")
    private String secretKey;
    private long expier = 604800L;
    private String BASE_URL = "https://data-center.scrmzk.com/api/im";
    private String GET_SESSION_LIST = "/getSessionList";
    private String GET_MSG_HISTORY = "/getMsgHistory";

    public String generateUserId(IMGenerateDto dto) {
        JSONObject jsonObject;
        TLSSigAPIv2 api = new TLSSigAPIv2(this.sdkAppId, this.secretKey);
        String userSig = api.genSig("administrator", this.expier);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UserID", dto.getUserId());
        if (StrUtil.isNotEmpty((CharSequence)dto.getUserName())) {
            map.put("Nick", dto.getUserName());
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getFaceUrl())) {
            map.put("FaceUrl", dto.getFaceUrl());
        }
        String postUrl = String.format("https://console.tim.qq.com/v4/im_open_login_svc/account_import?sdkappid=%s&identifier=%s&usersig=%s&contenttype=json", this.sdkAppId, "administrator", userSig);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(postUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        if (responseBody != null && (jsonObject = JSONObject.parseObject((String)responseBody)).get((Object)"ErrorCode").toString().equals("0")) {
            return api.genSig(dto.getUserId(), this.expier);
        }
        return responseBody;
    }

    public ResponseData<IMSessionHistoryPatientVo> getSessionList(String cardNo) throws IOException {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            return ResponseData.error((String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u67e5\u8be2\u5bf9\u8bdd\u5217\u8868--------\u8eab\u4efd\u8bc1\u53f7\uff1a{}", (Object)cardNo);
        String url = this.BASE_URL + this.GET_SESSION_LIST + "?cardNo=" + cardNo;
        String s = HttpUtils.get((String)url);
        Gson gson = new Gson();
        JSONObject parse = (JSONObject)JSONObject.parse((String)s);
        IMSessionHistoryPatientVo imSessionHistoryPatientVo = (IMSessionHistoryPatientVo)gson.fromJson(String.valueOf(parse), IMSessionHistoryPatientVo.class);
        return ResponseData.success((Object)imSessionHistoryPatientVo);
    }

    public ResponseData getMsgHistory(Integer id) throws IOException {
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u67e5\u8be2\u5bf9\u8bdd\u8be6\u60c5--------\u5bf9\u8bddid\uff1a{}", (Object)id);
        String url = this.BASE_URL + this.GET_MSG_HISTORY + "?id=" + id;
        String s = HttpUtils.get((String)url);
        JSONObject parse = (JSONObject)JSONObject.parse((String)s);
        String code = parse.get((Object)"code").toString();
        if ("200".equals(code)) {
            String msg = parse.get((Object)"msg").toString();
            JSONObject JSONMsg = (JSONObject)JSONObject.parse((String)msg);
            return ResponseData.success((Object)JSONMsg);
        }
        return ResponseData.error((String)code);
    }
}

