/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sdk.entity.OutFrontConfig;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.lisResult.LisResultDetailEntity;
import com.byh.sdk.entity.lisResult.LisResultEntity;
import com.byh.sdk.entity.lisResult.QueryLisResultDto;
import com.byh.sdk.entity.lisResult.QueryTreatmentItemVo;
import com.byh.sdk.enums.FrontMethodEnum;
import com.byh.sdk.mapper.LisResultMapper;
import com.byh.sdk.service.LisResultService;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LisResultServiceImpl
extends ServiceImpl<LisResultMapper, LisResultEntity>
implements LisResultService {
    private Logger logger = LoggerFactory.getLogger(LisResultServiceImpl.class);
    @Resource
    private LisResultMapper lisResultMapper;

    public List<LisResultEntity> getLisResultList(QueryLisResultDto dto) {
        List treatmentItemList = this.lisResultMapper.selectTreatmentList(dto);
        List<Object> resultList = new ArrayList<LisResultEntity>();
        if (!treatmentItemList.isEmpty()) {
            List hisIds = treatmentItemList.stream().distinct().filter(Objects::nonNull).map(QueryTreatmentItemVo::getHisId).collect(Collectors.toList());
            resultList = this.lisResultMapper.selectLisResultList(hisIds);
            List detailList = new ArrayList();
            if (!resultList.isEmpty()) {
                List lisResultIds = resultList.stream().map(LisResultEntity::getId).collect(Collectors.toList());
                detailList = this.lisResultMapper.selectLisDetailList(lisResultIds);
            }
            Map<Integer, List<LisResultDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(LisResultDetailEntity::getLisResultId));
            if (resultList != null && treatmentItemList != null && resultList.size() == treatmentItemList.size()) {
                for (LisResultEntity lisResultEntity : resultList) {
                    List details = detailMap.getOrDefault(lisResultEntity.getId(), new ArrayList());
                    lisResultEntity.setDetailList(details);
                }
            } else {
                JSONArray jsonArray;
                OutFrontConfig outFrontConfig = this.lisResultMapper.selectConfig(Integer.valueOf(1), FrontMethodEnum.LIS_RESULT_BY_HISIDS.getValue());
                dto.setHisIds(hisIds);
                FrontRequest frontRequest = new FrontRequest();
                frontRequest.setBody((Object)dto);
                String result = HttpUtil.post((String)outFrontConfig.getInterfaceUrl(), (String)JSONObject.toJSONString((Object)frontRequest));
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String code = jsonObject.getString("code");
                if ("1".equals(code) && !(jsonArray = jsonObject.getJSONArray("body")).isEmpty()) {
                    Map resultMap = resultList.stream().collect(Collectors.toMap(LisResultEntity::getHisId, Function.identity()));
                    Map listMap = treatmentItemList.stream().collect(Collectors.toMap(QueryTreatmentItemVo::getHisId, Function.identity()));
                    LinkedHashMap<String, List> objectMap = new LinkedHashMap<String, List>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject object = jsonArray.getJSONObject(i);
                        String hisId = object.getString("hisid");
                        Optional.ofNullable(listMap.get(hisId)).ifPresent(vo -> {
                            object.put("outpatientNo", (Object)vo.getOutpatientNo());
                            object.put("deptId", (Object)vo.getDeptId());
                            object.put("doctorId", (Object)vo.getDoctorId());
                            object.put("patientId", (Object)vo.getPatientId());
                            object.put("treatmentId", (Object)vo.getTreatmentItemId());
                        });
                        objectMap.computeIfAbsent(hisId, k -> new ArrayList()).add(object);
                    }
                    ArrayList<LisResultEntity> newResultList = new ArrayList<LisResultEntity>();
                    ArrayList<LisResultDetailEntity> newDetailList = new ArrayList<LisResultDetailEntity>();
                    for (Map.Entry entry : objectMap.entrySet()) {
                        String hisId = (String)entry.getKey();
                        List jsonObjects = (List)entry.getValue();
                        LisResultEntity newLisResult = new LisResultEntity();
                        LisResultEntity lisResult = (LisResultEntity)resultMap.get(hisId);
                        if (lisResult == null) {
                            JSONObject detailObject = (JSONObject)jsonObjects.get(0);
                            newLisResult.setTenantId(Integer.valueOf(1));
                            newLisResult.setCreateId(Integer.valueOf(1));
                            newLisResult.setCreateName("\u516c\u4f17\u53f7\u83b7\u53d6\u68c0\u9a8c\u7ed3\u679c");
                            newLisResult.setOutpatientNo(detailObject.getString("outpatientNo"));
                            newLisResult.setDeptId(detailObject.getInteger("deptId"));
                            newLisResult.setDeptName(detailObject.getString("department"));
                            newLisResult.setDoctorId(detailObject.getInteger("doctorId"));
                            newLisResult.setDoctorName(detailObject.getString("doctor"));
                            newLisResult.setPatientId(detailObject.getInteger("patientId"));
                            newLisResult.setItemId(detailObject.getInteger("treatmentId"));
                            newLisResult.setItemName(detailObject.getString("feename"));
                            newLisResult.setHisId(detailObject.getString("hisid"));
                            newLisResult.setSpecimenType(detailObject.getString("samplename"));
                            newLisResult.setOpter(detailObject.getString("opter"));
                            newLisResult.setAuditOpter(detailObject.getString("auditopter"));
                            newLisResult.setPrintOpter(detailObject.getString("printopter"));
                            newLisResult.setSampleDate(this.getDateValue(detailObject, "sampledate"));
                            newLisResult.setTestTime(this.getDateValue(detailObject, "testtime"));
                            newLisResult.setAuditTime(this.getDateValue(detailObject, "audittime"));
                            newLisResult.setPrintTime(this.getDateValue(detailObject, "printtime"));
                            newLisResult.setVisitType(detailObject.getString("pattype"));
                            newLisResult.setBarcode(detailObject.getString("barcode"));
                            newLisResult.setBarcodeTime(this.getDateValue(detailObject, "barcodetime"));
                            this.lisResultMapper.insert((Object)newLisResult);
                            for (JSONObject object : jsonObjects) {
                                LisResultDetailEntity detail = new LisResultDetailEntity();
                                detail.setLisResultId(newLisResult.getId());
                                detail.setTenantId(Integer.valueOf(1));
                                detail.setCreateId(Integer.valueOf(1));
                                detail.setCreateName("\u516c\u4f17\u53f7\u83b7\u53d6\u68c0\u9a8c\u7ed3\u679c");
                                detail.setItemCode(object.getString("itemename"));
                                detail.setItemName(object.getString("itemcname"));
                                detail.setResult(object.getString("result"));
                                detail.setUnit(object.getString("unit"));
                                detail.setResultStatus(object.getString("state"));
                                detail.setReferrenceRange(object.getString("limit"));
                                newDetailList.add(detail);
                            }
                            newResultList.add(newLisResult);
                            continue;
                        }
                        newResultList.add(lisResult);
                    }
                    if (!newDetailList.isEmpty()) {
                        this.lisResultMapper.insertDetailList(newDetailList);
                    }
                    Map<Integer, List<LisResultDetailEntity>> newDetailMap = newDetailList.stream().collect(Collectors.groupingBy(LisResultDetailEntity::getLisResultId));
                    for (LisResultEntity entity : newResultList) {
                        List details = detailMap.getOrDefault(entity.getId(), new ArrayList());
                        if (details == null || details.isEmpty()) {
                            details = newDetailMap.getOrDefault(entity.getId(), new ArrayList());
                        }
                        if (details == null || details.isEmpty()) continue;
                        entity.setDetailList(details);
                    }
                    return newResultList;
                }
            }
        }
        return resultList;
    }

    private Date getDateValue(JSONObject jsonObject, String field) {
        String dateTimeStr = jsonObject.getString(field);
        if (StrUtil.isEmpty((CharSequence)dateTimeStr)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeStr, formatter);
        Date date = Date.from(zonedDateTime.toInstant());
        return date;
    }
}

