/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.byh.sdk.entity.request.weChatStat.WeChatStatDto;
import com.byh.sdk.entity.respones.weChatStat.WeChatStatVo;
import com.byh.sdk.mapper.WeChatStatMapper;
import com.byh.sdk.service.WeChatStatService;
import com.byh.sdk.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WeChatStatServiceImpl
implements WeChatStatService {
    @Resource
    private WeChatStatMapper weChatStatMapper;

    public List<WeChatStatVo> weChatStat(WeChatStatDto dto) {
        List<Object> list = new ArrayList<WeChatStatVo>(30);
        switch (dto.getType()) {
            case 1: {
                list = this.deptDoctorRegisterDetail(dto);
                break;
            }
            case 2: {
                list = this.deptRegisterDetail(dto);
                break;
            }
            case 3: {
                list = this.deptIncomeDetail(dto);
                break;
            }
            case 4: {
                list = this.indexDetail(dto);
                break;
            }
            case 5: {
                list = this.registerCount(dto);
                break;
            }
            case 6: {
                list = this.medicalServiceIncome(dto);
                break;
            }
            case 7: {
                list = this.hospitalIncome(dto);
                break;
            }
            case 8: {
                list = this.patientStatus(dto);
                break;
            }
            case 9: {
                list = this.patientDisease(dto);
                break;
            }
            case 10: {
                list = this.patientSpread(dto);
            }
        }
        return list;
    }

    public List<WeChatStatVo> deptDoctorRegisterDetail(WeChatStatDto dto) {
        List list = this.weChatStatMapper.deptDoctorRegisterDetail(dto);
        return list;
    }

    public List<WeChatStatVo> deptRegisterDetail(WeChatStatDto dto) {
        List list = this.weChatStatMapper.deptRegisterDetail(dto);
        return list;
    }

    public List<WeChatStatVo> deptIncomeDetail(WeChatStatDto dto) {
        this.setStartAndEndTime(dto);
        List list = this.weChatStatMapper.deptIncomeDetail(dto);
        return list;
    }

    public List<WeChatStatVo> indexDetail(WeChatStatDto dto) {
        this.setStartAndEndTime(dto);
        List list = this.weChatStatMapper.indexDetail(dto);
        return list;
    }

    public List<WeChatStatVo> registerCount(WeChatStatDto dto) {
        this.setStartAndEndTime(dto);
        List list = this.weChatStatMapper.registerCount(dto);
        return list;
    }

    public List<WeChatStatVo> medicalServiceIncome(WeChatStatDto dto) {
        this.setStartAndEndTime(dto);
        Date BeginDate = DateUtils.stringTimeToDate((String)dto.getBeginDate(), (String)"yyyy-MM-dd");
        Date EndDate = DateUtils.stringTimeToDate((String)dto.getEndDate(), (String)"yyyy-MM-dd");
        Long days = DateUtils.computedDiffDays((Date)BeginDate, (Date)EndDate);
        dto.setPeriodBeginDate(DateUtils.getMoveDays((Date)BeginDate, (int)Integer.parseInt(days.toString()), (int)-1));
        dto.setPeriodEndDate(DateUtils.getMoveDays((Date)EndDate, (int)Integer.parseInt(days.toString()), (int)-1));
        List list = this.weChatStatMapper.medicalServiceIncome(dto);
        return list;
    }

    private List<WeChatStatVo> hospitalIncome(WeChatStatDto dto) {
        this.setStartAndEndTime(dto);
        Date BeginDate = DateUtils.stringTimeToDate((String)dto.getBeginDate(), (String)"yyyy-MM-dd");
        Date EndDate = DateUtils.stringTimeToDate((String)dto.getEndDate(), (String)"yyyy-MM-dd");
        Long days = DateUtils.computedDiffDays((Date)BeginDate, (Date)EndDate);
        dto.setPeriodBeginDate(DateUtils.getMoveDays((Date)BeginDate, (int)Integer.parseInt(days.toString()), (int)-1));
        dto.setPeriodEndDate(DateUtils.getMoveDays((Date)EndDate, (int)Integer.parseInt(days.toString()), (int)-1));
        List list = this.weChatStatMapper.hospitalIncome(dto);
        return list;
    }

    private List<WeChatStatVo> patientStatus(WeChatStatDto dto) {
        List list = this.weChatStatMapper.patientStatus(dto);
        return list;
    }

    private List<WeChatStatVo> patientDisease(WeChatStatDto dto) {
        List list = this.weChatStatMapper.patientDisease(dto);
        return list;
    }

    private List<WeChatStatVo> patientSpread(WeChatStatDto dto) {
        List list = this.weChatStatMapper.patientSpread(dto);
        return list;
    }

    private void setStartAndEndTime(WeChatStatDto dto) {
        if (null != dto.getBeginDate()) {
            String lastBeginDate = DateUtils.getMoveYear((String)dto.getBeginDate(), (int)1, (int)-1);
            dto.setLastBeginDate(lastBeginDate);
        }
        if (null != dto.getEndDate()) {
            String lastEndDate = DateUtils.getMoveYear((String)dto.getEndDate(), (int)1, (int)-1);
            dto.setLastEndDate(lastEndDate);
        }
    }
}

