/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import com.byh.sdk.util.enums.ResultEnum;

public class Result<T> {
    Integer resultCode;
    String resultDesc;
    T data;

    public Result(ResultEnum code) {
        this.resultCode = code.code();
        this.resultDesc = code.message();
    }

    public Result(ResultEnum code, T data) {
        this.resultCode = code.code();
        this.resultDesc = code.message();
        this.data = data;
    }

    public Result(String message) {
        this.resultDesc = message;
    }

    public static Result<String> success() {
        return new Result(ResultEnum.SUCCESS);
    }

    public static <T> Result<T> success(T data) {
        return new Result(ResultEnum.SUCCESS, data);
    }

    public static Result<String> error() {
        return new Result(ResultEnum.FAIL);
    }

    public static Result<String> error(ResultEnum resultCode) {
        return new Result(resultCode);
    }

    public static Result<String> error(String message) {
        return new Result(ResultEnum.FAIL, (Object)message);
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public String getResultDesc() {
        return this.resultDesc;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    public void setResultDesc(String resultDesc) {
        this.resultDesc = resultDesc;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$resultCode = this.getResultCode();
        Integer other$resultCode = other.getResultCode();
        if (this$resultCode == null ? other$resultCode != null : !((Object)this$resultCode).equals(other$resultCode)) {
            return false;
        }
        String this$resultDesc = this.getResultDesc();
        String other$resultDesc = other.getResultDesc();
        if (this$resultDesc == null ? other$resultDesc != null : !this$resultDesc.equals(other$resultDesc)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $resultCode = this.getResultCode();
        result = result * 59 + ($resultCode == null ? 43 : ((Object)$resultCode).hashCode());
        String $resultDesc = this.getResultDesc();
        result = result * 59 + ($resultDesc == null ? 43 : $resultDesc.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(resultCode=" + this.getResultCode() + ", resultDesc=" + this.getResultDesc() + ", data=" + this.getData() + ")";
    }
}

