/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);

    public static <T> T convertToJavaBean(String xml, Class<T> c) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        Object t = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            t = unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            log.error("ERROR", (Throwable)e);
        }
        return (T)t;
    }

    public static String convertToXml(Object obj) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            result = writer.toString();
        }
        catch (Exception e) {
            log.error("ERROR", (Throwable)e);
        }
        return result;
    }
}

