/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.DispensingDetails;
import com.byh.sdk.entity.DispensingInfo;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.service.DispensingService;
import com.byh.sdk.util.HttpUtils;
import com.byh.sdk.util.ResponseData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DispensingServiceImpl
implements DispensingService {
    private static Logger log = LoggerFactory.getLogger(DispensingServiceImpl.class);
    public final String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
    public final String url = "/his/product/presc";
    public Map<String, String> drugMap = new HashMap();
    @Resource
    private OutPrescriptionMapper outPrescriptionMapper;

    public DispensingServiceImpl() {
        this.drugMap.put("\u7545\u5feb\u53d8\u901a\u7247", "181242");
        this.drugMap.put("\u8109\u8840\u5eb7\u80f6\u56ca", "6");
        this.drugMap.put("\u76d0\u9178\u4f9d\u5339\u65af\u6c40\u80f6\u56ca", "181241");
        this.drugMap.put("\u8fde\u82b1\u6e05\u761f\u80f6\u56ca", "15414");
        this.drugMap.put("\u590d\u65b9\u6c2f\u9709\u7d20\u6813", "181240");
    }

    public ResponseData presc(OutPrescription prescription) {
        if (StringUtils.isBlank((CharSequence)prescription.getPrescriptionNo())) {
            return ResponseData.error((String)"\u5904\u65b9\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Set keys = this.drugMap.keySet();
        DispensingInfo info = this.outPrescriptionMapper.queryDispensing(prescription);
        log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u63a5\u6536\u5230\u7684deviceNo{}", (Object)prescription.getDeviceNo());
        if (StringUtils.isBlank((CharSequence)prescription.getDeviceNo())) {
            info.setDeviceNo("42088100200104");
        } else {
            info.setDeviceNo(prescription.getDeviceNo());
        }
        info.setCurrent("1");
        ArrayList<DispensingDetails> details = new ArrayList<DispensingDetails>();
        for (DispensingDetails detail : info.getDetails()) {
            String commonname = detail.getCommonname();
            if (!keys.contains(commonname)) continue;
            if ("\u8fde\u82b1\u6e05\u761f\u80f6\u56ca".equals(commonname)) {
                detail.setPackspecs("\u6bcf\u7c92\u88c50.35g");
                detail.setFactory("\u77f3\u5bb6\u5e84\u4ee5\u5cad\u836f\u4e1a\u80a1\u4efd\u6709\u9650\u516c\u53f8");
            }
            detail.setProductid((String)this.drugMap.get(commonname));
            details.add(detail);
        }
        if (details.size() == 0) {
            ResponseData.error((String)"\u8be5\u5904\u65b9\u6ca1\u5f00\u89c4\u5b9a\u7684\u836f\u54c1");
        }
        info.setDetails(details);
        String respStr = "";
        try {
            String jsonString = JSON.toJSONString((Object)info);
            log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u8bf7\u6c42\u53c2\u6570{}", (Object)jsonString);
            respStr = HttpUtils.doPost((String)"https://medbox.x.yaoxz.cn/mac158/his/product/presc", (String)jsonString, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u5c55\u5385\u53d1\u836f\u673a\u8fd4\u56de\u7684\u7ed3\u679c{}", (Object)respStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = JSON.parseObject((String)respStr);
        String status = jsonObject.get((Object)"status") + "";
        String message = jsonObject.get((Object)"message") + "";
        if ("200".equals(status)) {
            return ResponseData.success((Object)message);
        }
        return ResponseData.error((String)message);
    }
}

