/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sdk.entity.FEEntity;
import com.byh.sdk.entity.drug.SysEasyEntity;
import com.byh.sdk.entity.ve.AdmissionEntity;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.entity.ve.OutPrescriptionDrug;
import com.byh.sdk.mapper.OutAdmissionMapper;
import com.byh.sdk.mapper.OutPrescriptionDrugMapper;
import com.byh.sdk.mapper.OutPrescriptionMapper;
import com.byh.sdk.service.FPrinterService;
import com.byh.sdk.util.BeanUtil;
import com.byh.sdk.util.DateUtils;
import com.byh.sdk.util.ExceptionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FPrinterServiceImpl
implements FPrinterService {
    private static final Logger log = LoggerFactory.getLogger(FPrinterServiceImpl.class);
    @Resource
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Qualifier(value="outAdmissionMapper")
    @Autowired
    private OutAdmissionMapper outAdmissionMapper;

    public void printerReceipt(SysEasyEntity entity) {
        String[] ids;
        String prescriptionId = this.outPrescriptionDrugMapper.selectTakeDrug(entity.getId());
        if (null == prescriptionId || prescriptionId.isEmpty()) {
            return;
        }
        for (String id : ids = prescriptionId.split(",")) {
            OutPrescription outPrescription = this.outPrescriptionMapper.selectOneByPrescriptionId(id);
            if (!"202401290919222322".equals(outPrescription.getOutboundWarehouse())) continue;
            List outPrescriptionDrug = this.outPrescriptionDrugMapper.selectPrescriptionDrug(id);
            try {
                FEEntity feEntity = new FEEntity();
                feEntity.setStime(String.valueOf(new Date().getTime()));
                StringBuilder content = new StringBuilder();
                content.append("<CB># \u5357\u660c\u4f17\u5eb7\u533b\u9662</CB><BR>");
                if (StringUtils.isNotBlank((CharSequence)entity.getBakValue())) {
                    content.append("<CB>\u5e8f\u53f7\uff1a" + entity.getBakValue() + "</CB><BR>");
                }
                content.append("<CB>===\u53d6\u836f(" + outPrescription.getPatientSource() + ")===</CB><BR>").append("<BOLD><B>" + outPrescription.getPatientName() + "(" + outPrescription.getSex() + ")(" + outPrescription.getAge() + "\u5c81)</B></BOLD><BR>").append("\u7b7e\u5230\u65f6\u95f4:" + DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "<BR>").append("\u5904\u65b9\u53f7:" + id + "<BR><BR>").append("<C>============ \u836f\u54c1 ============</C><BR>");
                for (OutPrescriptionDrug n : outPrescriptionDrug) {
                    content.append("<BOLD>" + n.getDrugName() + "</BOLD><BR>").append("\u3010\u5382\u5546\u3011" + n.getManufacturer() + "<BR>").append("\u3010\u7528\u6cd5\u3011" + n.getFrequency() + "\uff1b\u6bcf\u6b21" + n.getSingleDose() + n.getDoseUnit() + "\uff1b" + n.getDrugUsage() + "<BR>").append(n.getSpecification() + "  x" + n.getQuantity() + n.getQuantityUnit() + "<BR>").append("<C>-----------------------------</C><BR>");
                }
                content.append("<QR>" + entity.getId() + "</QR>").append("<C>-----------\u626b\u7801\u53eb\u53f7-----------</C><BR>");
                content.append("<BR>\u9662\u5185\u7b7e\u5230\u81ea\u63d0");
                feEntity.setSig(feEntity.getSig() + feEntity.getStime());
                String s = this.shaUtil(feEntity.getSig());
                feEntity.setSig(s);
                feEntity.setSn(entity.getPrintSn());
                feEntity.setContent(content.toString());
                System.out.println(123);
                String string = this.send("https://api.feieyun.cn/Api/Open/", feEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    public void printerReceiptByHy(SysEasyEntity entity) {
        String[] ids;
        AdmissionEntity admissionEntity = (AdmissionEntity)this.outAdmissionMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(AdmissionEntity::getOutpatientNo, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(admissionEntity), (String)("\u672a\u67e5\u8be2\u5230\u95e8\u8bca\u53f7\uff1a" + entity.getId() + "\u7684\u6302\u53f7\u4fe1\u606f"));
        for (String id : ids = entity.getIds()) {
            OutPrescription outPrescription = this.outPrescriptionMapper.selectOneByPrescriptionId(id);
            if (!"202401290919222322".equals(outPrescription.getOutboundWarehouse())) continue;
            List outPrescriptionDrug = this.outPrescriptionDrugMapper.selectPrescriptionDrug(id);
            try {
                FEEntity feEntity = new FEEntity();
                feEntity.setStime(String.valueOf(new Date().getTime()));
                StringBuilder content = new StringBuilder();
                content.append("<CB># " + entity.getSourceName() + "</CB><BR>").append("<BOLD><B>" + outPrescription.getPatientName() + "(" + outPrescription.getSex() + ")(" + outPrescription.getAge() + "\u5c81)</B></BOLD><BR><BR>").append("\u7535\u8bdd:" + admissionEntity.getPhone() + "<BR>").append("\u6253\u5370\u65f6\u95f4:" + DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "<BR>").append("\u5904\u65b9\u53f7:" + id + "<BR><BR>").append("<C>============ \u836f\u54c1 ============</C><BR>");
                BigDecimal amount = new BigDecimal("0");
                for (OutPrescriptionDrug n : outPrescriptionDrug) {
                    content.append("<BOLD>" + n.getDrugName() + "</BOLD><BR>").append("\u3010\u5382\u5546\u3011" + n.getManufacturer() + "<BR>").append("\u3010\u7528\u6cd5\u3011" + n.getFrequency() + "\uff1b\u6bcf\u6b21" + n.getSingleDose() + n.getDoseUnit() + "\uff1b" + n.getDrugUsage() + "<BR>").append(n.getSpecification() + "  x" + n.getQuantity() + n.getQuantityUnit() + "<BR>").append("\u5355\u4ef7\uff1a" + n.getDrugPriceAmount().setScale(2, RoundingMode.HALF_UP) + "  \u603b\u4ef7\uff1a" + n.getTotalDrugAmount() + "<BR>").append("<C>-----------------------------</C><BR>");
                    amount = amount.add(n.getTotalDrugAmount());
                }
                content.append("\u836f\u54c1\u603b\u4ef7\uff1a" + amount + "<BR>");
                content.append("<C>============ \u5730\u5740 ============</C><BR>").append(entity.getBakValue() + "<BR>");
                content.append("<BR>\u836f\u5e97\u81ea\u53d6");
                feEntity.setSig(feEntity.getSig() + feEntity.getStime());
                String s = this.shaUtil(feEntity.getSig());
                feEntity.setSig(s);
                feEntity.setSn(entity.getPrintSn());
                feEntity.setContent(content.toString());
                System.out.println(123);
                String post = this.send("https://api.feieyun.cn/Api/Open/", feEntity);
                this.setPrintCount(outPrescription);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    public void printerReceiptDelivery(SysEasyEntity entity) {
        String[] ids;
        JSONObject json = JSONObject.parseObject((String)entity.getBakJsonStr());
        for (String id : ids = entity.getIds()) {
            OutPrescription outPrescription = this.outPrescriptionMapper.selectOneByPrescriptionId(id);
            if (!"202401290919222322".equals(outPrescription.getOutboundWarehouse())) continue;
            List outPrescriptionDrug = this.outPrescriptionDrugMapper.selectPrescriptionDrug(id);
            try {
                FEEntity feEntity = new FEEntity();
                feEntity.setStime(String.valueOf(new Date().getTime()));
                StringBuilder content = new StringBuilder();
                content.append("<BOLD><B>" + outPrescription.getPatientName() + "\uff08\u60a3\u8005\u59d3\u540d\uff09</B></BOLD><BR><BR>").append("\u6253\u5370\u65f6\u95f4:" + DateUtils.dateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "<BR>").append("\u5904\u65b9\u53f7:" + id + "<BR><BR>").append("\u6536\u4ef6\u4eba:" + String.valueOf(json.get((Object)"name")) + "<BR>").append("\u8054\u7cfb\u7535\u8bdd:" + String.valueOf(json.get((Object)"phone")) + "<BR>").append("\u5730\u533a\uff1a" + String.valueOf(json.get((Object)"province")) + "-" + String.valueOf(json.get((Object)"city")) + "-" + String.valueOf(json.get((Object)"district")) + "<BR>").append("\u5730\u5740\uff1a" + String.valueOf(json.get((Object)"address")) + "<BR>").append("\u8be6\u7ec6\u5730\u5740\uff1a" + String.valueOf(json.get((Object)"detailsAddress")) + "<BR><BR>").append("<C>============ \u836f\u54c1 ============</C><BR>");
                for (OutPrescriptionDrug n : outPrescriptionDrug) {
                    content.append("<BOLD>" + n.getDrugName() + "</BOLD><BR>").append("\u3010\u5382\u5546\u3011" + n.getManufacturer() + "<BR>").append("\u3010\u7528\u6cd5\u3011" + n.getFrequency() + "\uff1b\u6bcf\u6b21" + n.getSingleDose() + n.getDoseUnit() + "\uff1b" + n.getDrugUsage() + "<BR>").append(n.getSpecification() + "  x" + n.getQuantity() + n.getQuantityUnit() + "<BR>").append("<C>-----------------------------</C><BR>");
                }
                content.append("<BR>\u9001\u8d27\u4e0a\u95e8");
                feEntity.setSig(feEntity.getSig() + feEntity.getStime());
                String s = this.shaUtil(feEntity.getSig());
                feEntity.setSig(s);
                feEntity.setSn(entity.getPrintSn());
                feEntity.setContent(content.toString());
                String string = this.send("https://api.feieyun.cn/Api/Open/", feEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
    }

    public void printerReceiptRepair(SysEasyEntity entity) {
        if ("1".equals(entity.getType())) {
            this.printerReceipt(entity);
        } else if ("2".equals(entity.getType())) {
            this.printerReceiptByHy(entity);
        } else if ("3".equals(entity.getType())) {
            this.printerReceiptDelivery(entity);
        }
    }

    private void setPrintCount(OutPrescription outPrescription) {
        outPrescription.setPrintCount(Integer.valueOf(outPrescription.getPrintCount() + 1));
        int a = this.outPrescriptionMapper.updatePrientCount(outPrescription.getPrescriptionNo());
        ExceptionUtils.createException((Logger)log, (int)a, (String)("\u66f4\u65b0\u5904\u65b9\uff1a" + outPrescription.getPrescriptionNo() + "\u6253\u5370\u6b21\u6570\u5931\u8d25"));
    }

    private String shaUtil(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] bytes = data.getBytes();
        digest.update(bytes);
        byte[] hashedBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashedBytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String hashedData = hexString.toString();
        return hashedData;
    }

    public String send(String url, FEEntity feEntity) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Map objMap = BeanUtil.getObjMap((Object)feEntity);
        for (Map.Entry entry : objMap.entrySet()) {
            params.add((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
        }
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String response = ((String)restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0])).replace("\\", "");
        return response;
    }

    public List<JSONObject> getDetail(SysEasyEntity entity) {
        List outPrescriptionList = this.outPrescriptionMapper.getDetailByRePrint(entity.getId());
        return outPrescriptionList;
    }
}

