/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.drug.DrugInventoryResponse;
import com.byh.sdk.entity.drug.DrugRequestDTO;
import com.byh.sdk.entity.drug.DrugResponse;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.SysDictValueDTO;
import com.byh.sdk.entity.drug.SysDictValueVo;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleDto;
import com.byh.sdk.entity.drug.SysDrugPharmacySimpleVo;
import com.byh.sdk.entity.drug.SysDrugPharmacyStorageDto;
import com.byh.sdk.entity.drug.SysDrugPharmacyStorageVo;
import com.byh.sdk.entity.drug.SysEasyEntity;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.feign.sys.SysServiceFeign;
import com.byh.sdk.service.DrugService;
import com.byh.sdk.util.ResponseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugServiceImpl
implements DrugService {
    private static final Logger log = LoggerFactory.getLogger(DrugServiceImpl.class);
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    public FrontResponse<List<DrugResponse>> queryDrugList(FrontRequest<DrugRequestDTO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            DrugRequestDTO drugRequestDTO = (DrugRequestDTO)param.getBody();
            List drugCodesList = drugRequestDTO.getDrugCodes();
            ResponseData responseData = this.sysServiceFeign.sysDrugInternalCodes(drugCodesList, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.error("\u67e5\u8be2\u836f\u54c1\u57fa\u672c\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)drugCodesList, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), DrugResponse.class);
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                Map<Object, Object> sysDrugDosageUnitMap = new HashMap();
                Map<Object, Object> sysDrugPackUnitMap = new HashMap();
                SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                sysDictValueDTO.setType("usage_unit");
                sysDictValueDTO.setCurrent(1);
                sysDictValueDTO.setSize(-1);
                ResponseData sysDictValueVoResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, tenantId);
                if (Objects.isNull(sysDictValueVoResponseData) || !sysDictValueVoResponseData.isSuccess()) {
                    log.info("\u67e5\u8be2\u7528\u91cf\u5355\u4f4d\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)sysDictValueVoResponseData));
                    return FrontResponse.error((String)transactionId, (String)"0", (String)"\u836f\u54c1\u7528\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38");
                }
                List dictValueVoList = ((Page)sysDictValueVoResponseData.getData()).getRecords();
                if (CollectionUtils.isEmpty((Collection)dictValueVoList)) {
                    log.info("\u67e5\u8be2\u7528\u91cf\u5355\u4f4d\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)dictValueVoList));
                    return FrontResponse.error((String)transactionId, (String)"0", (String)"\u836f\u54c1\u7528\u91cf\u5355\u4f4d\u4fe1\u606f\u67e5\u8be2\u7f3a\u5931");
                }
                sysDrugDosageUnitMap = dictValueVoList.stream().collect(Collectors.toMap(SysDictValueVo::getValue, Function.identity()));
                sysDictValueDTO.setType("we_pack_units");
                ResponseData sysPackUnitResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, tenantId);
                if (Objects.isNull(sysPackUnitResponseData) || !sysPackUnitResponseData.isSuccess()) {
                    log.info("\u67e5\u8be2\u5305\u88c5\u5355\u4f4d\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)sysDictValueVoResponseData));
                    return FrontResponse.error((String)transactionId, (String)"0", (String)"\u836f\u54c1\u5305\u88c5\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38");
                }
                List dictPackValueVoList = ((Page)sysPackUnitResponseData.getData()).getRecords();
                if (CollectionUtils.isEmpty((Collection)dictPackValueVoList)) {
                    log.info("\u67e5\u8be2\u5305\u88c5\u5355\u4f4d\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)dictPackValueVoList));
                    return FrontResponse.error((String)transactionId, (String)"0", (String)"\u836f\u54c1\u5305\u88c5\u5355\u4f4d\u4fe1\u606f\u67e5\u8be2\u7f3a\u5931");
                }
                sysDrugPackUnitMap = dictPackValueVoList.stream().collect(Collectors.toMap(SysDictValueVo::getValue, Function.identity()));
                for (DrugResponse drug : data) {
                    SysDictValueVo sysDictValueVo = (SysDictValueVo)sysDrugDosageUnitMap.get(drug.getDefaultUsageUnit());
                    SysDictValueVo sysDictValueVo1 = (SysDictValueVo)sysDrugPackUnitMap.get(drug.getPackLargeUnits());
                    drug.setDefaultUsage(Objects.nonNull(sysDictValueVo) ? sysDictValueVo.getLabel() : drug.getDefaultUsage());
                    drug.setPackLargeUnitsLabel(Objects.nonNull(sysDictValueVo1) ? sysDictValueVo1.getLabel() : drug.getPackSmallUnitsLabel());
                }
            }
            return FrontResponse.success((String)transactionId, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<List<DrugInventoryResponse>> drugInventory(FrontRequest<DrugRequestDTO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            DrugRequestDTO drugRequestDTO = (DrugRequestDTO)param.getBody();
            List drugCodesList = drugRequestDTO.getDrugCodes();
            SysEasyEntity entity = new SysEasyEntity();
            entity.setIds(drugCodesList.toArray(new String[drugCodesList.size()]));
            entity.setWarehouse(drugRequestDTO.getPharmacyId());
            ResponseData responseData = this.sysServiceFeign.sysDrugPharmacyOutSearchByIds(entity, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)drugCodesList, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), DrugInventoryResponse.class);
            return FrontResponse.success((String)transactionId, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse pharmacyOutSearch(FrontRequest<SysDrugPharmacySimpleDto> param) {
        log.info("\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SysDrugPharmacySimpleDto sysDrugPharmacySimpleDto = (SysDrugPharmacySimpleDto)param.getBody();
            String[] drugListStr = new String[]{"1", "2"};
            sysDrugPharmacySimpleDto.setDrugsTypeList(Arrays.asList(drugListStr));
            sysDrugPharmacySimpleDto.setIsPlus("off");
            ResponseData responseData = this.sysServiceFeign.pharmacyOutSearch(sysDrugPharmacySimpleDto, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDrugPharmacySimpleDto, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), SysDrugPharmacySimpleVo.class);
            return FrontResponse.success((String)transactionId, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u836f\u623f\u836f\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse storageList(FrontRequest<SysDrugPharmacyStorageDto> param) {
        log.info("\u67e5\u8be2\u836f\u623f\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SysDrugPharmacyStorageDto sysDrugPharmacyStorageDto = (SysDrugPharmacyStorageDto)param.getBody();
            ResponseData responseData = this.sysServiceFeign.storageList(tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u67e5\u8be2\u836f\u623f\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDrugPharmacyStorageDto, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u67e5\u8be2\u836f\u623f\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            if (Objects.isNull(responseData.getData()) || CollectionUtils.isEmpty((Collection)((Collection)responseData.getData()))) {
                log.info("\u67e5\u8be2\u836f\u623f\u4fe1\u606f\u8fd4\u56de\u5931\u8d25\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)sysDrugPharmacyStorageDto, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u836f\u623f\u4fe1\u606f");
            }
            List data = (List)responseData.getData();
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                SysDrugPharmacyStorageVo item = (SysDrugPharmacyStorageVo)iterator.next();
                if (!item.getName().contains("\u865a\u62df")) continue;
                iterator.remove();
            }
            return FrontResponse.success((String)transactionId, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u836f\u623f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse dispenseMedicine(FrontRequest<OutPrescriptionDto> param) {
        log.info("\u53d1\u836f\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OutPrescriptionDto outPrescriptionDto = (OutPrescriptionDto)param.getBody();
            outPrescriptionDto.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.dispenseMedicine(outPrescriptionDto, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u53d1\u836f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)outPrescriptionDto, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u53d1\u836f\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d1\u836f\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53d1\u836f\u5f02\u5e38");
        }
    }

    public FrontResponse withdrawalOfMedication(FrontRequest<OutPrescriptionDto> param) {
        log.info("\u9000\u836f\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            OutPrescriptionDto outPrescriptionDto = (OutPrescriptionDto)param.getBody();
            outPrescriptionDto.setOperatorSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.withdrawalOfMedication(outPrescriptionDto, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.error("\u9000\u836f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)outPrescriptionDto, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u9000\u836f\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9000\u836f\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u9000\u836f\u5f02\u5e38");
        }
    }

    public FrontResponse<List<DrugResponse>> queryDrugBaseList(FrontRequest<DrugRequestDTO> param) {
        log.info("\u67e5\u8be2\u836f\u54c1\u57fa\u672c\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            DrugRequestDTO drugRequestDTO = (DrugRequestDTO)param.getBody();
            List drugCodesList = drugRequestDTO.getDrugCodes();
            ResponseData responseData = this.sysServiceFeign.sysDrugInternalCodes(drugCodesList, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.error("\u67e5\u8be2\u836f\u54c1\u57fa\u672c\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)drugCodesList, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), DrugResponse.class);
            return FrontResponse.success((String)transactionId, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

