/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.byh.sdk.constant.call.Constant;
import com.byh.sdk.entity.call.ActivateEcp;
import com.byh.sdk.entity.call.MakeCall;
import com.byh.sdk.entity.call.SendSms;
import com.byh.sdk.service.MakeCallService;
import com.byh.sdk.util.ResponseData;
import com.byh.sdk.util.call.CheckSumUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MakeCallServiceImpl
implements MakeCallService {
    private static final Logger log = LoggerFactory.getLogger(MakeCallServiceImpl.class);
    @Value(value="${call.baseUrl}")
    private String baseUrl;
    @Value(value="${call.appId}")
    private String appId;
    @Value(value="${call.appSecret}")
    private String appSecret;

    public ResponseData MakeCall(MakeCall makeCall) {
        String url = this.baseUrl + Constant.makeCallUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        String body = JSON.toJSONString((Object)makeCall);
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData endCall(String callSid) {
        String url = this.baseUrl + Constant.endCallUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        JSONObject jsonObject = new JSONObject();
        String body = jsonObject.toString();
        jsonObject.put("callSid", (Object)callSid);
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData queryEcpNumberStatus(String ecpNumber) {
        String url = this.baseUrl + Constant.queryEcpNumberStatusUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ecpNumber", (Object)ecpNumber);
        String body = jsonObject.toString();
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData activateEcpNumber(ActivateEcp activateEcp) {
        String url = this.baseUrl + Constant.activateEcpNumberUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        String body = JSON.toJSONString((Object)activateEcp);
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData sendSms(SendSms sendSms) {
        String url = this.baseUrl + Constant.sendSmsUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        String body = JSON.toJSONString((Object)sendSms);
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData getToken(String grantType) {
        String url = this.baseUrl + Constant.sendSmsUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("grantType", (Object)grantType);
        String body = jsonObject.toString();
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData batchQueryEcpNumberStatus(List<String> ecpNumbers) {
        String url = this.baseUrl + Constant.batchQueryEcpNumberStatusUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        String body = JSON.toJSONString(ecpNumbers);
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }

    public ResponseData autoRecycle(String ecpNumber) {
        String url = this.baseUrl + Constant.autoRecycleUrl;
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String apiVersion = "0";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ecpNumber", (Object)ecpNumber);
        String body = jsonObject.toString();
        String checkSum = CheckSumUtils.getCheckSum((String)timeStamp, (String)apiVersion, (String)this.appSecret, (String)body);
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("X-YX-AppKey", this.appId)).header("X-YX-TimeStamp", timeStamp)).header("X-YX-APIVersion", apiVersion)).header("X-YX-CheckSum", checkSum)).body(body).execute().body();
        log.info("result{}", (Object)result);
        return ResponseData.success((Object)result);
    }
}

