/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.card.HsPatientInfoDto;
import com.byh.sdk.entity.card.PatientEntity;
import com.byh.sdk.entity.card.QueryCardInfoReqVO;
import com.byh.sdk.entity.card.QueryCardInfoResVO;
import com.byh.sdk.entity.card.RegisteredCardReqDTO;
import com.byh.sdk.entity.card.RegisteredCardReqVO;
import com.byh.sdk.entity.card.RegisteredCardResVO;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.service.ICardService;
import com.byh.sdk.util.DobUtils;
import com.byh.sdk.util.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            String credNo = body.getCredNo();
            ResponseData responseData = this.outpatientServiceFeign.queryPatientByCardNo(credNo, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)credNo, (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), PatientEntity.class);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return FrontResponse.success((String)transactionId, null);
            }
            PatientEntity patientEntity = (PatientEntity)data.get(0);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setTelephone(patientEntity.getPhone());
            queryCardInfoResVO.setCardNo(patientEntity.getId().toString());
            queryCardInfoResVO.setPatientId(patientEntity.getId().toString());
            queryCardInfoResVO.setDob(patientEntity.getBirthday());
            queryCardInfoResVO.setAddress(patientEntity.getAddress());
            queryCardInfoResVO.setName(patientEntity.getName());
            queryCardInfoResVO.setSex(patientEntity.getSex());
            queryCardInfoResVO.setCredNo(patientEntity.getCardNo());
            queryCardInfoResVO.setCardType("1702");
            queryCardInfoResVO.setCredType("01");
            return FrontResponse.success((String)transactionId, (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u4fdd\u5b58\u5c31\u8bca\u5361\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            RegisteredCardReqDTO createPatientInfoReqDTO = new RegisteredCardReqDTO();
            createPatientInfoReqDTO.setName(body.getName());
            createPatientInfoReqDTO.setPhone(body.getTelephone());
            createPatientInfoReqDTO.setCardType("01");
            createPatientInfoReqDTO.setCardNo(body.getCredNo());
            createPatientInfoReqDTO.setIsSkin("0");
            createPatientInfoReqDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())));
            createPatientInfoReqDTO.setBirthday(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            createPatientInfoReqDTO.setAge(Integer.valueOf(DobUtils.countAge((String)body.getCredNo())));
            createPatientInfoReqDTO.setSource(SourceEnum.ONLINE.getValue());
            ResponseData responseData = this.outpatientServiceFeign.patientInsert(createPatientInfoReqDTO, tenantId);
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)createPatientInfoReqDTO), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            String patientId = JSON.toJSONString((Object)responseData.getData());
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(patientId);
            registeredCardResVO.setPatientId(patientId);
            registeredCardResVO.setCardType("01");
            registeredCardResVO.setName(createPatientInfoReqDTO.getName());
            registeredCardResVO.setTelephone(createPatientInfoReqDTO.getPhone());
            registeredCardResVO.setCredNo(createPatientInfoReqDTO.getCardNo());
            registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            registeredCardResVO.setDob(createPatientInfoReqDTO.getBirthday());
            registeredCardResVO.setSex(createPatientInfoReqDTO.getSex());
            registeredCardResVO.setCardType("1702");
            registeredCardResVO.setCredType("01");
            return FrontResponse.success((String)transactionId, (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse queryPatientHsInfo(FrontRequest<HsPatientInfoDto> param) {
        log.info("\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u5165\u53c2{}\uff1a" + JSON.toJSONString(param));
        String transactionId = param.getTransactionId();
        Integer tenantId = param.getTenantId();
        if (Objects.isNull(tenantId)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HsPatientInfoDto body = (HsPatientInfoDto)param.getBody();
            ResponseData responseData = this.outpatientServiceFeign.queryPatientHsInfo(body, tenantId, param.getOperatorId(), param.getOperatorName());
            if (responseData == null || !responseData.isSuccess()) {
                log.info("\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)body), (Object)JSON.toJSONString((Object)responseData));
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8fd4\u56de\u53c2\u4fdd\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)responseData.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

