/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.card.HsPatientInfoDto;
import com.byh.sdk.entity.diagnostic.WisQueryHistoricalPrescriptionListDto;
import com.byh.sdk.entity.order.FeeBillCreationDto;
import com.byh.sdk.entity.order.HsPayDto;
import com.byh.sdk.entity.order.HsPreparePayDto;
import com.byh.sdk.entity.order.PayDto;
import com.byh.sdk.entity.order.PayVo;
import com.byh.sdk.entity.order.QueryFeeDetailsDto;
import com.byh.sdk.entity.order.QueryFeeDetailsListDto;
import com.byh.sdk.entity.order.QueryFeeDetailsVo;
import com.byh.sdk.enums.SourceEnum;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.model.outpatient.ComfirmPayNewReq;
import com.byh.sdk.model.outpatient.ComfirmPayNewRes;
import com.byh.sdk.model.outpatient.GetAdmissionItems;
import com.byh.sdk.model.outpatient.GetAdmissionReq;
import com.byh.sdk.model.outpatient.GetAdmissionRes;
import com.byh.sdk.model.outpatient.HsPayItemReq;
import com.byh.sdk.model.outpatient.PayItemReq;
import com.byh.sdk.model.outpatient.PayItemRes;
import com.byh.sdk.model.outpatient.RefundTradeReq;
import com.byh.sdk.model.outpatient.datas.PayItemResDatas;
import com.byh.sdk.model.outpatient.items.PayItemResItems;
import com.byh.sdk.service.OutpatientPaymentService;
import com.byh.sdk.util.RedisUtil;
import com.byh.sdk.util.ResponseData;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;
    @Value(value="${remote.tenantId}")
    private Integer tenantId;
    @Value(value="${remote.wisdomUserId}")
    private Integer userId;
    @Value(value="${remote.wisdomUserName}")
    private String userName;
    @Autowired
    private RedisUtil redisUtil;

    public FrontResponse<Object> queryPatientInfoByEcCode(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionReq paramBody = (GetAdmissionReq)param.getBody();
        HsPatientInfoDto hsPatientInfoDto = new HsPatientInfoDto();
        hsPatientInfoDto.setCardNo(paramBody.getIdNo());
        hsPatientInfoDto.setCardType("01");
        hsPatientInfoDto.setMdtrtCertType("02");
        hsPatientInfoDto.setMdtrtCertNo(paramBody.getIdNo());
        ResponseData responseData = this.outpatientServiceFeign.queryRegPatientHsInfo(hsPatientInfoDto, this.tenantId, this.userId, this.userName);
        log.info("\u67e5\u8be2\u53c2\u4fdd\u4fe1\u606f" + JSONObject.toJSONString((Object)responseData));
        if (Objects.isNull(responseData) || !responseData.isSuccess()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u53c2\u4fdd\u4fe1\u606f\u5931\u8d25");
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseData.getData());
    }

    public FrontResponse<ComfirmPayNewRes> paymentConfirmation(FrontRequest<ComfirmPayNewReq> param) {
        log.info("\u667a\u6167\u5c31\u533b\u7ed3\u7b97\u5165\u53c2" + JSONObject.toJSONString(param));
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        if (!Objects.isNull(comfirmPayNewReq.getIsMedicare()) && 1 == comfirmPayNewReq.getIsMedicare()) {
            HsPayDto hsPayDto = new HsPayDto();
            hsPayDto.setPayOrderNo(comfirmPayNewReq.getPayOrderNo());
            hsPayDto.setPaymentMethod(Integer.valueOf(10));
            ResponseData stringResponseData = this.outpatientServiceFeign.hsPayment(hsPayDto, this.tenantId, this.userId, this.userName);
            log.info("\u533b\u4fdd\u7ed3\u7b97\u8fd4\u56de" + JSONObject.toJSONString((Object)stringResponseData));
            if (!stringResponseData.isSuccess() || Objects.isNull(stringResponseData.getData())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u7ed3\u7b97\u5931\u8d25\uff01");
            }
            ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
            comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
            comfirmPayNewRes.setCardNo(comfirmPayNewReq.getPatientId());
            comfirmPayNewRes.setReceiptId(comfirmPayNewReq.getPayOrderNo());
            comfirmPayNewRes.setRemark(JSONObject.toJSONString((Object)stringResponseData.getData()));
            comfirmPayNewRes.setAmount(String.valueOf(comfirmPayNewReq.getAmount()));
            return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
        }
        FeeBillCreationDto feeBillCreationDto = new FeeBillCreationDto();
        String[] stringArray = comfirmPayNewReq.getPrescriptionNos().split(",");
        List<String> orderNoList = Arrays.asList(stringArray);
        feeBillCreationDto.setOrderNoList(orderNoList);
        feeBillCreationDto.setPayOrderName("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        feeBillCreationDto.setSource(SourceEnum.OFFLINE.getValue());
        feeBillCreationDto.setOperatorSource(SourceEnum.OFFLINE.getValue());
        feeBillCreationDto.setAmount(new BigDecimal(comfirmPayNewReq.getAmount()));
        feeBillCreationDto.setSettlementMethod(comfirmPayNewReq.getSettlementMethod());
        feeBillCreationDto.setOperatorId(this.userId);
        feeBillCreationDto.setOperatorName(this.userName);
        feeBillCreationDto.setTenantId(this.tenantId);
        feeBillCreationDto.setTotalAmount(new BigDecimal(comfirmPayNewReq.getAmount()));
        String outpatientNo = String.valueOf(this.redisUtil.get("orderno_" + comfirmPayNewReq.getId()));
        feeBillCreationDto.setOutpatientNo(outpatientNo);
        log.info("\u7f34\u8d39\u5165\u53c2======>" + JSONObject.toJSONString((Object)feeBillCreationDto));
        ResponseData orderCharge = this.outpatientServiceFeign.orderCharge(feeBillCreationDto, this.tenantId, this.userId, this.userName);
        log.info("\u7f34\u8d39\u51fa\u53c2===>" + JSONObject.toJSONString((Object)orderCharge));
        if (!orderCharge.isSuccess() || Objects.isNull(orderCharge.getData())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u81ea\u8d39\u9884\u7ed3\u7b97\u5931\u8d25\uff01");
        }
        JSONObject feeBillCreationVo = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderCharge.getData()), JSONObject.class);
        PayDto payDto = new PayDto();
        payDto.setSource(SourceEnum.OFFLINE.getValue());
        payDto.setTenantId(this.tenantId);
        payDto.setOperatorSource(SourceEnum.OFFLINE.getValue());
        payDto.setPayOrderNo(feeBillCreationVo.getString("payOrderNo"));
        payDto.setAmount(new BigDecimal(comfirmPayNewReq.getAmount()));
        payDto.setTotalAmount(new BigDecimal(comfirmPayNewReq.getAmount()));
        payDto.setPaymentType(Integer.valueOf(2));
        payDto.setPaymentMethod(Integer.valueOf("WECHAT".equals(comfirmPayNewReq.getPaychannel()) ? 10 : 20));
        ResponseData orderResponse = this.outpatientServiceFeign.payment(payDto, this.tenantId, this.userId, this.userName);
        log.info("\u7ed3\u7b97\u8fd4\u56de\u53c2\u6570" + JSONObject.toJSONString((Object)orderResponse));
        if (Objects.isNull(orderResponse) && !orderResponse.isSuccess() && !Objects.isNull(orderResponse.getData())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u7ed3\u7b97\u5931\u8d25\uff01");
        }
        PayVo payVo = (PayVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderResponse.getData()), PayVo.class);
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getPatientId());
        comfirmPayNewRes.setReceiptId(payVo.getPayOrderNo());
        comfirmPayNewRes.setRemark(JSONObject.toJSONString((Object)orderResponse.getData()));
        comfirmPayNewRes.setAmount(String.valueOf(payVo.getAmount()));
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<JSONObject> refund(RefundTradeReq refundTradeReq) {
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)refundTradeReq));
        return FrontResponse.success((String)refundTradeReq.getTransactionId(), null);
    }

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionReq getAdmissionReq = (GetAdmissionReq)param.getBody();
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getAdmissionReq));
        WisQueryHistoricalPrescriptionListDto wisQueryHistoricalPrescriptionListDto = new WisQueryHistoricalPrescriptionListDto();
        wisQueryHistoricalPrescriptionListDto.setPatientId(new Integer(getAdmissionReq.getCardNo()));
        wisQueryHistoricalPrescriptionListDto.setPaymentStatus(Integer.valueOf(10));
        log.info("===\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f====" + JSONObject.toJSONString((Object)wisQueryHistoricalPrescriptionListDto));
        ResponseData listResponseData = this.outpatientServiceFeign.queryByWaitPayByPatientId(new Integer(getAdmissionReq.getCardNo()), this.tenantId);
        log.info("===\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f\u51fa\u53c2====" + JSONObject.toJSONString((Object)listResponseData));
        if (listResponseData == null || !listResponseData.isSuccess()) {
            log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u4fe1\u606f\u5165\u53c2\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)wisQueryHistoricalPrescriptionListDto), (Object)JSON.toJSONString((Object)listResponseData));
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)listResponseData.getMsg());
        }
        if (Objects.isNull(listResponseData.getData())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u4e3a\u7a7a");
        }
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        ArrayList admissionItems = new ArrayList();
        List admissionEntityList = (List)listResponseData.getData();
        admissionEntityList.stream().forEach(outOrder -> {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmId(outOrder.getOrderNo());
            getAdmissionItems.setAdmDate(outOrder.getRegTime());
            getAdmissionItems.setAdmStatus("2");
            getAdmissionItems.setAdmType("0");
            getAdmissionItems.setDeptName(outOrder.getDeptName());
            getAdmissionItems.setDeptCode(String.valueOf(outOrder.getDeptId()));
            getAdmissionItems.setDocCode(String.valueOf(outOrder.getDoctorId()));
            getAdmissionItems.setDocName(outOrder.getDoctorName());
            getAdmissionItems.setAge(String.valueOf(IdcardUtil.getAgeByIdCard((String)outOrder.getPatientCardNo())));
            getAdmissionItems.setName(outOrder.getPatientName());
            getAdmissionItems.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)outOrder.getPatientCardNo())).equals("1") ? "M" : "F");
            getAdmissionItems.setPatientId(getAdmissionReq.getCardNo());
            admissionItems.add(getAdmissionItems);
        });
        getAdmissionRes.setItems(admissionItems);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> queryChargeDetails(FrontRequest<PayItemReq> param) {
        PayItemReq payItemReq = (PayItemReq)param.getBody();
        log.info("\u533b\u5631\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString((Object)payItemReq));
        QueryFeeDetailsDto queryFeeDetailsDto = new QueryFeeDetailsDto();
        queryFeeDetailsDto.setOrderNo(payItemReq.getAdmId());
        ResponseData queryFeeDetailsVoResponseData = this.outpatientServiceFeign.wisQueryFeeDetailsByOrderNo(queryFeeDetailsDto, this.tenantId);
        log.info("\u67e5\u533b\u5631\u8be6\u60c5His\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)queryFeeDetailsVoResponseData));
        if (!queryFeeDetailsVoResponseData.isSuccess()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39\u4fe1\u606f\u8be6\u60c5");
        }
        QueryFeeDetailsVo queryFeeDetailsVo = (QueryFeeDetailsVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)queryFeeDetailsVoResponseData.getData()), QueryFeeDetailsVo.class);
        if (Objects.isNull(queryFeeDetailsVo)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39\u4fe1\u606f\u8be6\u60c5");
        }
        PayItemRes payItemRes = new PayItemRes();
        ArrayList datas = new ArrayList();
        if (!Objects.isNull(queryFeeDetailsVo.getDetailsList())) {
            queryFeeDetailsVo.getDetailsList().stream().forEach(detail -> {
                PayItemResDatas payItemResData = new PayItemResDatas();
                List<String> orderTypeList = Arrays.asList("20", "21", "30", "31", "32", "40", "41");
                if (orderTypeList.contains(detail.getOrderType())) {
                    payItemResData.setItemType("3");
                } else {
                    payItemResData.setItemType("2");
                }
                QueryFeeDetailsListDto queryFeeDetailsListDto = new QueryFeeDetailsListDto();
                queryFeeDetailsListDto.setOrderNo(detail.getOrderNo());
                ResponseData listResponseData = this.outpatientServiceFeign.queryFeeDetailsByProjectID(queryFeeDetailsListDto);
                if (listResponseData.isSuccess() && !Objects.isNull(listResponseData)) {
                    ArrayList items = new ArrayList();
                    ((List)listResponseData.getData()).stream().forEach(queryFeeDetailsListVo -> {
                        PayItemResItems payItemResItems = new PayItemResItems();
                        payItemResItems.setItemType(payItemResData.getItemType());
                        payItemResItems.setInsuCode(queryFeeDetailsListVo.getInsuranceDrugCode());
                        payItemResItems.setPrice(String.valueOf(queryFeeDetailsListVo.getDrugPriceAmount()));
                        payItemResItems.setQty(String.valueOf(queryFeeDetailsListVo.getQuantity()));
                        payItemResItems.setSum(String.valueOf(queryFeeDetailsListVo.getTotalDrugAmount()));
                        payItemResItems.setUnit(queryFeeDetailsListVo.getSpec());
                        payItemResItems.setDesc(queryFeeDetailsListVo.getName());
                        items.add(payItemResItems);
                    });
                    payItemResData.setItems(items);
                    payItemResData.setAmount(String.valueOf(detail.getAmount()));
                    payItemResData.setFeeId(detail.getOrderNo());
                }
                datas.add(payItemResData);
            });
        }
        payItemRes.setDatas(datas);
        log.info("\u5904\u65b9\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)payItemRes));
        this.redisUtil.set("orderno_" + payItemReq.getAdmId(), (Object)queryFeeDetailsVo.getOutpatientNo(), 3600L);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public static String fen2yuan(int price) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.CHINA);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        String format = numberFormat.format(BigDecimal.valueOf(price).divide(BigDecimal.valueOf(100L)));
        return format.replace("\uffe5", "");
    }

    public FrontResponse<Object> hsPreparePay(FrontRequest<HsPayItemReq> param) {
        HsPayItemReq payItemReq = (HsPayItemReq)param.getBody();
        HsPreparePayDto hsPreparePayDto = new HsPreparePayDto();
        hsPreparePayDto.setAmount(payItemReq.getAmount());
        hsPreparePayDto.setOrderNoList(payItemReq.getOrderNoList());
        hsPreparePayDto.setOutpatientNo(payItemReq.getAdmId());
        hsPreparePayDto.setTotalAmount(payItemReq.getAmount());
        hsPreparePayDto.setPayOrderNo("\u5357\u660c\u4f17\u5eb7\u533b\u9662\u6709\u9650\u516c\u53f8");
        hsPreparePayDto.setMdtrtCertNo(payItemReq.getIdNo());
        hsPreparePayDto.setAcctUsedFlag("1");
        hsPreparePayDto.setPsnSetlway("01");
        hsPreparePayDto.setMdtrtCertType("01");
        hsPreparePayDto.setPsnCertType("01");
        hsPreparePayDto.setPatientName(payItemReq.getPatientName());
        hsPreparePayDto.setInsutype(payItemReq.getInsutype());
        hsPreparePayDto.setPsnNo(payItemReq.getPsnNo());
        hsPreparePayDto.setInsuplcAdmdvs(payItemReq.getInsuplcAdmdvs());
        hsPreparePayDto.setCardNo(payItemReq.getIdNo());
        hsPreparePayDto.setPsnType(payItemReq.getPsnType());
        if ("369900".equals(payItemReq.getInsuplcAdmdvs())) {
            hsPreparePayDto.setSettlementMethod(Integer.valueOf(4));
        } else {
            hsPreparePayDto.setSettlementMethod(Integer.valueOf(3));
        }
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u5165\u53c2\uff1a" + JSON.toJSONString((Object)payItemReq));
        ResponseData responseData = this.outpatientServiceFeign.wisHsPreparePayment(hsPreparePayDto, this.tenantId, this.userId, this.userName);
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)responseData));
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseData.getData());
    }
}

