/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;

public class JsonUtils {
    private Object object;
    private JSONObject json;
    private List<JSONObject> list;
    private String concatValues;

    public JsonUtils() {
    }

    public JsonUtils(Object object) {
        this.object = object;
    }

    public JsonUtils(JSONObject jsonObject) {
        this.json = jsonObject;
    }

    public JsonUtils(List<JSONObject> list) {
        this.list = list;
    }

    public static JsonUtils create(Object object) {
        return new JsonUtils(object);
    }

    public JsonUtils(String concatValues) {
        this.concatValues = concatValues;
    }

    public JsonUtils getObjectValue(String key) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.object), JSONObject.class);
        this.object = jsonObject.get((Object)key);
        return new JsonUtils(this.object);
    }

    public JsonUtils getArrayValue(String key, String sourceKey, String equlesValue) {
        List array = JSONArray.parseArray((String)JSONObject.toJSONString((Object)this.object), JSONObject.class);
        for (JSONObject json : array) {
            if (!json.get((Object)sourceKey).toString().equals(equlesValue)) continue;
            this.object = json.get((Object)key);
            return new JsonUtils(this.object);
        }
        return new JsonUtils(this.object);
    }

    public JsonUtils getArrayValue() {
        List array = JSONArray.parseArray((String)JSONObject.toJSONString((Object)this.object), JSONObject.class);
        return new JsonUtils(array);
    }

    public JsonUtils concatArrayValue(String key) {
        StringBuilder builder = new StringBuilder();
        List array = JSONArray.parseArray((String)JSONObject.toJSONString((Object)this.object), JSONObject.class);
        for (JSONObject json : array) {
            builder.append(json.get((Object)key).toString()).append(",");
        }
        builder = builder.deleteCharAt(builder.length() - 1);
        return new JsonUtils(builder.toString());
    }

    public JsonUtils toJsonObject() {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.object));
        return new JsonUtils(jsonObject);
    }

    public Object getObject() {
        return this.object;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public List<JSONObject> getList() {
        return this.list;
    }

    public String getConcatValues() {
        return this.concatValues;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setJson(JSONObject json) {
        this.json = json;
    }

    public void setList(List<JSONObject> list) {
        this.list = list;
    }

    public void setConcatValues(String concatValues) {
        this.concatValues = concatValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonUtils)) {
            return false;
        }
        JsonUtils other = (JsonUtils)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        JSONObject this$json = this.getJson();
        JSONObject other$json = other.getJson();
        if (this$json == null ? other$json != null : !this$json.equals(other$json)) {
            return false;
        }
        List this$list = this.getList();
        List other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        String this$concatValues = this.getConcatValues();
        String other$concatValues = other.getConcatValues();
        return !(this$concatValues == null ? other$concatValues != null : !this$concatValues.equals(other$concatValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        JSONObject $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        List $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        String $concatValues = this.getConcatValues();
        result = result * 59 + ($concatValues == null ? 43 : $concatValues.hashCode());
        return result;
    }

    public String toString() {
        return "JsonUtils(object=" + this.getObject() + ", json=" + this.getJson() + ", list=" + this.getList() + ", concatValues=" + this.getConcatValues() + ")";
    }
}

