/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.sys.api.annotation.WrapperNotBlank;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetWrapperUtil {
    private static Logger logger = LoggerFactory.getLogger(SetWrapperUtil.class);
    private static final String field = "serialVersionUID";

    public static <T, P> void setWrapper(QueryWrapper<T> wrapper, P dto) {
        Class<?> dtoClass = dto.getClass();
        Field[] dtoFields = dtoClass.getDeclaredFields();
        try {
            for (Field f : dtoFields) {
                f.setAccessible(true);
                if (null == f.get(dto) || field.equals(f.getName())) continue;
                String fieldName = SetWrapperUtil.recoverHump(f.getName());
                boolean isAnno = f.isAnnotationPresent(WrapperNotBlank.class);
                if (isAnno && f.getAnnotation(WrapperNotBlank.class).value() && "".equals(f.get(dto))) continue;
                logger.info("\u5b57\u6bb5{}\u5df2\u6dfb\u52a0\u81f3Wrapper", (Object)fieldName);
                wrapper.eq((Object)fieldName, f.get(dto));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String recoverHump(String f) {
        StringBuilder builder = new StringBuilder(f);
        char[] a = builder.toString().toCharArray();
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] < 'A' || a[i] > 'Z') continue;
            builder.replace(i, i + 1, "_" + String.valueOf(a[i]).toLowerCase());
        }
        return builder.toString();
    }
}

