/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.springframework.web.multipart.MultipartFile;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelStreamingReader {
    public List<List<String>> readExcel(MultipartFile file) throws Exception {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        OPCPackage pkg = OPCPackage.open((InputStream)file.getInputStream());
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst, rows);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        int sheetIndexToRead = 1;
        int currentIndex = 0;
        while (sheets.hasNext()) {
            InputStream sheet = sheets.next();
            Throwable throwable = null;
            try {
                if (currentIndex == sheetIndexToRead) {
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                    break;
                }
                ++currentIndex;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sheet == null) continue;
                if (throwable != null) {
                    try {
                        sheet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sheet.close();
            }
        }
        return rows;
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst, List<List<String>> rows) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        SheetHandler handler = new SheetHandler(sst, rows);
        parser.setContentHandler(handler);
        return parser;
    }

    private class SheetHandler
    extends DefaultHandler {
        private SharedStringsTable sst;
        private String lastContents;
        private boolean nextIsString;
        private List<String> row = new ArrayList<String>();
        private final List<List<String>> rows;

        private SheetHandler(SharedStringsTable sst, List<List<String>> rows) {
            this.sst = sst;
            this.rows = rows;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                String cellType = attributes.getValue("t");
                this.nextIsString = cellType != null && cellType.equals("s");
                this.lastContents = "";
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.nextIsString) {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                this.nextIsString = false;
            }
            if (name.equals("v")) {
                this.row.add(this.lastContents);
            } else if (name.equals("row")) {
                this.rows.add(new ArrayList<String>(this.row));
                this.row.clear();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.lastContents = this.lastContents + new String(ch, start, length);
        }
    }
}

