/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.aspect;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysLoginLogEntity;
import com.byh.sys.api.model.SysOperLogEntity;
import com.byh.sys.api.util.IpUtils;
import com.byh.sys.web.mvc.utils.RedisUtil;
import com.byh.sys.web.service.SysOperLogService;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.UserAgent;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    Long createTime = 0L;
    String description;
    String method;
    String appCode;
    String url;
    String ip;
    String type;
    String requstParam;
    String userId;
    String address;
    String browser;
    String respParam;
    String useTime;
    Long tenantId;
    private static boolean ipLocal = false;
    private static File file = null;
    private static DbConfig config;
    private static final String UN = "unknown";
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCAL_IP2 = "0:0:0:0:0:0:0:1";
    private static final String SEPARATE = ",";
    private static final int IP_LENGTH = 15;
    private static Logger logger;
    private static final ThreadLocal<Long> threadLocal;
    @Resource
    private HttpServletRequest request;
    @Resource
    private SysOperLogService sysOperLogService;
    @Resource
    private RedisUtil redisUtil;

    @Before(value="@annotation(controllerLog)")
    public void boBefore(JoinPoint joinPoint, UserOptLogger controllerLog) {
        threadLocal.set(System.currentTimeMillis());
    }

    @AfterReturning(pointcut="@annotation(controllerLog)")
    public void doAfterReturning(JoinPoint joinPoint, UserOptLogger controllerLog) throws Throwable {
        this.doBefore(joinPoint, controllerLog, null);
    }

    @AfterThrowing(value="@annotation(controllerLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, UserOptLogger controllerLog, Exception e) throws Throwable {
        this.doBefore(joinPoint, controllerLog, e);
    }

    public void doBefore(JoinPoint joinPoint, UserOptLogger log, Exception e) throws Throwable {
        this.createTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Method targetMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Method realMethod = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), targetMethod.getParameterTypes());
        ApiOperation operation = realMethod.getAnnotation(ApiOperation.class);
        this.description = operation.value();
        this.method = joinPoint.getSignature().getName();
        this.url = request.getRequestURL().toString();
        this.ip = LogAspect.getIpAddr((HttpServletRequest)request);
        try {
            this.address = LogAspect.getCityInfo((String)this.ip);
        }
        catch (Exception e2) {
            this.address = this.ip;
        }
        this.type = request.getMethod();
        this.requstParam = JSON.toJSONString((Object)Arrays.toString(joinPoint.getArgs()));
        this.userId = request.getHeader("userId");
        String tenantId = request.getHeader("tenantId");
        if (StrUtil.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237ID \u4e0d\u80fd\u4e3a\u7a7a\uff01\uff5btenantId\uff5d==");
        }
        this.appCode = request.getHeader("appCode");
        this.browser = LogAspect.getBrowser((HttpServletRequest)request);
        logger.info("\n\u8bf7\u6c42\u5f00\u59cb===\u65b9\u6cd5\u63cf\u8ff0:{},\n\u8bf7\u6c42\u65b9\u6cd5:{},\n\u8bf7\u6c42\u5730\u5740:{},\n\u8bf7\u6c42ip:{},\n\u8bf7\u6c42\u7c7b\u578b:{},\n\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{this.description, this.method, this.url, this.ip, this.type, this.requstParam});
        SysOperLogEntity operLog = new SysOperLogEntity();
        operLog.setBusinessType(this.description);
        operLog.setMethod(this.method);
        operLog.setRequestMethod(this.type);
        operLog.setOperatorType(Integer.valueOf(1));
        operLog.setOperName(this.userId);
        operLog.setTenantId(Integer.valueOf(tenantId));
        operLog.setOperUrl(this.url);
        operLog.setOperIp(this.ip);
        operLog.setOperParam(this.requstParam);
        operLog.setJsonResult(this.respParam);
        operLog.setOperTime(new Date());
        long l = this.createTime - (Long)threadLocal.get();
        operLog.setCostTime(String.valueOf(l));
        operLog.setStatus(Integer.valueOf(0));
        if (e != null) {
            operLog.setStatus(Integer.valueOf(1));
            operLog.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
        }
        this.sysOperLogService.save((Object)operLog);
        SysLoginLogEntity entity = new SysLoginLogEntity();
        if (StrUtil.isNotEmpty((CharSequence)this.userId)) {
            entity.setUserAccount(this.userId);
            entity.setIpAddress(this.ip);
            entity.setStatus(Integer.valueOf(0));
            if (e != null) {
                entity.setStatus(Integer.valueOf(1));
                entity.setMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            this.redisUtil.set(this.userId, (Object)entity, 240L, TimeUnit.MINUTES);
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty((CharSequence)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((StringUtils.isEmpty((CharSequence)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getBrowser(HttpServletRequest request) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        Browser browser = userAgent.getBrowser();
        return browser.getName();
    }

    public static String getCityInfo(String ip) {
        if (ipLocal) {
            return LogAspect.getLocalCityInfo((String)ip);
        }
        return LogAspect.getHttpCityInfo((String)ip);
    }

    public static String getHttpCityInfo(String ip) {
        String api = String.format("http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true", ip);
        JSONObject object = JSONUtil.parseObj((String)HttpUtil.get((String)api));
        return (String)object.get((Object)"addr", String.class);
    }

    public static String getLocalCityInfo(String ip) {
        try {
            DataBlock dataBlock = new DbSearcher(config, file.getPath()).binarySearch(ip);
            String region = dataBlock.getRegion();
            String address = region.replace("0|", "");
            char symbol = '|';
            if (address.charAt(address.length() - 1) == symbol) {
                address = address.substring(0, address.length() - 1);
            }
            return "\u5185\u7f51IP|\u5185\u7f51IP".equals(address) ? "\u5185\u7f51IP" : address;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Pointcut(value="execution(* com.byh.sys.web.mvc.controller.*.*(..))||execution(* com.byh.sys.web.mvc.controller.drug.*.*(..))||execution(* com.byh.sys.web.mvc.controller.material.*.*(..))")
    public void allMethod() {
    }

    public void before(JoinPoint joinPoint) {
        Method targetMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        AntiRefresh annotation = targetMethod.getAnnotation(AntiRefresh.class);
        if (null != annotation) {
            String ipAddr = IpUtils.getIpAddr((HttpServletRequest)this.request);
            String key = ipAddr + ":" + targetMethod.getName();
            log.debug("\u5f53\u524d\u64cd\u4f5c\u65b9\u6cd5\uff1a{}", (Object)key);
            Object o = this.redisUtil.get(key);
            if (null == o) {
                this.redisUtil.set(key, (Object)1, (long)annotation.time(), TimeUnit.SECONDS);
            } else if (Integer.parseInt(o.toString()) < annotation.number()) {
                this.redisUtil.set(key, (Object)(Integer.parseInt(o.toString()) + 1), (long)annotation.time(), TimeUnit.SECONDS);
            } else {
                throw new BusinessException("500", "\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
    }

    @After(value="allMethod()")
    public void after(JoinPoint joinPoint) {
        log.debug(joinPoint.getSignature().getName() + "\u65b9\u6cd5\u6267\u884c\u7ed3\u675f============== \u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191\u2191 ==============");
    }

    @AfterReturning(value="allMethod()")
    public void afterReturn() {
    }

    @AfterThrowing(value="allMethod()", throwing="e")
    public void afterThrowing(Exception e) {
        log.error("\u65b9\u6cd5\u6267\u884c\u5f02\u5e38\uff1a" + e);
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIp() {
        return this.ip;
    }

    public String getType() {
        return this.type;
    }

    public String getRequstParam() {
        return this.requstParam;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAddress() {
        return this.address;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getRespParam() {
        return this.respParam;
    }

    public String getUseTime() {
        return this.useTime;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public SysOperLogService getSysOperLogService() {
        return this.sysOperLogService;
    }

    public RedisUtil getRedisUtil() {
        return this.redisUtil;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequstParam(String requstParam) {
        this.requstParam = requstParam;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setRespParam(String respParam) {
        this.respParam = respParam;
    }

    public void setUseTime(String useTime) {
        this.useTime = useTime;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setSysOperLogService(SysOperLogService sysOperLogService) {
        this.sysOperLogService = sysOperLogService;
    }

    public void setRedisUtil(RedisUtil redisUtil) {
        this.redisUtil = redisUtil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogAspect)) {
            return false;
        }
        LogAspect other = (LogAspect)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$requstParam = this.getRequstParam();
        String other$requstParam = other.getRequstParam();
        if (this$requstParam == null ? other$requstParam != null : !this$requstParam.equals(other$requstParam)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$browser = this.getBrowser();
        String other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
            return false;
        }
        String this$respParam = this.getRespParam();
        String other$respParam = other.getRespParam();
        if (this$respParam == null ? other$respParam != null : !this$respParam.equals(other$respParam)) {
            return false;
        }
        String this$useTime = this.getUseTime();
        String other$useTime = other.getUseTime();
        if (this$useTime == null ? other$useTime != null : !this$useTime.equals(other$useTime)) {
            return false;
        }
        Long this$tenantId = this.getTenantId();
        Long other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        SysOperLogService this$sysOperLogService = this.getSysOperLogService();
        SysOperLogService other$sysOperLogService = other.getSysOperLogService();
        if (this$sysOperLogService == null ? other$sysOperLogService != null : !this$sysOperLogService.equals(other$sysOperLogService)) {
            return false;
        }
        RedisUtil this$redisUtil = this.getRedisUtil();
        RedisUtil other$redisUtil = other.getRedisUtil();
        return !(this$redisUtil == null ? other$redisUtil != null : !this$redisUtil.equals(other$redisUtil));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogAspect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $requstParam = this.getRequstParam();
        result = result * 59 + ($requstParam == null ? 43 : $requstParam.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
        String $respParam = this.getRespParam();
        result = result * 59 + ($respParam == null ? 43 : $respParam.hashCode());
        String $useTime = this.getUseTime();
        result = result * 59 + ($useTime == null ? 43 : $useTime.hashCode());
        Long $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        SysOperLogService $sysOperLogService = this.getSysOperLogService();
        result = result * 59 + ($sysOperLogService == null ? 43 : $sysOperLogService.hashCode());
        RedisUtil $redisUtil = this.getRedisUtil();
        result = result * 59 + ($redisUtil == null ? 43 : $redisUtil.hashCode());
        return result;
    }

    public String toString() {
        return "LogAspect(createTime=" + this.getCreateTime() + ", description=" + this.getDescription() + ", method=" + this.getMethod() + ", appCode=" + this.getAppCode() + ", url=" + this.getUrl() + ", ip=" + this.getIp() + ", type=" + this.getType() + ", requstParam=" + this.getRequstParam() + ", userId=" + this.getUserId() + ", address=" + this.getAddress() + ", browser=" + this.getBrowser() + ", respParam=" + this.getRespParam() + ", useTime=" + this.getUseTime() + ", tenantId=" + this.getTenantId() + ", request=" + this.getRequest() + ", sysOperLogService=" + this.getSysOperLogService() + ", redisUtil=" + this.getRedisUtil() + ")";
    }

    static {
        logger = LoggerFactory.getLogger(LogAspect.class);
        threadLocal = new NamedThreadLocal("Cost Time");
    }
}

