/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.department.SysDepartmentDTO;
import com.byh.sys.api.dto.department.SysDepartmentSaveDTO;
import com.byh.sys.api.dto.department.SysDepartmentUpdateDTO;
import com.byh.sys.api.dto.department.SysDeptDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.department.SysDepartmentVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDepartmentService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDepartment"})
public class SysDepartmentController {
    @Autowired
    private SysDepartmentService sysDepartmentService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u79d1\u5ba4\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectDeptList"})
    public ResponseData selectDeptList(@RequestBody SysDepartmentDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysDepartmentService.selectDeptList(dto));
    }

    @RequestMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e\u90e8\u95e8\u4fe1\u606f")
    @UserOptLogger(operation="\u90e8\u95e8\u6a21\u5757")
    public ResponseData sysDepartmentSave(@RequestBody @Valid SysDepartmentSaveDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.sysDepartmentService.sysDepartmentSave(dto);
        return ResponseData.success().msg("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/select"})
    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784\u90e8\u95e8\u4fe1\u606f")
    @AntiRefresh
    public ResponseData sysDepartmentSelect(@RequestBody SysDepartmentDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDepartmentService.sysDepartmentSelect(dto);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/select/list"})
    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784\u90e8\u95e8\u4fe1\u606f")
    @AntiRefresh
    public ResponseData sysDepartmentSelectList(@RequestBody SysDepartmentDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDepartmentService.sysDepartmentSelectList(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/get/oneLevel"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u533b\u9662\u7684\u4e00\u7ea7\u90e8\u95e8")
    @AntiRefresh
    public ResponseData sysDepartmentGetOneLevel(@RequestBody Integer id) {
        List list = this.sysDepartmentService.sysDepartmentGetOneLevel(id);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/selectFast"})
    @ApiOperation(value="\u67e5\u8be2\u6811\u7ed3\u6784\u90e8\u95e8\u4fe1\u606f")
    @AntiRefresh
    public ResponseData sysDepartmentSelectFast(@RequestBody SysDepartmentDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDepartmentService.sysDepartmentSelectFast(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/getAllIds"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u90e8\u95e8id\u4e0b\u7684\u6240\u6709\u90e8\u95e8id")
    @AntiRefresh
    public ResponseData sysDepartmentGetAllIds(@RequestBody Integer id) {
        List ids = this.sysDepartmentService.sysDepartmentGetAllIds(id);
        return ResponseData.success((Object)ids);
    }

    @RequestMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u90e8\u95e8\u4fe1\u606f")
    @UserOptLogger(operation="\u90e8\u95e8\u6a21\u5757")
    public ResponseData sysDepartmentUpdate(@RequestBody @Valid SysDepartmentUpdateDTO dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setUpdateId(this.commonRequest.getUserId());
        dto.setUpdateName(this.commonRequest.getUserName());
        this.sysDepartmentService.sysDepartmentUpdate(dto);
        return ResponseData.success((Object)Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u6279\u91cf\u548c\u5355\u4e2a\u5220\u9664\u90e8\u95e8\u4fe1\u606f")
    @UserOptLogger(operation="\u90e8\u95e8\u6a21\u5757")
    public ResponseData sysDepartmentDelete(@RequestBody Integer[] ids) {
        this.sysDepartmentService.sysDepartmentDelete(ids, this.commonRequest.getTenant());
        return ResponseData.success((Object)Thread.currentThread().getStackTrace()[1].getMethodName());
    }

    @PostMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f")
    @AntiRefresh
    public ResponseData queryById(@RequestBody SysDeptDto sysDeptDto) {
        SysDepartmentVo sysDepartmentVo = this.sysDepartmentService.queryById(sysDeptDto.getId());
        return ResponseData.success((Object)sysDepartmentVo);
    }
}

