/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.DoctorOnlineDto;
import com.byh.sys.api.dto.SysDoctorDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.SysDoctorEntityVO;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.SysUserRoleEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.hospital.SysHospitalEntity;
import com.byh.sys.api.model.hospital.SysHospitalUserEntity;
import com.byh.sys.api.model.ward.SysDoctorWardEntity;
import com.byh.sys.api.util.Base64Util;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.DictValueVo;
import com.byh.sys.api.vo.SysDoctorIdVo;
import com.byh.sys.api.vo.SysDoctorImportExcel;
import com.byh.sys.api.vo.SysDoctorVo;
import com.byh.sys.api.vo.department.SysDepartmentVo;
import com.byh.sys.data.repository.SysDictMapper;
import com.byh.sys.data.repository.SysDoctorWardMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.mvc.utils.aes.DecryptRequest;
import com.byh.sys.web.mvc.utils.aes.EncryptResponse;
import com.byh.sys.web.service.SysDepartmentService;
import com.byh.sys.web.service.SysDoctorService;
import com.byh.sys.web.service.SysHospitalService;
import com.byh.sys.web.service.SysHospitalUserService;
import com.byh.sys.web.service.SysRoleService;
import com.byh.sys.web.service.SysUserRoleService;
import com.byh.sys.web.service.SysUserService;
import enums.ConstantsEnums;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"sysDoctor"})
public class SysDoctorController {
    private static final Logger log = LoggerFactory.getLogger(SysDoctorController.class);
    private static Logger logger = LoggerFactory.getLogger(SysDoctorController.class);
    private static final String password = "H123456";
    private final SysDoctorService sysDoctorService;
    private final SysUserService sysUserService;
    private final SysUserRoleService sysUserRoleService;
    private final SysDepartmentService sysDepartmentService;
    private final SysRoleService sysRoleService;
    private final SysDictMapper sysDictMapper;
    @Resource
    private SysDoctorWardMapper sysDoctorWardMapper;
    private final SysHospitalService sysHospitalService;
    private static final String dictDuties = "sys_doctor_duties";
    private static final String doctorTitle = "sys_doctor_title";
    private final SysHospitalUserService sysHospitalUserService;
    private final CommonRequest commonRequest;
    private final PlatformTransactionManager transactionManager;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u533b\u751f\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectListByCondition"})
    public ResponseData selectListByCondition(@RequestBody SysDoctorDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.sysDoctorService.selectListByCondition(dto));
    }

    @ApiOperation(value="\u533b\u751f\u5217\u8868", httpMethod="GET", notes="\u533b\u751f\u5217\u8868")
    @GetMapping(value={"/dataCenter"})
    public ResponseData dataCenter() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String format = now.format(formatter);
        Page page = new Page();
        page.setSize(-1L);
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setTenantId(Integer.valueOf(1));
        sysDoctorDto.setDuties("0");
        sysDoctorDto.setDataCenter("AA");
        sysDoctorDto.setRoleId("14");
        IPage iPage = this.sysDoctorService.pageList(page, sysDoctorDto);
        List records = iPage.getRecords();
        return ResponseData.success((Object)records);
    }

    @DecryptRequest
    @EncryptResponse
    @ApiOperation(value="\u533b\u751f\u5217\u8868", httpMethod="GET", notes="\u533b\u751f\u5217\u8868")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDoctorDto sysDoctorDto) {
        Integer tenantId = this.commonRequest.getTenant();
        sysDoctorDto.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDoctorService.pageList(page, sysDoctorDto));
    }

    @ApiOperation(value="\u5916\u90e8\u8c03\u7528\u67e5\u8be2\u533b\u751f\u5217\u8868")
    @PostMapping(value={"/withoutSelectPageList"})
    public ResponseData withoutSelectPageList(@RequestBody SysDoctorDto dto) {
        Page page = new Page();
        page.setSize(-1L);
        return ResponseData.success((Object)this.sysDoctorService.pageList(page, dto));
    }

    @UserOptLogger(operation="\u533b\u751f\u6a21\u5757")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysDoctorDto sysDoctorDto) {
        String[] roleIds;
        Integer tenantId = this.commonRequest.getTenant();
        Integer operatorId = this.commonRequest.getUserId();
        String operatorName = this.commonRequest.getUserName();
        SysUserEntity sysUserEntity = new SysUserEntity();
        byte[] bytes = password.getBytes();
        String encode = Base64Util.encode((byte[])bytes);
        sysUserEntity.setPassword(encode);
        BeanUtils.copyProperties((Object)sysDoctorDto, (Object)sysUserEntity);
        SysDoctorEntity doctorEntity = new SysDoctorEntity();
        BeanUtils.copyProperties((Object)sysDoctorDto, (Object)doctorEntity);
        SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
        SysHospitalUserEntity hospitalUserEntity = new SysHospitalUserEntity();
        if (null == sysDoctorDto.getId()) {
            if (StrUtil.isEmpty((CharSequence)sysDoctorDto.getUserName())) {
                throw new BusinessException("\u6210\u5458\u540d\u79f0doctorName\u4e0d\u80fd\u4e3a\u7a7a\uff01{doctorName}");
            }
            if (StrUtil.isEmpty((CharSequence)sysDoctorDto.getPhone())) {
                throw new BusinessException("\u624b\u673a\u53f7phone\u4e0d\u80fd\u4e3a\u7a7a\uff01{phone}");
            }
            if (StrUtil.isEmpty((CharSequence)sysDoctorDto.getDepartmentId())) {
                throw new BusinessException("\u79d1\u5ba4\u8868\u4e3b\u952edepartmentId\u4e0d\u80fd\u4e3a\u7a7a\uff01{departmentId}");
            }
            if (StrUtil.isEmpty((CharSequence)sysDoctorDto.getHospitalId())) {
                throw new BusinessException("\u533b\u9662\u7528\u6237\u8868\u533b\u9662hospitalId\u4e0d\u80fd\u4e3a\u7a7a\uff01{hospitalId}");
            }
            SysDoctorEntity one = (SysDoctorEntity)this.sysDoctorService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).eq(SysDoctorEntity::getPhone, (Object)sysDoctorDto.getPhone())).last(" limit 1"));
            if (!StrUtil.isEmptyIfStr((Object)one)) {
                throw new BusinessException("\u533b\u751f\u540d\u79f0/\u624b\u673a\u53f7\u4e0d\u80fd\u91cd\u590d\uff01{one}" + one);
            }
            sysUserEntity.setTenantId(tenantId);
            sysUserEntity.setCreateTime(new Date());
            this.sysUserService.save((Object)sysUserEntity);
            Integer id = sysUserEntity.getId();
            doctorEntity.setTenantId(tenantId);
            doctorEntity.setUserId(id);
            doctorEntity.setUpdateTime(new Date());
            doctorEntity.setCreateTime(new Date());
            doctorEntity.setDelFlag("0");
            doctorEntity.setStatus("0");
            this.sysDoctorService.save((Object)doctorEntity);
            sysUserRoleEntity.setTenantId(tenantId);
            sysUserRoleEntity.setUserId(id);
            for (String ids : roleIds = sysDoctorDto.getRoleIds()) {
                sysUserRoleEntity.setRoleId(Integer.valueOf(ids));
                sysUserRoleEntity.setTenantId(sysDoctorDto.getTenantId());
                sysUserRoleEntity.setCreateTime(new Date());
                this.sysUserRoleService.save((Object)sysUserRoleEntity);
            }
            hospitalUserEntity.setTenantId(tenantId);
            hospitalUserEntity.setUserId(id);
            hospitalUserEntity.setHospitalId(Integer.valueOf(sysDoctorDto.getHospitalId()));
            hospitalUserEntity.setCreateTime(new Date());
            this.sysHospitalUserService.save((Object)hospitalUserEntity);
        } else {
            String hospitalId = sysDoctorDto.getHospitalId();
            if (StrUtil.isEmpty((CharSequence)hospitalId)) {
                throw new BusinessException("\u6240\u5c5e\u533b\u9662hospitalId\u4e0d\u80fd\u4e3a\u7a7a\uff01{hospitalId}=");
            }
            Integer userId = sysDoctorDto.getUserId();
            roleIds = sysDoctorDto.getRoleIds();
            sysUserEntity.setTenantId(tenantId);
            sysUserEntity.setUpdateTime(new Date());
            sysUserEntity.setId(userId);
            this.sysUserService.saveOrUpdate((Object)sysUserEntity);
            doctorEntity.setTenantId(tenantId);
            doctorEntity.setUpdateTime(new Date());
            this.sysDoctorService.saveOrUpdate((Object)doctorEntity);
            this.sysUserRoleService.deleteUserRole(userId);
            for (String ids : roleIds) {
                sysUserRoleEntity.setUserId(userId);
                sysUserRoleEntity.setTenantId(tenantId);
                sysUserRoleEntity.setRoleId(Integer.valueOf(ids));
                sysUserRoleEntity.setTenantId(sysDoctorDto.getTenantId());
                sysUserRoleEntity.setCreateTime(new Date());
                sysUserRoleEntity.setUpdateTime(new Date());
                this.sysUserRoleService.save((Object)sysUserRoleEntity);
            }
            SysHospitalUserEntity one = (SysHospitalUserEntity)this.sysHospitalUserService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysHospitalUserEntity::getUserId, (Object)userId));
            hospitalUserEntity.setUserId(userId);
            hospitalUserEntity.setHospitalId(Integer.valueOf(hospitalId));
            if (StrUtil.isEmptyIfStr((Object)one)) {
                hospitalUserEntity.setTenantId(tenantId);
                hospitalUserEntity.setUpdateTime(new Date());
                this.sysHospitalUserService.save((Object)hospitalUserEntity);
            } else {
                hospitalUserEntity.setTenantId(tenantId);
                hospitalUserEntity.setUpdateTime(new Date());
                this.sysHospitalUserService.update((Object)hospitalUserEntity, (Wrapper)Wrappers.lambdaQuery().eq(SysHospitalUserEntity::getUserId, (Object)userId));
            }
            LambdaQueryWrapper deleteRelationWrapper = Wrappers.lambdaQuery();
            deleteRelationWrapper.eq(tenantId != null, SysDoctorWardEntity::getTenantId, (Object)tenantId);
            deleteRelationWrapper.eq(SysDoctorWardEntity::getDoctorId, (Object)doctorEntity.getId());
            this.sysDoctorWardMapper.delete((Wrapper)deleteRelationWrapper);
        }
        if (sysDoctorDto.getWardIds() != null && !sysDoctorDto.getWardIds().isEmpty()) {
            ArrayList<SysDoctorWardEntity> doctorWardList = new ArrayList<SysDoctorWardEntity>();
            for (Integer wardId : sysDoctorDto.getWardIds()) {
                SysDoctorWardEntity doctorWard = new SysDoctorWardEntity();
                doctorWard.setTenantId(tenantId);
                doctorWard.setDoctorId(doctorEntity.getId());
                doctorWard.setWardId(wardId);
                doctorWard.setOperatorId(operatorId);
                doctorWard.setOperatorName(operatorName);
                doctorWardList.add(doctorWard);
            }
            this.sysDoctorWardMapper.insertList(doctorWardList);
        }
        return ResponseData.success().msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET", notes="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    @AntiRefresh
    public ResponseData getInfo(Integer doctorId) {
        Integer tenantId = this.commonRequest.getTenant();
        if (StrUtil.isEmpty((CharSequence)String.valueOf(doctorId))) {
            throw new BusinessException("\u533b\u751f\u4e3b\u952edoctorId\u4e0d\u80fd\u4e3a\u7a7a\uff01{id}" + doctorId);
        }
        return ResponseData.success((Object)this.sysDoctorService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getId, (Object)tenantId)).eq(SysDoctorEntity::getTenantId, (Object)doctorId)).eq(SysDoctorEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())));
    }

    @UserOptLogger(operation="\u533b\u751f\u6a21\u5757")
    @PostMapping(value={"/removeSysDoctor"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public ResponseData removeSysDoctor(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.sysDoctorService.removeSysDoctor(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u533b\u751f\u5217\u8868 \u72b6\u6001\u4fee\u6539", httpMethod="GET", notes="\u533b\u751f\u5217\u8868 \u72b6\u6001\u4fee\u6539")
    @GetMapping(value={"/updateStatus"})
    public ResponseData updateStatus(SysDoctorDto sysDoctorDto) {
        SysUserEntity sue = new SysUserEntity();
        sue.setLockFlag(Integer.valueOf(sysDoctorDto.getStatus()));
        this.sysUserService.update((Object)sue, (Wrapper)Wrappers.lambdaQuery().eq(SysUserEntity::getId, (Object)sysDoctorDto.getUserId()));
        SysDoctorEntity sde = new SysDoctorEntity();
        sde.setStatus(sysDoctorDto.getStatus());
        this.sysDoctorService.update((Object)sde, (Wrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getId, (Object)sysDoctorDto.getId()));
        return ResponseData.success().msg("\u72b6\u6001\u5df2\u4fee\u6539");
    }

    @PostMapping(value={"/importDoctorExcel"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u7528\u6237\u5bfc\u5165Excel", httpMethod="POST", notes="\u7528\u6237\u5bfc\u5165Excel")
    public ResponseData importDoctorExcel(@RequestPart(value="file") MultipartFile file) throws IOException {
        Integer tenantId = this.commonRequest.getTenant();
        String st = EasyExcelUtil.importExcelMerge((MultipartFile)file, (Object)new SysDoctorImportExcel());
        List list = JSON.parseArray((String)st, SysDoctorImportExcel.class);
        if (!StrUtil.isEmptyIfStr((Object)list)) {
            list.forEach(a -> {
                SysDoctorVo departmentDTO = new SysDoctorVo();
                departmentDTO.setTenantId(tenantId);
                departmentDTO.setType(doctorTitle);
                departmentDTO.setDoctorTitleName(a.getDoctorTitle());
                DictValueVo doctorTitleOne = this.sysDictMapper.querySysDictValue(departmentDTO);
                if (StrUtil.isEmptyIfStr((Object)doctorTitleOne)) {
                    throw new BusinessException("Excel\u91cc\u9762\u804c\u79f0\u548c\u5b57\u5178\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysDoctorVo dutiesDTO = new SysDoctorVo();
                dutiesDTO.setTenantId(tenantId);
                dutiesDTO.setType(dictDuties);
                dutiesDTO.setDutiesName(a.getDuties());
                DictValueVo dutiesOne = this.sysDictMapper.querySysDictValue(dutiesDTO);
                if (StrUtil.isEmptyIfStr((Object)dutiesOne)) {
                    throw new BusinessException("Excel\u91cc\u9762\u804c\u52a1\u548c\u5b57\u5178\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysDepartmentEntity departmentOne = (SysDepartmentEntity)this.sysDepartmentService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDepartmentEntity::getDepartmentName, (Object)a.getDepartmentName())).eq(SysDepartmentEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
                    throw new BusinessException("Excel\u91cc\u9762\u79d1\u5ba4\u540d\u79f0\u548c\u79d1\u5ba4\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysRoleEntity roleOne = (SysRoleEntity)this.sysRoleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRoleEntity::getRoleName, (Object)a.getRoleName())).eq(SysRoleEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
                    throw new BusinessException("Excel\u91cc\u9762\u89d2\u8272\u540d\u79f0\u548c\u89d2\u8272\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysHospitalEntity hospitalOne = (SysHospitalEntity)this.sysHospitalService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysHospitalEntity::getHospitalName, (Object)a.getHospitalName())).eq(SysHospitalEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)hospitalOne)) {
                    throw new BusinessException("Excel\u91cc\u9762\u6240\u5c5e\u533b\u9662\u540d\u79f0\u548c\u4e0b\u5c5e\u533b\u9662\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysUserEntity userEntity = new SysUserEntity();
                byte[] bytes = password.getBytes();
                String encode = Base64Util.encode((byte[])bytes);
                userEntity.setUserName(a.getUserName());
                userEntity.setTenantId(tenantId);
                userEntity.setPassword(encode);
                userEntity.setPhone(a.getPhone());
                userEntity.setRoleId(roleOne.getId());
                userEntity.setCreateTime(new Date());
                userEntity.setUpdateTime(new Date());
                this.sysUserService.save((Object)userEntity);
                SysDoctorEntity doctorEntity = new SysDoctorEntity();
                doctorEntity.setTenantId(tenantId);
                doctorEntity.setUserId(userEntity.getId());
                doctorEntity.setUserName(a.getUserName());
                doctorEntity.setDepartmentId(departmentOne.getId().toString());
                doctorEntity.setJobNumber(a.getJobNumber());
                doctorEntity.setIdCard(a.getIdCard());
                doctorEntity.setDoctorAge(a.getDoctorAge());
                doctorEntity.setDuties(dutiesOne.getValue());
                doctorEntity.setDoctorBirthday(a.getDoctorBirthday());
                doctorEntity.setDoctorSex(a.getDoctorSex());
                doctorEntity.setDoctorTitle(doctorTitleOne.getValue());
                doctorEntity.setDoctorEducation(a.getDoctorEducation());
                doctorEntity.setPhone(a.getPhone());
                doctorEntity.setHsCode(a.getHsCode());
                doctorEntity.setTenantId(tenantId);
                doctorEntity.setCreateTime(new Date());
                doctorEntity.setUpdateTime(new Date());
                this.sysDoctorService.save((Object)doctorEntity);
                SysUserRoleEntity userRole = new SysUserRoleEntity();
                userRole.setUserId(userEntity.getId());
                userRole.setRoleId(roleOne.getId());
                userRole.setTenantId(tenantId);
                userRole.setCreateTime(new Date());
                userRole.setUpdateTime(new Date());
                this.sysUserRoleService.save((Object)userRole);
                SysHospitalUserEntity hospitalUser = new SysHospitalUserEntity();
                hospitalUser.setHospitalId(hospitalOne.getId());
                hospitalUser.setUserId(userEntity.getId());
                hospitalUser.setTenantId(tenantId);
                hospitalUser.setCreateTime(new Date());
                hospitalUser.setUpdateTime(new Date());
                this.sysHospitalUserService.save((Object)hospitalUser);
            });
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/importByJSFKDoctorExcel"})
    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165Excel", httpMethod="POST", notes="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165Excel")
    public ResponseData importByJSFKDoctorExcel(@RequestPart(value="file") MultipartFile file) {
        ArrayList successList = new ArrayList();
        ArrayList continueList = new ArrayList();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            Integer tenantId = 1;
            String st = EasyExcelUtil.importExcelMerge((MultipartFile)file, (Object)new SysDoctorImportExcel());
            List list = JSON.parseArray((String)st, SysDoctorImportExcel.class);
            if (list == null || list.isEmpty()) {
                return ResponseData.error((String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            }
            list.forEach(a -> {
                int count = this.sysDoctorService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getPhone, (Object)a.getPhone()));
                if (count > 0) {
                    continueList.add(a);
                    return;
                }
                SysDepartmentEntity departmentOne = (SysDepartmentEntity)this.sysDepartmentService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDepartmentEntity::getDepartmentName, (Object)a.getDepartmentName())).eq(SysDepartmentEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
                    throw new BusinessException("Excel\u91cc\u9762" + a.getUserName() + "\u7684\u79d1\u5ba4\u540d\u79f0\u548c\u79d1\u5ba4\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysRoleEntity roleOne = (SysRoleEntity)this.sysRoleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRoleEntity::getRoleName, (Object)a.getRoleName())).eq(SysRoleEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
                    throw new BusinessException("Excel\u91cc\u9762" + a.getUserName() + "\u89d2\u8272\u540d\u79f0\u548c\u89d2\u8272\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysHospitalEntity hospitalOne = (SysHospitalEntity)this.sysHospitalService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysHospitalEntity::getHospitalName, (Object)a.getHospitalName())).eq(SysHospitalEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
                if (StrUtil.isEmptyIfStr((Object)hospitalOne)) {
                    throw new BusinessException("Excel\u91cc\u9762" + a.getUserName() + "\u6240\u5c5e\u533b\u9662\u540d\u79f0\u548c\u4e0b\u5c5e\u533b\u9662\u5339\u914d\u4e0d\u5230\uff01");
                }
                SysUserEntity userEntity = new SysUserEntity();
                byte[] bytes = password.getBytes();
                String encode = Base64Util.encode((byte[])bytes);
                userEntity.setUserName(a.getUserName());
                userEntity.setTenantId(tenantId);
                userEntity.setPassword(encode);
                userEntity.setPhone(a.getPhone());
                userEntity.setRoleId(roleOne.getId());
                userEntity.setCreateTime(new Date());
                userEntity.setUpdateTime(new Date());
                this.sysUserService.save((Object)userEntity);
                SysDoctorEntity doctorEntity = new SysDoctorEntity();
                doctorEntity.setTenantId(tenantId);
                doctorEntity.setUserId(userEntity.getId());
                doctorEntity.setUserName(a.getUserName());
                doctorEntity.setDepartmentId(departmentOne.getId().toString());
                doctorEntity.setPhone(a.getPhone());
                doctorEntity.setHsCode(a.getHsCode());
                doctorEntity.setTenantId(tenantId);
                doctorEntity.setCreateTime(new Date());
                doctorEntity.setUpdateTime(new Date());
                this.sysDoctorService.save((Object)doctorEntity);
                SysUserRoleEntity userRole = new SysUserRoleEntity();
                userRole.setUserId(userEntity.getId());
                userRole.setRoleId(roleOne.getId());
                userRole.setTenantId(tenantId);
                userRole.setCreateTime(new Date());
                userRole.setUpdateTime(new Date());
                this.sysUserRoleService.save((Object)userRole);
                SysHospitalUserEntity hospitalUser = new SysHospitalUserEntity();
                hospitalUser.setHospitalId(hospitalOne.getId());
                hospitalUser.setUserId(userEntity.getId());
                hospitalUser.setTenantId(tenantId);
                hospitalUser.setCreateTime(new Date());
                hospitalUser.setUpdateTime(new Date());
                this.sysHospitalUserService.save((Object)hospitalUser);
                successList.add(a);
            });
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            result.put("successCount", Integer.valueOf(successList.size()));
            result.put("skipCount", Integer.valueOf(continueList.size()));
            result.put("successDetails", successList);
            result.put("continueDetails", continueList);
            this.transactionManager.commit(status);
            return ResponseData.success(result);
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
            this.transactionManager.rollback(status);
            return ResponseData.error((String)("\u5bfc\u5165\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/importByJSFKDoctorByOne"})
    @ApiOperation(value="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165\u5355\u4e2a", httpMethod="POST", notes="\u6781\u901f\u5f00\u65b9\u533b\u751f\u5feb\u901f\u5bfc\u5165\u5355\u4e2a")
    public ResponseData importByJSFKDoctorByOne(@RequestBody SysDoctorImportExcel dto) {
        Integer tenantId = 1;
        int count = this.sysDoctorService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getPhone, (Object)dto.getPhone()));
        if (count > 0) {
            return ResponseData.success((Object)"2");
        }
        SysDepartmentEntity departmentOne = (SysDepartmentEntity)this.sysDepartmentService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDepartmentEntity::getDepartmentName, (Object)dto.getDepartmentName())).eq(SysDepartmentEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
        if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
            throw new BusinessException(dto.getUserName() + "\u7684\u79d1\u5ba4\u540d\u79f0\u548c\u79d1\u5ba4\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
        }
        SysRoleEntity roleOne = (SysRoleEntity)this.sysRoleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRoleEntity::getRoleName, (Object)dto.getRoleName())).eq(SysRoleEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
        if (StrUtil.isEmptyIfStr((Object)departmentOne)) {
            throw new BusinessException(dto.getUserName() + "\u89d2\u8272\u540d\u79f0\u548c\u89d2\u8272\u7ba1\u7406\u5339\u914d\u4e0d\u5230\uff01");
        }
        SysHospitalEntity hospitalOne = (SysHospitalEntity)this.sysHospitalService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysHospitalEntity::getHospitalName, (Object)dto.getHospitalName())).eq(SysHospitalEntity::getTenantId, (Object)tenantId)).last(" limit 1"));
        if (StrUtil.isEmptyIfStr((Object)hospitalOne)) {
            throw new BusinessException(dto.getUserName() + "\u6240\u5c5e\u533b\u9662\u540d\u79f0\u548c\u4e0b\u5c5e\u533b\u9662\u5339\u914d\u4e0d\u5230\uff01");
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            SysUserEntity userEntity = new SysUserEntity();
            byte[] bytes = password.getBytes();
            String encode = Base64Util.encode((byte[])bytes);
            userEntity.setUserName(dto.getUserName());
            userEntity.setTenantId(tenantId);
            userEntity.setPassword(encode);
            userEntity.setPhone(dto.getPhone());
            userEntity.setRoleId(roleOne.getId());
            userEntity.setCreateTime(new Date());
            userEntity.setUpdateTime(new Date());
            this.sysUserService.save((Object)userEntity);
            SysDoctorEntity doctorEntity = new SysDoctorEntity();
            doctorEntity.setTenantId(tenantId);
            doctorEntity.setUserId(userEntity.getId());
            doctorEntity.setUserName(dto.getUserName());
            doctorEntity.setDepartmentId(departmentOne.getId().toString());
            doctorEntity.setPhone(dto.getPhone());
            doctorEntity.setHsCode(dto.getHsCode());
            doctorEntity.setTenantId(tenantId);
            doctorEntity.setCreateTime(new Date());
            doctorEntity.setUpdateTime(new Date());
            this.sysDoctorService.save((Object)doctorEntity);
            SysUserRoleEntity userRole = new SysUserRoleEntity();
            userRole.setUserId(userEntity.getId());
            userRole.setRoleId(roleOne.getId());
            userRole.setTenantId(tenantId);
            userRole.setCreateTime(new Date());
            userRole.setUpdateTime(new Date());
            this.sysUserRoleService.save((Object)userRole);
            SysHospitalUserEntity hospitalUser = new SysHospitalUserEntity();
            hospitalUser.setHospitalId(hospitalOne.getId());
            hospitalUser.setUserId(userEntity.getId());
            hospitalUser.setTenantId(tenantId);
            hospitalUser.setCreateTime(new Date());
            hospitalUser.setUpdateTime(new Date());
            this.sysHospitalUserService.save((Object)hospitalUser);
            this.transactionManager.commit(status);
            return ResponseData.success((Object)"1");
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u533b\u751f\u5f02\u5e38", (Throwable)e);
            this.transactionManager.rollback(status);
            return ResponseData.error((String)("\u5bfc\u5165\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/querySysDoctorInfo"})
    public ResponseData querySysDoctorInfo(@RequestParam(value="phone") String phone) {
        try {
            SysDoctorEntity one = (SysDoctorEntity)this.sysDoctorService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDoctorEntity::getTenantId, (Object)1)).eq(SysDoctorEntity::getPhone, (Object)phone));
            SysDepartmentVo sysDepartmentVo = this.sysDepartmentService.queryById(Integer.valueOf(one.getDepartmentId()));
            List list = this.sysUserRoleService.list((Wrapper)Wrappers.lambdaQuery().eq(SysUserRoleEntity::getUserId, (Object)one.getUserId()));
            SysDoctorEntityVO sysDoctorEntityVO = new SysDoctorEntityVO();
            BeanUtils.copyProperties((Object)one, (Object)sysDoctorEntityVO);
            sysDoctorEntityVO.setDepartmentName(sysDepartmentVo.getDepartmentName());
            sysDoctorEntityVO.setRoleId(String.valueOf(((SysUserRoleEntity)list.get(0)).getRoleId()));
            return ResponseData.success((Object)sysDoctorEntityVO);
        }
        catch (Exception e) {
            return ResponseData.success(null);
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u8be6\u60c5", httpMethod="GET", notes="\u901a\u8fc7id\u8be6\u60c5")
    @PostMapping(value={"/doctorById"})
    @AntiRefresh
    public ResponseData doctorById(@RequestBody SysDoctorDto sysDoctorDto) {
        return ResponseData.success((Object)this.sysDoctorService.doctorById(sysDoctorDto));
    }

    @ApiOperation(value="\u901a\u8fc7id\u8be6\u60c5", httpMethod="GET", notes="\u9632\u6b62null\u503c\u5e8f\u5217\u5316\u9519\u8bef\uff01\uff01\uff01")
    @PostMapping(value={"/newDoctorById"})
    @AntiRefresh
    public ResponseData newDoctorById(@RequestBody SysDoctorDto sysDoctorDto) {
        SysDoctorIdVo sysDoctorIdVo = this.sysDoctorService.doctorById(sysDoctorDto);
        if (sysDoctorIdVo == null) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25!");
        }
        return ResponseData.success((Object)sysDoctorIdVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u533b\u751f\u8be6\u60c5", httpMethod="GET", notes="\u901a\u8fc7id\u8be6\u60c5")
    @PostMapping(value={"/doctor"})
    @AntiRefresh
    public ResponseData doctor() {
        return ResponseData.success((Object)this.sysDoctorService.doctor());
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u6240\u5728\u79d1\u5ba4\u6240\u6709\u533b\u751f\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u533b\u751f\u6240\u5728\u79d1\u5ba4\u6240\u6709\u533b\u751f\u8be6\u60c5")
    @GetMapping(value={"/doctorByDept"})
    @AntiRefresh
    public ResponseData<List<SysDoctorIdVo>> doctorByDept(@RequestParam(value="deptId", required=true) Integer deptId) {
        return ResponseData.success((Object)this.sysDoctorService.doctorByDept(deptId));
    }

    @ApiOperation(value="\u9009\u62e9\u5728\u7ebf\u72b6\u6001", httpMethod="POST", notes="\u9009\u62e9\u5728\u7ebf\u72b6\u6001")
    @PostMapping(value={"/doctorOnline"})
    @AntiRefresh
    public ResponseData doctorOnline(@RequestBody DoctorOnlineDto dto) {
        return ResponseData.success((Object)this.sysDoctorService.doctorOnline(dto));
    }

    public SysDoctorController(SysDoctorService sysDoctorService, SysUserService sysUserService, SysUserRoleService sysUserRoleService, SysDepartmentService sysDepartmentService, SysRoleService sysRoleService, SysDictMapper sysDictMapper, SysHospitalService sysHospitalService, SysHospitalUserService sysHospitalUserService, CommonRequest commonRequest, PlatformTransactionManager transactionManager) {
        this.sysDoctorService = sysDoctorService;
        this.sysUserService = sysUserService;
        this.sysUserRoleService = sysUserRoleService;
        this.sysDepartmentService = sysDepartmentService;
        this.sysRoleService = sysRoleService;
        this.sysDictMapper = sysDictMapper;
        this.sysHospitalService = sysHospitalService;
        this.sysHospitalUserService = sysHospitalUserService;
        this.commonRequest = commonRequest;
        this.transactionManager = transactionManager;
    }
}

