/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller;

import com.byh.sys.api.model.SysInventoryAlertEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysInventoryAlertService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysInventoryAlertController {
    @Autowired
    private SysInventoryAlertService sysInventoryAlertService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/sys/inventory/alert/save"})
    public ResponseData sysInventoryAlertSave(@RequestBody @Valid SysInventoryAlertEntity entity) {
        this.sysInventoryAlertService.sysInventoryAlertSave(entity);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/sys/inventory/alert/select"})
    public ResponseData sysInventoryAlertSelect(@RequestBody @Valid SysInventoryAlertEntity entity) {
        List list = this.sysInventoryAlertService.sysInventoryAlertSelect(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/sys/inventory/alert/selectOne"})
    public ResponseData<SysInventoryAlertEntity> sysInventoryAlertSelectOne(@RequestBody @Valid SysInventoryAlertEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        SysInventoryAlertEntity byOne = this.sysInventoryAlertService.sysInventoryAlertSelectOne(entity);
        return ResponseData.success((Object)byOne);
    }

    @RequestMapping(value={"/sys/inventory/alert/update"})
    public ResponseData sysInventoryAlertUpdate(@RequestBody @Valid SysInventoryAlertEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sysInventoryAlertService.sysInventoryAlertUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/sys/inventory/alert/delete"})
    public ResponseData sysInventoryAlertDelete(@RequestBody @Valid SysInventoryAlertEntity entity) {
        this.sysInventoryAlertService.sysInventoryAlertDelete(entity);
        return ResponseData.success().delete();
    }
}

