/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustDto;
import com.byh.sys.api.model.drug.SysDrugAdjustEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugAdjustService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysDrugAdjustController {
    @Autowired
    private SysDrugAdjustService sysDrugAdjustService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/sys/drug/adjust/save"})
    public ResponseData sysDrugAdjustSave(@RequestBody @Valid SysDrugAdjustEntity entity) {
        this.sysDrugAdjustService.sysDrugAdjustSave(entity);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/sys/drug/adjust/select"})
    @AntiRefresh
    public ResponseData sysDrugAdjustSelect(SysDrugAdjustDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.sysDrugAdjustService.sysDrugAdjustSelect(dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/sys/drug/adjust/update"})
    public ResponseData sysDrugAdjustUpdate(@RequestBody @Valid SysDrugAdjustEntity entity) {
        this.sysDrugAdjustService.sysDrugAdjustUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/sys/drug/adjust/delete"})
    public ResponseData sysDrugAdjustDelete(@RequestBody @Valid SysDrugAdjustEntity entity) {
        this.sysDrugAdjustService.sysDrugAdjustDelete(entity);
        return ResponseData.success().delete();
    }
}

